/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.api.ArrayBufferLibrary;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ArrayBufferLibrary.class)
final class ArrayBufferLibraryGen
extends LibraryFactory<ArrayBufferLibrary> {
    private static final Class<ArrayBufferLibrary> LIBRARY_CLASS = ArrayBufferLibraryGen.lazyLibraryClass();
    private static final Message IS_ARRAY_BUFFER = new MessageImpl("isArrayBuffer", 0, false, Boolean.TYPE, Object.class);
    private static final Message GET_CONTENTS = new MessageImpl("getContents", 1, false, ByteBuffer.class, Object.class);
    private static final Message GET_BYTE_LENGTH = new MessageImpl("getByteLength", 2, false, Integer.TYPE, Object.class);
    private static final ArrayBufferLibraryGen INSTANCE = new ArrayBufferLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ArrayBufferLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_ARRAY_BUFFER, GET_CONTENTS, GET_BYTE_LENGTH));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return ArrayBufferLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected ArrayBufferLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected ArrayBufferLibrary createDelegate(ArrayBufferLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        ArrayBufferLibrary lib = (ArrayBufferLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isArrayBuffer(receiver);
            }
            case 1: {
                return lib.getContents(receiver);
            }
            case 2: {
                return lib.getByteLength(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected ArrayBufferLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected ArrayBufferLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<ArrayBufferLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.js.api.ArrayBufferLibrary", false, ArrayBufferLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class Proxy
    extends ArrayBufferLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_ARRAY_BUFFER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            try {
                return (ByteBuffer)this.lib.send(receiver_, GET_CONTENTS, new Object[0]);
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            try {
                return (Integer)this.lib.send(receiver_, GET_BYTE_LENGTH, new Object[0]);
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class Delegate
    extends ArrayBufferLibrary {
        @Node.Child
        private ArrayBufferLibrary delegateLibrary;

        Delegate(ArrayBufferLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            if (ArrayBufferLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = ArrayBufferLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayBufferLibrary)ArrayBufferLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isArrayBuffer(delegate);
            }
            return this.delegateLibrary.isArrayBuffer(receiver_);
        }

        @Override
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            if (ArrayBufferLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = ArrayBufferLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayBufferLibrary)ArrayBufferLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getContents(delegate);
            }
            return this.delegateLibrary.getContents(receiver_);
        }

        @Override
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            if (ArrayBufferLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = ArrayBufferLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayBufferLibrary)ArrayBufferLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getByteLength(delegate);
            }
            return this.delegateLibrary.getByteLength(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(ArrayBufferLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static abstract class CachedDispatch
    extends ArrayBufferLibrary {
        @Node.Child
        ArrayBufferLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(ArrayBufferLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean isArrayBuffer(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isArrayBuffer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getContents(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayBufferLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getByteLength(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                ArrayBufferLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (ArrayBufferLibrary)this.insert((Node)((ArrayBufferLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        ArrayBufferLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (ArrayBufferLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((ArrayBufferLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends ArrayBufferLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isArrayBuffer(Object receiver_) {
            return ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).isArrayBuffer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            return ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getContents(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            return ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getByteLength(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class Default
    extends LibraryExport<ArrayBufferLibrary> {
        private Default() {
            super(ArrayBufferLibrary.class, Object.class, false, false, 0);
        }

        protected ArrayBufferLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ArrayBufferLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=ArrayBufferLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends ArrayBufferLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getContents(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getByteLength(receiver);
            }
        }

        @GeneratedBy(value=ArrayBufferLibrary.class)
        private static final class Cached
        extends ArrayBufferLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isArrayBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getContents(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getByteLength(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(ArrayBufferLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=ArrayBufferLibrary.class)
    private static final class CachedToUncachedDispatch
    extends ArrayBufferLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isArrayBuffer(Object receiver_) {
            assert (ArrayBufferLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).isArrayBuffer(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public ByteBuffer getContents(Object receiver_) throws UnsupportedMessageException {
            assert (ArrayBufferLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ByteBuffer byteBuffer = ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getContents(receiver_);
                return byteBuffer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int getByteLength(Object receiver_) throws UnsupportedMessageException {
            assert (ArrayBufferLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((ArrayBufferLibrary)INSTANCE.getUncached(receiver_)).getByteLength(receiver_);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

