/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.duckdb.DuckDBArrayResultSet;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;

public class DuckDBArray
implements Array {
    private final Object[] array;
    private final DuckDBVector vector;
    final int offset;
    final int length;

    DuckDBArray(DuckDBVector vector, int offset, int length) throws SQLException {
        this.vector = vector;
        this.length = length;
        this.offset = offset;
        this.array = new Object[length];
        for (int i = 0; i < length; ++i) {
            this.array[i] = vector.getObject(offset + i);
        }
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Object getArray() throws SQLException {
        return this.array;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getArray'");
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getArray'");
    }

    @Override
    public int getBaseType() throws SQLException {
        return DuckDBResultSetMetaData.type_to_int(this.vector.duckdb_type);
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.vector.duckdb_type.name();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new DuckDBArrayResultSet(this.vector, this.offset, this.length);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getResultSet'");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getResultSet'");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getResultSet'");
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

