/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;

public class ConsumerGroupDescription {
    private final String groupId;
    private final boolean isSimpleConsumerGroup;
    private final Collection<MemberDescription> members;
    private final String partitionAssignor;
    private final GroupType type;
    private final GroupState groupState;
    private final Node coordinator;
    private final Set<AclOperation> authorizedOperations;
    private final Optional<Integer> groupEpoch;
    private final Optional<Integer> targetAssignmentEpoch;

    @Deprecated
    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, Collection<MemberDescription> members, String partitionAssignor, ConsumerGroupState state, Node coordinator) {
        this(groupId, isSimpleConsumerGroup, members, partitionAssignor, state, coordinator, Collections.emptySet());
    }

    @Deprecated
    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, Collection<MemberDescription> members, String partitionAssignor, ConsumerGroupState state, Node coordinator, Set<AclOperation> authorizedOperations) {
        this(groupId, isSimpleConsumerGroup, members, partitionAssignor, GroupType.CLASSIC, state, coordinator, authorizedOperations);
    }

    @Deprecated
    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, Collection<MemberDescription> members, String partitionAssignor, GroupType type, ConsumerGroupState state, Node coordinator, Set<AclOperation> authorizedOperations) {
        this.groupId = groupId == null ? "" : groupId;
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        this.members = members == null ? Collections.emptyList() : List.copyOf(members);
        this.partitionAssignor = partitionAssignor == null ? "" : partitionAssignor;
        this.type = type;
        this.groupState = GroupState.parse(state.toString());
        this.coordinator = coordinator;
        this.authorizedOperations = authorizedOperations;
        this.groupEpoch = Optional.empty();
        this.targetAssignmentEpoch = Optional.empty();
    }

    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, Collection<MemberDescription> members, String partitionAssignor, GroupType type, GroupState groupState, Node coordinator, Set<AclOperation> authorizedOperations, Optional<Integer> groupEpoch, Optional<Integer> targetAssignmentEpoch) {
        this.groupId = groupId == null ? "" : groupId;
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        this.members = members == null ? Collections.emptyList() : List.copyOf(members);
        this.partitionAssignor = partitionAssignor == null ? "" : partitionAssignor;
        this.type = type;
        this.groupState = groupState;
        this.coordinator = coordinator;
        this.authorizedOperations = authorizedOperations;
        this.groupEpoch = groupEpoch;
        this.targetAssignmentEpoch = targetAssignmentEpoch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupDescription that = (ConsumerGroupDescription)o;
        return this.isSimpleConsumerGroup == that.isSimpleConsumerGroup && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.members, that.members) && Objects.equals(this.partitionAssignor, that.partitionAssignor) && this.type == that.type && this.groupState == that.groupState && Objects.equals(this.coordinator, that.coordinator) && Objects.equals(this.authorizedOperations, that.authorizedOperations) && Objects.equals(this.groupEpoch, that.groupEpoch) && Objects.equals(this.targetAssignmentEpoch, that.targetAssignmentEpoch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.isSimpleConsumerGroup, this.members, this.partitionAssignor, this.type, this.groupState, this.coordinator, this.authorizedOperations, this.groupEpoch, this.targetAssignmentEpoch});
    }

    public String groupId() {
        return this.groupId;
    }

    public boolean isSimpleConsumerGroup() {
        return this.isSimpleConsumerGroup;
    }

    public Collection<MemberDescription> members() {
        return this.members;
    }

    public String partitionAssignor() {
        return this.partitionAssignor;
    }

    public GroupType type() {
        return this.type;
    }

    @Deprecated
    public ConsumerGroupState state() {
        return ConsumerGroupState.parse(this.groupState.toString());
    }

    public GroupState groupState() {
        return this.groupState;
    }

    public Node coordinator() {
        return this.coordinator;
    }

    public Set<AclOperation> authorizedOperations() {
        return this.authorizedOperations;
    }

    public Optional<Integer> groupEpoch() {
        return this.groupEpoch;
    }

    public Optional<Integer> targetAssignmentEpoch() {
        return this.targetAssignmentEpoch;
    }

    public String toString() {
        return "(groupId=" + this.groupId + ", isSimpleConsumerGroup=" + this.isSimpleConsumerGroup + ", members=" + this.members.stream().map(MemberDescription::toString).collect(Collectors.joining(",")) + ", partitionAssignor=" + this.partitionAssignor + ", type=" + String.valueOf((Object)this.type) + ", groupState=" + String.valueOf((Object)this.groupState) + ", coordinator=" + String.valueOf(this.coordinator) + ", authorizedOperations=" + String.valueOf(this.authorizedOperations) + ", groupEpoch=" + String.valueOf(this.groupEpoch.orElse(null)) + ", targetAssignmentEpoch=" + String.valueOf(this.targetAssignmentEpoch.orElse(null)) + ")";
    }
}

