/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90.blocktree;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.backward_codecs.lucene90.blocktree.FieldReader;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.Outputs;

public final class Lucene90BlockTreeTermsReader
extends FieldsProducer {
    static final Outputs<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = (BytesRef)FST_OUTPUTS.getNoOutput();
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    public static final String TERMS_EXTENSION = "tim";
    public static final String TERMS_CODEC_NAME = "BlockTreeTermsDict";
    public static final int VERSION_START = 0;
    public static final int VERSION_MSB_VLONG_OUTPUT = 1;
    public static final int VERSION_FST_CONTINUOUS_ARCS = 2;
    public static final int VERSION_CURRENT = 2;
    public static final String TERMS_INDEX_EXTENSION = "tip";
    public static final String TERMS_INDEX_CODEC_NAME = "BlockTreeTermsIndex";
    public static final String TERMS_META_EXTENSION = "tmd";
    public static final String TERMS_META_CODEC_NAME = "BlockTreeTermsMeta";
    final IndexInput termsIn;
    final IndexInput indexIn;
    final PostingsReaderBase postingsReader;
    private final FieldInfos fieldInfos;
    private final IntObjectHashMap<FieldReader> fieldMap;
    private final List<String> fieldList;
    final String segment;
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene90BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        boolean success = false;
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        try {
            long termsLength;
            long indexLength;
            IntObjectHashMap fieldMap;
            block27: {
                String termsName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
                this.termsIn = state.directory.openInput(termsName, state.context);
                this.version = CodecUtil.checkIndexHeader((DataInput)this.termsIn, (String)TERMS_CODEC_NAME, (int)0, (int)2, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                String indexName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
                this.indexIn = state.directory.openInput(indexName, state.context.withHints(new IOContext.FileOpenHint[]{FileTypeHint.INDEX}));
                CodecUtil.checkIndexHeader((DataInput)this.indexIn, (String)TERMS_INDEX_CODEC_NAME, (int)this.version, (int)this.version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                String metaName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_META_EXTENSION);
                fieldMap = null;
                Throwable priorE = null;
                indexLength = -1L;
                termsLength = -1L;
                try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(metaName);){
                    block26: {
                        try {
                            CodecUtil.checkIndexHeader((DataInput)metaIn, (String)TERMS_META_CODEC_NAME, (int)this.version, (int)this.version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                            postingsReader.init((IndexInput)metaIn, state);
                            int numFields = metaIn.readVInt();
                            if (numFields < 0) {
                                throw new CorruptIndexException("invalid numFields: " + numFields, (DataInput)metaIn);
                            }
                            fieldMap = new IntObjectHashMap(numFields);
                            for (int i = 0; i < numFields; ++i) {
                                int field = metaIn.readVInt();
                                long numTerms = metaIn.readVLong();
                                if (numTerms <= 0L) {
                                    throw new CorruptIndexException("Illegal numTerms for field number: " + field, (DataInput)metaIn);
                                }
                                BytesRef rootCode = Lucene90BlockTreeTermsReader.readBytesRef((IndexInput)metaIn);
                                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                                if (fieldInfo == null) {
                                    throw new CorruptIndexException("invalid field number: " + field, (DataInput)metaIn);
                                }
                                long sumTotalTermFreq = metaIn.readVLong();
                                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : metaIn.readVLong();
                                int docCount = metaIn.readVInt();
                                BytesRef minTerm = Lucene90BlockTreeTermsReader.readBytesRef((IndexInput)metaIn);
                                BytesRef maxTerm = Lucene90BlockTreeTermsReader.readBytesRef((IndexInput)metaIn);
                                if (numTerms == 1L) {
                                    assert (maxTerm.equals((Object)minTerm));
                                    maxTerm = minTerm;
                                }
                                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), (DataInput)metaIn);
                                }
                                if (sumDocFreq < (long)docCount) {
                                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, (DataInput)metaIn);
                                }
                                if (sumTotalTermFreq < sumDocFreq) {
                                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, (DataInput)metaIn);
                                }
                                long indexStartFP = metaIn.readVLong();
                                FieldReader previous = (FieldReader)((Object)fieldMap.put(fieldInfo.number, (Object)new FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, (IndexInput)metaIn, this.indexIn, minTerm, maxTerm)));
                                if (previous == null) continue;
                                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, (DataInput)metaIn);
                            }
                            indexLength = metaIn.readLong();
                            termsLength = metaIn.readLong();
                            if (metaIn == null) break block26;
                        }
                        catch (Throwable exception) {
                            try {
                                priorE = exception;
                                break block27;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (metaIn != null) {
                                    CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                                } else if (priorE != null) {
                                    IOUtils.rethrowAlways((Throwable)priorE);
                                }
                            }
                        }
                        CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                        break block27;
                    }
                    if (priorE != null) {
                        IOUtils.rethrowAlways((Throwable)priorE);
                    }
                }
            }
            CodecUtil.retrieveChecksum((IndexInput)this.indexIn, (long)indexLength);
            CodecUtil.retrieveChecksum((IndexInput)this.termsIn, (long)termsLength);
            this.fieldInfos = state.fieldInfos;
            this.fieldMap = fieldMap;
            this.fieldList = Lucene90BlockTreeTermsReader.sortFieldNames((IntObjectHashMap<FieldReader>)fieldMap, state.fieldInfos);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        int numBytes = in.readVInt();
        if (numBytes < 0) {
            throw new CorruptIndexException("invalid bytes length: " + numBytes, (DataInput)in);
        }
        BytesRef bytes = new BytesRef(numBytes);
        bytes.length = numBytes;
        in.readBytes(bytes.bytes, 0, numBytes);
        return bytes;
    }

    private static List<String> sortFieldNames(IntObjectHashMap<FieldReader> fieldMap, FieldInfos fieldInfos) {
        ArrayList<String> fieldNames = new ArrayList<String>(fieldMap.size());
        for (IntCursor fieldNumber : fieldMap.keys()) {
            fieldNames.add(fieldInfos.fieldInfo((int)fieldNumber.value).name);
        }
        fieldNames.sort(null);
        return Collections.unmodifiableList(fieldNames);
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.indexIn, this.termsIn, this.postingsReader});
        }
        finally {
            this.fieldMap.clear();
        }
    }

    public Iterator<String> iterator() {
        return this.fieldList.iterator();
    }

    public Terms terms(String field) throws IOException {
        assert (field != null);
        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
        return fieldInfo == null ? null : (Terms)this.fieldMap.get(fieldInfo.number);
    }

    public int size() {
        return this.fieldMap.size();
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.indexIn);
        CodecUtil.checksumEntireFile((IndexInput)this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fieldMap.size() + ",delegate=" + String.valueOf(this.postingsReader) + ")";
    }
}

