/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorBase;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.filterrewrite.AggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.RangeAggregatorBridge;
import org.opensearch.search.aggregations.bucket.range.InternalRange;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.MatchAllFilter;

public class RangeAggregator
extends BucketsAggregator
implements StarTreePreComputeCollector {
    public static final ParseField RANGES_FIELD = new ParseField("ranges", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    public final String fieldName;
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    final Range[] ranges;
    final boolean keyed;
    final InternalRange.Factory rangeFactory;
    final double[] maxTo;
    private final FilterRewriteOptimizationContext filterRewriteOptimizationContext;

    public RangeAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, InternalRange.Factory rangeFactory, final Range[] ranges, boolean keyed, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata, final ValuesSourceConfig config) throws IOException {
        super(name, factories, context, parent, cardinality.multiply(ranges.length), metadata);
        assert (valuesSource != null);
        this.valuesSource = valuesSource;
        this.format = format;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.ranges = ranges;
        this.maxTo = new double[this.ranges.length];
        this.maxTo[0] = this.ranges[0].to;
        for (int i = 1; i < this.ranges.length; ++i) {
            this.maxTo[i] = Math.max(this.ranges[i].to, this.maxTo[i - 1]);
        }
        RangeAggregatorBridge bridge = new RangeAggregatorBridge(){

            @Override
            protected boolean canOptimize() {
                return this.canOptimize(config, ranges);
            }

            @Override
            protected void prepare() {
                this.buildRanges(ranges);
            }

            @Override
            protected Function<Object, Long> bucketOrdProducer() {
                return activeIndex -> RangeAggregator.this.subBucketOrdinal(0L, (Integer)activeIndex);
            }
        };
        this.filterRewriteOptimizationContext = new FilterRewriteOptimizationContext(bridge, parent, this.subAggregators.length, context);
        this.fieldName = valuesSource instanceof ValuesSource.Numeric.FieldData ? ((ValuesSource.Numeric.FieldData)valuesSource).getIndexFieldName() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext());
        if (supportedStarTree != null) {
            this.preComputeWithStarTree(ctx, supportedStarTree);
            return true;
        }
        try {
            this.leafCollectorMode = AggregatorBase.LeafCollectionMode.FILTER_REWRITE;
            boolean bl = AggregatorBridge.segmentMatchAll(this.context, ctx) && this.filterRewriteOptimizationContext.tryOptimize(ctx, this::incrementBucketDocCount, true, this.collectableSubAggregators);
            return bl;
        }
        finally {
            this.leafCollectorMode = AggregatorBase.LeafCollectionMode.NORMAL;
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    int lo = 0;
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        lo = this.collect(doc, value, bucket, lo);
                    }
                }
            }

            @Override
            public void collect(DocIdStream stream, long owningBucketOrd) throws IOException {
                super.collect(stream, owningBucketOrd);
            }

            @Override
            public void collectRange(int min, int max) throws IOException {
                super.collectRange(min, max);
            }

            private int collect(int doc, double value, long owningBucketOrdinal, int lowBound) throws IOException {
                MatchedRange range = new MatchedRange(RangeAggregator.this.ranges, lowBound, value, RangeAggregator.this.maxTo);
                for (int i = range.startLo; i <= range.endHi; ++i) {
                    if (!RangeAggregator.this.ranges[i].matches(value)) continue;
                    RangeAggregator.this.collectBucket(sub, doc, RangeAggregator.this.subBucketOrdinal(owningBucketOrdinal, i));
                }
                return range.endHi + 1;
            }
        };
    }

    private void preComputeWithStarTree(LeafReaderContext ctx, CompositeIndexFieldInfo starTree) throws IOException {
        StarTreeBucketCollector starTreeBucketCollector = this.getStarTreeBucketCollector(ctx, starTree, null);
        FixedBitSet matchingDocsBitSet = starTreeBucketCollector.getMatchingDocsBitSet();
        int numBits = matchingDocsBitSet.length();
        if (numBits > 0) {
            int bit = matchingDocsBitSet.nextSetBit(0);
            while (bit != Integer.MAX_VALUE) {
                starTreeBucketCollector.collectStarTreeEntry(bit, 0L);
                bit = bit + 1 < numBits ? matchingDocsBitSet.nextSetBit(bit + 1) : Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public List<DimensionFilter> getDimensionFilters() {
        return StarTreeQueryHelper.collectDimensionFilters(new MatchAllFilter(this.fieldName), this.subAggregators);
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(final LeafReaderContext ctx, final CompositeIndexFieldInfo starTree, StarTreeBucketCollector parentCollector) throws IOException {
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        return new StarTreeBucketCollector(starTreeValues, parentCollector == null ? StarTreeQueryHelper.getStarTreeResult(starTreeValues, this.context, this.getDimensionFilters()) : null){
            SortedNumericStarTreeValuesIterator valuesIterator;
            String metricName;
            SortedNumericStarTreeValuesIterator docCountsIterator;
            {
                super(starTreeValues, matchingDocsBitSet);
                this.valuesIterator = (SortedNumericStarTreeValuesIterator)this.starTreeValues.getDimensionValuesIterator(RangeAggregator.this.fieldName);
                this.metricName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTree.getField(), "_doc_count", MetricStat.DOC_COUNT.getTypeName());
                this.docCountsIterator = (SortedNumericStarTreeValuesIterator)this.starTreeValues.getMetricValuesIterator(this.metricName);
            }

            @Override
            public void setSubCollectors() throws IOException {
                for (Aggregator aggregator : RangeAggregator.this.subAggregators) {
                    this.subCollectors.add(((StarTreePreComputeCollector)((Object)aggregator.unwrapAggregator())).getStarTreeBucketCollector(ctx, starTree, this));
                }
            }

            @Override
            public void collectStarTreeEntry(int starTreeEntry, long owningBucketOrd) throws IOException {
                if (!this.valuesIterator.advanceExact(starTreeEntry)) {
                    return;
                }
                int count = this.valuesIterator.entryValueCount();
                for (int i = 0; i < count; ++i) {
                    long dimensionLongValue = this.valuesIterator.nextValue();
                    double dimensionValue = RangeAggregator.this.valuesSource.isFloatingPoint() ? ((NumberFieldMapper.NumberFieldType)RangeAggregator.this.context.mapperService().fieldType(RangeAggregator.this.fieldName)).toDoubleValue(dimensionLongValue) : (double)dimensionLongValue;
                    MatchedRange matchedRange = new MatchedRange(RangeAggregator.this.ranges, 0, dimensionValue, RangeAggregator.this.maxTo);
                    if (matchedRange.startLo > matchedRange.endHi || !this.docCountsIterator.advanceExact(starTreeEntry)) continue;
                    long metricValue = this.docCountsIterator.nextValue();
                    for (int j = matchedRange.startLo; j <= matchedRange.endHi; ++j) {
                        if (!RangeAggregator.this.ranges[j].matches(dimensionValue)) continue;
                        long bucketOrd = RangeAggregator.this.subBucketOrdinal(owningBucketOrd, j);
                        RangeAggregator.this.collectStarTreeBucket(this, metricValue, bucketOrd, starTreeEntry);
                    }
                }
            }
        };
    }

    private long subBucketOrdinal(long owningBucketOrdinal, int rangeOrd) {
        return owningBucketOrdinal * (long)this.ranges.length + (long)rangeOrd;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForFixedBucketCount(owningBucketOrds, this.ranges.length, (offsetInOwningOrd, docCount, subAggregationResults) -> {
            this.checkCancelled();
            Range range = this.ranges[offsetInOwningOrd];
            return this.rangeFactory.createBucket(range.key, range.from, range.to, docCount, subAggregationResults, this.keyed, this.format);
        }, buckets -> this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList buckets = new ArrayList(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            Range range = this.ranges[i];
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, 0L, subAggs, this.keyed, this.format);
            buckets.add(bucket);
        }
        return this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.metadata());
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        this.filterRewriteOptimizationContext.populateDebugInfo(add);
    }

    public static class Range
    implements Writeable,
    ToXContentObject {
        public static final ParseField KEY_FIELD = new ParseField("key", new String[0]);
        public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
        public static final ParseField TO_FIELD = new ParseField("to", new String[0]);
        protected final String key;
        protected final double from;
        protected final String fromAsStr;
        protected final double to;
        protected final String toAsStr;
        public static final ConstructingObjectParser<Range, Void> PARSER = new ConstructingObjectParser("range", arg -> {
            String key = (String)arg[0];
            Object from = arg[1];
            Object to = arg[2];
            Double fromDouble = from instanceof Number ? Double.valueOf(((Number)from).doubleValue()) : null;
            Double toDouble = to instanceof Number ? Double.valueOf(((Number)to).doubleValue()) : null;
            String fromStr = from instanceof String ? (String)from : null;
            String toStr = to instanceof String ? (String)to : null;
            return new Range(key, fromDouble, fromStr, toDouble, toStr);
        });

        public Range(String key, Double from, String fromAsStr, Double to, String toAsStr) {
            this.key = key;
            this.from = from == null ? Double.NEGATIVE_INFINITY : from;
            this.fromAsStr = fromAsStr;
            this.to = to == null ? Double.POSITIVE_INFINITY : to;
            this.toAsStr = toAsStr;
        }

        public Range(String key, Double from, Double to) {
            this(key, from, null, to, null);
        }

        public Range(String key, String from, String to) {
            this(key, null, from, null, to);
        }

        public Range(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.fromAsStr = in.readOptionalString();
            this.toAsStr = in.readOptionalString();
            this.from = in.readDouble();
            this.to = in.readDouble();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeOptionalString(this.fromAsStr);
            out.writeOptionalString(this.toAsStr);
            out.writeDouble(this.from);
            out.writeDouble(this.to);
        }

        public double getFrom() {
            return this.from;
        }

        public double getTo() {
            return this.to;
        }

        public String getFromAsString() {
            return this.fromAsStr;
        }

        public String getToAsString() {
            return this.toAsStr;
        }

        public String getKey() {
            return this.key;
        }

        boolean matches(double value) {
            return value >= this.from && value < this.to;
        }

        public String toString() {
            return "[" + this.from + " to " + this.to + ")";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.key != null) {
                builder.field(KEY_FIELD.getPreferredName(), this.key);
            }
            if (Double.isFinite(this.from)) {
                builder.field(FROM_FIELD.getPreferredName(), this.from);
            }
            if (Double.isFinite(this.to)) {
                builder.field(TO_FIELD.getPreferredName(), this.to);
            }
            if (this.fromAsStr != null) {
                builder.field(FROM_FIELD.getPreferredName(), this.fromAsStr);
            }
            if (this.toAsStr != null) {
                builder.field(TO_FIELD.getPreferredName(), this.toAsStr);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.from, this.fromAsStr, this.to, this.toAsStr);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.from, other.from) && Objects.equals(this.fromAsStr, other.fromAsStr) && Objects.equals(this.to, other.to) && Objects.equals(this.toAsStr, other.toAsStr);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), KEY_FIELD, ObjectParser.ValueType.DOUBLE);
            ContextParser fromToParser = (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return p.text();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.doubleValue();
                }
                return null;
            };
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), fromToParser, FROM_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), fromToParser, TO_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
        }
    }

    public static class Unmapped<R extends Range>
    extends NonCollectingAggregator {
        private final R[] ranges;
        private final boolean keyed;
        private final InternalRange.Factory factory;
        private final DocValueFormat format;

        public Unmapped(String name, AggregatorFactories factories, R[] ranges, boolean keyed, DocValueFormat format, SearchContext context, Aggregator parent, InternalRange.Factory factory, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
            this.ranges = ranges;
            this.keyed = keyed;
            this.format = format;
            this.factory = factory;
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            InternalAggregations subAggs = this.buildEmptySubAggregations();
            ArrayList buckets = new ArrayList(this.ranges.length);
            for (R range : this.ranges) {
                buckets.add(this.factory.createBucket(((Range)range).key, ((Range)range).from, ((Range)range).to, 0L, subAggs, this.keyed, this.format));
            }
            return this.factory.create(this.name, buckets, this.format, this.keyed, this.metadata());
        }
    }

    static class MatchedRange {
        int startLo;
        int endHi;

        MatchedRange(Range[] ranges, int lowBound, double value, double[] maxTo) {
            this.computeMatchingRange(ranges, lowBound, value, maxTo);
        }

        private void computeMatchingRange(Range[] ranges, int lowBound, double value, double[] maxTo) {
            int lo = lowBound;
            int hi = ranges.length - 1;
            int mid = lo + hi >>> 1;
            while (lo <= hi) {
                if (value < ranges[mid].from) {
                    hi = mid - 1;
                } else {
                    if (!(value >= maxTo[mid])) break;
                    lo = mid + 1;
                }
                mid = lo + hi >>> 1;
            }
            if (lo > hi) {
                this.startLo = lo;
                this.endHi = lo - 1;
                return;
            }
            int startLo = lo;
            int startHi = mid;
            while (startLo <= startHi) {
                int startMid = startLo + startHi >>> 1;
                if (value >= maxTo[startMid]) {
                    startLo = startMid + 1;
                    continue;
                }
                startHi = startMid - 1;
            }
            int endLo = mid;
            int endHi = hi;
            while (endLo <= endHi) {
                int endMid = endLo + endHi >>> 1;
                if (value < ranges[endMid].from) {
                    endHi = endMid - 1;
                    continue;
                }
                endLo = endMid + 1;
            }
            assert (startLo == lowBound || value >= maxTo[startLo - 1]);
            assert (endHi == ranges.length - 1 || value < ranges[endHi + 1].from);
            this.startLo = startLo;
            this.endHi = endHi;
        }
    }
}

