/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import java.io.IOException;
import java.util.List;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rule.autotagging.Rule;

@ExperimentalApi
public class GetRuleResponse
extends ActionResponse
implements ToXContent,
ToXContentObject {
    private final List<Rule> rules;
    private final String searchAfter;

    public GetRuleResponse(List<Rule> rules, String searchAfter) {
        this.rules = rules;
        this.searchAfter = searchAfter;
    }

    public GetRuleResponse(StreamInput in) throws IOException {
        this(in.readList(Rule::new), in.readOptionalString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.rules);
        out.writeOptionalString(this.searchAfter);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("rules");
        for (Rule rule : this.rules) {
            rule.toXContent(builder, params);
        }
        builder.endArray();
        if (this.searchAfter != null && !this.searchAfter.isEmpty()) {
            builder.field("search_after", (Object)new Object[]{this.searchAfter});
        }
        builder.endObject();
        return builder;
    }

    public List<Rule> getRules() {
        return this.rules;
    }
}

