/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class PackagePart extends Base {

	public PackagePart(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Returns the absolute path of this PackagePart.
	 *
	 * @return Returns the absolute path of this PackagePart
	 * @throws Lib3MFException
	 */
	public String getPath() throws Lib3MFException {
		Pointer bytesNeededPath = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_packagepart_getpath.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededPath, null}));
		int sizePath = bytesNeededPath.getInt(0);
		Pointer bufferPath = new Memory(sizePath);
		mWrapper.checkError(this, mWrapper.lib3mf_packagepart_getpath.invokeInt(new java.lang.Object[]{mHandle, sizePath, bytesNeededPath, bufferPath}));
		return new String(bufferPath.getByteArray(0, sizePath - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the absolute path of this PackagePart.
	 *
	 * @param path Sets the absolute path of this PackagePart.
	 * @throws Lib3MFException
	 */
	public void setPath(String path) throws Lib3MFException {
		byte[] bytesPath = path.getBytes(StandardCharsets.UTF_8);
		Memory bufferPath = new Memory(bytesPath.length + 1);
		bufferPath.write(0, bytesPath, 0, bytesPath.length);
		bufferPath.setByte(bytesPath.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_packagepart_setpath.invokeInt(new java.lang.Object[]{mHandle, bufferPath}));
	}


}

