/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystem;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.collection.CollectRequest;
import org.jetbrains.kotlin.org.eclipse.aether.collection.CollectResult;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyCollectionException;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.DependencyCollector;
import org.jetbrains.kotlin.org.eclipse.aether.impl.Deployer;
import org.jetbrains.kotlin.org.eclipse.aether.impl.Installer;
import org.jetbrains.kotlin.org.eclipse.aether.impl.LocalRepositoryProvider;
import org.jetbrains.kotlin.org.eclipse.aether.impl.MetadataResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionResolver;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.spi.synccontext.SyncContextFactory;

@Singleton
@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;
    private RepositorySystemLifecycle repositorySystemLifecycle;

    @Deprecated
    public DefaultRepositorySystem() {
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositorySystemLifecycle(locator.getService(RepositorySystemLifecycle.class));
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifact resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadata resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.artifactDescriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        this.dependencyCollector = Objects.requireNonNull(dependencyCollector, "dependency collector cannot be null");
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        this.installer = Objects.requireNonNull(installer, "installer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        this.deployer = Objects.requireNonNull(deployer, "deployer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        this.localRepositoryProvider = Objects.requireNonNull(localRepositoryProvider, "local repository provider cannot be null");
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultRepositorySystem setRepositorySystemLifecycle(RepositorySystemLifecycle repositorySystemLifecycle) {
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle, "repository system lifecycle cannot be null");
        return this;
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(requests, "requests cannot be null");
        return this.artifactResolver.resolveArtifacts(session, requests);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.dependencyCollector.collectDependencies(session, request);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void validateSession(RepositorySystemSession session) {
        Objects.requireNonNull(session, "repository system session cannot be null");
        this.invalidSession(session.getLocalRepositoryManager(), "local repository manager");
        this.invalidSession(session.getSystemProperties(), "system properties");
        this.invalidSession(session.getUserProperties(), "user properties");
        this.invalidSession(session.getConfigProperties(), "config properties");
        this.invalidSession(session.getMirrorSelector(), "mirror selector");
        this.invalidSession(session.getProxySelector(), "proxy selector");
        this.invalidSession(session.getAuthenticationSelector(), "authentication selector");
        this.invalidSession(session.getArtifactTypeRegistry(), "artifact type registry");
        this.invalidSession(session.getData(), "data");
        if (this.shutdown.get()) {
            throw new IllegalStateException("repository system is already shut down");
        }
    }

    private void invalidSession(Object obj, String name) {
        Objects.requireNonNull(obj, "repository system session's " + name + " cannot be null");
    }
}

