/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.PathSource;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractManagedType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.AttributeContainer;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.NonAggregatedCompositeSqmPathSource;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmManagedDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.jboss.logging.Logger;

public abstract class AbstractIdentifiableType<J>
extends AbstractManagedType<J>
implements IdentifiableDomainType<J>,
Serializable {
    private final boolean hasIdentifierProperty;
    private final boolean hasIdClass;
    private SqmSingularPersistentAttribute<J, ?> id;
    private List<SqmSingularPersistentAttribute<? super J, ?>> nonAggregatedIdAttributes;
    private SqmEmbeddableDomainType<?> idClassType;
    private SqmPathSource<?> identifierDescriptor;
    private final boolean isVersioned;
    private SqmSingularPersistentAttribute<J, ?> versionAttribute;
    private List<SqmPersistentAttribute<J, ?>> naturalIdAttributes;
    private static final Logger log = Logger.getLogger(AbstractIdentifiableType.class);

    public AbstractIdentifiableType(String typeName, JavaType<J> javaType, IdentifiableDomainType<? super J> superType, boolean hasIdClass, boolean hasIdentifierProperty, boolean versioned, JpaMetamodelImplementor metamodel) {
        super(typeName, javaType, superType, metamodel);
        this.hasIdClass = hasIdClass;
        this.hasIdentifierProperty = hasIdentifierProperty;
        this.isVersioned = versioned;
    }

    @Override
    protected AttributeContainer.InFlightAccess<J> createInFlightAccess() {
        return new InFlightAccessImpl(super.createInFlightAccess());
    }

    @Override
    public SqmPathSource<?> getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    @Override
    public boolean hasIdClass() {
        return this.hasIdClass;
    }

    public boolean hasSingleIdAttribute() {
        return !this.hasIdClass() && this.hasIdentifierProperty;
    }

    @Override
    public AbstractIdentifiableType<? super J> getSuperType() {
        return (AbstractIdentifiableType)super.getSuperType();
    }

    @Override
    public IdentifiableDomainType<? super J> getSupertype() {
        return this.getSuperType();
    }

    @Override
    public <Y> SqmSingularPersistentAttribute<? super J, Y> getId(Class<Y> javaType) {
        this.ensureNoIdClass();
        SingularPersistentAttribute id = this.findIdAttribute();
        if (id != null) {
            this.checkType(id, javaType);
        }
        return id;
    }

    private void ensureNoIdClass() {
        if (this.hasIdClass()) {
            throw new IllegalArgumentException("Illegal call to IdentifiableType#getId for class [" + this.getTypeName() + "] defined with @IdClass");
        }
    }

    @Override
    public SqmSingularPersistentAttribute<? super J, ?> findIdAttribute() {
        if (this.id != null) {
            return this.id;
        }
        if (this.getSuperType() != null) {
            return ((AbstractIdentifiableType)this.getSuperType()).findIdAttribute();
        }
        return null;
    }

    private void checkType(SingularPersistentAttribute<?, ?> attribute, Class<?> javaType) {
        PrimitiveJavaType primitiveJavaType;
        JavaType attributeJavaType;
        if (!(javaType.isAssignableFrom(attribute.getType().getJavaType()) || (attributeJavaType = attribute.getAttributeJavaType()) instanceof PrimitiveJavaType && (primitiveJavaType = (PrimitiveJavaType)attributeJavaType).getPrimitiveClass() == javaType)) {
            throw new IllegalArgumentException(String.format("Attribute [%s#%s : %s] not castable to requested type [%s]", this.getTypeName(), attribute.getName(), attribute.getType().getJavaType().getName(), javaType.getName()));
        }
    }

    @Override
    public <Y> SqmSingularPersistentAttribute<J, Y> getDeclaredId(Class<Y> javaType) {
        this.ensureNoIdClass();
        if (this.id == null) {
            throw new IllegalArgumentException("The id attribute is not declared on this type [" + this.getTypeName() + "]");
        }
        this.checkType(this.id, javaType);
        return this.id;
    }

    @Override
    public SimpleDomainType<?> getIdType() {
        SingularPersistentAttribute id = this.findIdAttribute();
        if (id != null) {
            return id.getType();
        }
        Set<SingularPersistentAttribute<J, ?>> idClassAttributes = this.getIdClassAttributesSafely();
        if (idClassAttributes != null) {
            if (idClassAttributes.size() == 1) {
                return idClassAttributes.iterator().next().getType();
            }
            SqmEmbeddableDomainType<?> sqmEmbeddableDomainType = this.idClassType;
            if (sqmEmbeddableDomainType instanceof SimpleDomainType) {
                SimpleDomainType simpleDomainType = (SimpleDomainType)((Object)sqmEmbeddableDomainType);
                return simpleDomainType;
            }
        }
        return null;
    }

    public Set<SingularPersistentAttribute<? super J, ?>> getIdClassAttributesSafely() {
        if (this.hasIdClass()) {
            HashSet attributes = new HashSet();
            this.visitIdClassAttributes(attributes::add);
            return attributes.isEmpty() ? null : attributes;
        }
        return null;
    }

    @Override
    public Set<SingularAttribute<? super J, ?>> getIdClassAttributes() {
        if (!this.hasIdClass()) {
            throw new IllegalArgumentException("This class [" + String.valueOf(this.getJavaType()) + "] does not define an IdClass");
        }
        HashSet attributes = new HashSet();
        this.visitIdClassAttributes(attributes::add);
        if (attributes.isEmpty()) {
            throw new IllegalArgumentException("Unable to locate IdClass attributes [" + String.valueOf(this.getJavaType()) + "]");
        }
        return attributes;
    }

    @Override
    public void visitIdClassAttributes(Consumer<SingularPersistentAttribute<? super J, ?>> attributeConsumer) {
        if (this.nonAggregatedIdAttributes != null) {
            this.nonAggregatedIdAttributes.forEach(attributeConsumer);
        } else if (this.getSuperType() != null) {
            ((AbstractIdentifiableType)this.getSuperType()).visitIdClassAttributes(attributeConsumer);
        }
    }

    public boolean hasVersionAttribute() {
        return this.isVersioned;
    }

    public boolean hasDeclaredVersionAttribute() {
        return this.isVersioned && this.versionAttribute != null;
    }

    @Override
    public <Y> SingularPersistentAttribute<? super J, Y> getVersion(Class<Y> javaType) {
        if (this.hasVersionAttribute()) {
            SingularPersistentAttribute version = this.findVersionAttribute();
            if (version != null) {
                this.checkType(version, javaType);
            }
            return version;
        }
        return null;
    }

    @Override
    public SqmSingularPersistentAttribute<? super J, ?> findVersionAttribute() {
        if (this.versionAttribute != null) {
            return this.versionAttribute;
        }
        if (this.getSuperType() != null) {
            return ((AbstractIdentifiableType)this.getSuperType()).findVersionAttribute();
        }
        return null;
    }

    @Override
    public List<? extends PersistentAttribute<? super J, ?>> findNaturalIdAttributes() {
        if (this.naturalIdAttributes != null) {
            return this.naturalIdAttributes;
        }
        if (this.getSuperType() != null) {
            return ((AbstractIdentifiableType)this.getSuperType()).findNaturalIdAttributes();
        }
        return null;
    }

    @Override
    public <Y> SingularPersistentAttribute<J, Y> getDeclaredVersion(Class<Y> javaType) {
        this.checkDeclaredVersion();
        this.checkType(this.versionAttribute, javaType);
        return this.versionAttribute;
    }

    private void checkDeclaredVersion() {
        if (this.versionAttribute == null || this.getSuperType() != null && ((AbstractIdentifiableType)this.getSuperType()).hasVersionAttribute()) {
            throw new IllegalArgumentException("The version attribute is not declared by this type [" + String.valueOf(this.getJavaType()) + "]");
        }
    }

    public SqmSingularPersistentAttribute<J, ?> getDeclaredVersion() {
        this.checkDeclaredVersion();
        return this.versionAttribute;
    }

    private SqmPathSource<?> interpretIdDescriptor() {
        PathSource idDescriptor;
        log.tracef("Interpreting domain-model identifier descriptor", new Object[0]);
        SqmManagedDomainType superType = this.getSuperType();
        if (superType != null && (idDescriptor = ((AbstractIdentifiableType)superType).getIdentifierDescriptor()) != null) {
            return idDescriptor;
        }
        if (this.id != null) {
            return this.pathSource(this.id);
        }
        if (this.nonAggregatedIdAttributes != null && !this.nonAggregatedIdAttributes.isEmpty()) {
            return this.compositePathSource();
        }
        if (this.isIdMappingRequired()) {
            throw new UnsupportedMappingException("Could not build SqmPathSource for entity identifier : " + this.getTypeName());
        }
        return null;
    }

    private AbstractSqmPathSource<?> compositePathSource() {
        if (this.idClassType == null) {
            return new NonAggregatedCompositeSqmPathSource("{id}", null, Bindable.BindableType.SINGULAR_ATTRIBUTE, this);
        }
        return new EmbeddedSqmPathSource("{id}", null, this.idClassType, Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
    }

    private <T> AbstractSqmPathSource<T> pathSource(SqmSingularPersistentAttribute<J, T> attribute) {
        Type type = attribute.getType();
        if (type instanceof BasicDomainType) {
            BasicDomainType basicDomainType = (BasicDomainType)type;
            return new BasicSqmPathSource("{id}", attribute, basicDomainType, type.getExpressibleJavaType(), Bindable.BindableType.SINGULAR_ATTRIBUTE, attribute.isGeneric());
        }
        if (type instanceof SqmEmbeddableDomainType) {
            SqmEmbeddableDomainType embeddableDomainType = (SqmEmbeddableDomainType)type;
            return new EmbeddedSqmPathSource("{id}", attribute, embeddableDomainType, Bindable.BindableType.SINGULAR_ATTRIBUTE, attribute.isGeneric());
        }
        if (type instanceof BasicSqmPathSource) {
            BasicSqmPathSource pathSource = (BasicSqmPathSource)type;
            return pathSource;
        }
        throw new AssertionFailure("Unrecognized type: " + String.valueOf(type));
    }

    protected boolean isIdMappingRequired() {
        return true;
    }

    private class InFlightAccessImpl
    extends AbstractManagedType.InFlightAccessImpl {
        private final AttributeContainer.InFlightAccess<J> managedTypeAccess;

        private InFlightAccessImpl(AttributeContainer.InFlightAccess<J> managedTypeAccess) {
            super(AbstractIdentifiableType.this);
            this.managedTypeAccess = managedTypeAccess;
        }

        @Override
        public void applyIdAttribute(SingularPersistentAttribute<J, ?> idAttribute) {
            AbstractIdentifiableType.this.id = (SqmSingularPersistentAttribute)idAttribute;
            this.managedTypeAccess.addAttribute(idAttribute);
        }

        @Override
        public void applyNonAggregatedIdAttributes(Set<SingularPersistentAttribute<? super J, ?>> idAttributes, EmbeddableDomainType<?> idClassType) {
            if (AbstractIdentifiableType.this.id != null) {
                throw new IllegalArgumentException("`AbstractIdentifiableType#id` already set on call to `#applyNonAggregatedIdAttribute`");
            }
            if (AbstractIdentifiableType.this.nonAggregatedIdAttributes != null) {
                throw new IllegalStateException("Non-aggregated id attributes were already set");
            }
            if (idAttributes.isEmpty()) {
                AbstractIdentifiableType.this.nonAggregatedIdAttributes = Collections.emptyList();
            } else {
                AbstractIdentifiableType.this.nonAggregatedIdAttributes = new ArrayList(idAttributes.size());
                for (SingularPersistentAttribute idAttribute : idAttributes) {
                    AbstractIdentifiableType.this.nonAggregatedIdAttributes.add((SqmSingularPersistentAttribute)idAttribute);
                    if (AbstractIdentifiableType.this != idAttribute.getDeclaringType()) continue;
                    SingularPersistentAttribute declaredAttribute = idAttribute;
                    this.addAttribute(declaredAttribute);
                }
            }
            AbstractIdentifiableType.this.idClassType = (SqmEmbeddableDomainType)idClassType;
        }

        @Override
        public void applyIdClassAttributes(Set<SingularPersistentAttribute<? super J, ?>> idClassAttributes) {
            this.applyNonAggregatedIdAttributes(idClassAttributes, null);
        }

        @Override
        public void applyVersionAttribute(SingularPersistentAttribute<J, ?> versionAttribute) {
            AbstractIdentifiableType.this.versionAttribute = (SqmSingularPersistentAttribute)versionAttribute;
            this.managedTypeAccess.addAttribute(versionAttribute);
        }

        @Override
        public void applyNaturalIdAttribute(PersistentAttribute<J, ?> naturalIdAttribute) {
            if (AbstractIdentifiableType.this.naturalIdAttributes == null) {
                AbstractIdentifiableType.this.naturalIdAttributes = new ArrayList();
            }
            AbstractIdentifiableType.this.naturalIdAttributes.add((SqmPersistentAttribute)naturalIdAttribute);
        }

        @Override
        public void addAttribute(PersistentAttribute<J, ?> attribute) {
            this.managedTypeAccess.addAttribute(attribute);
        }

        @Override
        public void finishUp() {
            this.managedTypeAccess.finishUp();
            AbstractIdentifiableType.this.identifierDescriptor = AbstractIdentifiableType.this.interpretIdDescriptor();
        }
    }
}

