/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.keycloak.vault.VaultRawSecret;

public class DefaultVaultRawSecret
implements VaultRawSecret {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final VaultRawSecret EMPTY_VAULT_SECRET = new VaultRawSecret(){

        public Optional<ByteBuffer> get() {
            return Optional.empty();
        }

        public Optional<byte[]> getAsArray() {
            return Optional.empty();
        }

        public void close() {
        }
    };
    private ByteBuffer rawSecret;
    private byte[] secretArray;

    public static VaultRawSecret forBuffer(Optional<ByteBuffer> buffer) {
        if (buffer == null || !buffer.isPresent()) {
            return EMPTY_VAULT_SECRET;
        }
        return new DefaultVaultRawSecret(buffer.get());
    }

    private DefaultVaultRawSecret(ByteBuffer rawSecret) {
        this.rawSecret = rawSecret;
    }

    public Optional<ByteBuffer> get() {
        return Optional.of(this.rawSecret);
    }

    public Optional<byte[]> getAsArray() {
        if (this.secretArray == null) {
            if (this.rawSecret.hasArray()) {
                this.secretArray = this.rawSecret.array();
            } else {
                this.secretArray = new byte[this.rawSecret.capacity()];
                this.rawSecret.get(this.secretArray);
            }
        }
        return Optional.of(this.secretArray);
    }

    public void close() {
        if (this.rawSecret.hasArray()) {
            ThreadLocalRandom.current().nextBytes(this.rawSecret.array());
        }
        if (this.secretArray != null) {
            ThreadLocalRandom.current().nextBytes(this.secretArray);
            this.secretArray = null;
        }
        this.rawSecret.clear();
        this.rawSecret = EMPTY_BUFFER;
    }
}

