/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.hibernate.Incubating;
import org.hibernate.boot.BootLogging;

@Incubating
public enum CollectionClassification {
    ARRAY,
    BAG,
    ID_BAG,
    LIST,
    SET,
    SORTED_SET,
    ORDERED_SET,
    MAP,
    SORTED_MAP,
    ORDERED_MAP;


    public PluralAttribute.CollectionType toJpaClassification() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1, 2 -> PluralAttribute.CollectionType.COLLECTION;
            case 3 -> PluralAttribute.CollectionType.LIST;
            case 4, 5, 6 -> PluralAttribute.CollectionType.SET;
            case 7, 8, 9 -> PluralAttribute.CollectionType.MAP;
        };
    }

    public boolean isIndexed() {
        return switch (this.ordinal()) {
            case 0, 3, 7, 8, 9 -> true;
            default -> false;
        };
    }

    public boolean isRowUpdatePossible() {
        return this != BAG && this != SET;
    }

    public static CollectionClassification interpretSetting(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CollectionClassification) {
            CollectionClassification classification = (CollectionClassification)((Object)value);
            return classification;
        }
        if (value instanceof String) {
            String string = (String)value;
            for (CollectionClassification collectionClassification : CollectionClassification.values()) {
                if (!collectionClassification.name().equalsIgnoreCase(string)) continue;
                return collectionClassification;
            }
            return null;
        }
        if (value instanceof Class) {
            Class type = (Class)value;
            return CollectionClassification.interpretClass(type);
        }
        return null;
    }

    private static CollectionClassification interpretClass(Class<?> configuredClass) {
        if (List.class.isAssignableFrom(configuredClass)) {
            return LIST;
        }
        if (SortedSet.class.isAssignableFrom(configuredClass)) {
            return SORTED_SET;
        }
        if (Set.class.isAssignableFrom(configuredClass)) {
            return SET;
        }
        if (SortedMap.class.isAssignableFrom(configuredClass)) {
            return SORTED_MAP;
        }
        if (Map.class.isAssignableFrom(configuredClass)) {
            return MAP;
        }
        if (Collection.class.isAssignableFrom(configuredClass)) {
            return BAG;
        }
        BootLogging.BOOT_LOGGER.debugf("Unexpected Class specified for CollectionClassification resolution (`%s`) - should be one of `%s`, `%s`, `%s`, `%s`, `%s` or `%s`  (or subclass of)", new Object[]{configuredClass.getName(), List.class.getName(), SortedSet.class.getName(), Set.class.getName(), SortedMap.class.isAssignableFrom(configuredClass), Map.class.isAssignableFrom(configuredClass), Collection.class.getName()});
        return null;
    }
}

