/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MetaAttribute
implements Serializable {
    private final String name;
    private final List<String> values = new ArrayList<String>();

    public MetaAttribute(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String getValue() {
        if (this.values.size() != 1) {
            throw new IllegalStateException("no unique value");
        }
        return this.values.get(0);
    }

    public boolean isMultiValued() {
        return this.values.size() > 1;
    }

    public String toString() {
        return "[" + this.name + "=" + String.valueOf(this.values) + "]";
    }
}

