/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.spi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.hibernate.type.descriptor.jdbc.StructHelper;
import org.hibernate.type.format.JsonDocumentWriter;

public class JsonGeneratingVisitor {
    public static final JsonGeneratingVisitor INSTANCE = new JsonGeneratingVisitor();

    protected JsonGeneratingVisitor() {
    }

    public void visitArray(JavaType<?> elementJavaType, JdbcType elementJdbcType, Object[] values, WrapperOptions options, JsonDocumentWriter writer) {
        writer.startArray();
        if (values.length == 0) {
            writer.endArray();
            return;
        }
        if (elementJdbcType instanceof JsonJdbcType) {
            JsonJdbcType jsonElementJdbcType = (JsonJdbcType)elementJdbcType;
            this.visitPluralAggregateValues(jsonElementJdbcType, values, options, writer);
        } else {
            assert (!(elementJdbcType instanceof AggregateJdbcType));
            this.visitBasicPluralValues(elementJavaType, elementJdbcType, values, options, writer);
        }
        writer.endArray();
    }

    private void visitPluralAggregateValues(AggregateJdbcType elementJdbcType, Object values, WrapperOptions options, JsonDocumentWriter writer) {
        EmbeddableMappingType embeddableMappingType = elementJdbcType.getEmbeddableMappingType();
        if (values.getClass().isArray()) {
            int length = Array.getLength(values);
            for (int j = 0; j < length; ++j) {
                try {
                    this.visit(embeddableMappingType, Array.get(values, j), options, writer);
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not serialize array element", e);
                }
            }
        } else if (values instanceof Collection) {
            Collection collection = (Collection)values;
            for (Object item : collection) {
                try {
                    this.visit(embeddableMappingType, item, options, writer);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not serialize array element", e);
                }
            }
        } else {
            throw new IllegalArgumentException("Expected array or collection value, but got: " + values.getClass().getName());
        }
    }

    private void visitBasicPluralValues(JavaType<?> elementJavaType, JdbcType elementJdbcType, Object values, WrapperOptions options, JsonDocumentWriter writer) {
        if (values.getClass().isArray()) {
            int length = Array.getLength(values);
            for (int j = 0; j < length; ++j) {
                Object item = Array.get(values, j);
                if (item == null) {
                    writer.nullValue();
                    continue;
                }
                writer.serializeJsonValue(item, elementJavaType, elementJdbcType, options);
            }
        } else if (values instanceof Collection) {
            Collection collection = (Collection)values;
            for (Object item : collection) {
                if (item == null) {
                    writer.nullValue();
                    continue;
                }
                writer.serializeJsonValue(item, elementJavaType, elementJdbcType, options);
            }
        } else {
            throw new IllegalArgumentException("Expected array or collection value, but got: " + values.getClass().getName());
        }
    }

    public void visit(MappingType mappedType, Object value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        if (this.handleNullOrLazy(value, writer)) {
            return;
        }
        if (mappedType instanceof EntityMappingType) {
            EntityMappingType entityType = (EntityMappingType)mappedType;
            this.serializeEntity(value, entityType, options, writer);
        } else if (mappedType instanceof ManagedMappingType) {
            ManagedMappingType managedMappingType = (ManagedMappingType)mappedType;
            this.serializeObject(managedMappingType, value, options, writer);
        } else if (mappedType instanceof BasicType) {
            BasicType basicType = (BasicType)mappedType;
            JdbcType jdbcType = basicType.getJdbcType();
            if (jdbcType instanceof ArrayJdbcType) {
                ArrayJdbcType arrayJdbcType = (ArrayJdbcType)jdbcType;
                Object domainValue = basicType.convertToRelationalValue(value);
                JdbcType elementJdbcType = arrayJdbcType.getElementJdbcType();
                writer.startArray();
                if (elementJdbcType instanceof AggregateJdbcType) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)elementJdbcType;
                    this.visitPluralAggregateValues(aggregateJdbcType, domainValue, options, writer);
                } else {
                    this.visitBasicPluralValues(((BasicPluralJavaType)((Object)basicType.getJdbcJavaType())).getElementJavaType(), elementJdbcType, domainValue, options, writer);
                }
                writer.endArray();
            } else {
                writer.serializeJsonValue(basicType.convertToRelationalValue(value), basicType.getJdbcJavaType(), basicType.getJdbcType(), options);
            }
        } else {
            throw new UnsupportedOperationException("Support for mapping type not yet implemented: " + mappedType.getClass().getName());
        }
    }

    protected boolean handleNullOrLazy(Object value, JsonDocumentWriter writer) {
        if (value == null) {
            writer.nullValue();
            return true;
        }
        return false;
    }

    private void serializeObject(ManagedMappingType managedMappingType, Object value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        writer.startObject();
        this.serializeObjectValues(managedMappingType, value, options, writer);
        writer.endObject();
    }

    protected void serializeObjectValues(ManagedMappingType managedMappingType, Object object, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        Object[] values = managedMappingType.getValues(object);
        for (int i = 0; i < values.length; ++i) {
            ValuedModelPart subPart = StructHelper.getSubPart(managedMappingType, i);
            Object value = values[i];
            this.serializeModelPart(subPart, value, options, writer);
        }
    }

    protected void serializeModelPart(ValuedModelPart modelPart, Object value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        if (modelPart instanceof SelectableMapping) {
            SelectableMapping selectableMapping = (SelectableMapping)((Object)modelPart);
            writer.objectKey(selectableMapping.getSelectableName());
            this.visit(modelPart.getMappedType(), value, options, writer);
        } else if (modelPart instanceof EmbeddedAttributeMapping) {
            EmbeddedAttributeMapping embeddedAttribute = (EmbeddedAttributeMapping)modelPart;
            if (value != null) {
                EmbeddableMappingType mappingType = embeddedAttribute.getMappedType();
                SelectableMapping aggregateMapping = mappingType.getAggregateMapping();
                if (aggregateMapping == null) {
                    this.serializeObjectValues(mappingType, value, options, writer);
                } else {
                    String name = aggregateMapping.getSelectableName();
                    writer.objectKey(name);
                    this.visit(mappingType, value, options, writer);
                }
            }
        } else {
            throw new UnsupportedOperationException("Support for model part type not yet implemented: " + (modelPart != null ? modelPart.getClass().getName() : "null"));
        }
    }

    protected void serializeEntity(Object value, EntityMappingType entityType, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        EntityIdentifierMapping identifierMapping = entityType.getIdentifierMapping();
        this.serializeEntityIdentifier(value, identifierMapping, options, writer);
    }

    protected void serializeEntityIdentifier(Object value, EntityIdentifierMapping identifierMapping, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        Object identifier = identifierMapping.getIdentifier(value);
        if (identifierMapping instanceof SingleAttributeIdentifierMapping) {
            SingleAttributeIdentifierMapping singleAttribute = (SingleAttributeIdentifierMapping)identifierMapping;
            writer.serializeJsonValue(identifier, singleAttribute.getJavaType(), singleAttribute.getSingleJdbcMapping().getJdbcType(), options);
        } else if (identifier instanceof CompositeIdentifierMapping) {
            CompositeIdentifierMapping composite = (CompositeIdentifierMapping)identifier;
            this.visit(composite.getMappedType(), identifier, options, writer);
        } else {
            throw new UnsupportedOperationException("Unsupported identifier type: " + identifier.getClass().getName());
        }
    }
}

