/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.List;
import java.util.Objects;
import org.hibernate.Incubating;
import org.hibernate.query.criteria.JpaSetReturningFunction;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleType;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;

@Incubating
public abstract class SqmSetReturningFunction<T>
extends AbstractSqmNode
implements SqmVisitableNode,
JpaSetReturningFunction<T> {
    private final String functionName;
    private final SqmSetReturningFunctionDescriptor functionDescriptor;
    private final List<? extends SqmTypedNode<?>> arguments;

    public SqmSetReturningFunction(String functionName, SqmSetReturningFunctionDescriptor functionDescriptor, List<? extends SqmTypedNode<?>> arguments, NodeBuilder criteriaBuilder) {
        super(criteriaBuilder);
        this.functionName = functionName;
        this.functionDescriptor = functionDescriptor;
        this.arguments = arguments;
    }

    @Override
    public abstract SqmSetReturningFunction<T> copy(SqmCopyContext var1);

    public SqmSetReturningFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public abstract AnonymousTupleType<T> getType();

    public List<? extends SqmTypedNode<?>> getArguments() {
        return this.arguments;
    }

    public abstract TableGroup convertToSqlAst(NavigablePath var1, String var2, boolean var3, boolean var4, boolean var5, SqmToSqlAstConverter var6);

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSetReturningFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(this.functionName);
        if (this.arguments.isEmpty()) {
            hql.append("()");
        } else {
            hql.append('(');
            this.arguments.get(0).appendHqlString(hql, context);
            for (int i = 1; i < this.arguments.size(); ++i) {
                hql.append(", ");
                this.arguments.get(i).appendHqlString(hql, context);
            }
            hql.append(')');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof SqmSetReturningFunction)) return false;
        SqmSetReturningFunction that = (SqmSetReturningFunction)other;
        if (!Objects.equals(this.functionName, that.functionName)) return false;
        if (!Objects.equals(this.arguments, that.arguments)) return false;
        if (this.getClass() != that.getClass()) return false;
        if (!Objects.equals(this.toHqlString(), that.toHqlString())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.arguments, this.getClass());
    }
}

