/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.cache.infinispan.events.AuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.RootAuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.stream.SessionWrapperPredicate;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class InfinispanAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private final KeycloakSession session;
    private final int authSessionsLimit;
    protected final InfinispanChangelogBasedTransaction<String, RootAuthenticationSessionEntity> sessionTx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;

    public InfinispanAuthenticationSessionProvider(KeycloakSession session, InfinispanChangelogBasedTransaction<String, RootAuthenticationSessionEntity> sessionTx, int authSessionsLimit) {
        this.session = session;
        this.authSessionsLimit = authSessionsLimit;
        this.sessionTx = sessionTx;
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm) {
        return this.createRootAuthenticationSession(realm, this.sessionTx.generateKey());
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm, String id) {
        RootAuthenticationSessionEntity entity = new RootAuthenticationSessionEntity(id);
        entity.setRealmId(realm.getId());
        entity.setTimestamp(Time.currentTime());
        SessionUpdateTask createAuthSessionTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(entity.getId(), createAuthSessionTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        return this.wrap(realm, entity);
    }

    private RootAuthenticationSessionAdapter wrap(RealmModel realm, RootAuthenticationSessionEntity entity) {
        return entity == null ? null : new RootAuthenticationSessionAdapter(this.session, this, realm, entity, this.authSessionsLimit);
    }

    private RootAuthenticationSessionEntity getRootAuthenticationSessionEntity(String authSessionId) {
        SessionEntityWrapper<RootAuthenticationSessionEntity> entityWrapper = this.sessionTx.get(authSessionId);
        return entityWrapper == null ? null : entityWrapper.getEntity();
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_AUTHSESSIONS", this.session, realm.getId()));
    }

    protected void onRealmRemovedEvent(String realmId) {
        Cache<String, SessionEntityWrapper<RootAuthenticationSessionEntity>> cache = this.sessionTx.getCache();
        Iterator itr = CacheDecorators.localCache(cache).entrySet().stream().filter(SessionWrapperPredicate.create(realmId)).iterator();
        while (itr.hasNext()) {
            CacheDecorators.localCache(cache).remove(((Map.Entry)itr.next()).getKey());
        }
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public void updateNonlocalSessionAuthNotes(AuthenticationSessionCompoundId compoundId, Map<String, String> authNotesFragment) {
        if (compoundId == null) {
            return;
        }
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("AUTHENTICATION_SESSION_EVENTS", (ClusterEvent)AuthenticationSessionAuthNoteUpdateEvent.create(compoundId.getRootSessionId(), compoundId.getTabId(), authNotesFragment), true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }

    public RootAuthenticationSessionModel getRootAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        RootAuthenticationSessionEntity entity = this.getRootAuthenticationSessionEntity(authenticationSessionId);
        return this.wrap(realm, entity);
    }

    public void removeRootAuthenticationSession(RealmModel realm, RootAuthenticationSessionModel authenticationSession) {
        SessionUpdateTask removeTask = Tasks.removeSync();
        this.sessionTx.addTask(authenticationSession.getId(), removeTask);
    }

    public void close() {
    }

    public Cache<String, SessionEntityWrapper<RootAuthenticationSessionEntity>> getCache() {
        return this.sessionTx.getCache();
    }

    public InfinispanChangelogBasedTransaction<String, RootAuthenticationSessionEntity> getRootAuthSessionTransaction() {
        return this.sessionTx;
    }

    public void migrate(String modelVersion) {
        if ("26.1.0".equals(modelVersion)) {
            InfinispanConnectionProvider infinispanConnectionProvider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
            Cache authSessionsCache = infinispanConnectionProvider.getCache("authenticationSessions");
            CompletionStages.join((CompletionStage)((PersistenceManager)ComponentRegistry.componentOf(authSessionsCache, PersistenceManager.class)).clearAllStores((Predicate)PersistenceManager.AccessMode.BOTH));
        }
    }
}

