/*******************************************************************************
* Copyright 2023 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER

template <int MAXROWSIZE>
ESIMD_INLINE void insertionsort_kernel(
    esimd::simd<int32_t, MAXROWSIZE> &inds,
    esimd::simd<double, MAXROWSIZE> &vals, int32_t length) {

    for (int step = 1; step < length; ++step) {

        int32_t keyInd = inds[step];
        double keyVal = vals[step];
        int j = step - 1;
        while (keyInd < static_cast<int32_t>(inds[j]) && j >= 0) {
            inds[j+1] = inds[j];
            vals[j+1] = vals[j];
            --j;
        }
//      int j_shift = esimd::fbl(esimd::pack_mask(keyInd < inds));
//      int count = j - j_shift;
//      inds. select<count, 1, int32_t>(j_shift+1) = inds.template select<count, 1, local_int_t>(j_shift);
//      vals.template select<count, 1, local_int_t>(j_shift+1) = vals.template select<count, 1, local_int_t>(j_shift);

        inds[j+1] = keyInd;
        vals[j+1] = keyVal;
    }
};
