/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriority;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolRole;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class ExasolRoleManager
extends SQLObjectEditor<ExasolRole, ExasolDataSource>
implements DBEObjectRenamer<ExasolRole> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolRole> getObjectsCache(ExasolRole object) {
        ExasolDataSource ds = object.getDataSource();
        return ds.getRoleCache();
    }

    protected ExasolRole createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new ExasolRole((ExasolDataSource)((Object)container), "ROLE", "");
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        String script = "CREATE ROLE " + DBUtils.getQuotedIdentifier((DBSObject)obj);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Role", script));
        if (!CommonUtils.isEmpty((String)obj.getDescription())) {
            actions.add((DBEPersistAction)this.Comment(obj));
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Role", "DROP ROLE " + DBUtils.getQuotedIdentifier((DBSObject)obj)));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolRole object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void processObjectRename(DBECommandContext commandContext, ExasolRole object, Map<String, Object> options, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, options, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename ROLE", "RENAME ROLE " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    private SQLDatabasePersistAction Comment(ExasolRole obj) {
        return new SQLDatabasePersistAction("Comment on Role", "COMMENT ON ROLE " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IS '" + ExasolUtils.quoteString(obj.getDescription()) + "'");
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        ExasolPriority priority = obj.getPriority();
        if (command.getProperties().containsKey("description")) {
            actionList.add((DBEPersistAction)this.Comment(obj));
        }
        if (command.getProperties().containsKey("priority")) {
            String script = "";
            if ("org.jkiss.dbeaver.ext.exasol.model.ExasolConsumerGroup".equals(priority.getClass().getName())) {
                script = String.format("ALTER ROLE %s SET CONSUMER_GROUP = %s", DBUtils.getQuotedIdentifier((DBSObject)obj), DBUtils.getQuotedIdentifier((DBSObject)priority));
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_assign_priority_group, script));
            } else if ("org.jkiss.dbeaver.ext.exasol.model.ExasolPriorityGroup".equals(priority.getClass().getName())) {
                script = String.format("GRANT PRIORITY GROUP %s to %s", DBUtils.getQuotedIdentifier((DBSObject)priority), DBUtils.getQuotedIdentifier((DBSObject)obj));
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_assign_priority_group, script));
            }
        }
    }
}

