# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "security setting create",
)
class Create(AAZCommand):
    """Create settings about different configurations in Microsoft Defender for Cloud

    :example: Create a security setting
        az security setting create -n Sentinel --alert-sync-settings enabled=true
        az security setting create -n MCAS --data-export-settings enabled=true
    """

    _aaz_info = {
        "version": "2022-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.security/settings/{}", "2022-05-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.setting_name = AAZStrArg(
            options=["-n", "--name", "--setting-name"],
            help="The name of the setting",
            required=True,
            enum={"MCAS": "MCAS", "Sentinel": "Sentinel", "WDATP": "WDATP", "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW": "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW", "WDATP_UNIFIED_SOLUTION": "WDATP_UNIFIED_SOLUTION"},
        )

        # define Arg Group "Setting"

        _args_schema = cls._args_schema
        _args_schema.alert_sync_settings = AAZObjectArg(
            options=["--alert-sync-settings"],
            arg_group="Setting",
        )
        _args_schema.data_export_settings = AAZObjectArg(
            options=["--data-export-settings"],
            arg_group="Setting",
        )

        alert_sync_settings = cls._args_schema.alert_sync_settings
        alert_sync_settings.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is the alert sync setting enabled",
        )

        data_export_settings = cls._args_schema.data_export_settings
        data_export_settings.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is the data export setting enabled",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SettingsUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SettingsUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Security/settings/{settingName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "settingName", self.ctx.args.setting_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_const("kind", "AlertSyncSettings", AAZStrType, ".alert_sync_settings", typ_kwargs={"flags": {"required": True}})
            _builder.set_const("kind", "DataExportSettings", AAZStrType, ".data_export_settings", typ_kwargs={"flags": {"required": True}})
            _builder.discriminate_by("kind", "AlertSyncSettings")
            _builder.discriminate_by("kind", "DataExportSettings")

            disc_alert_sync_settings = _builder.get("{kind:AlertSyncSettings}")
            if disc_alert_sync_settings is not None:
                disc_alert_sync_settings.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get("{kind:AlertSyncSettings}.properties")
            if properties is not None:
                properties.set_prop("enabled", AAZBoolType, ".alert_sync_settings.enabled", typ_kwargs={"flags": {"required": True}})

            disc_data_export_settings = _builder.get("{kind:DataExportSettings}")
            if disc_data_export_settings is not None:
                disc_data_export_settings.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get("{kind:DataExportSettings}.properties")
            if properties is not None:
                properties.set_prop("enabled", AAZBoolType, ".data_export_settings.enabled", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.kind = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            disc_alert_sync_settings = cls._schema_on_200.discriminate_by("kind", "AlertSyncSettings")
            disc_alert_sync_settings.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.discriminate_by("kind", "AlertSyncSettings").properties
            properties.enabled = AAZBoolType(
                flags={"required": True},
            )

            disc_data_export_settings = cls._schema_on_200.discriminate_by("kind", "DataExportSettings")
            disc_data_export_settings.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.discriminate_by("kind", "DataExportSettings").properties
            properties.enabled = AAZBoolType(
                flags={"required": True},
            )

            return cls._schema_on_200


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
