﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mailmanager/MailManager_EXPORTS.h>
#include <aws/mailmanager/model/ActionFailurePolicy.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MailManager {
namespace Model {

/**
 * <p>Sends the email to the internet using the ses:SendRawEmail API.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/SendAction">AWS
 * API Reference</a></p>
 */
class SendAction {
 public:
  AWS_MAILMANAGER_API SendAction() = default;
  AWS_MAILMANAGER_API SendAction(Aws::Utils::Json::JsonView jsonValue);
  AWS_MAILMANAGER_API SendAction& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MAILMANAGER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A policy that states what to do in the case of failure. The action will fail
   * if there are configuration errors. For example, the caller does not have the
   * permissions to call the sendRawEmail API.</p>
   */
  inline ActionFailurePolicy GetActionFailurePolicy() const { return m_actionFailurePolicy; }
  inline bool ActionFailurePolicyHasBeenSet() const { return m_actionFailurePolicyHasBeenSet; }
  inline void SetActionFailurePolicy(ActionFailurePolicy value) {
    m_actionFailurePolicyHasBeenSet = true;
    m_actionFailurePolicy = value;
  }
  inline SendAction& WithActionFailurePolicy(ActionFailurePolicy value) {
    SetActionFailurePolicy(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the role to use for this action. This role
   * must have access to the ses:SendRawEmail API.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  SendAction& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}
 private:
  ActionFailurePolicy m_actionFailurePolicy{ActionFailurePolicy::NOT_SET};

  Aws::String m_roleArn;
  bool m_actionFailurePolicyHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
