# -*- coding: utf-8 -*-
# Copyright 2025 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the ios_bfd_templates module
"""


class Bfd_templatesArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_bfd_templates module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"required": True, "type": "str"},
                "hop": {
                    "required": True,
                    "choices": ["single_hop", "multi_hop"],
                    "type": "str",
                },
                "interval": {
                    "type": "dict",
                    "options": {
                        "min_tx": {"type": "int"},
                        "min_rx": {"type": "int"},
                        "multiplier": {"type": "int"},
                    },
                },
                "dampening": {
                    "type": "dict",
                    "options": {
                        "half_life_period": {"type": "int"},
                        "reuse_threshold": {"type": "int"},
                        "suppress_threshold": {"type": "int"},
                        "max_suppress_time": {"type": "int"},
                    },
                },
                "echo": {"type": "bool"},
                "authentication": {
                    "type": "dict",
                    "options": {
                        "type": {
                            "choices": [
                                "sha_1",
                                "md5",
                                "meticulous_md5",
                                "meticulous_sha_1",
                            ],
                            "type": "str",
                        },
                        "keychain": {"type": "str", "no_log": False},
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "rendered",
                "gathered",
                "purged",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
