/*
 * knewsticker.h
 *
 * Copyright (c) 2000, 2001, 2007 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef KNEWSTICKER_H
#define KNEWSTICKER_H

#include <plasma/applet.h>

class QSignalMapper;
class QTimer;

struct NewsItem;
class NewsItemView;
class SettingsDialog;

class KNewsTicker : public Plasma::Applet
{
    Q_OBJECT
public:
    KNewsTicker( QObject *parent, const QVariantList &args );
    virtual ~KNewsTicker();

    virtual QSizeF contentSizeHint() const;

    virtual QList<QAction *> contextActions();

    bool hideArticle( const QUrl &url );

public Q_SLOTS:
    virtual void showConfigurationInterface();

private Q_SLOTS:
    void updateFeeds();
    void feedLoaded( const QUrl &url );
    void feedUpdateFinished();
    void openFeedItem( const QString &url );
    void settingsChanged( const QString &dialogName );
    void settingsAccepted();
    void setupItemView();

private:
    void reloadSettings();

    QList<NewsItem> m_items;
    QTimer *m_updateTimer;
    QSignalMapper *m_signalMapper;
    QSet<QUrl> m_readArticles;
    NewsItemView *m_itemView;
    SettingsDialog *m_settingsDialog;
};

#endif // KNEWSTICKER_H
