/* timsort.c generated by valac, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TIM_SORT (gee_tim_sort_get_type ())
#define GEE_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TIM_SORT, GeeTimSort))
#define GEE_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TIM_SORT, GeeTimSortClass))
#define GEE_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TIM_SORT))
#define GEE_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TIM_SORT))
#define GEE_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TIM_SORT, GeeTimSortClass))

typedef struct _GeeTimSort GeeTimSort;
typedef struct _GeeTimSortClass GeeTimSortClass;
typedef struct _GeeTimSortPrivate GeeTimSortPrivate;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;
typedef struct _GeeTimSortSlice GeeTimSortSlice;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;

struct _GeeTimSort {
	GObject parent_instance;
	GeeTimSortPrivate * priv;
};

struct _GeeTimSortClass {
	GObjectClass parent_class;
};

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeList* list_collection;
	gpointer* array;
	gint array_length1;
	gint array_size;
	gpointer* list;
	gint list_length1;
	gint list_size;
	gint index;
	gint size;
	GeeTimSortSlice** pending;
	gint pending_length1;
	gint pending_size;
	gint minimum_gallop;
	GCompareFunc compare;
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeArrayList {
	GeeAbstractList parent_instance;
	GeeArrayListPrivate * priv;
	gpointer* _items;
	gint _items_length1;
	gint _items_size;
	gint _size;
};

struct _GeeArrayListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeTimSortSlice {
	gpointer* list;
	gint list_length1;
	gint list_size;
	gpointer* new_list;
	gint new_list_length1;
	gint new_list_size;
	gint index;
	gint length;
};

typedef gboolean (*GeeTimSortLowerFunc) (gconstpointer left, gconstpointer right, void* user_data);

static gpointer gee_tim_sort_parent_class = NULL;

GType gee_tim_sort_get_type (void);
GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_bidir_iterator_get_type (void);
GType gee_list_iterator_get_type (void);
GType gee_list_get_type (void);
#define GEE_TIM_SORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TIM_SORT, GeeTimSortPrivate))
enum  {
	GEE_TIM_SORT_DUMMY_PROPERTY,
	GEE_TIM_SORT_G_TYPE,
	GEE_TIM_SORT_G_DUP_FUNC,
	GEE_TIM_SORT_G_DESTROY_FUNC
};
#define GEE_TIM_SORT_MINIMUM_GALLOP 7
GType gee_abstract_collection_get_type (void);
GType gee_abstract_list_get_type (void);
GType gee_array_list_get_type (void);
static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare);
static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare);
void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare);
GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
static void gee_tim_sort_do_sort (GeeTimSort* self);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
static GeeTimSortSlice* gee_tim_sort_slice_new (gpointer* list, int list_length1, gint index, gint length);
static GeeTimSortSlice* gee_tim_sort_slice_new (gpointer* list, int list_length1, gint index, gint length);
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length);
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending);
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self);
static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset);
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n);
static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value);
static void gee_tim_sort_merge_collapse (GeeTimSort* self);
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self);
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right);
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right);
static void gee_tim_sort_merge_at (GeeTimSort* self, gint index);
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline gconstpointer gee_tim_sort_slice_peek_first (GeeTimSortSlice* self);
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline gconstpointer gee_tim_sort_slice_peek_last (GeeTimSortSlice* self);
static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, gpointer* dest_array, int dest_array_length1, gint index, gint dest_index, gint count);
static inline gconstpointer gee_tim_sort_slice_pop_first (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, gpointer* dest_array, int dest_array_length1, gint index, gint dest_index, gint count);
static inline gconstpointer gee_tim_sort_slice_pop_last (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n);
static void gee_tim_sort_slice_free (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j);
static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self);
static void gee_tim_sort_finalize (GObject* obj);
static void gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);



#line 49 "timsort.vala"
void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare) {
#line 49 "timsort.vala"
	g_return_if_fail (list != NULL);
#line 50 "timsort.vala"
	if (GEE_IS_ARRAY_LIST (list)) {
#line 51 "timsort.vala"
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, GEE_ARRAY_LIST (list), compare);
#line 361 "timsort.c"
	} else {
#line 53 "timsort.vala"
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, list, compare);
#line 365 "timsort.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 57 "timsort.vala"
static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare) {
#line 377 "timsort.c"
	GeeTimSort* helper;
	GeeList* _tmp0_;
	gpointer* _tmp2_;
	gint _tmp1_;
	gpointer* _tmp3_;
#line 57 "timsort.vala"
	g_return_if_fail (list != NULL);
#line 58 "timsort.vala"
	helper = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 60 "timsort.vala"
	helper->priv->list_collection = (_tmp0_ = _g_object_ref0 (list), _g_object_unref0 (helper->priv->list_collection), _tmp0_);
#line 61 "timsort.vala"
	helper->priv->array = (_tmp2_ = gee_collection_to_array ((GeeCollection*) list, &_tmp1_), helper->priv->array = (_vala_array_free (helper->priv->array, helper->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL), helper->priv->array_length1 = _tmp1_, helper->priv->array_size = helper->priv->array_length1, _tmp2_);
#line 62 "timsort.vala"
	helper->priv->list = (_tmp3_ = helper->priv->array, helper->priv->list_length1 = helper->priv->array_length1, helper->priv->list_size = helper->priv->list_length1, _tmp3_);
#line 63 "timsort.vala"
	helper->priv->index = 0;
#line 64 "timsort.vala"
	helper->priv->size = gee_collection_get_size ((GeeCollection*) list);
#line 65 "timsort.vala"
	helper->priv->compare = compare;
#line 67 "timsort.vala"
	gee_tim_sort_do_sort (helper);
#line 70 "timsort.vala"
	gee_collection_clear ((GeeCollection*) list);
#line 403 "timsort.c"
	{
		gpointer* item_collection;
		int item_collection_length1;
		int item_it;
#line 71 "timsort.vala"
		item_collection = helper->priv->array;
#line 410 "timsort.c"
		item_collection_length1 = helper->priv->array_length1;
		for (item_it = 0; item_it < helper->priv->array_length1; item_it = item_it + 1) {
			gconstpointer _tmp4_;
			gpointer item;
			item = (_tmp4_ = item_collection[item_it], ((_tmp4_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp4_) : g_dup_func ((gpointer) _tmp4_));
			{
#line 72 "timsort.vala"
				gee_collection_add ((GeeCollection*) list, item);
#line 419 "timsort.c"
				_g_destroy_func0 (item);
			}
		}
	}
	_g_object_unref0 (helper);
}


#line 76 "timsort.vala"
static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare) {
#line 430 "timsort.c"
	GeeTimSort* helper;
	GeeList* _tmp0_;
	gpointer* _tmp1_;
#line 76 "timsort.vala"
	g_return_if_fail (list != NULL);
#line 77 "timsort.vala"
	helper = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 79 "timsort.vala"
	helper->priv->list_collection = (_tmp0_ = _g_object_ref0 ((GeeList*) list), _g_object_unref0 (helper->priv->list_collection), _tmp0_);
#line 80 "timsort.vala"
	helper->priv->list = (_tmp1_ = list->_items, helper->priv->list_length1 = list->_items_length1, helper->priv->list_size = helper->priv->list_length1, _tmp1_);
#line 81 "timsort.vala"
	helper->priv->index = 0;
#line 82 "timsort.vala"
	helper->priv->size = list->_size;
#line 83 "timsort.vala"
	helper->priv->compare = compare;
#line 85 "timsort.vala"
	gee_tim_sort_do_sort (helper);
#line 450 "timsort.c"
	_g_object_unref0 (helper);
}


static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GeeTimSortSlice*, *array, *size);
	}
	(*array)[(*length)++] = value;
}


#line 99 "timsort.vala"
static void gee_tim_sort_do_sort (GeeTimSort* self) {
#line 466 "timsort.c"
	GeeTimSortSlice** _tmp0_;
	GeeTimSortSlice* remaining;
	gint minimum_length;
#line 99 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 100 "timsort.vala"
	if (self->priv->size < 2) {
#line 101 "timsort.vala"
		return;
#line 476 "timsort.c"
	}
#line 104 "timsort.vala"
	self->priv->pending = (_tmp0_ = g_new0 (GeeTimSortSlice*, 0 + 1), self->priv->pending = (g_free (self->priv->pending), NULL), self->priv->pending_length1 = 0, self->priv->pending_size = self->priv->pending_length1, _tmp0_);
#line 105 "timsort.vala"
	self->priv->minimum_gallop = GEE_TIM_SORT_MINIMUM_GALLOP;
#line 107 "timsort.vala"
	remaining = gee_tim_sort_slice_new (self->priv->list, self->priv->list_length1, self->priv->index, self->priv->size);
#line 108 "timsort.vala"
	minimum_length = gee_tim_sort_compute_minimum_run_length (self, remaining->length);
#line 110 "timsort.vala"
	while (TRUE) {
#line 488 "timsort.c"
		gboolean descending = FALSE;
		GeeTimSortSlice* run;
#line 110 "timsort.vala"
		if (!(remaining->length > 0)) {
#line 110 "timsort.vala"
			break;
#line 495 "timsort.c"
		}
#line 113 "timsort.vala"
		run = gee_tim_sort_compute_longest_run (self, remaining, &descending);
#line 118 "timsort.vala"
		if (descending) {
#line 119 "timsort.vala"
			gee_tim_sort_slice_reverse (run);
#line 503 "timsort.c"
		}
#line 123 "timsort.vala"
		if (run->length < minimum_length) {
#line 507 "timsort.c"
			gint sorted_count;
#line 124 "timsort.vala"
			sorted_count = run->length;
#line 125 "timsort.vala"
			run->length = MIN (minimum_length, remaining->length);
#line 126 "timsort.vala"
			gee_tim_sort_insertion_sort (self, run, sorted_count);
#line 515 "timsort.c"
		}
#line 134 "timsort.vala"
		gee_tim_sort_slice_shorten_start (remaining, run->length);
#line 137 "timsort.vala"
		_vala_array_add1 (&self->priv->pending, &self->priv->pending_length1, &self->priv->pending_size, run);
#line 138 "timsort.vala"
		gee_tim_sort_merge_collapse (self);
#line 523 "timsort.c"
	}
#line 141 "timsort.vala"
	g_assert (remaining->index == self->priv->size);
#line 143 "timsort.vala"
	gee_tim_sort_merge_force_collapse (self);
#line 145 "timsort.vala"
	g_assert (self->priv->pending_length1 == 1);
#line 146 "timsort.vala"
	g_assert (self->priv->pending[0]->index == 0);
#line 147 "timsort.vala"
	g_assert (self->priv->pending[0]->length == self->priv->size);
#line 149 "timsort.vala"
	gee_tim_sort_slice_free (remaining);
#line 150 "timsort.vala"
	gee_tim_sort_slice_free (self->priv->pending[0]);
#line 539 "timsort.c"
}


#line 155 "timsort.vala"
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right) {
#line 545 "timsort.c"
	gboolean result;
#line 155 "timsort.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 549 "timsort.c"
	result = self->priv->compare (left, right) < 0;
#line 156 "timsort.vala"
	return result;
#line 553 "timsort.c"
}


#line 159 "timsort.vala"
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right) {
#line 559 "timsort.c"
	gboolean result;
#line 159 "timsort.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 563 "timsort.c"
	result = self->priv->compare (left, right) <= 0;
#line 160 "timsort.vala"
	return result;
#line 567 "timsort.c"
}


#line 163 "timsort.vala"
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length) {
#line 573 "timsort.c"
	gint result;
	gint run_length;
#line 163 "timsort.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 164 "timsort.vala"
	run_length = 0;
#line 165 "timsort.vala"
	while (TRUE) {
#line 165 "timsort.vala"
		if (!(length >= 64)) {
#line 165 "timsort.vala"
			break;
#line 586 "timsort.c"
		}
#line 166 "timsort.vala"
		run_length = run_length | (length & 1);
#line 167 "timsort.vala"
		length = length >> 1;
#line 592 "timsort.c"
	}
	result = length + run_length;
#line 169 "timsort.vala"
	return result;
#line 597 "timsort.c"
}


#line 172 "timsort.vala"
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending) {
#line 603 "timsort.c"
	GeeTimSortSlice* result;
	gint run_length = 0;
#line 172 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "timsort.vala"
	if (a->length <= 1) {
#line 175 "timsort.vala"
		run_length = a->length;
#line 176 "timsort.vala"
		*descending = FALSE;
#line 614 "timsort.c"
	} else {
#line 178 "timsort.vala"
		run_length = 2;
#line 179 "timsort.vala"
		if (gee_tim_sort_lower_than (self, a->list[a->index + 1], a->list[a->index])) {
#line 180 "timsort.vala"
			*descending = TRUE;
#line 622 "timsort.c"
			{
				gint i;
#line 181 "timsort.vala"
				i = a->index + 2;
#line 627 "timsort.c"
				{
					gboolean _tmp0_;
#line 181 "timsort.vala"
					_tmp0_ = TRUE;
#line 181 "timsort.vala"
					while (TRUE) {
#line 181 "timsort.vala"
						if (!_tmp0_) {
#line 181 "timsort.vala"
							i++;
#line 638 "timsort.c"
						}
#line 181 "timsort.vala"
						_tmp0_ = FALSE;
#line 181 "timsort.vala"
						if (!(i < (a->index + a->length))) {
#line 181 "timsort.vala"
							break;
#line 646 "timsort.c"
						}
#line 182 "timsort.vala"
						if (gee_tim_sort_lower_than (self, a->list[i], a->list[i - 1])) {
#line 183 "timsort.vala"
							run_length++;
#line 652 "timsort.c"
						} else {
#line 185 "timsort.vala"
							break;
#line 656 "timsort.c"
						}
					}
				}
			}
		} else {
#line 189 "timsort.vala"
			*descending = FALSE;
#line 664 "timsort.c"
			{
				gint i;
#line 190 "timsort.vala"
				i = a->index + 2;
#line 669 "timsort.c"
				{
					gboolean _tmp1_;
#line 190 "timsort.vala"
					_tmp1_ = TRUE;
#line 190 "timsort.vala"
					while (TRUE) {
#line 190 "timsort.vala"
						if (!_tmp1_) {
#line 190 "timsort.vala"
							i++;
#line 680 "timsort.c"
						}
#line 190 "timsort.vala"
						_tmp1_ = FALSE;
#line 190 "timsort.vala"
						if (!(i < (a->index + a->length))) {
#line 190 "timsort.vala"
							break;
#line 688 "timsort.c"
						}
#line 191 "timsort.vala"
						if (gee_tim_sort_lower_than (self, a->list[i], a->list[i - 1])) {
#line 192 "timsort.vala"
							break;
#line 694 "timsort.c"
						} else {
#line 194 "timsort.vala"
							run_length++;
#line 698 "timsort.c"
						}
					}
				}
			}
		}
	}
	result = gee_tim_sort_slice_new (a->list, a->list_length1, a->index, run_length);
#line 199 "timsort.vala"
	return result;
#line 708 "timsort.c"
}


#line 202 "timsort.vala"
static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset) {
#line 202 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 716 "timsort.c"
	{
		gint start;
#line 206 "timsort.vala"
		start = a->index + offset;
#line 721 "timsort.c"
		{
			gboolean _tmp0_;
#line 206 "timsort.vala"
			_tmp0_ = TRUE;
#line 206 "timsort.vala"
			while (TRUE) {
#line 728 "timsort.c"
				gint left;
				gint right;
				gpointer _tmp1_;
				gpointer pivot;
				gpointer _tmp2_;
#line 206 "timsort.vala"
				if (!_tmp0_) {
#line 206 "timsort.vala"
					start++;
#line 738 "timsort.c"
				}
#line 206 "timsort.vala"
				_tmp0_ = FALSE;
#line 206 "timsort.vala"
				if (!(start < (a->index + a->length))) {
#line 206 "timsort.vala"
					break;
#line 746 "timsort.c"
				}
#line 207 "timsort.vala"
				left = a->index;
#line 208 "timsort.vala"
				right = start;
#line 209 "timsort.vala"
				pivot = (_tmp1_ = a->list[right], a->list[right] = NULL, _tmp1_);
#line 211 "timsort.vala"
				while (TRUE) {
#line 756 "timsort.c"
					gint p;
#line 211 "timsort.vala"
					if (!(left < right)) {
#line 211 "timsort.vala"
						break;
#line 762 "timsort.c"
					}
#line 212 "timsort.vala"
					p = left + ((right - left) >> 1);
#line 213 "timsort.vala"
					if (gee_tim_sort_lower_than (self, pivot, a->list[p])) {
#line 214 "timsort.vala"
						right = p;
#line 770 "timsort.c"
					} else {
#line 216 "timsort.vala"
						left = p + 1;
#line 774 "timsort.c"
					}
				}
#line 219 "timsort.vala"
				g_assert (left == right);
#line 221 "timsort.vala"
				_vala_array_move (a->list, sizeof (gpointer), left, left + 1, start - left);
#line 222 "timsort.vala"
				a->list[left] = (_tmp2_ = pivot, pivot = NULL, _tmp2_);
#line 783 "timsort.c"
				((pivot == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (pivot = (self->priv->g_destroy_func (pivot), NULL));
			}
		}
	}
}


#line 226 "timsort.vala"
static void gee_tim_sort_merge_collapse (GeeTimSort* self) {
#line 793 "timsort.c"
	gint count;
#line 226 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 230 "timsort.vala"
	count = self->priv->pending_length1;
#line 231 "timsort.vala"
	while (TRUE) {
#line 801 "timsort.c"
		gboolean _tmp0_ = FALSE;
#line 231 "timsort.vala"
		if (!(count > 1)) {
#line 231 "timsort.vala"
			break;
#line 807 "timsort.c"
		}
#line 239 "timsort.vala"
		if (count >= 3) {
#line 239 "timsort.vala"
			_tmp0_ = self->priv->pending[count - 3]->length <= (self->priv->pending[count - 2]->length + self->priv->pending[count - 1]->length);
#line 813 "timsort.c"
		} else {
#line 239 "timsort.vala"
			_tmp0_ = FALSE;
#line 817 "timsort.c"
		}
#line 239 "timsort.vala"
		if (_tmp0_) {
#line 240 "timsort.vala"
			if (self->priv->pending[count - 3]->length < self->priv->pending[count - 1]->length) {
#line 241 "timsort.vala"
				gee_tim_sort_merge_at (self, count - 3);
#line 825 "timsort.c"
			} else {
#line 243 "timsort.vala"
				gee_tim_sort_merge_at (self, count - 2);
#line 829 "timsort.c"
			}
		} else {
#line 245 "timsort.vala"
			if (self->priv->pending[count - 2]->length <= self->priv->pending[count - 1]->length) {
#line 246 "timsort.vala"
				gee_tim_sort_merge_at (self, count - 2);
#line 836 "timsort.c"
			} else {
#line 248 "timsort.vala"
				break;
#line 840 "timsort.c"
			}
		}
#line 250 "timsort.vala"
		count = self->priv->pending_length1;
#line 845 "timsort.c"
	}
}


#line 257 "timsort.vala"
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self) {
#line 852 "timsort.c"
	gint count;
#line 257 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 261 "timsort.vala"
	count = self->priv->pending_length1;
#line 265 "timsort.vala"
	while (TRUE) {
#line 860 "timsort.c"
		gboolean _tmp0_ = FALSE;
#line 265 "timsort.vala"
		if (!(count > 1)) {
#line 265 "timsort.vala"
			break;
#line 866 "timsort.c"
		}
#line 266 "timsort.vala"
		if (count >= 3) {
#line 266 "timsort.vala"
			_tmp0_ = self->priv->pending[count - 3]->length < self->priv->pending[count - 1]->length;
#line 872 "timsort.c"
		} else {
#line 266 "timsort.vala"
			_tmp0_ = FALSE;
#line 876 "timsort.c"
		}
#line 266 "timsort.vala"
		if (_tmp0_) {
#line 267 "timsort.vala"
			gee_tim_sort_merge_at (self, count - 3);
#line 882 "timsort.c"
		} else {
#line 269 "timsort.vala"
			gee_tim_sort_merge_at (self, count - 2);
#line 886 "timsort.c"
		}
#line 271 "timsort.vala"
		count = self->priv->pending_length1;
#line 890 "timsort.c"
	}
}


#line 278 "timsort.vala"
static void gee_tim_sort_merge_at (GeeTimSort* self, gint index) {
#line 897 "timsort.c"
	GError * _inner_error_;
	GeeTimSortSlice* a;
	GeeTimSortSlice* b;
#line 278 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 903 "timsort.c"
	_inner_error_ = NULL;
#line 282 "timsort.vala"
	a = self->priv->pending[index];
#line 283 "timsort.vala"
	b = self->priv->pending[index + 1];
#line 909 "timsort.c"
	{
		gint sorted_count;
#line 285 "timsort.vala"
		g_assert (a->length > 0);
#line 286 "timsort.vala"
		g_assert (b->length > 0);
#line 287 "timsort.vala"
		g_assert ((a->index + a->length) == b->index);
#line 289 "timsort.vala"
		self->priv->pending[index] = gee_tim_sort_slice_new (self->priv->list, self->priv->list_length1, a->index, a->length + b->length);
#line 290 "timsort.vala"
		_vala_array_move (self->priv->pending, sizeof (GeeTimSortSlice*), index + 2, index + 1, (self->priv->pending_length1 - index) - 2);
#line 291 "timsort.vala"
		self->priv->pending_length1 = self->priv->pending_length1 - 1;
#line 293 "timsort.vala"
		sorted_count = gee_tim_sort_gallop_rightmost (self, gee_tim_sort_slice_peek_first (b), a, 0);
#line 294 "timsort.vala"
		gee_tim_sort_slice_shorten_start (a, sorted_count);
#line 295 "timsort.vala"
		if (a->length == 0) {
#line 930 "timsort.c"
			{
#line 310 "timsort.vala"
				gee_tim_sort_slice_free (a);
#line 311 "timsort.vala"
				gee_tim_sort_slice_free (b);
#line 936 "timsort.c"
			}
#line 296 "timsort.vala"
			return;
#line 940 "timsort.c"
		}
#line 299 "timsort.vala"
		b->length = gee_tim_sort_gallop_leftmost (self, gee_tim_sort_slice_peek_last (a), b, b->length - 1);
#line 300 "timsort.vala"
		if (b->length == 0) {
#line 946 "timsort.c"
			{
#line 310 "timsort.vala"
				gee_tim_sort_slice_free (a);
#line 311 "timsort.vala"
				gee_tim_sort_slice_free (b);
#line 952 "timsort.c"
			}
#line 301 "timsort.vala"
			return;
#line 956 "timsort.c"
		}
#line 304 "timsort.vala"
		if (a->length <= b->length) {
#line 305 "timsort.vala"
			gee_tim_sort_merge_low (self, a, b);
#line 962 "timsort.c"
		} else {
#line 307 "timsort.vala"
			gee_tim_sort_merge_high (self, a, b);
#line 966 "timsort.c"
		}
	}
	__finally0:
	{
#line 310 "timsort.vala"
		gee_tim_sort_slice_free (a);
#line 311 "timsort.vala"
		gee_tim_sort_slice_free (b);
#line 975 "timsort.c"
	}
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 315 "timsort.vala"
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
#line 987 "timsort.c"
	gint result;
	gint p;
	gint last_offset;
	gint offset;
#line 315 "timsort.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 319 "timsort.vala"
	g_assert (0 <= hint);
#line 320 "timsort.vala"
	g_assert (hint < a->length);
#line 322 "timsort.vala"
	p = a->index + hint;
#line 323 "timsort.vala"
	last_offset = 0;
#line 324 "timsort.vala"
	offset = 1;
#line 325 "timsort.vala"
	if (gee_tim_sort_lower_than (self, a->list[p], key)) {
#line 1006 "timsort.c"
		gint max_offset;
#line 326 "timsort.vala"
		max_offset = a->length - hint;
#line 327 "timsort.vala"
		while (TRUE) {
#line 327 "timsort.vala"
			if (!(offset < max_offset)) {
#line 327 "timsort.vala"
				break;
#line 1016 "timsort.c"
			}
#line 328 "timsort.vala"
			if (gee_tim_sort_lower_than (self, a->list[p + offset], key)) {
#line 329 "timsort.vala"
				last_offset = offset;
#line 330 "timsort.vala"
				offset = offset << 1;
#line 331 "timsort.vala"
				offset++;
#line 1026 "timsort.c"
			} else {
#line 333 "timsort.vala"
				break;
#line 1030 "timsort.c"
			}
		}
#line 337 "timsort.vala"
		if (offset > max_offset) {
#line 338 "timsort.vala"
			offset = max_offset;
#line 1037 "timsort.c"
		}
#line 341 "timsort.vala"
		last_offset = hint + last_offset;
#line 342 "timsort.vala"
		offset = hint + offset;
#line 1043 "timsort.c"
	} else {
		gint max_offset;
		gint temp_last_offset;
		gint temp_offset;
#line 344 "timsort.vala"
		max_offset = hint + 1;
#line 345 "timsort.vala"
		while (TRUE) {
#line 345 "timsort.vala"
			if (!(offset < max_offset)) {
#line 345 "timsort.vala"
				break;
#line 1056 "timsort.c"
			}
#line 346 "timsort.vala"
			if (gee_tim_sort_lower_than (self, a->list[p - offset], key)) {
#line 347 "timsort.vala"
				break;
#line 1062 "timsort.c"
			} else {
#line 349 "timsort.vala"
				last_offset = offset;
#line 350 "timsort.vala"
				offset = offset << 1;
#line 351 "timsort.vala"
				offset++;
#line 1070 "timsort.c"
			}
		}
#line 355 "timsort.vala"
		if (offset > max_offset) {
#line 356 "timsort.vala"
			offset = max_offset;
#line 1077 "timsort.c"
		}
#line 359 "timsort.vala"
		temp_last_offset = last_offset;
#line 360 "timsort.vala"
		temp_offset = offset;
#line 361 "timsort.vala"
		last_offset = hint - temp_offset;
#line 362 "timsort.vala"
		offset = hint - temp_last_offset;
#line 1087 "timsort.c"
	}
#line 365 "timsort.vala"
	g_assert ((-1) <= last_offset);
#line 366 "timsort.vala"
	g_assert (last_offset < offset);
#line 367 "timsort.vala"
	g_assert (offset <= a->length);
#line 369 "timsort.vala"
	last_offset = last_offset + 1;
#line 370 "timsort.vala"
	while (TRUE) {
#line 1099 "timsort.c"
		gint m;
#line 370 "timsort.vala"
		if (!(last_offset < offset)) {
#line 370 "timsort.vala"
			break;
#line 1105 "timsort.c"
		}
#line 371 "timsort.vala"
		m = last_offset + ((offset - last_offset) >> 1);
#line 372 "timsort.vala"
		if (gee_tim_sort_lower_than (self, a->list[a->index + m], key)) {
#line 373 "timsort.vala"
			last_offset = m + 1;
#line 1113 "timsort.c"
		} else {
#line 375 "timsort.vala"
			offset = m;
#line 1117 "timsort.c"
		}
	}
#line 379 "timsort.vala"
	g_assert (last_offset == offset);
#line 1122 "timsort.c"
	result = offset;
#line 380 "timsort.vala"
	return result;
#line 1126 "timsort.c"
}


#line 383 "timsort.vala"
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
#line 1132 "timsort.c"
	gint result;
	gint p;
	gint last_offset;
	gint offset;
#line 383 "timsort.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 387 "timsort.vala"
	g_assert (0 <= hint);
#line 388 "timsort.vala"
	g_assert (hint < a->length);
#line 390 "timsort.vala"
	p = a->index + hint;
#line 391 "timsort.vala"
	last_offset = 0;
#line 392 "timsort.vala"
	offset = 1;
#line 393 "timsort.vala"
	if (gee_tim_sort_lower_than_or_equal_to (self, a->list[p], key)) {
#line 1151 "timsort.c"
		gint max_offset;
#line 394 "timsort.vala"
		max_offset = a->length - hint;
#line 395 "timsort.vala"
		while (TRUE) {
#line 395 "timsort.vala"
			if (!(offset < max_offset)) {
#line 395 "timsort.vala"
				break;
#line 1161 "timsort.c"
			}
#line 396 "timsort.vala"
			if (gee_tim_sort_lower_than_or_equal_to (self, a->list[p + offset], key)) {
#line 397 "timsort.vala"
				last_offset = offset;
#line 398 "timsort.vala"
				offset = offset << 1;
#line 399 "timsort.vala"
				offset++;
#line 1171 "timsort.c"
			} else {
#line 401 "timsort.vala"
				break;
#line 1175 "timsort.c"
			}
		}
#line 405 "timsort.vala"
		if (offset > max_offset) {
#line 406 "timsort.vala"
			offset = max_offset;
#line 1182 "timsort.c"
		}
#line 409 "timsort.vala"
		last_offset = hint + last_offset;
#line 410 "timsort.vala"
		offset = hint + offset;
#line 1188 "timsort.c"
	} else {
		gint max_offset;
		gint temp_last_offset;
		gint temp_offset;
#line 412 "timsort.vala"
		max_offset = hint + 1;
#line 413 "timsort.vala"
		while (TRUE) {
#line 413 "timsort.vala"
			if (!(offset < max_offset)) {
#line 413 "timsort.vala"
				break;
#line 1201 "timsort.c"
			}
#line 414 "timsort.vala"
			if (gee_tim_sort_lower_than_or_equal_to (self, a->list[p - offset], key)) {
#line 415 "timsort.vala"
				break;
#line 1207 "timsort.c"
			} else {
#line 417 "timsort.vala"
				last_offset = offset;
#line 418 "timsort.vala"
				offset = offset << 1;
#line 419 "timsort.vala"
				offset++;
#line 1215 "timsort.c"
			}
		}
#line 423 "timsort.vala"
		if (offset > max_offset) {
#line 424 "timsort.vala"
			offset = max_offset;
#line 1222 "timsort.c"
		}
#line 427 "timsort.vala"
		temp_last_offset = last_offset;
#line 428 "timsort.vala"
		temp_offset = offset;
#line 429 "timsort.vala"
		last_offset = hint - temp_offset;
#line 430 "timsort.vala"
		offset = hint - temp_last_offset;
#line 1232 "timsort.c"
	}
#line 433 "timsort.vala"
	g_assert ((-1) <= last_offset);
#line 434 "timsort.vala"
	g_assert (last_offset < offset);
#line 435 "timsort.vala"
	g_assert (offset <= a->length);
#line 437 "timsort.vala"
	last_offset = last_offset + 1;
#line 438 "timsort.vala"
	while (TRUE) {
#line 1244 "timsort.c"
		gint m;
#line 438 "timsort.vala"
		if (!(last_offset < offset)) {
#line 438 "timsort.vala"
			break;
#line 1250 "timsort.c"
		}
#line 439 "timsort.vala"
		m = last_offset + ((offset - last_offset) >> 1);
#line 440 "timsort.vala"
		if (gee_tim_sort_lower_than_or_equal_to (self, a->list[a->index + m], key)) {
#line 441 "timsort.vala"
			last_offset = m + 1;
#line 1258 "timsort.c"
		} else {
#line 443 "timsort.vala"
			offset = m;
#line 1262 "timsort.c"
		}
	}
#line 447 "timsort.vala"
	g_assert (last_offset == offset);
#line 1267 "timsort.c"
	result = offset;
#line 448 "timsort.vala"
	return result;
#line 1271 "timsort.c"
}


#line 451 "timsort.vala"
static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
#line 1277 "timsort.c"
	GError * _inner_error_;
	gint minimum_gallop;
	gint dest;
#line 451 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 1283 "timsort.c"
	_inner_error_ = NULL;
#line 455 "timsort.vala"
	g_assert (a->length > 0);
#line 456 "timsort.vala"
	g_assert (b->length > 0);
#line 457 "timsort.vala"
	g_assert ((a->index + a->length) == b->index);
#line 459 "timsort.vala"
	minimum_gallop = self->priv->minimum_gallop;
#line 460 "timsort.vala"
	dest = a->index;
#line 461 "timsort.vala"
	gee_tim_sort_slice_copy (a);
#line 1297 "timsort.c"
	{
		gpointer _tmp2_;
		gpointer *_tmp1_;
		gconstpointer _tmp0_;
		gboolean _tmp3_ = FALSE;
#line 464 "timsort.vala"
		_tmp1_ = &self->priv->list[dest++];
#line 464 "timsort.vala"
		(*_tmp1_) = (_tmp2_ = (_tmp0_ = gee_tim_sort_slice_pop_first (b), ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), (((*_tmp1_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp1_) = (self->priv->g_destroy_func ((*_tmp1_)), NULL)), _tmp2_);
#line 465 "timsort.vala"
		if (a->length == 1) {
#line 465 "timsort.vala"
			_tmp3_ = TRUE;
#line 1311 "timsort.c"
		} else {
#line 465 "timsort.vala"
			_tmp3_ = b->length == 0;
#line 1315 "timsort.c"
		}
#line 465 "timsort.vala"
		if (_tmp3_) {
#line 1319 "timsort.c"
			{
#line 540 "timsort.vala"
				g_assert (a->length >= 0);
#line 541 "timsort.vala"
				g_assert (b->length >= 0);
#line 542 "timsort.vala"
				gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
				gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1329 "timsort.c"
			}
#line 466 "timsort.vala"
			return;
#line 1333 "timsort.c"
		}
#line 469 "timsort.vala"
		while (TRUE) {
#line 1337 "timsort.c"
			gint a_count;
			gint b_count;
#line 470 "timsort.vala"
			a_count = 0;
#line 471 "timsort.vala"
			b_count = 0;
#line 473 "timsort.vala"
			while (TRUE) {
#line 474 "timsort.vala"
				if (gee_tim_sort_lower_than (self, gee_tim_sort_slice_peek_first (b), gee_tim_sort_slice_peek_first (a))) {
#line 1348 "timsort.c"
					gpointer _tmp6_;
					gpointer *_tmp5_;
					gconstpointer _tmp4_;
#line 475 "timsort.vala"
					_tmp5_ = &self->priv->list[dest++];
#line 475 "timsort.vala"
					(*_tmp5_) = (_tmp6_ = (_tmp4_ = gee_tim_sort_slice_pop_first (b), ((_tmp4_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->g_dup_func ((gpointer) _tmp4_)), (((*_tmp5_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp5_) = (self->priv->g_destroy_func ((*_tmp5_)), NULL)), _tmp6_);
#line 476 "timsort.vala"
					if (b->length == 0) {
#line 1358 "timsort.c"
						{
#line 540 "timsort.vala"
							g_assert (a->length >= 0);
#line 541 "timsort.vala"
							g_assert (b->length >= 0);
#line 542 "timsort.vala"
							gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
							gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1368 "timsort.c"
						}
#line 477 "timsort.vala"
						return;
#line 1372 "timsort.c"
					}
#line 480 "timsort.vala"
					b_count++;
#line 481 "timsort.vala"
					a_count = 0;
#line 482 "timsort.vala"
					if (b_count >= minimum_gallop) {
#line 483 "timsort.vala"
						break;
#line 1382 "timsort.c"
					}
				} else {
					gpointer _tmp9_;
					gpointer *_tmp8_;
					gconstpointer _tmp7_;
#line 486 "timsort.vala"
					_tmp8_ = &self->priv->list[dest++];
#line 486 "timsort.vala"
					(*_tmp8_) = (_tmp9_ = (_tmp7_ = gee_tim_sort_slice_pop_first (a), ((_tmp7_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp7_) : self->priv->g_dup_func ((gpointer) _tmp7_)), (((*_tmp8_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp8_) = (self->priv->g_destroy_func ((*_tmp8_)), NULL)), _tmp9_);
#line 487 "timsort.vala"
					if (a->length == 1) {
#line 1394 "timsort.c"
						{
#line 540 "timsort.vala"
							g_assert (a->length >= 0);
#line 541 "timsort.vala"
							g_assert (b->length >= 0);
#line 542 "timsort.vala"
							gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
							gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1404 "timsort.c"
						}
#line 488 "timsort.vala"
						return;
#line 1408 "timsort.c"
					}
#line 491 "timsort.vala"
					a_count++;
#line 492 "timsort.vala"
					b_count = 0;
#line 493 "timsort.vala"
					if (a_count >= minimum_gallop) {
#line 494 "timsort.vala"
						break;
#line 1418 "timsort.c"
					}
				}
			}
#line 499 "timsort.vala"
			minimum_gallop++;
#line 501 "timsort.vala"
			while (TRUE) {
#line 1426 "timsort.c"
				gint _tmp10_ = 0;
				gpointer _tmp13_;
				gpointer *_tmp12_;
				gconstpointer _tmp11_;
				gpointer _tmp16_;
				gpointer *_tmp15_;
				gconstpointer _tmp14_;
				gboolean _tmp17_ = FALSE;
#line 502 "timsort.vala"
				if (minimum_gallop > 1) {
#line 502 "timsort.vala"
					_tmp10_ = 1;
#line 1439 "timsort.c"
				} else {
#line 502 "timsort.vala"
					_tmp10_ = 0;
#line 1443 "timsort.c"
				}
#line 502 "timsort.vala"
				minimum_gallop = minimum_gallop - _tmp10_;
#line 503 "timsort.vala"
				self->priv->minimum_gallop = minimum_gallop;
#line 505 "timsort.vala"
				a_count = gee_tim_sort_gallop_rightmost (self, gee_tim_sort_slice_peek_first (b), a, 0);
#line 506 "timsort.vala"
				gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest, a_count);
#line 507 "timsort.vala"
				dest = dest + a_count;
#line 508 "timsort.vala"
				gee_tim_sort_slice_shorten_start (a, a_count);
#line 509 "timsort.vala"
				if (a->length <= 1) {
#line 1459 "timsort.c"
					{
#line 540 "timsort.vala"
						g_assert (a->length >= 0);
#line 541 "timsort.vala"
						g_assert (b->length >= 0);
#line 542 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1469 "timsort.c"
					}
#line 510 "timsort.vala"
					return;
#line 1473 "timsort.c"
				}
#line 513 "timsort.vala"
				_tmp12_ = &self->priv->list[dest++];
#line 513 "timsort.vala"
				(*_tmp12_) = (_tmp13_ = (_tmp11_ = gee_tim_sort_slice_pop_first (b), ((_tmp11_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp11_) : self->priv->g_dup_func ((gpointer) _tmp11_)), (((*_tmp12_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp12_) = (self->priv->g_destroy_func ((*_tmp12_)), NULL)), _tmp13_);
#line 514 "timsort.vala"
				if (b->length == 0) {
#line 1481 "timsort.c"
					{
#line 540 "timsort.vala"
						g_assert (a->length >= 0);
#line 541 "timsort.vala"
						g_assert (b->length >= 0);
#line 542 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1491 "timsort.c"
					}
#line 515 "timsort.vala"
					return;
#line 1495 "timsort.c"
				}
#line 518 "timsort.vala"
				b_count = gee_tim_sort_gallop_leftmost (self, gee_tim_sort_slice_peek_first (a), b, 0);
#line 519 "timsort.vala"
				gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b_count);
#line 520 "timsort.vala"
				dest = dest + b_count;
#line 521 "timsort.vala"
				gee_tim_sort_slice_shorten_start (b, b_count);
#line 522 "timsort.vala"
				if (b->length == 0) {
#line 1507 "timsort.c"
					{
#line 540 "timsort.vala"
						g_assert (a->length >= 0);
#line 541 "timsort.vala"
						g_assert (b->length >= 0);
#line 542 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1517 "timsort.c"
					}
#line 523 "timsort.vala"
					return;
#line 1521 "timsort.c"
				}
#line 526 "timsort.vala"
				_tmp15_ = &self->priv->list[dest++];
#line 526 "timsort.vala"
				(*_tmp15_) = (_tmp16_ = (_tmp14_ = gee_tim_sort_slice_pop_first (a), ((_tmp14_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp14_) : self->priv->g_dup_func ((gpointer) _tmp14_)), (((*_tmp15_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp15_) = (self->priv->g_destroy_func ((*_tmp15_)), NULL)), _tmp16_);
#line 527 "timsort.vala"
				if (a->length == 1) {
#line 1529 "timsort.c"
					{
#line 540 "timsort.vala"
						g_assert (a->length >= 0);
#line 541 "timsort.vala"
						g_assert (b->length >= 0);
#line 542 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1539 "timsort.c"
					}
#line 528 "timsort.vala"
					return;
#line 1543 "timsort.c"
				}
#line 531 "timsort.vala"
				if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
#line 531 "timsort.vala"
					_tmp17_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
#line 1549 "timsort.c"
				} else {
#line 531 "timsort.vala"
					_tmp17_ = FALSE;
#line 1553 "timsort.c"
				}
#line 531 "timsort.vala"
				if (_tmp17_) {
#line 532 "timsort.vala"
					break;
#line 1559 "timsort.c"
				}
			}
#line 536 "timsort.vala"
			minimum_gallop++;
#line 537 "timsort.vala"
			self->priv->minimum_gallop = minimum_gallop;
#line 1566 "timsort.c"
		}
	}
	__finally1:
	{
#line 540 "timsort.vala"
		g_assert (a->length >= 0);
#line 541 "timsort.vala"
		g_assert (b->length >= 0);
#line 542 "timsort.vala"
		gee_tim_sort_slice_merge_in (b, self->priv->list, self->priv->list_length1, b->index, dest, b->length);
#line 543 "timsort.vala"
		gee_tim_sort_slice_merge_in (a, self->priv->list, self->priv->list_length1, a->index, dest + b->length, a->length);
#line 1579 "timsort.c"
	}
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 547 "timsort.vala"
static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
#line 1591 "timsort.c"
	GError * _inner_error_;
	gint minimum_gallop;
	gint dest;
#line 547 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 1597 "timsort.c"
	_inner_error_ = NULL;
#line 551 "timsort.vala"
	g_assert (a->length > 0);
#line 552 "timsort.vala"
	g_assert (b->length > 0);
#line 553 "timsort.vala"
	g_assert ((a->index + a->length) == b->index);
#line 555 "timsort.vala"
	minimum_gallop = self->priv->minimum_gallop;
#line 556 "timsort.vala"
	dest = b->index + b->length;
#line 557 "timsort.vala"
	gee_tim_sort_slice_copy (b);
#line 1611 "timsort.c"
	{
		gpointer _tmp2_;
		gpointer *_tmp1_;
		gconstpointer _tmp0_;
		gboolean _tmp3_ = FALSE;
#line 560 "timsort.vala"
		_tmp1_ = &self->priv->list[dest = dest - 1];
#line 560 "timsort.vala"
		(*_tmp1_) = (_tmp2_ = (_tmp0_ = gee_tim_sort_slice_pop_last (a), ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), (((*_tmp1_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp1_) = (self->priv->g_destroy_func ((*_tmp1_)), NULL)), _tmp2_);
#line 561 "timsort.vala"
		if (a->length == 0) {
#line 561 "timsort.vala"
			_tmp3_ = TRUE;
#line 1625 "timsort.c"
		} else {
#line 561 "timsort.vala"
			_tmp3_ = b->length == 1;
#line 1629 "timsort.c"
		}
#line 561 "timsort.vala"
		if (_tmp3_) {
#line 1633 "timsort.c"
			{
#line 638 "timsort.vala"
				g_assert (a->length >= 0);
#line 639 "timsort.vala"
				g_assert (b->length >= 0);
#line 640 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1643 "timsort.c"
			}
#line 562 "timsort.vala"
			return;
#line 1647 "timsort.c"
		}
#line 565 "timsort.vala"
		while (TRUE) {
#line 1651 "timsort.c"
			gint a_count;
			gint b_count;
#line 566 "timsort.vala"
			a_count = 0;
#line 567 "timsort.vala"
			b_count = 0;
#line 569 "timsort.vala"
			while (TRUE) {
#line 570 "timsort.vala"
				if (gee_tim_sort_lower_than (self, gee_tim_sort_slice_peek_last (b), gee_tim_sort_slice_peek_last (a))) {
#line 1662 "timsort.c"
					gpointer _tmp6_;
					gpointer *_tmp5_;
					gconstpointer _tmp4_;
#line 571 "timsort.vala"
					_tmp5_ = &self->priv->list[dest = dest - 1];
#line 571 "timsort.vala"
					(*_tmp5_) = (_tmp6_ = (_tmp4_ = gee_tim_sort_slice_pop_last (a), ((_tmp4_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->g_dup_func ((gpointer) _tmp4_)), (((*_tmp5_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp5_) = (self->priv->g_destroy_func ((*_tmp5_)), NULL)), _tmp6_);
#line 572 "timsort.vala"
					if (a->length == 0) {
#line 1672 "timsort.c"
						{
#line 638 "timsort.vala"
							g_assert (a->length >= 0);
#line 639 "timsort.vala"
							g_assert (b->length >= 0);
#line 640 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1682 "timsort.c"
						}
#line 573 "timsort.vala"
						return;
#line 1686 "timsort.c"
					}
#line 576 "timsort.vala"
					a_count++;
#line 577 "timsort.vala"
					b_count = 0;
#line 578 "timsort.vala"
					if (a_count >= minimum_gallop) {
#line 579 "timsort.vala"
						break;
#line 1696 "timsort.c"
					}
				} else {
					gpointer _tmp9_;
					gpointer *_tmp8_;
					gconstpointer _tmp7_;
#line 582 "timsort.vala"
					_tmp8_ = &self->priv->list[dest = dest - 1];
#line 582 "timsort.vala"
					(*_tmp8_) = (_tmp9_ = (_tmp7_ = gee_tim_sort_slice_pop_last (b), ((_tmp7_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp7_) : self->priv->g_dup_func ((gpointer) _tmp7_)), (((*_tmp8_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp8_) = (self->priv->g_destroy_func ((*_tmp8_)), NULL)), _tmp9_);
#line 583 "timsort.vala"
					if (b->length == 1) {
#line 1708 "timsort.c"
						{
#line 638 "timsort.vala"
							g_assert (a->length >= 0);
#line 639 "timsort.vala"
							g_assert (b->length >= 0);
#line 640 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1718 "timsort.c"
						}
#line 584 "timsort.vala"
						return;
#line 1722 "timsort.c"
					}
#line 587 "timsort.vala"
					b_count++;
#line 588 "timsort.vala"
					a_count = 0;
#line 589 "timsort.vala"
					if (b_count >= minimum_gallop) {
#line 590 "timsort.vala"
						break;
#line 1732 "timsort.c"
					}
				}
			}
#line 595 "timsort.vala"
			minimum_gallop++;
#line 597 "timsort.vala"
			while (TRUE) {
#line 1740 "timsort.c"
				gint _tmp10_ = 0;
				gint k;
				gpointer _tmp13_;
				gpointer *_tmp12_;
				gconstpointer _tmp11_;
				gpointer _tmp16_;
				gpointer *_tmp15_;
				gconstpointer _tmp14_;
				gboolean _tmp17_ = FALSE;
#line 598 "timsort.vala"
				if (minimum_gallop > 1) {
#line 598 "timsort.vala"
					_tmp10_ = 1;
#line 1754 "timsort.c"
				} else {
#line 598 "timsort.vala"
					_tmp10_ = 0;
#line 1758 "timsort.c"
				}
#line 598 "timsort.vala"
				minimum_gallop = minimum_gallop - _tmp10_;
#line 599 "timsort.vala"
				self->priv->minimum_gallop = minimum_gallop;
#line 601 "timsort.vala"
				k = gee_tim_sort_gallop_rightmost (self, gee_tim_sort_slice_peek_last (b), a, a->length - 1);
#line 602 "timsort.vala"
				a_count = a->length - k;
#line 603 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index + k, dest - a_count, a_count);
#line 604 "timsort.vala"
				dest = dest - a_count;
#line 605 "timsort.vala"
				gee_tim_sort_slice_shorten_end (a, a_count);
#line 606 "timsort.vala"
				if (a->length == 0) {
#line 1776 "timsort.c"
					{
#line 638 "timsort.vala"
						g_assert (a->length >= 0);
#line 639 "timsort.vala"
						g_assert (b->length >= 0);
#line 640 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1786 "timsort.c"
					}
#line 607 "timsort.vala"
					return;
#line 1790 "timsort.c"
				}
#line 610 "timsort.vala"
				_tmp12_ = &self->priv->list[dest = dest - 1];
#line 610 "timsort.vala"
				(*_tmp12_) = (_tmp13_ = (_tmp11_ = gee_tim_sort_slice_pop_last (b), ((_tmp11_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp11_) : self->priv->g_dup_func ((gpointer) _tmp11_)), (((*_tmp12_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp12_) = (self->priv->g_destroy_func ((*_tmp12_)), NULL)), _tmp13_);
#line 611 "timsort.vala"
				if (b->length == 1) {
#line 1798 "timsort.c"
					{
#line 638 "timsort.vala"
						g_assert (a->length >= 0);
#line 639 "timsort.vala"
						g_assert (b->length >= 0);
#line 640 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1808 "timsort.c"
					}
#line 612 "timsort.vala"
					return;
#line 1812 "timsort.c"
				}
#line 615 "timsort.vala"
				k = gee_tim_sort_gallop_leftmost (self, gee_tim_sort_slice_peek_last (a), b, b->length - 1);
#line 616 "timsort.vala"
				b_count = b->length - k;
#line 617 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index + k, dest - b_count, b_count);
#line 618 "timsort.vala"
				dest = dest - b_count;
#line 619 "timsort.vala"
				gee_tim_sort_slice_shorten_end (b, b_count);
#line 620 "timsort.vala"
				if (b->length <= 1) {
#line 1826 "timsort.c"
					{
#line 638 "timsort.vala"
						g_assert (a->length >= 0);
#line 639 "timsort.vala"
						g_assert (b->length >= 0);
#line 640 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1836 "timsort.c"
					}
#line 621 "timsort.vala"
					return;
#line 1840 "timsort.c"
				}
#line 624 "timsort.vala"
				_tmp15_ = &self->priv->list[dest = dest - 1];
#line 624 "timsort.vala"
				(*_tmp15_) = (_tmp16_ = (_tmp14_ = gee_tim_sort_slice_pop_last (a), ((_tmp14_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp14_) : self->priv->g_dup_func ((gpointer) _tmp14_)), (((*_tmp15_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp15_) = (self->priv->g_destroy_func ((*_tmp15_)), NULL)), _tmp16_);
#line 625 "timsort.vala"
				if (a->length == 0) {
#line 1848 "timsort.c"
					{
#line 638 "timsort.vala"
						g_assert (a->length >= 0);
#line 639 "timsort.vala"
						g_assert (b->length >= 0);
#line 640 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1858 "timsort.c"
					}
#line 626 "timsort.vala"
					return;
#line 1862 "timsort.c"
				}
#line 629 "timsort.vala"
				if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
#line 629 "timsort.vala"
					_tmp17_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
#line 1868 "timsort.c"
				} else {
#line 629 "timsort.vala"
					_tmp17_ = FALSE;
#line 1872 "timsort.c"
				}
#line 629 "timsort.vala"
				if (_tmp17_) {
#line 630 "timsort.vala"
					break;
#line 1878 "timsort.c"
				}
			}
#line 634 "timsort.vala"
			minimum_gallop++;
#line 635 "timsort.vala"
			self->priv->minimum_gallop = minimum_gallop;
#line 1885 "timsort.c"
		}
	}
	__finally2:
	{
#line 638 "timsort.vala"
		g_assert (a->length >= 0);
#line 639 "timsort.vala"
		g_assert (b->length >= 0);
#line 640 "timsort.vala"
		gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, self->priv->list_length1, a->index, dest - a->length, a->length);
#line 641 "timsort.vala"
		gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, self->priv->list_length1, b->index, (dest - a->length) - b->length, b->length);
#line 1898 "timsort.c"
	}
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 47 "timsort.vala"
GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
#line 1910 "timsort.c"
	GeeTimSort * self;
#line 47 "timsort.vala"
	self = (GeeTimSort*) g_object_new (object_type, NULL);
#line 47 "timsort.vala"
	self->priv->g_type = g_type;
#line 47 "timsort.vala"
	self->priv->g_dup_func = g_dup_func;
#line 47 "timsort.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 1920 "timsort.c"
	return self;
}


#line 47 "timsort.vala"
GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
#line 47 "timsort.vala"
	return gee_tim_sort_construct (GEE_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
#line 1929 "timsort.c"
}


#line 653 "timsort.vala"
static GeeTimSortSlice* gee_tim_sort_slice_new (gpointer* list, int list_length1, gint index, gint length) {
#line 1935 "timsort.c"
	GeeTimSortSlice* self;
	gpointer* _tmp0_;
	self = g_slice_new0 (GeeTimSortSlice);
	gee_tim_sort_slice_instance_init (self);
#line 654 "timsort.vala"
	self->list = (_tmp0_ = list, self->list_length1 = list_length1, self->list_size = self->list_length1, _tmp0_);
#line 655 "timsort.vala"
	self->index = index;
#line 656 "timsort.vala"
	self->length = length;
#line 1946 "timsort.c"
	return self;
}


#line 659 "timsort.vala"
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self) {
#line 1953 "timsort.c"
	gpointer* _tmp0_;
	gpointer* _tmp1_;
#line 659 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 660 "timsort.vala"
	self->new_list = (_tmp0_ = g_new0 (gpointer, self->length), self->new_list = (g_free (self->new_list), NULL), self->new_list_length1 = self->length, self->new_list_size = self->new_list_length1, _tmp0_);
#line 661 "timsort.vala"
	memcpy (&self->new_list[0], &self->list[self->index], (gsize) (sizeof (gpointer) * self->length));
#line 662 "timsort.vala"
	self->list = (_tmp1_ = self->new_list, self->list_length1 = self->new_list_length1, self->list_size = self->list_length1, _tmp1_);
#line 663 "timsort.vala"
	self->index = 0;
#line 1966 "timsort.c"
}


#line 666 "timsort.vala"
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, gpointer* dest_array, int dest_array_length1, gint index, gint dest_index, gint count) {
#line 666 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 667 "timsort.vala"
	g_memmove (&dest_array[dest_index], &self->list[index], (gsize) (sizeof (gpointer) * count));
#line 1976 "timsort.c"
}


#line 670 "timsort.vala"
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, gpointer* dest_array, int dest_array_length1, gint index, gint dest_index, gint count) {
#line 670 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 671 "timsort.vala"
	g_memmove (&dest_array[dest_index], &self->list[index], (gsize) (sizeof (gpointer) * count));
#line 1986 "timsort.c"
}


#line 674 "timsort.vala"
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n) {
#line 674 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 675 "timsort.vala"
	self->index = self->index + n;
#line 676 "timsort.vala"
	self->length = self->length - n;
#line 1998 "timsort.c"
}


#line 679 "timsort.vala"
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n) {
#line 679 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 680 "timsort.vala"
	self->length = self->length - n;
#line 2008 "timsort.c"
}


#line 683 "timsort.vala"
static inline gconstpointer gee_tim_sort_slice_pop_first (GeeTimSortSlice* self) {
#line 2014 "timsort.c"
	gconstpointer result;
#line 683 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 684 "timsort.vala"
	self->length--;
#line 2020 "timsort.c"
	result = self->list[self->index++];
#line 685 "timsort.vala"
	return result;
#line 2024 "timsort.c"
}


#line 688 "timsort.vala"
static inline gconstpointer gee_tim_sort_slice_pop_last (GeeTimSortSlice* self) {
#line 2030 "timsort.c"
	gconstpointer result;
#line 688 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 689 "timsort.vala"
	self->length--;
#line 2036 "timsort.c"
	result = self->list[self->index + self->length];
#line 690 "timsort.vala"
	return result;
#line 2040 "timsort.c"
}


#line 693 "timsort.vala"
static inline gconstpointer gee_tim_sort_slice_peek_first (GeeTimSortSlice* self) {
#line 2046 "timsort.c"
	gconstpointer result;
#line 693 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2050 "timsort.c"
	result = self->list[self->index];
#line 694 "timsort.vala"
	return result;
#line 2054 "timsort.c"
}


#line 697 "timsort.vala"
static inline gconstpointer gee_tim_sort_slice_peek_last (GeeTimSortSlice* self) {
#line 2060 "timsort.c"
	gconstpointer result;
#line 697 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2064 "timsort.c"
	result = self->list[(self->index + self->length) - 1];
#line 698 "timsort.vala"
	return result;
#line 2068 "timsort.c"
}


#line 701 "timsort.vala"
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self) {
#line 2074 "timsort.c"
	gint low;
	gint high;
#line 701 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 702 "timsort.vala"
	low = self->index;
#line 703 "timsort.vala"
	high = (self->index + self->length) - 1;
#line 704 "timsort.vala"
	while (TRUE) {
#line 704 "timsort.vala"
		if (!(low < high)) {
#line 704 "timsort.vala"
			break;
#line 2089 "timsort.c"
		}
#line 705 "timsort.vala"
		gee_tim_sort_slice_swap (self, low++, high--);
#line 2093 "timsort.c"
	}
}


#line 709 "timsort.vala"
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j) {
#line 2100 "timsort.c"
	gpointer _tmp0_;
	gpointer temp;
	gpointer _tmp1_;
	gpointer _tmp2_;
#line 709 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 710 "timsort.vala"
	temp = (_tmp0_ = self->list[i], self->list[i] = NULL, _tmp0_);
#line 711 "timsort.vala"
	self->list[i] = (_tmp1_ = self->list[j], self->list[j] = NULL, _tmp1_);
#line 712 "timsort.vala"
	self->list[j] = (_tmp2_ = temp, temp = NULL, _tmp2_);
#line 2113 "timsort.c"
}


static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self) {
}


static void gee_tim_sort_slice_free (GeeTimSortSlice* self) {
	self->new_list = (g_free (self->new_list), NULL);
	g_slice_free (GeeTimSortSlice, self);
}


static void gee_tim_sort_class_init (GeeTimSortClass * klass) {
	gee_tim_sort_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTimSortPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_tim_sort_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tim_sort_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tim_sort_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tim_sort_instance_init (GeeTimSort * self) {
	self->priv = GEE_TIM_SORT_GET_PRIVATE (self);
}


static void gee_tim_sort_finalize (GObject* obj) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (obj);
	_g_object_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (g_free (self->priv->pending), NULL);
	G_OBJECT_CLASS (gee_tim_sort_parent_class)->finalize (obj);
}


GType gee_tim_sort_get_type (void) {
	static GType gee_tim_sort_type_id = 0;
	if (gee_tim_sort_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTimSort), 0, (GInstanceInitFunc) gee_tim_sort_instance_init, NULL };
		gee_tim_sort_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTimSort", &g_define_type_info, 0);
	}
	return gee_tim_sort_type_id;
}


static void gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TIM_SORT_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TIM_SORT_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TIM_SORT_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if (src < dest) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	}
}




