/* priorityqueue.c generated by valac, the Vala compiler
 * generated from priorityqueue.vala, do not modify */

/* priorityqueue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

#define GEE_TYPE_PRIORITY_QUEUE (gee_priority_queue_get_type ())
#define GEE_PRIORITY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueue))
#define GEE_PRIORITY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueueClass))
#define GEE_IS_PRIORITY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_PRIORITY_QUEUE))
#define GEE_IS_PRIORITY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_PRIORITY_QUEUE))
#define GEE_PRIORITY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueueClass))

typedef struct _GeePriorityQueue GeePriorityQueue;
typedef struct _GeePriorityQueueClass GeePriorityQueueClass;
typedef struct _GeePriorityQueuePrivate GeePriorityQueuePrivate;

#define GEE_PRIORITY_QUEUE_TYPE_NODE (gee_priority_queue_node_get_type ())
#define GEE_PRIORITY_QUEUE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNode))
#define GEE_PRIORITY_QUEUE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodeClass))
#define GEE_PRIORITY_QUEUE_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE))
#define GEE_PRIORITY_QUEUE_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE))
#define GEE_PRIORITY_QUEUE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodeClass))

typedef struct _GeePriorityQueueNode GeePriorityQueueNode;
typedef struct _GeePriorityQueueNodeClass GeePriorityQueueNodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE (gee_priority_queue_type1_node_get_type ())
#define GEE_PRIORITY_QUEUE_TYPE1_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1Node))
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodeClass))
#define GEE_PRIORITY_QUEUE_IS_TYPE1_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE))
#define GEE_PRIORITY_QUEUE_IS_TYPE1_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE))
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodeClass))

typedef struct _GeePriorityQueueType1Node GeePriorityQueueType1Node;
typedef struct _GeePriorityQueueType1NodeClass GeePriorityQueueType1NodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE (gee_priority_queue_type2_node_get_type ())
#define GEE_PRIORITY_QUEUE_TYPE2_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2Node))
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodeClass))
#define GEE_PRIORITY_QUEUE_IS_TYPE2_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE))
#define GEE_PRIORITY_QUEUE_IS_TYPE2_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE))
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodeClass))

typedef struct _GeePriorityQueueType2Node GeePriorityQueueType2Node;
typedef struct _GeePriorityQueueType2NodeClass GeePriorityQueueType2NodeClass;

#define GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR (gee_priority_queue_node_pair_get_type ())
#define GEE_PRIORITY_QUEUE_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePair))
#define GEE_PRIORITY_QUEUE_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePairClass))
#define GEE_PRIORITY_QUEUE_IS_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR))
#define GEE_PRIORITY_QUEUE_IS_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR))
#define GEE_PRIORITY_QUEUE_NODE_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePairClass))

typedef struct _GeePriorityQueueNodePair GeePriorityQueueNodePair;
typedef struct _GeePriorityQueueNodePairClass GeePriorityQueueNodePairClass;
#define _gee_priority_queue_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_priority_queue_node_unref (var), NULL)))
#define _gee_priority_queue_node_pair_unref0(var) ((var == NULL) ? NULL : (var = (gee_priority_queue_node_pair_unref (var), NULL)))
typedef struct _GeePriorityQueueNodePrivate GeePriorityQueueNodePrivate;
typedef struct _GeePriorityQueueType1NodePrivate GeePriorityQueueType1NodePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_PRIORITY_QUEUE_TYPE_ITERATOR (gee_priority_queue_iterator_get_type ())
#define GEE_PRIORITY_QUEUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIterator))
#define GEE_PRIORITY_QUEUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorClass))
#define GEE_PRIORITY_QUEUE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR))
#define GEE_PRIORITY_QUEUE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_PRIORITY_QUEUE_TYPE_ITERATOR))
#define GEE_PRIORITY_QUEUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorClass))

typedef struct _GeePriorityQueueIterator GeePriorityQueueIterator;
typedef struct _GeePriorityQueueIteratorClass GeePriorityQueueIteratorClass;
typedef struct _GeePriorityQueueNodePairPrivate GeePriorityQueueNodePairPrivate;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeePriorityQueueParamSpecNode GeePriorityQueueParamSpecNode;
typedef struct _GeePriorityQueueType2NodePrivate GeePriorityQueueType2NodePrivate;
typedef struct _GeePriorityQueueParamSpecNodePair GeePriorityQueueParamSpecNodePair;
typedef struct _GeePriorityQueueIteratorPrivate GeePriorityQueueIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gboolean (*offer) (GeeAbstractQueue* self, gconstpointer element);
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	gint (*drain) (GeeAbstractQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeePriorityQueue {
	GeeAbstractQueue parent_instance;
	GeePriorityQueuePrivate * priv;
};

struct _GeePriorityQueueClass {
	GeeAbstractQueueClass parent_class;
};

struct _GeePriorityQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GCompareFunc _compare_func;
	gint _size;
	gint _stamp;
	GeePriorityQueueType1Node* _r;
	GeePriorityQueueType2Node* _r_prime;
	GeePriorityQueueType2Node* _lm_head;
	GeePriorityQueueType2Node* _lm_tail;
	GeePriorityQueueType1Node* _p;
	GeePriorityQueueType1Node** _a;
	gint _a_length1;
	gint _a_size;
	GeePriorityQueueNodePair* _lp_head;
	GeePriorityQueueNodePair* _lp_tail;
	gboolean* _b;
	gint _b_length1;
	gint _b_size;
	GeePriorityQueueType1Node* _ll_head;
	GeePriorityQueueType1Node* _ll_tail;
};

struct _GeePriorityQueueNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeePriorityQueueNodePrivate * priv;
	gpointer data;
	GeePriorityQueueNode* parent;
	gint type1_children_count;
	GeePriorityQueueType1Node* type1_children_head;
	GeePriorityQueueType1Node* type1_children_tail;
	gboolean pending_drop;
};

struct _GeePriorityQueueNodeClass {
	GTypeClass parent_class;
	void (*finalize) (GeePriorityQueueNode *self);
};

struct _GeePriorityQueueType1Node {
	GeePriorityQueueNode parent_instance;
	GeePriorityQueueType1NodePrivate * priv;
	guint lost;
	GeePriorityQueueType1Node* brothers_prev;
	GeePriorityQueueType1Node* brothers_next;
	GeePriorityQueueType2Node* type2_child;
	GeePriorityQueueType1Node* ll_prev;
	GeePriorityQueueType1Node* ll_next;
	GeePriorityQueueNodePair* pair;
};

struct _GeePriorityQueueType1NodeClass {
	GeePriorityQueueNodeClass parent_class;
};

struct _GeePriorityQueueNodePair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeePriorityQueueNodePairPrivate * priv;
	GeePriorityQueueNodePair* lp_prev;
	GeePriorityQueueNodePair* lp_next;
	GeePriorityQueueType1Node* node1;
	GeePriorityQueueType1Node* node2;
};

struct _GeePriorityQueueNodePairClass {
	GTypeClass parent_class;
	void (*finalize) (GeePriorityQueueNodePair *self);
};

struct _GeePriorityQueueNodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueParamSpecNode {
	GParamSpec parent_instance;
};

struct _GeePriorityQueueType1NodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueType2Node {
	GeePriorityQueueNode parent_instance;
	GeePriorityQueueType2NodePrivate * priv;
};

struct _GeePriorityQueueType2NodeClass {
	GeePriorityQueueNodeClass parent_class;
};

struct _GeePriorityQueueType2NodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueNodePairPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeePriorityQueueParamSpecNodePair {
	GParamSpec parent_instance;
};

struct _GeePriorityQueueIterator {
	GObject parent_instance;
	GeePriorityQueueIteratorPrivate * priv;
};

struct _GeePriorityQueueIteratorClass {
	GObjectClass parent_class;
};

struct _GeePriorityQueueIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeePriorityQueue* queue;
	gboolean started;
	gboolean from_type1_children;
	gboolean from_type2_child;
	GeePriorityQueueNode* position;
	GeePriorityQueueNode* _next;
	gint stamp;
	gboolean removed;
};


static gpointer gee_priority_queue_node_parent_class = NULL;
static gpointer gee_priority_queue_type1_node_parent_class = NULL;
static gpointer gee_priority_queue_type2_node_parent_class = NULL;
static gpointer gee_priority_queue_node_pair_parent_class = NULL;
static gpointer gee_priority_queue_iterator_parent_class = NULL;
static GeeIteratorIface* gee_priority_queue_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_priority_queue_parent_class = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_abstract_collection_get_type (void);
GType gee_queue_get_type (void);
GType gee_abstract_queue_get_type (void);
GType gee_priority_queue_get_type (void);
static gpointer gee_priority_queue_node_ref (gpointer instance);
static void gee_priority_queue_node_unref (gpointer instance);
static GParamSpec* gee_priority_queue_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
static void gee_priority_queue_value_set_node (GValue* value, gpointer v_object);
static gpointer gee_priority_queue_value_get_node (const GValue* value);
static GType gee_priority_queue_node_get_type (void);
static GType gee_priority_queue_type1_node_get_type (void);
static GType gee_priority_queue_type2_node_get_type (void);
static gpointer gee_priority_queue_node_pair_ref (gpointer instance);
static void gee_priority_queue_node_pair_unref (gpointer instance);
static GParamSpec* gee_priority_queue_param_spec_node_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
static void gee_priority_queue_value_set_node_pair (GValue* value, gpointer v_object);
static gpointer gee_priority_queue_value_get_node_pair (const GValue* value);
static GType gee_priority_queue_node_pair_get_type (void);
#define GEE_PRIORITY_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_PRIORITY_QUEUE, GeePriorityQueuePrivate))
enum  {
	GEE_PRIORITY_QUEUE_DUMMY_PROPERTY,
	GEE_PRIORITY_QUEUE_COMPARE_FUNC,
	GEE_PRIORITY_QUEUE_CAPACITY,
	GEE_PRIORITY_QUEUE_REMAINING_CAPACITY,
	GEE_PRIORITY_QUEUE_IS_FULL,
	GEE_PRIORITY_QUEUE_SIZE,
	GEE_PRIORITY_QUEUE_G_TYPE,
	GEE_PRIORITY_QUEUE_G_DUP_FUNC,
	GEE_PRIORITY_QUEUE_G_DESTROY_FUNC
};
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GCompareFunc gee_functions_get_compare_func_for (GType t);
static void gee_priority_queue_set_compare_func (GeePriorityQueue* self, GCompareFunc value);
GeePriorityQueue* gee_priority_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GeePriorityQueue* gee_priority_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static void _gee_priority_queue_add (GeePriorityQueue* self, GeePriorityQueueType1Node* n);
static gboolean gee_priority_queue_real_offer (GeeAbstractQueue* base, gconstpointer element);
static gpointer gee_priority_queue_real_peek (GeeAbstractQueue* base);
static void _gee_priority_queue_remove_type2_node (GeePriorityQueue* self, GeePriorityQueueType2Node* node);
static inline gint _gee_priority_queue_compare (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2);
static void _gee_priority_queue_remove_type1_node (GeePriorityQueue* self, GeePriorityQueueType1Node* node);
static void _gee_priority_queue_add_in_r_prime (GeePriorityQueue* self, GeePriorityQueueType1Node* node);
static void _gee_priority_queue_adjust (GeePriorityQueue* self, GeePriorityQueueType1Node* p1, GeePriorityQueueType1Node* p2);
static gboolean _gee_priority_queue_check_linkable (GeePriorityQueue* self);
static gpointer gee_priority_queue_real_poll (GeeAbstractQueue* base);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gpointer gee_abstract_queue_poll (GeeAbstractQueue* self);
static gint gee_priority_queue_real_drain (GeeAbstractQueue* base, GeeCollection* recipient, gint amount);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
GCompareFunc gee_priority_queue_get_compare_func (GeePriorityQueue* self);
static gboolean gee_priority_queue_real_contains (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_queue_offer (GeeAbstractQueue* self, gconstpointer element);
static gboolean gee_priority_queue_real_add (GeeAbstractCollection* base, gconstpointer item);
static GeePriorityQueueIterator* gee_priority_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue);
static GeePriorityQueueIterator* gee_priority_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue);
static GType gee_priority_queue_iterator_get_type (void);
static void _gee_priority_queue_delete (GeePriorityQueue* self, GeePriorityQueueNode* n);
static GeePriorityQueueNode* gee_priority_queue_iterator_get_node (GeePriorityQueueIterator* self);
static gboolean gee_priority_queue_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_priority_queue_real_clear (GeeAbstractCollection* base);
static GeeIterator* gee_priority_queue_real_iterator (GeeAbstractCollection* base);
static inline void _gee_priority_queue_swap_data (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2);
static inline gint gee_priority_queue_node_degree (GeePriorityQueueNode* self);
static void _gee_priority_queue_add_to (GeePriorityQueue* self, GeePriorityQueueType1Node* node, GeePriorityQueueType1Node* parent);
static void _gee_priority_queue_link (GeePriorityQueue* self, GeePriorityQueueType1Node* ri, GeePriorityQueueType1Node* rj);
static GeePriorityQueueNode* _gee_priority_queue_re_insert (GeePriorityQueue* self, GeePriorityQueueType1Node* n);
static void _gee_priority_queue_decrease_key (GeePriorityQueue* self, GeePriorityQueueNode* n);
static inline void gee_priority_queue_type1_node_add (GeePriorityQueueType1Node* self, GeePriorityQueueType1Node* node);
static GeePriorityQueueNodePair* gee_priority_queue_node_pair_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2);
static GeePriorityQueueNodePair* gee_priority_queue_node_pair_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2);
static void _gee_priority_queue_updated_degree (GeePriorityQueue* self, GeePriorityQueueType1Node* node, gboolean child_removed);
static inline void gee_priority_queue_type1_node_remove (GeePriorityQueueType1Node* self);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
#define GEE_PRIORITY_QUEUE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_NODE, GeePriorityQueueNodePrivate))
enum  {
	GEE_PRIORITY_QUEUE_NODE_DUMMY_PROPERTY
};
static GeePriorityQueueNode* gee_priority_queue_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static void gee_priority_queue_node_finalize (GeePriorityQueueNode* obj);
#define GEE_PRIORITY_QUEUE_TYPE1_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, GeePriorityQueueType1NodePrivate))
enum  {
	GEE_PRIORITY_QUEUE_TYPE1_NODE_DUMMY_PROPERTY
};
static void gee_priority_queue_type1_node_finalize (GeePriorityQueueNode* obj);
#define GEE_PRIORITY_QUEUE_TYPE2_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, GeePriorityQueueType2NodePrivate))
enum  {
	GEE_PRIORITY_QUEUE_TYPE2_NODE_DUMMY_PROPERTY
};
#define GEE_PRIORITY_QUEUE_NODE_PAIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, GeePriorityQueueNodePairPrivate))
enum  {
	GEE_PRIORITY_QUEUE_NODE_PAIR_DUMMY_PROPERTY
};
static void gee_priority_queue_node_pair_finalize (GeePriorityQueueNodePair* obj);
#define GEE_PRIORITY_QUEUE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_PRIORITY_QUEUE_TYPE_ITERATOR, GeePriorityQueueIteratorPrivate))
enum  {
	GEE_PRIORITY_QUEUE_ITERATOR_DUMMY_PROPERTY,
	GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE,
	GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC,
	GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC
};
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_priority_queue_iterator_real_next (GeeIterator* base);
static gboolean _gee_priority_queue_iterator_has_next (GeePriorityQueueIterator* self);
static gboolean gee_priority_queue_iterator_real_has_next (GeeIterator* base);
static gboolean gee_priority_queue_iterator_real_first (GeeIterator* base);
static gpointer gee_priority_queue_iterator_real_get (GeeIterator* base);
static void gee_priority_queue_iterator_real_remove (GeeIterator* base);
static void gee_priority_queue_iterator_finalize (GObject* obj);
static void gee_priority_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_priority_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_priority_queue_finalize (GObject* obj);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static void gee_priority_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_priority_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



#line 71 "priorityqueue.vala"
GeePriorityQueue* gee_priority_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
#line 526 "priorityqueue.c"
	GeePriorityQueue * self;
#line 71 "priorityqueue.vala"
	self = (GeePriorityQueue*) gee_abstract_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 71 "priorityqueue.vala"
	self->priv->g_type = g_type;
#line 71 "priorityqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 71 "priorityqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 72 "priorityqueue.vala"
	if (compare_func == NULL) {
#line 73 "priorityqueue.vala"
		compare_func = gee_functions_get_compare_func_for (g_type);
#line 540 "priorityqueue.c"
	}
#line 75 "priorityqueue.vala"
	gee_priority_queue_set_compare_func (self, compare_func);
#line 544 "priorityqueue.c"
	return self;
}


#line 71 "priorityqueue.vala"
GeePriorityQueue* gee_priority_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
#line 71 "priorityqueue.vala"
	return gee_priority_queue_construct (GEE_TYPE_PRIORITY_QUEUE, g_type, g_dup_func, g_destroy_func, compare_func);
#line 553 "priorityqueue.c"
}


static gpointer _gee_priority_queue_node_ref0 (gpointer self) {
	return self ? gee_priority_queue_node_ref (self) : NULL;
}


#line 102 "priorityqueue.vala"
static gboolean gee_priority_queue_real_offer (GeeAbstractQueue* base, gconstpointer element) {
#line 564 "priorityqueue.c"
	GeePriorityQueue * self;
	gboolean result;
	self = (GeePriorityQueue*) base;
#line 103 "priorityqueue.vala"
	if (self->priv->_r == NULL) {
#line 570 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp0_;
		GeePriorityQueueType1Node* _tmp1_;
#line 104 "priorityqueue.vala"
		self->priv->_r = (_tmp0_ = gee_priority_queue_type1_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, element), _gee_priority_queue_node_unref0 (self->priv->_r), _tmp0_);
#line 105 "priorityqueue.vala"
		self->priv->_p = (_tmp1_ = _gee_priority_queue_node_ref0 (self->priv->_r), _gee_priority_queue_node_unref0 (self->priv->_p), _tmp1_);
#line 577 "priorityqueue.c"
	} else {
#line 106 "priorityqueue.vala"
		if (self->priv->_r_prime == NULL) {
#line 581 "priorityqueue.c"
			GeePriorityQueueType2Node* _tmp2_;
			GeePriorityQueueType2Node* _tmp3_;
#line 107 "priorityqueue.vala"
			self->priv->_r_prime = (_tmp2_ = gee_priority_queue_type2_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, element), _gee_priority_queue_node_unref0 (self->priv->_r_prime), _tmp2_);
#line 108 "priorityqueue.vala"
			((GeePriorityQueueNode*) self->priv->_r_prime)->parent = (GeePriorityQueueNode*) self->priv->_r;
#line 109 "priorityqueue.vala"
			self->priv->_r->type2_child = (_tmp3_ = _gee_priority_queue_node_ref0 (self->priv->_r_prime), _gee_priority_queue_node_unref0 (self->priv->_r->type2_child), _tmp3_);
#line 590 "priorityqueue.c"
		} else {
			GeePriorityQueueType1Node* node;
#line 112 "priorityqueue.vala"
			node = gee_priority_queue_type1_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, element);
#line 115 "priorityqueue.vala"
			_gee_priority_queue_add (self, node);
#line 597 "priorityqueue.c"
			_gee_priority_queue_node_unref0 (node);
		}
	}
#line 118 "priorityqueue.vala"
	self->priv->_stamp++;
#line 119 "priorityqueue.vala"
	self->priv->_size++;
#line 605 "priorityqueue.c"
	result = TRUE;
#line 120 "priorityqueue.vala"
	return result;
#line 609 "priorityqueue.c"
}


#line 126 "priorityqueue.vala"
static gpointer gee_priority_queue_real_peek (GeeAbstractQueue* base) {
#line 615 "priorityqueue.c"
	GeePriorityQueue * self;
	gpointer result;
	gconstpointer _tmp0_;
	self = (GeePriorityQueue*) base;
#line 127 "priorityqueue.vala"
	if (self->priv->_r == NULL) {
#line 622 "priorityqueue.c"
		result = NULL;
#line 128 "priorityqueue.vala"
		return result;
#line 626 "priorityqueue.c"
	}
	result = (_tmp0_ = ((GeePriorityQueueNode*) self->priv->_r)->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 130 "priorityqueue.vala"
	return result;
#line 631 "priorityqueue.c"
}


#line 136 "priorityqueue.vala"
static gpointer gee_priority_queue_real_poll (GeeAbstractQueue* base) {
#line 637 "priorityqueue.c"
	GeePriorityQueue * self;
	gpointer result;
	gconstpointer _tmp0_;
	gpointer min;
	gpointer _tmp4_;
	gconstpointer _tmp3_;
	GeePriorityQueueType1Node* r_second;
	GeePriorityQueueType1Node* node;
	gpointer _tmp10_;
	gconstpointer _tmp9_;
	GeePriorityQueueType1Node* _tmp11_;
	self = (GeePriorityQueue*) base;
#line 142 "priorityqueue.vala"
	if (self->priv->_r == NULL) {
#line 652 "priorityqueue.c"
		result = NULL;
#line 143 "priorityqueue.vala"
		return result;
#line 656 "priorityqueue.c"
	}
#line 145 "priorityqueue.vala"
	min = (_tmp0_ = ((GeePriorityQueueNode*) self->priv->_r)->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 146 "priorityqueue.vala"
	((GeePriorityQueueNode*) self->priv->_r)->pending_drop = FALSE;
#line 147 "priorityqueue.vala"
	self->priv->_stamp++;
#line 148 "priorityqueue.vala"
	self->priv->_size--;
#line 151 "priorityqueue.vala"
	if (self->priv->_r_prime == NULL) {
#line 668 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp1_;
		GeePriorityQueueType1Node* _tmp2_;
#line 152 "priorityqueue.vala"
		self->priv->_r = (_tmp1_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r), _tmp1_);
#line 153 "priorityqueue.vala"
		self->priv->_p = (_tmp2_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_p), _tmp2_);
#line 675 "priorityqueue.c"
		result = min;
#line 154 "priorityqueue.vala"
		return result;
#line 679 "priorityqueue.c"
	}
#line 156 "priorityqueue.vala"
	((GeePriorityQueueNode*) self->priv->_r)->data = (_tmp4_ = (_tmp3_ = ((GeePriorityQueueNode*) self->priv->_r_prime)->data, ((_tmp3_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->g_dup_func ((gpointer) _tmp3_)), ((((GeePriorityQueueNode*) self->priv->_r)->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (((GeePriorityQueueNode*) self->priv->_r)->data = (self->priv->g_destroy_func (((GeePriorityQueueNode*) self->priv->_r)->data), NULL)), _tmp4_);
#line 159 "priorityqueue.vala"
	if (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head == NULL) {
#line 685 "priorityqueue.c"
		GeePriorityQueueType2Node* _tmp5_;
#line 160 "priorityqueue.vala"
		_gee_priority_queue_remove_type2_node (self, self->priv->_r_prime);
#line 161 "priorityqueue.vala"
		self->priv->_r_prime = (_tmp5_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r_prime), _tmp5_);
#line 691 "priorityqueue.c"
		result = min;
#line 162 "priorityqueue.vala"
		return result;
#line 695 "priorityqueue.c"
	}
#line 164 "priorityqueue.vala"
	r_second = NULL;
#line 165 "priorityqueue.vala"
	node = _gee_priority_queue_node_ref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head);
#line 166 "priorityqueue.vala"
	while (TRUE) {
#line 703 "priorityqueue.c"
		gboolean _tmp6_ = FALSE;
		GeePriorityQueueType1Node* _tmp8_;
#line 166 "priorityqueue.vala"
		if (!(node != NULL)) {
#line 166 "priorityqueue.vala"
			break;
#line 710 "priorityqueue.c"
		}
#line 167 "priorityqueue.vala"
		if (r_second == NULL) {
#line 167 "priorityqueue.vala"
			_tmp6_ = TRUE;
#line 716 "priorityqueue.c"
		} else {
#line 167 "priorityqueue.vala"
			_tmp6_ = _gee_priority_queue_compare (self, (GeePriorityQueueNode*) node, (GeePriorityQueueNode*) r_second) < 0;
#line 720 "priorityqueue.c"
		}
#line 167 "priorityqueue.vala"
		if (_tmp6_) {
#line 724 "priorityqueue.c"
			GeePriorityQueueType1Node* _tmp7_;
#line 168 "priorityqueue.vala"
			r_second = (_tmp7_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (r_second), _tmp7_);
#line 728 "priorityqueue.c"
		}
#line 170 "priorityqueue.vala"
		node = (_tmp8_ = _gee_priority_queue_node_ref0 (node->brothers_next), _gee_priority_queue_node_unref0 (node), _tmp8_);
#line 732 "priorityqueue.c"
	}
#line 174 "priorityqueue.vala"
	((GeePriorityQueueNode*) self->priv->_r_prime)->data = (_tmp10_ = (_tmp9_ = ((GeePriorityQueueNode*) r_second)->data, ((_tmp9_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp9_) : self->priv->g_dup_func ((gpointer) _tmp9_)), ((((GeePriorityQueueNode*) self->priv->_r_prime)->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (((GeePriorityQueueNode*) self->priv->_r_prime)->data = (self->priv->g_destroy_func (((GeePriorityQueueNode*) self->priv->_r_prime)->data), NULL)), _tmp10_);
#line 177 "priorityqueue.vala"
	_gee_priority_queue_remove_type1_node (self, r_second);
#line 180 "priorityqueue.vala"
	node = (_tmp11_ = _gee_priority_queue_node_ref0 (((GeePriorityQueueNode*) r_second)->type1_children_head), _gee_priority_queue_node_unref0 (node), _tmp11_);
#line 181 "priorityqueue.vala"
	while (TRUE) {
#line 742 "priorityqueue.c"
		GeePriorityQueueType1Node* next;
		GeePriorityQueueType1Node* _tmp12_;
#line 181 "priorityqueue.vala"
		if (!(node != NULL)) {
#line 181 "priorityqueue.vala"
			break;
#line 749 "priorityqueue.c"
		}
#line 182 "priorityqueue.vala"
		next = _gee_priority_queue_node_ref0 (node->brothers_next);
#line 183 "priorityqueue.vala"
		_gee_priority_queue_remove_type1_node (self, node);
#line 184 "priorityqueue.vala"
		_gee_priority_queue_add_in_r_prime (self, node);
#line 185 "priorityqueue.vala"
		node = (_tmp12_ = _gee_priority_queue_node_ref0 (next), _gee_priority_queue_node_unref0 (node), _tmp12_);
#line 759 "priorityqueue.c"
		_gee_priority_queue_node_unref0 (next);
	}
#line 209 "priorityqueue.vala"
	if (self->priv->_p == NULL) {
#line 764 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp13_;
#line 210 "priorityqueue.vala"
		self->priv->_p = (_tmp13_ = _gee_priority_queue_node_ref0 (self->priv->_r), _gee_priority_queue_node_unref0 (self->priv->_p), _tmp13_);
#line 768 "priorityqueue.c"
	}
#line 212 "priorityqueue.vala"
	_gee_priority_queue_adjust (self, self->priv->_p, self->priv->_p);
#line 240 "priorityqueue.vala"
	while (TRUE) {
#line 240 "priorityqueue.vala"
		if (!_gee_priority_queue_check_linkable (self)) {
#line 240 "priorityqueue.vala"
			break;
#line 778 "priorityqueue.c"
		}
	}
	result = min;
	_gee_priority_queue_node_unref0 (r_second);
	_gee_priority_queue_node_unref0 (node);
#line 243 "priorityqueue.vala"
	return result;
#line 786 "priorityqueue.c"
}


#line 249 "priorityqueue.vala"
static gint gee_priority_queue_real_drain (GeeAbstractQueue* base, GeeCollection* recipient, gint amount) {
#line 792 "priorityqueue.c"
	GeePriorityQueue * self;
	gint result;
	self = (GeePriorityQueue*) base;
#line 249 "priorityqueue.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 250 "priorityqueue.vala"
	if (amount == (-1)) {
#line 251 "priorityqueue.vala"
		amount = self->priv->_size;
#line 802 "priorityqueue.c"
	}
	{
		gint i;
#line 253 "priorityqueue.vala"
		i = 0;
#line 808 "priorityqueue.c"
		{
			gboolean _tmp0_;
#line 253 "priorityqueue.vala"
			_tmp0_ = TRUE;
#line 253 "priorityqueue.vala"
			while (TRUE) {
#line 815 "priorityqueue.c"
				gpointer _tmp1_;
#line 253 "priorityqueue.vala"
				if (!_tmp0_) {
#line 253 "priorityqueue.vala"
					i++;
#line 821 "priorityqueue.c"
				}
#line 253 "priorityqueue.vala"
				_tmp0_ = FALSE;
#line 253 "priorityqueue.vala"
				if (!(i < amount)) {
#line 253 "priorityqueue.vala"
					break;
#line 829 "priorityqueue.c"
				}
#line 254 "priorityqueue.vala"
				if (self->priv->_size == 0) {
#line 833 "priorityqueue.c"
					result = i;
#line 255 "priorityqueue.vala"
					return result;
#line 837 "priorityqueue.c"
				}
#line 257 "priorityqueue.vala"
				gee_collection_add (recipient, _tmp1_ = gee_abstract_queue_poll ((GeeAbstractQueue*) self));
#line 841 "priorityqueue.c"
				((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			}
		}
	}
	result = amount;
#line 259 "priorityqueue.vala"
	return result;
#line 849 "priorityqueue.c"
}


#line 272 "priorityqueue.vala"
static gboolean gee_priority_queue_real_contains (GeeAbstractCollection* base, gconstpointer item) {
#line 855 "priorityqueue.c"
	GeePriorityQueue * self;
	gboolean result;
	self = (GeePriorityQueue*) base;
	{
		GeeIterator* _an_item_it;
		_an_item_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
#line 273 "priorityqueue.vala"
		while (TRUE) {
#line 864 "priorityqueue.c"
			gpointer an_item;
#line 273 "priorityqueue.vala"
			if (!gee_iterator_next (_an_item_it)) {
#line 273 "priorityqueue.vala"
				break;
#line 870 "priorityqueue.c"
			}
#line 273 "priorityqueue.vala"
			an_item = gee_iterator_get (_an_item_it);
#line 274 "priorityqueue.vala"
			if (gee_priority_queue_get_compare_func (self) (item, an_item) == 0) {
#line 876 "priorityqueue.c"
				result = TRUE;
				((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
				_g_object_unref0 (_an_item_it);
#line 275 "priorityqueue.vala"
				return result;
#line 882 "priorityqueue.c"
			}
			((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
		}
		_g_object_unref0 (_an_item_it);
	}
	result = FALSE;
#line 278 "priorityqueue.vala"
	return result;
#line 891 "priorityqueue.c"
}


#line 284 "priorityqueue.vala"
static gboolean gee_priority_queue_real_add (GeeAbstractCollection* base, gconstpointer item) {
#line 897 "priorityqueue.c"
	GeePriorityQueue * self;
	gboolean result;
	self = (GeePriorityQueue*) base;
	result = gee_abstract_queue_offer ((GeeAbstractQueue*) self, item);
#line 285 "priorityqueue.vala"
	return result;
#line 904 "priorityqueue.c"
}


#line 291 "priorityqueue.vala"
static gboolean gee_priority_queue_real_remove (GeeAbstractCollection* base, gconstpointer item) {
#line 910 "priorityqueue.c"
	GeePriorityQueue * self;
	gboolean result;
	GeePriorityQueueIterator* iterator;
	self = (GeePriorityQueue*) base;
#line 296 "priorityqueue.vala"
	iterator = gee_priority_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 297 "priorityqueue.vala"
	while (TRUE) {
#line 919 "priorityqueue.c"
		gpointer an_item;
#line 297 "priorityqueue.vala"
		if (!gee_iterator_next ((GeeIterator*) iterator)) {
#line 297 "priorityqueue.vala"
			break;
#line 925 "priorityqueue.c"
		}
#line 298 "priorityqueue.vala"
		an_item = gee_iterator_get ((GeeIterator*) iterator);
#line 299 "priorityqueue.vala"
		if (gee_priority_queue_get_compare_func (self) (item, an_item) == 0) {
#line 931 "priorityqueue.c"
			GeePriorityQueueNode* _tmp0_;
#line 300 "priorityqueue.vala"
			_gee_priority_queue_delete (self, _tmp0_ = gee_priority_queue_iterator_get_node (iterator));
#line 935 "priorityqueue.c"
			_gee_priority_queue_node_unref0 (_tmp0_);
			result = TRUE;
			((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
			_g_object_unref0 (iterator);
#line 301 "priorityqueue.vala"
			return result;
#line 942 "priorityqueue.c"
		}
		((an_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (an_item = (self->priv->g_destroy_func (an_item), NULL));
	}
	result = FALSE;
	_g_object_unref0 (iterator);
#line 304 "priorityqueue.vala"
	return result;
#line 950 "priorityqueue.c"
}


#line 310 "priorityqueue.vala"
static void gee_priority_queue_real_clear (GeeAbstractCollection* base) {
#line 956 "priorityqueue.c"
	GeePriorityQueue * self;
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType2Node* _tmp1_;
	GeePriorityQueueType2Node* _tmp2_;
	GeePriorityQueueType2Node* _tmp3_;
	GeePriorityQueueType1Node* _tmp4_;
	GeePriorityQueueType1Node** _tmp5_;
	GeePriorityQueueNodePair* _tmp6_;
	GeePriorityQueueNodePair* _tmp7_;
	gboolean* _tmp8_;
	GeePriorityQueueType1Node* _tmp9_;
	GeePriorityQueueType1Node* _tmp10_;
	self = (GeePriorityQueue*) base;
#line 311 "priorityqueue.vala"
	self->priv->_size = 0;
#line 312 "priorityqueue.vala"
	self->priv->_r = (_tmp0_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r), _tmp0_);
#line 313 "priorityqueue.vala"
	self->priv->_r_prime = (_tmp1_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_r_prime), _tmp1_);
#line 314 "priorityqueue.vala"
	self->priv->_lm_head = (_tmp2_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_lm_head), _tmp2_);
#line 315 "priorityqueue.vala"
	self->priv->_lm_tail = (_tmp3_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_lm_tail), _tmp3_);
#line 316 "priorityqueue.vala"
	self->priv->_p = (_tmp4_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_p), _tmp4_);
#line 317 "priorityqueue.vala"
	self->priv->_a = (_tmp5_ = g_new0 (GeePriorityQueueType1Node*, 0 + 1), self->priv->_a = (_vala_array_free (self->priv->_a, self->priv->_a_length1, (GDestroyNotify) gee_priority_queue_node_unref), NULL), self->priv->_a_length1 = 0, self->priv->_a_size = self->priv->_a_length1, _tmp5_);
#line 318 "priorityqueue.vala"
	self->priv->_lp_head = (_tmp6_ = NULL, _gee_priority_queue_node_pair_unref0 (self->priv->_lp_head), _tmp6_);
#line 319 "priorityqueue.vala"
	self->priv->_lp_tail = (_tmp7_ = NULL, _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp7_);
#line 320 "priorityqueue.vala"
	self->priv->_b = (_tmp8_ = g_new0 (gboolean, 0), self->priv->_b = (g_free (self->priv->_b), NULL), self->priv->_b_length1 = 0, self->priv->_b_size = self->priv->_b_length1, _tmp8_);
#line 321 "priorityqueue.vala"
	self->priv->_ll_head = (_tmp9_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp9_);
#line 322 "priorityqueue.vala"
	self->priv->_ll_tail = (_tmp10_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_ll_tail), _tmp10_);
#line 994 "priorityqueue.c"
}


#line 328 "priorityqueue.vala"
static GeeIterator* gee_priority_queue_real_iterator (GeeAbstractCollection* base) {
#line 1000 "priorityqueue.c"
	GeePriorityQueue * self;
	GeeIterator* result;
	self = (GeePriorityQueue*) base;
	result = (GeeIterator*) gee_priority_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 329 "priorityqueue.vala"
	return result;
#line 1007 "priorityqueue.c"
}


#line 332 "priorityqueue.vala"
static inline gint _gee_priority_queue_compare (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2) {
#line 1013 "priorityqueue.c"
	gint result;
#line 332 "priorityqueue.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 332 "priorityqueue.vala"
	g_return_val_if_fail (node1 != NULL, 0);
#line 332 "priorityqueue.vala"
	g_return_val_if_fail (node2 != NULL, 0);
#line 334 "priorityqueue.vala"
	if (node1->pending_drop) {
#line 1023 "priorityqueue.c"
		result = -1;
#line 335 "priorityqueue.vala"
		return result;
#line 1027 "priorityqueue.c"
	} else {
#line 336 "priorityqueue.vala"
		if (node2->pending_drop) {
#line 1031 "priorityqueue.c"
			result = 1;
#line 337 "priorityqueue.vala"
			return result;
#line 1035 "priorityqueue.c"
		} else {
			result = gee_priority_queue_get_compare_func (self) (node1->data, node2->data);
#line 339 "priorityqueue.vala"
			return result;
#line 1040 "priorityqueue.c"
		}
	}
}


#line 343 "priorityqueue.vala"
static inline void _gee_priority_queue_swap_data (GeePriorityQueue* self, GeePriorityQueueNode* node1, GeePriorityQueueNode* node2) {
#line 1048 "priorityqueue.c"
	gpointer _tmp0_;
	gpointer temp_data;
	gboolean temp_pending_drop;
	gpointer _tmp2_;
	gpointer _tmp1_;
	gpointer _tmp4_;
	gpointer _tmp3_;
#line 343 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 343 "priorityqueue.vala"
	g_return_if_fail (node1 != NULL);
#line 343 "priorityqueue.vala"
	g_return_if_fail (node2 != NULL);
#line 344 "priorityqueue.vala"
	temp_data = (_tmp0_ = node1->data, node1->data = NULL, _tmp0_);
#line 345 "priorityqueue.vala"
	temp_pending_drop = node1->pending_drop;
#line 346 "priorityqueue.vala"
	node1->data = (_tmp2_ = (_tmp1_ = node2->data, node2->data = NULL, _tmp1_), ((node1->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node1->data = (self->priv->g_destroy_func (node1->data), NULL)), _tmp2_);
#line 347 "priorityqueue.vala"
	node1->pending_drop = node2->pending_drop;
#line 348 "priorityqueue.vala"
	node2->data = (_tmp4_ = (_tmp3_ = temp_data, temp_data = NULL, _tmp3_), ((node2->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node2->data = (self->priv->g_destroy_func (node2->data), NULL)), _tmp4_);
#line 349 "priorityqueue.vala"
	node2->pending_drop = temp_pending_drop;
#line 1074 "priorityqueue.c"
	((temp_data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (temp_data = (self->priv->g_destroy_func (temp_data), NULL));
}


#line 352 "priorityqueue.vala"
static void _gee_priority_queue_link (GeePriorityQueue* self, GeePriorityQueueType1Node* ri, GeePriorityQueueType1Node* rj) {
#line 352 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 352 "priorityqueue.vala"
	g_return_if_fail (ri != NULL);
#line 352 "priorityqueue.vala"
	g_return_if_fail (rj != NULL);
#line 353 "priorityqueue.vala"
	g_assert (gee_priority_queue_node_degree ((GeePriorityQueueNode*) ri) == gee_priority_queue_node_degree ((GeePriorityQueueNode*) rj));
#line 356 "priorityqueue.vala"
	_gee_priority_queue_remove_type1_node (self, ri);
#line 357 "priorityqueue.vala"
	_gee_priority_queue_remove_type1_node (self, rj);
#line 360 "priorityqueue.vala"
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) ri, (GeePriorityQueueNode*) rj) > 0) {
#line 1095 "priorityqueue.c"
		GeePriorityQueueType1Node* temp;
#line 361 "priorityqueue.vala"
		temp = _gee_priority_queue_node_ref0 (ri);
#line 362 "priorityqueue.vala"
		ri = rj;
#line 363 "priorityqueue.vala"
		rj = temp;
#line 1103 "priorityqueue.c"
		_gee_priority_queue_node_unref0 (temp);
	}
#line 367 "priorityqueue.vala"
	_gee_priority_queue_add_to (self, rj, ri);
#line 370 "priorityqueue.vala"
	_gee_priority_queue_add_in_r_prime (self, ri);
#line 1110 "priorityqueue.c"
}


#line 373 "priorityqueue.vala"
static void _gee_priority_queue_add (GeePriorityQueue* self, GeePriorityQueueType1Node* n) {
#line 373 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 373 "priorityqueue.vala"
	g_return_if_fail (n != NULL);
#line 375 "priorityqueue.vala"
	_gee_priority_queue_add_in_r_prime (self, n);
#line 378 "priorityqueue.vala"
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) n, (GeePriorityQueueNode*) self->priv->_r_prime) < 0) {
#line 379 "priorityqueue.vala"
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) n, (GeePriorityQueueNode*) self->priv->_r_prime);
#line 1126 "priorityqueue.c"
	}
#line 383 "priorityqueue.vala"
	if (_gee_priority_queue_compare (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r) < 0) {
#line 384 "priorityqueue.vala"
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r);
#line 1132 "priorityqueue.c"
	}
#line 389 "priorityqueue.vala"
	_gee_priority_queue_check_linkable (self);
#line 1136 "priorityqueue.c"
}


static gpointer _gee_priority_queue_node_pair_ref0 (gpointer self) {
	return self ? gee_priority_queue_node_pair_ref (self) : NULL;
}


#line 396 "priorityqueue.vala"
static gboolean _gee_priority_queue_check_linkable (GeePriorityQueue* self) {
#line 1147 "priorityqueue.c"
	gboolean result;
#line 396 "priorityqueue.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 401 "priorityqueue.vala"
	if (self->priv->_lp_head != NULL) {
#line 1153 "priorityqueue.c"
		GeePriorityQueueNodePair* pair;
#line 402 "priorityqueue.vala"
		pair = _gee_priority_queue_node_pair_ref0 (self->priv->_lp_head);
#line 403 "priorityqueue.vala"
		_gee_priority_queue_link (self, pair->node1, pair->node2);
#line 1159 "priorityqueue.c"
		result = TRUE;
		_gee_priority_queue_node_pair_unref0 (pair);
#line 404 "priorityqueue.vala"
		return result;
#line 1164 "priorityqueue.c"
	}
	result = FALSE;
#line 406 "priorityqueue.vala"
	return result;
#line 1169 "priorityqueue.c"
}


#line 409 "priorityqueue.vala"
static GeePriorityQueueNode* _gee_priority_queue_re_insert (GeePriorityQueue* self, GeePriorityQueueType1Node* n) {
#line 1175 "priorityqueue.c"
	GeePriorityQueueNode* result;
	GeePriorityQueueNode* parent;
#line 409 "priorityqueue.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 409 "priorityqueue.vala"
	g_return_val_if_fail (n != NULL, NULL);
#line 410 "priorityqueue.vala"
	g_assert (n != self->priv->_r);
#line 417 "priorityqueue.vala"
	parent = _gee_priority_queue_node_ref0 (((GeePriorityQueueNode*) n)->parent);
#line 420 "priorityqueue.vala"
	_gee_priority_queue_remove_type1_node (self, n);
#line 423 "priorityqueue.vala"
	_gee_priority_queue_add (self, n);
#line 1190 "priorityqueue.c"
	result = parent;
#line 426 "priorityqueue.vala"
	return result;
#line 1194 "priorityqueue.c"
}


#line 429 "priorityqueue.vala"
static void _gee_priority_queue_adjust (GeePriorityQueue* self, GeePriorityQueueType1Node* p1, GeePriorityQueueType1Node* p2) {
#line 1200 "priorityqueue.c"
	GeePriorityQueueType1Node* m;
	GeePriorityQueueType1Node* _tmp4_;
#line 429 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 429 "priorityqueue.vala"
	g_return_if_fail (p1 != NULL);
#line 429 "priorityqueue.vala"
	g_return_if_fail (p2 != NULL);
#line 431 "priorityqueue.vala"
	if (self->priv->_ll_head == NULL) {
#line 432 "priorityqueue.vala"
		return;
#line 1213 "priorityqueue.c"
	}
	m = NULL;
#line 441 "priorityqueue.vala"
	if (p1->lost > p2->lost) {
#line 1218 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp0_;
#line 442 "priorityqueue.vala"
		m = (_tmp0_ = _gee_priority_queue_node_ref0 (p1), _gee_priority_queue_node_unref0 (m), _tmp0_);
#line 1222 "priorityqueue.c"
	} else {
		GeePriorityQueueType1Node* _tmp1_;
#line 444 "priorityqueue.vala"
		m = (_tmp1_ = _gee_priority_queue_node_ref0 (p2), _gee_priority_queue_node_unref0 (m), _tmp1_);
#line 1227 "priorityqueue.c"
	}
#line 448 "priorityqueue.vala"
	if (m->lost <= 1) {
#line 1231 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp2_;
		GeePriorityQueueType1Node* _tmp3_;
#line 449 "priorityqueue.vala"
		m = (_tmp2_ = _gee_priority_queue_node_ref0 (self->priv->_ll_head), _gee_priority_queue_node_unref0 (m), _tmp2_);
#line 450 "priorityqueue.vala"
		if (self->priv->_ll_head->ll_next != NULL) {
#line 451 "priorityqueue.vala"
			self->priv->_ll_head->ll_next->ll_prev = NULL;
#line 1240 "priorityqueue.c"
		}
#line 453 "priorityqueue.vala"
		self->priv->_ll_head = (_tmp3_ = _gee_priority_queue_node_ref0 (self->priv->_ll_head->ll_next), _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp3_);
#line 1244 "priorityqueue.c"
	}
#line 457 "priorityqueue.vala"
	self->priv->_p = (_tmp4_ = GEE_PRIORITY_QUEUE_TYPE1_NODE (_gee_priority_queue_re_insert (self, m)), _gee_priority_queue_node_unref0 (self->priv->_p), _tmp4_);
#line 1248 "priorityqueue.c"
	_gee_priority_queue_node_unref0 (m);
}


#line 464 "priorityqueue.vala"
static void _gee_priority_queue_delete (GeePriorityQueue* self, GeePriorityQueueNode* n) {
#line 1255 "priorityqueue.c"
	gpointer _tmp0_;
#line 464 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 464 "priorityqueue.vala"
	g_return_if_fail (n != NULL);
#line 466 "priorityqueue.vala"
	_gee_priority_queue_decrease_key (self, n);
#line 469 "priorityqueue.vala"
	_tmp0_ = gee_abstract_queue_poll ((GeeAbstractQueue*) self);
#line 1265 "priorityqueue.c"
	((_tmp0_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_ = (self->priv->g_destroy_func (_tmp0_), NULL));
}


#line 472 "priorityqueue.vala"
static void _gee_priority_queue_decrease_key (GeePriorityQueue* self, GeePriorityQueueNode* n) {
#line 1272 "priorityqueue.c"
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeePriorityQueueNode* p_prime;
#line 472 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 472 "priorityqueue.vala"
	g_return_if_fail (n != NULL);
#line 477 "priorityqueue.vala"
	if (n == GEE_PRIORITY_QUEUE_NODE (self->priv->_r)) {
#line 477 "priorityqueue.vala"
		_tmp0_ = TRUE;
#line 1284 "priorityqueue.c"
	} else {
#line 477 "priorityqueue.vala"
		_tmp0_ = self->priv->_r_prime == NULL;
#line 1288 "priorityqueue.c"
	}
#line 477 "priorityqueue.vala"
	if (_tmp0_) {
#line 478 "priorityqueue.vala"
		return;
#line 1294 "priorityqueue.c"
	}
#line 481 "priorityqueue.vala"
	n->pending_drop = TRUE;
#line 485 "priorityqueue.vala"
	if (n == GEE_PRIORITY_QUEUE_NODE (self->priv->_r_prime)) {
#line 485 "priorityqueue.vala"
		_tmp1_ = _gee_priority_queue_compare (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r) < 0;
#line 1302 "priorityqueue.c"
	} else {
#line 485 "priorityqueue.vala"
		_tmp1_ = FALSE;
#line 1306 "priorityqueue.c"
	}
#line 485 "priorityqueue.vala"
	if (_tmp1_) {
#line 486 "priorityqueue.vala"
		_gee_priority_queue_swap_data (self, (GeePriorityQueueNode*) self->priv->_r_prime, (GeePriorityQueueNode*) self->priv->_r);
#line 487 "priorityqueue.vala"
		return;
#line 1314 "priorityqueue.c"
	}
#line 509 "priorityqueue.vala"
	p_prime = _gee_priority_queue_re_insert (self, GEE_PRIORITY_QUEUE_TYPE1_NODE (n));
#line 511 "priorityqueue.vala"
	if (GEE_PRIORITY_QUEUE_IS_TYPE2_NODE (p_prime)) {
#line 513 "priorityqueue.vala"
		_gee_priority_queue_adjust (self, self->priv->_p, self->priv->_p);
#line 1322 "priorityqueue.c"
	} else {
#line 516 "priorityqueue.vala"
		_gee_priority_queue_adjust (self, self->priv->_p, GEE_PRIORITY_QUEUE_TYPE1_NODE (p_prime));
#line 1326 "priorityqueue.c"
	}
	_gee_priority_queue_node_unref0 (p_prime);
}


#line 520 "priorityqueue.vala"
static void _gee_priority_queue_add_to (GeePriorityQueue* self, GeePriorityQueueType1Node* node, GeePriorityQueueType1Node* parent) {
#line 520 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 520 "priorityqueue.vala"
	g_return_if_fail (node != NULL);
#line 520 "priorityqueue.vala"
	g_return_if_fail (parent != NULL);
#line 521 "priorityqueue.vala"
	gee_priority_queue_type1_node_add (parent, node);
#line 522 "priorityqueue.vala"
	parent->lost = (guint) 0;
#line 1344 "priorityqueue.c"
}


#line 525 "priorityqueue.vala"
static void _gee_priority_queue_add_in_r_prime (GeePriorityQueue* self, GeePriorityQueueType1Node* node) {
#line 1350 "priorityqueue.c"
	gint degree;
	GeePriorityQueueType1Node* insertion_point;
	GeePriorityQueueType1Node* _tmp13_;
#line 525 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 525 "priorityqueue.vala"
	g_return_if_fail (node != NULL);
#line 530 "priorityqueue.vala"
	degree = gee_priority_queue_node_degree ((GeePriorityQueueNode*) node);
#line 532 "priorityqueue.vala"
	insertion_point = NULL;
#line 533 "priorityqueue.vala"
	if (degree < self->priv->_a_length1) {
#line 1364 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp0_;
#line 534 "priorityqueue.vala"
		insertion_point = (_tmp0_ = _gee_priority_queue_node_ref0 (self->priv->_a[degree]), _gee_priority_queue_node_unref0 (insertion_point), _tmp0_);
#line 1368 "priorityqueue.c"
	}
#line 537 "priorityqueue.vala"
	if (insertion_point == NULL) {
#line 1372 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp3_;
#line 538 "priorityqueue.vala"
		if (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail != NULL) {
#line 1376 "priorityqueue.c"
			GeePriorityQueueType1Node* _tmp1_;
#line 539 "priorityqueue.vala"
			node->brothers_prev = ((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail;
#line 540 "priorityqueue.vala"
			((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail->brothers_next = (_tmp1_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail->brothers_next), _tmp1_);
#line 1382 "priorityqueue.c"
		} else {
			GeePriorityQueueType1Node* _tmp2_;
#line 542 "priorityqueue.vala"
			((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head = (_tmp2_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head), _tmp2_);
#line 1387 "priorityqueue.c"
		}
#line 544 "priorityqueue.vala"
		((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail = (_tmp3_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_tail), _tmp3_);
#line 1391 "priorityqueue.c"
	} else {
		GeePriorityQueueType1Node* _tmp6_;
#line 546 "priorityqueue.vala"
		if (insertion_point->brothers_prev != NULL) {
#line 1396 "priorityqueue.c"
			GeePriorityQueueType1Node* _tmp4_;
#line 547 "priorityqueue.vala"
			insertion_point->brothers_prev->brothers_next = (_tmp4_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (insertion_point->brothers_prev->brothers_next), _tmp4_);
#line 548 "priorityqueue.vala"
			node->brothers_prev = insertion_point->brothers_prev;
#line 1402 "priorityqueue.c"
		} else {
			GeePriorityQueueType1Node* _tmp5_;
#line 550 "priorityqueue.vala"
			((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head = (_tmp5_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self->priv->_r_prime)->type1_children_head), _tmp5_);
#line 1407 "priorityqueue.c"
		}
#line 552 "priorityqueue.vala"
		node->brothers_next = (_tmp6_ = _gee_priority_queue_node_ref0 (insertion_point), _gee_priority_queue_node_unref0 (node->brothers_next), _tmp6_);
#line 553 "priorityqueue.vala"
		insertion_point->brothers_prev = node;
#line 1413 "priorityqueue.c"
	}
#line 555 "priorityqueue.vala"
	((GeePriorityQueueNode*) node)->parent = (GeePriorityQueueNode*) self->priv->_r_prime;
#line 558 "priorityqueue.vala"
	if (degree >= self->priv->_a_length1) {
#line 1419 "priorityqueue.c"
		gint _tmp7_;
		gint _tmp8_;
#line 559 "priorityqueue.vala"
		_tmp7_ = degree + 1;
#line 559 "priorityqueue.vala"
		self->priv->_a = g_renew (GeePriorityQueueType1Node*, self->priv->_a, degree + 1);
#line 559 "priorityqueue.vala"
		(_tmp7_ > self->priv->_a_length1) ? memset (self->priv->_a + self->priv->_a_length1, 0, sizeof (GeePriorityQueueType1Node*) * (_tmp7_ - self->priv->_a_length1)) : NULL;
#line 559 "priorityqueue.vala"
		self->priv->_a_length1 = _tmp7_;
#line 560 "priorityqueue.vala"
		_tmp8_ = degree + 1;
#line 560 "priorityqueue.vala"
		self->priv->_b = g_renew (gboolean, self->priv->_b, degree + 1);
#line 560 "priorityqueue.vala"
		(_tmp8_ > self->priv->_b_length1) ? memset (self->priv->_b + self->priv->_b_length1, 0, sizeof (gboolean) * (_tmp8_ - self->priv->_b_length1)) : NULL;
#line 560 "priorityqueue.vala"
		self->priv->_b_length1 = _tmp8_;
#line 1438 "priorityqueue.c"
	}
#line 564 "priorityqueue.vala"
	if (self->priv->_a[degree] == NULL) {
#line 565 "priorityqueue.vala"
		self->priv->_b[degree] = TRUE;
#line 1444 "priorityqueue.c"
	} else {
#line 568 "priorityqueue.vala"
		if (self->priv->_b[degree]) {
#line 1448 "priorityqueue.c"
			GeePriorityQueueNodePair* pair;
#line 570 "priorityqueue.vala"
			pair = gee_priority_queue_node_pair_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, node, node->brothers_next);
#line 571 "priorityqueue.vala"
			node->brothers_next->pair = pair;
#line 572 "priorityqueue.vala"
			node->pair = pair;
#line 573 "priorityqueue.vala"
			if (self->priv->_lp_head == NULL) {
#line 1458 "priorityqueue.c"
				GeePriorityQueueNodePair* _tmp9_;
				GeePriorityQueueNodePair* _tmp10_;
#line 574 "priorityqueue.vala"
				self->priv->_lp_head = (_tmp9_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_head), _tmp9_);
#line 575 "priorityqueue.vala"
				self->priv->_lp_tail = (_tmp10_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp10_);
#line 1465 "priorityqueue.c"
			} else {
				GeePriorityQueueNodePair* _tmp11_;
				GeePriorityQueueNodePair* _tmp12_;
#line 577 "priorityqueue.vala"
				pair->lp_prev = self->priv->_lp_tail;
#line 578 "priorityqueue.vala"
				self->priv->_lp_tail->lp_next = (_tmp11_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail->lp_next), _tmp11_);
#line 579 "priorityqueue.vala"
				self->priv->_lp_tail = (_tmp12_ = _gee_priority_queue_node_pair_ref0 (pair), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp12_);
#line 1475 "priorityqueue.c"
			}
#line 582 "priorityqueue.vala"
			self->priv->_b[degree] = FALSE;
#line 1479 "priorityqueue.c"
			_gee_priority_queue_node_pair_unref0 (pair);
		} else {
#line 584 "priorityqueue.vala"
			self->priv->_b[degree] = TRUE;
#line 1484 "priorityqueue.c"
		}
	}
#line 587 "priorityqueue.vala"
	self->priv->_a[degree] = (_tmp13_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (self->priv->_a[degree]), _tmp13_);
#line 1489 "priorityqueue.c"
	_gee_priority_queue_node_unref0 (insertion_point);
}


#line 594 "priorityqueue.vala"
static void _gee_priority_queue_remove_type1_node (GeePriorityQueue* self, GeePriorityQueueType1Node* node) {
#line 594 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 594 "priorityqueue.vala"
	g_return_if_fail (node != NULL);
#line 599 "priorityqueue.vala"
	if (((GeePriorityQueueNode*) node)->parent == GEE_PRIORITY_QUEUE_NODE (self->priv->_r_prime)) {
#line 600 "priorityqueue.vala"
		_gee_priority_queue_updated_degree (self, node, FALSE);
#line 1504 "priorityqueue.c"
	} else {
#line 603 "priorityqueue.vala"
		if (node->ll_prev != NULL) {
#line 1508 "priorityqueue.c"
			GeePriorityQueueType1Node* _tmp0_;
#line 604 "priorityqueue.vala"
			node->ll_prev->ll_next = (_tmp0_ = _gee_priority_queue_node_ref0 (node->ll_next), _gee_priority_queue_node_unref0 (node->ll_prev->ll_next), _tmp0_);
#line 1512 "priorityqueue.c"
		} else {
#line 605 "priorityqueue.vala"
			if (self->priv->_ll_head == node) {
#line 1516 "priorityqueue.c"
				GeePriorityQueueType1Node* _tmp1_;
#line 606 "priorityqueue.vala"
				self->priv->_ll_head = (_tmp1_ = _gee_priority_queue_node_ref0 (node->ll_next), _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp1_);
#line 1520 "priorityqueue.c"
			}
		}
#line 608 "priorityqueue.vala"
		if (node->ll_next != NULL) {
#line 609 "priorityqueue.vala"
			node->ll_next->ll_prev = node->ll_prev;
#line 1527 "priorityqueue.c"
		} else {
#line 610 "priorityqueue.vala"
			if (self->priv->_ll_tail == node) {
#line 1531 "priorityqueue.c"
				GeePriorityQueueType1Node* _tmp2_;
#line 611 "priorityqueue.vala"
				self->priv->_ll_tail = (_tmp2_ = _gee_priority_queue_node_ref0 (node->ll_prev), _gee_priority_queue_node_unref0 (self->priv->_ll_tail), _tmp2_);
#line 1535 "priorityqueue.c"
			}
		}
#line 614 "priorityqueue.vala"
		if (((GeePriorityQueueNode*) node)->parent != NULL) {
#line 615 "priorityqueue.vala"
			if (((GeePriorityQueueNode*) node)->parent->parent == GEE_PRIORITY_QUEUE_NODE (self->priv->_r_prime)) {
#line 616 "priorityqueue.vala"
				_gee_priority_queue_updated_degree (self, GEE_PRIORITY_QUEUE_TYPE1_NODE (((GeePriorityQueueNode*) node)->parent), TRUE);
#line 1544 "priorityqueue.c"
			} else {
#line 617 "priorityqueue.vala"
				if (((GeePriorityQueueNode*) node)->parent->parent != NULL) {
#line 1548 "priorityqueue.c"
					GeePriorityQueueType1Node* parent;
#line 618 "priorityqueue.vala"
					parent = _gee_priority_queue_node_ref0 (GEE_PRIORITY_QUEUE_TYPE1_NODE (((GeePriorityQueueNode*) node)->parent));
#line 621 "priorityqueue.vala"
					parent->lost++;
#line 624 "priorityqueue.vala"
					if (parent->lost > 1) {
#line 1556 "priorityqueue.c"
						GeePriorityQueueType1Node* _tmp5_;
#line 625 "priorityqueue.vala"
						if (self->priv->_ll_tail != NULL) {
#line 1560 "priorityqueue.c"
							GeePriorityQueueType1Node* _tmp3_;
#line 626 "priorityqueue.vala"
							parent->ll_prev = self->priv->_ll_tail;
#line 627 "priorityqueue.vala"
							self->priv->_ll_tail->ll_next = (_tmp3_ = _gee_priority_queue_node_ref0 (parent), _gee_priority_queue_node_unref0 (self->priv->_ll_tail->ll_next), _tmp3_);
#line 1566 "priorityqueue.c"
						} else {
							GeePriorityQueueType1Node* _tmp4_;
#line 629 "priorityqueue.vala"
							self->priv->_ll_head = (_tmp4_ = _gee_priority_queue_node_ref0 (parent), _gee_priority_queue_node_unref0 (self->priv->_ll_head), _tmp4_);
#line 1571 "priorityqueue.c"
						}
#line 631 "priorityqueue.vala"
						self->priv->_ll_tail = (_tmp5_ = _gee_priority_queue_node_ref0 (parent), _gee_priority_queue_node_unref0 (self->priv->_ll_tail), _tmp5_);
#line 1575 "priorityqueue.c"
					}
					_gee_priority_queue_node_unref0 (parent);
				}
			}
		}
	}
#line 638 "priorityqueue.vala"
	if (node == self->priv->_p) {
#line 1584 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp6_;
#line 639 "priorityqueue.vala"
		self->priv->_p = (_tmp6_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_p), _tmp6_);
#line 1588 "priorityqueue.c"
	}
#line 643 "priorityqueue.vala"
	gee_priority_queue_type1_node_remove (node);
#line 1592 "priorityqueue.c"
}


#line 646 "priorityqueue.vala"
static void _gee_priority_queue_updated_degree (GeePriorityQueue* self, GeePriorityQueueType1Node* node, gboolean child_removed) {
#line 1598 "priorityqueue.c"
	gint degree;
	gboolean _tmp0_ = FALSE;
#line 646 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 646 "priorityqueue.vala"
	g_return_if_fail (node != NULL);
#line 647 "priorityqueue.vala"
	degree = gee_priority_queue_node_degree ((GeePriorityQueueNode*) node);
#line 650 "priorityqueue.vala"
	if (child_removed) {
#line 650 "priorityqueue.vala"
		_tmp0_ = self->priv->_a[degree - 1] == NULL;
#line 1611 "priorityqueue.c"
	} else {
#line 650 "priorityqueue.vala"
		_tmp0_ = FALSE;
#line 1615 "priorityqueue.c"
	}
#line 650 "priorityqueue.vala"
	if (_tmp0_) {
#line 1619 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp1_;
#line 651 "priorityqueue.vala"
		self->priv->_a[degree - 1] = (_tmp1_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (self->priv->_a[degree - 1]), _tmp1_);
#line 652 "priorityqueue.vala"
		self->priv->_b[degree - 1] = !self->priv->_b[degree - 1];
#line 1625 "priorityqueue.c"
	}
#line 655 "priorityqueue.vala"
	self->priv->_b[degree] = !self->priv->_b[degree];
#line 656 "priorityqueue.vala"
	if (self->priv->_a[degree] == node) {
#line 1631 "priorityqueue.c"
		GeePriorityQueueType1Node* next;
		gboolean _tmp2_ = FALSE;
#line 657 "priorityqueue.vala"
		next = _gee_priority_queue_node_ref0 (node->brothers_next);
#line 658 "priorityqueue.vala"
		if (next != NULL) {
#line 658 "priorityqueue.vala"
			_tmp2_ = gee_priority_queue_node_degree ((GeePriorityQueueNode*) next) == degree;
#line 1640 "priorityqueue.c"
		} else {
#line 658 "priorityqueue.vala"
			_tmp2_ = FALSE;
#line 1644 "priorityqueue.c"
		}
#line 658 "priorityqueue.vala"
		if (_tmp2_) {
#line 1648 "priorityqueue.c"
			GeePriorityQueueType1Node* _tmp3_;
#line 659 "priorityqueue.vala"
			self->priv->_a[degree] = (_tmp3_ = _gee_priority_queue_node_ref0 (next), _gee_priority_queue_node_unref0 (self->priv->_a[degree]), _tmp3_);
#line 1652 "priorityqueue.c"
		} else {
			GeePriorityQueueType1Node* _tmp4_;
			gint i;
			gint _tmp5_;
			gint _tmp6_;
#line 661 "priorityqueue.vala"
			self->priv->_a[degree] = (_tmp4_ = NULL, _gee_priority_queue_node_unref0 (self->priv->_a[degree]), _tmp4_);
#line 663 "priorityqueue.vala"
			i = self->priv->_a_length1 - 1;
#line 664 "priorityqueue.vala"
			while (TRUE) {
#line 664 "priorityqueue.vala"
				if (!(self->priv->_a[i] == NULL)) {
#line 664 "priorityqueue.vala"
					break;
#line 1668 "priorityqueue.c"
				}
#line 665 "priorityqueue.vala"
				i--;
#line 1672 "priorityqueue.c"
			}
#line 667 "priorityqueue.vala"
			_tmp5_ = i + 1;
#line 667 "priorityqueue.vala"
			self->priv->_a = g_renew (GeePriorityQueueType1Node*, self->priv->_a, i + 1);
#line 667 "priorityqueue.vala"
			(_tmp5_ > self->priv->_a_length1) ? memset (self->priv->_a + self->priv->_a_length1, 0, sizeof (GeePriorityQueueType1Node*) * (_tmp5_ - self->priv->_a_length1)) : NULL;
#line 667 "priorityqueue.vala"
			self->priv->_a_length1 = _tmp5_;
#line 668 "priorityqueue.vala"
			_tmp6_ = i + 1;
#line 668 "priorityqueue.vala"
			self->priv->_b = g_renew (gboolean, self->priv->_b, i + 1);
#line 668 "priorityqueue.vala"
			(_tmp6_ > self->priv->_b_length1) ? memset (self->priv->_b + self->priv->_b_length1, 0, sizeof (gboolean) * (_tmp6_ - self->priv->_b_length1)) : NULL;
#line 668 "priorityqueue.vala"
			self->priv->_b_length1 = _tmp6_;
#line 1690 "priorityqueue.c"
		}
		_gee_priority_queue_node_unref0 (next);
	}
#line 673 "priorityqueue.vala"
	if (node->pair != NULL) {
#line 1696 "priorityqueue.c"
		GeePriorityQueueNodePair* pair;
		GeePriorityQueueType1Node* _tmp7_;
		GeePriorityQueueType1Node* other;
#line 674 "priorityqueue.vala"
		pair = _gee_priority_queue_node_pair_ref0 (node->pair);
#line 1702 "priorityqueue.c"
		_tmp7_ = NULL;
#line 675 "priorityqueue.vala"
		if (pair->node1 == node) {
#line 675 "priorityqueue.vala"
			_tmp7_ = pair->node2;
#line 1708 "priorityqueue.c"
		} else {
#line 675 "priorityqueue.vala"
			_tmp7_ = pair->node1;
#line 1712 "priorityqueue.c"
		}
#line 675 "priorityqueue.vala"
		other = _gee_priority_queue_node_ref0 (_tmp7_);
#line 676 "priorityqueue.vala"
		node->pair = NULL;
#line 677 "priorityqueue.vala"
		other->pair = NULL;
#line 678 "priorityqueue.vala"
		if (pair->lp_prev != NULL) {
#line 1722 "priorityqueue.c"
			GeePriorityQueueNodePair* _tmp8_;
#line 679 "priorityqueue.vala"
			pair->lp_prev->lp_next = (_tmp8_ = _gee_priority_queue_node_pair_ref0 (pair->lp_next), _gee_priority_queue_node_pair_unref0 (pair->lp_prev->lp_next), _tmp8_);
#line 1726 "priorityqueue.c"
		} else {
			GeePriorityQueueNodePair* _tmp9_;
#line 681 "priorityqueue.vala"
			self->priv->_lp_head = (_tmp9_ = _gee_priority_queue_node_pair_ref0 (pair->lp_next), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_head), _tmp9_);
#line 1731 "priorityqueue.c"
		}
#line 683 "priorityqueue.vala"
		if (pair->lp_next != NULL) {
#line 684 "priorityqueue.vala"
			pair->lp_next->lp_prev = pair->lp_prev;
#line 1737 "priorityqueue.c"
		} else {
			GeePriorityQueueNodePair* _tmp10_;
#line 686 "priorityqueue.vala"
			self->priv->_lp_tail = (_tmp10_ = _gee_priority_queue_node_pair_ref0 (pair->lp_prev), _gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail), _tmp10_);
#line 1742 "priorityqueue.c"
		}
		_gee_priority_queue_node_pair_unref0 (pair);
		_gee_priority_queue_node_unref0 (other);
	}
}


#line 691 "priorityqueue.vala"
static void _gee_priority_queue_remove_type2_node (GeePriorityQueue* self, GeePriorityQueueType2Node* node) {
#line 1752 "priorityqueue.c"
	GeePriorityQueueType2Node* _tmp1_;
	GeePriorityQueueType2Node* *_tmp0_;
#line 691 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 691 "priorityqueue.vala"
	g_return_if_fail (node != NULL);
#line 692 "priorityqueue.vala"
	_tmp0_ = &GEE_PRIORITY_QUEUE_TYPE1_NODE (((GeePriorityQueueNode*) node)->parent)->type2_child;
#line 692 "priorityqueue.vala"
	(*_tmp0_) = (_tmp1_ = NULL, _gee_priority_queue_node_unref0 ((*_tmp0_)), _tmp1_);
#line 693 "priorityqueue.vala"
	((GeePriorityQueueNode*) node)->parent = NULL;
#line 1765 "priorityqueue.c"
}


GCompareFunc gee_priority_queue_get_compare_func (GeePriorityQueue* self) {
	GCompareFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_compare_func;
#line 47 "priorityqueue.vala"
	return result;
#line 1775 "priorityqueue.c"
}


static void gee_priority_queue_set_compare_func (GeePriorityQueue* self, GCompareFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_compare_func = value;
	g_object_notify ((GObject *) self, "compare-func");
}


static gint gee_priority_queue_real_get_capacity (GeeAbstractQueue* base) {
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 82 "priorityqueue.vala"
	return result;
#line 1793 "priorityqueue.c"
}


static gint gee_priority_queue_real_get_remaining_capacity (GeeAbstractQueue* base) {
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 89 "priorityqueue.vala"
	return result;
#line 1804 "priorityqueue.c"
}


static gboolean gee_priority_queue_real_get_is_full (GeeAbstractQueue* base) {
	gboolean result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = FALSE;
#line 96 "priorityqueue.vala"
	return result;
#line 1815 "priorityqueue.c"
}


static gint gee_priority_queue_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeePriorityQueue* self;
	self = (GeePriorityQueue*) base;
	result = self->priv->_size;
#line 266 "priorityqueue.vala"
	return result;
#line 1826 "priorityqueue.c"
}


#line 763 "priorityqueue.vala"
static GeePriorityQueueNode* gee_priority_queue_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
#line 1832 "priorityqueue.c"
	GeePriorityQueueNode* self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeePriorityQueueNode*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
#line 764 "priorityqueue.vala"
	self->data = (_tmp1_ = (_tmp0_ = data, ((_tmp0_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp0_) : g_dup_func ((gpointer) _tmp0_)), _g_destroy_func0 (self->data), _tmp1_);
#line 1842 "priorityqueue.c"
	return self;
}


#line 767 "priorityqueue.vala"
static inline gint gee_priority_queue_node_degree (GeePriorityQueueNode* self) {
#line 1849 "priorityqueue.c"
	gint result;
#line 767 "priorityqueue.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1853 "priorityqueue.c"
	result = self->type1_children_count;
#line 768 "priorityqueue.vala"
	return result;
#line 1857 "priorityqueue.c"
}


static void gee_priority_queue_value_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_priority_queue_value_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_priority_queue_node_unref (value->data[0].v_pointer);
	}
}


static void gee_priority_queue_value_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_priority_queue_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_priority_queue_value_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_priority_queue_value_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeePriorityQueueNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_priority_queue_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_priority_queue_value_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeePriorityQueueNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_priority_queue_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_priority_queue_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeePriorityQueueParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_PRIORITY_QUEUE_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_priority_queue_value_get_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


static void gee_priority_queue_value_set_node (GValue* value, gpointer v_object) {
	GeePriorityQueueNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_priority_queue_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_unref (old);
	}
}


static void gee_priority_queue_node_class_init (GeePriorityQueueNodeClass * klass) {
	gee_priority_queue_node_parent_class = g_type_class_peek_parent (klass);
	GEE_PRIORITY_QUEUE_NODE_CLASS (klass)->finalize = gee_priority_queue_node_finalize;
	g_type_class_add_private (klass, sizeof (GeePriorityQueueNodePrivate));
}


static void gee_priority_queue_node_instance_init (GeePriorityQueueNode * self) {
	self->priv = GEE_PRIORITY_QUEUE_NODE_GET_PRIVATE (self);
	self->parent = NULL;
	self->type1_children_head = NULL;
	self->type1_children_tail = NULL;
	self->ref_count = 1;
}


static void gee_priority_queue_node_finalize (GeePriorityQueueNode* obj) {
	GeePriorityQueueNode * self;
	self = GEE_PRIORITY_QUEUE_NODE (obj);
	((self->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->data = (self->priv->g_destroy_func (self->data), NULL));
	_gee_priority_queue_node_unref0 (self->type1_children_head);
	_gee_priority_queue_node_unref0 (self->type1_children_tail);
}


static GType gee_priority_queue_node_get_type (void) {
	static GType gee_priority_queue_node_type_id = 0;
	if (gee_priority_queue_node_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { gee_priority_queue_value_node_init, gee_priority_queue_value_node_free_value, gee_priority_queue_value_node_copy_value, gee_priority_queue_value_node_peek_pointer, "p", gee_priority_queue_value_node_collect_value, "p", gee_priority_queue_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueNode), 0, (GInstanceInitFunc) gee_priority_queue_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		gee_priority_queue_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeePriorityQueueNode", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gee_priority_queue_node_type_id;
}


static gpointer gee_priority_queue_node_ref (gpointer instance) {
	GeePriorityQueueNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_priority_queue_node_unref (gpointer instance) {
	GeePriorityQueueNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_PRIORITY_QUEUE_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


#line 800 "priorityqueue.vala"
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
#line 2011 "priorityqueue.c"
	GeePriorityQueueType1Node* self;
#line 801 "priorityqueue.vala"
	self = (GeePriorityQueueType1Node*) gee_priority_queue_node_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, data);
#line 801 "priorityqueue.vala"
	self->priv->g_type = g_type;
#line 801 "priorityqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 801 "priorityqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 2021 "priorityqueue.c"
	return self;
}


#line 800 "priorityqueue.vala"
static GeePriorityQueueType1Node* gee_priority_queue_type1_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
#line 800 "priorityqueue.vala"
	return gee_priority_queue_type1_node_construct (GEE_PRIORITY_QUEUE_TYPE_TYPE1_NODE, g_type, g_dup_func, g_destroy_func, data);
#line 2030 "priorityqueue.c"
}


#line 804 "priorityqueue.vala"
static inline void gee_priority_queue_type1_node_add (GeePriorityQueueType1Node* self, GeePriorityQueueType1Node* node) {
#line 2036 "priorityqueue.c"
	GeePriorityQueueType1Node* _tmp2_;
#line 804 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 804 "priorityqueue.vala"
	g_return_if_fail (node != NULL);
#line 805 "priorityqueue.vala"
	((GeePriorityQueueNode*) node)->parent = (GeePriorityQueueNode*) self;
#line 806 "priorityqueue.vala"
	if (((GeePriorityQueueNode*) self)->type1_children_head == NULL) {
#line 2046 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp0_;
#line 807 "priorityqueue.vala"
		((GeePriorityQueueNode*) self)->type1_children_head = (_tmp0_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_head), _tmp0_);
#line 2050 "priorityqueue.c"
	} else {
#line 809 "priorityqueue.vala"
		node->brothers_prev = ((GeePriorityQueueNode*) self)->type1_children_tail;
#line 2054 "priorityqueue.c"
	}
#line 811 "priorityqueue.vala"
	if (((GeePriorityQueueNode*) self)->type1_children_tail != NULL) {
#line 2058 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp1_;
#line 812 "priorityqueue.vala"
		((GeePriorityQueueNode*) self)->type1_children_tail->brothers_next = (_tmp1_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_tail->brothers_next), _tmp1_);
#line 2062 "priorityqueue.c"
	}
#line 814 "priorityqueue.vala"
	((GeePriorityQueueNode*) self)->type1_children_tail = (_tmp2_ = _gee_priority_queue_node_ref0 (node), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->type1_children_tail), _tmp2_);
#line 815 "priorityqueue.vala"
	((GeePriorityQueueNode*) self)->type1_children_count++;
#line 2068 "priorityqueue.c"
}


#line 818 "priorityqueue.vala"
static inline void gee_priority_queue_type1_node_remove (GeePriorityQueueType1Node* self) {
#line 2074 "priorityqueue.c"
	GeePriorityQueueType1Node* _tmp3_;
#line 818 "priorityqueue.vala"
	g_return_if_fail (self != NULL);
#line 819 "priorityqueue.vala"
	if (self->brothers_prev == NULL) {
#line 2080 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp0_;
#line 820 "priorityqueue.vala"
		((GeePriorityQueueNode*) self)->parent->type1_children_head = (_tmp0_ = _gee_priority_queue_node_ref0 (self->brothers_next), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->parent->type1_children_head), _tmp0_);
#line 2084 "priorityqueue.c"
	} else {
		GeePriorityQueueType1Node* _tmp1_;
#line 822 "priorityqueue.vala"
		self->brothers_prev->brothers_next = (_tmp1_ = _gee_priority_queue_node_ref0 (self->brothers_next), _gee_priority_queue_node_unref0 (self->brothers_prev->brothers_next), _tmp1_);
#line 2089 "priorityqueue.c"
	}
#line 824 "priorityqueue.vala"
	if (self->brothers_next == NULL) {
#line 2093 "priorityqueue.c"
		GeePriorityQueueType1Node* _tmp2_;
#line 825 "priorityqueue.vala"
		((GeePriorityQueueNode*) self)->parent->type1_children_tail = (_tmp2_ = _gee_priority_queue_node_ref0 (self->brothers_prev), _gee_priority_queue_node_unref0 (((GeePriorityQueueNode*) self)->parent->type1_children_tail), _tmp2_);
#line 2097 "priorityqueue.c"
	} else {
#line 827 "priorityqueue.vala"
		self->brothers_next->brothers_prev = self->brothers_prev;
#line 2101 "priorityqueue.c"
	}
#line 829 "priorityqueue.vala"
	((GeePriorityQueueNode*) self)->parent->type1_children_count--;
#line 830 "priorityqueue.vala"
	((GeePriorityQueueNode*) self)->parent = NULL;
#line 831 "priorityqueue.vala"
	self->brothers_prev = NULL;
#line 832 "priorityqueue.vala"
	self->brothers_next = (_tmp3_ = NULL, _gee_priority_queue_node_unref0 (self->brothers_next), _tmp3_);
#line 2111 "priorityqueue.c"
}


static void gee_priority_queue_type1_node_class_init (GeePriorityQueueType1NodeClass * klass) {
	gee_priority_queue_type1_node_parent_class = g_type_class_peek_parent (klass);
	GEE_PRIORITY_QUEUE_NODE_CLASS (klass)->finalize = gee_priority_queue_type1_node_finalize;
	g_type_class_add_private (klass, sizeof (GeePriorityQueueType1NodePrivate));
}


static void gee_priority_queue_type1_node_instance_init (GeePriorityQueueType1Node * self) {
	self->priv = GEE_PRIORITY_QUEUE_TYPE1_NODE_GET_PRIVATE (self);
	self->brothers_prev = NULL;
	self->brothers_next = NULL;
	self->type2_child = NULL;
	self->ll_prev = NULL;
	self->ll_next = NULL;
	self->pair = NULL;
}


static void gee_priority_queue_type1_node_finalize (GeePriorityQueueNode* obj) {
	GeePriorityQueueType1Node * self;
	self = GEE_PRIORITY_QUEUE_TYPE1_NODE (obj);
	_gee_priority_queue_node_unref0 (self->brothers_next);
	_gee_priority_queue_node_unref0 (self->type2_child);
	_gee_priority_queue_node_unref0 (self->ll_next);
	GEE_PRIORITY_QUEUE_NODE_CLASS (gee_priority_queue_type1_node_parent_class)->finalize (obj);
}


static GType gee_priority_queue_type1_node_get_type (void) {
	static GType gee_priority_queue_type1_node_type_id = 0;
	if (gee_priority_queue_type1_node_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueType1NodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_type1_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueType1Node), 0, (GInstanceInitFunc) gee_priority_queue_type1_node_instance_init, NULL };
		gee_priority_queue_type1_node_type_id = g_type_register_static (GEE_PRIORITY_QUEUE_TYPE_NODE, "GeePriorityQueueType1Node", &g_define_type_info, 0);
	}
	return gee_priority_queue_type1_node_type_id;
}


#line 872 "priorityqueue.vala"
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
#line 2155 "priorityqueue.c"
	GeePriorityQueueType2Node* self;
#line 873 "priorityqueue.vala"
	self = (GeePriorityQueueType2Node*) gee_priority_queue_node_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, data);
#line 873 "priorityqueue.vala"
	self->priv->g_type = g_type;
#line 873 "priorityqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 873 "priorityqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 2165 "priorityqueue.c"
	return self;
}


#line 872 "priorityqueue.vala"
static GeePriorityQueueType2Node* gee_priority_queue_type2_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
#line 872 "priorityqueue.vala"
	return gee_priority_queue_type2_node_construct (GEE_PRIORITY_QUEUE_TYPE_TYPE2_NODE, g_type, g_dup_func, g_destroy_func, data);
#line 2174 "priorityqueue.c"
}


static void gee_priority_queue_type2_node_class_init (GeePriorityQueueType2NodeClass * klass) {
	gee_priority_queue_type2_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeePriorityQueueType2NodePrivate));
}


static void gee_priority_queue_type2_node_instance_init (GeePriorityQueueType2Node * self) {
	self->priv = GEE_PRIORITY_QUEUE_TYPE2_NODE_GET_PRIVATE (self);
}


static GType gee_priority_queue_type2_node_get_type (void) {
	static GType gee_priority_queue_type2_node_type_id = 0;
	if (gee_priority_queue_type2_node_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueType2NodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_type2_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueType2Node), 0, (GInstanceInitFunc) gee_priority_queue_type2_node_instance_init, NULL };
		gee_priority_queue_type2_node_type_id = g_type_register_static (GEE_PRIORITY_QUEUE_TYPE_NODE, "GeePriorityQueueType2Node", &g_define_type_info, 0);
	}
	return gee_priority_queue_type2_node_type_id;
}


#line 900 "priorityqueue.vala"
static GeePriorityQueueNodePair* gee_priority_queue_node_pair_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2) {
#line 2201 "priorityqueue.c"
	GeePriorityQueueNodePair* self;
	GeePriorityQueueType1Node* _tmp0_;
	GeePriorityQueueType1Node* _tmp1_;
#line 900 "priorityqueue.vala"
	g_return_val_if_fail (node1 != NULL, NULL);
#line 900 "priorityqueue.vala"
	g_return_val_if_fail (node2 != NULL, NULL);
#line 2209 "priorityqueue.c"
	self = (GeePriorityQueueNodePair*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
#line 901 "priorityqueue.vala"
	self->node1 = (_tmp0_ = _gee_priority_queue_node_ref0 (node1), _gee_priority_queue_node_unref0 (self->node1), _tmp0_);
#line 902 "priorityqueue.vala"
	self->node2 = (_tmp1_ = _gee_priority_queue_node_ref0 (node2), _gee_priority_queue_node_unref0 (self->node2), _tmp1_);
#line 2218 "priorityqueue.c"
	return self;
}


#line 900 "priorityqueue.vala"
static GeePriorityQueueNodePair* gee_priority_queue_node_pair_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueueType1Node* node1, GeePriorityQueueType1Node* node2) {
#line 900 "priorityqueue.vala"
	return gee_priority_queue_node_pair_construct (GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR, g_type, g_dup_func, g_destroy_func, node1, node2);
#line 2227 "priorityqueue.c"
}


static void gee_priority_queue_value_node_pair_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_priority_queue_value_node_pair_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_priority_queue_node_pair_unref (value->data[0].v_pointer);
	}
}


static void gee_priority_queue_value_node_pair_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_priority_queue_node_pair_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_priority_queue_value_node_pair_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_priority_queue_value_node_pair_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeePriorityQueueNodePair* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_priority_queue_node_pair_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_priority_queue_value_node_pair_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeePriorityQueueNodePair** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_priority_queue_node_pair_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_priority_queue_param_spec_node_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeePriorityQueueParamSpecNodePair* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_priority_queue_value_get_node_pair (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR), NULL);
	return value->data[0].v_pointer;
}


static void gee_priority_queue_value_set_node_pair (GValue* value, gpointer v_object) {
	GeePriorityQueueNodePair* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_PRIORITY_QUEUE_TYPE_NODE_PAIR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_priority_queue_node_pair_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_priority_queue_node_pair_unref (old);
	}
}


static void gee_priority_queue_node_pair_class_init (GeePriorityQueueNodePairClass * klass) {
	gee_priority_queue_node_pair_parent_class = g_type_class_peek_parent (klass);
	GEE_PRIORITY_QUEUE_NODE_PAIR_CLASS (klass)->finalize = gee_priority_queue_node_pair_finalize;
	g_type_class_add_private (klass, sizeof (GeePriorityQueueNodePairPrivate));
}


static void gee_priority_queue_node_pair_instance_init (GeePriorityQueueNodePair * self) {
	self->priv = GEE_PRIORITY_QUEUE_NODE_PAIR_GET_PRIVATE (self);
	self->lp_prev = NULL;
	self->lp_next = NULL;
	self->node1 = NULL;
	self->node2 = NULL;
	self->ref_count = 1;
}


static void gee_priority_queue_node_pair_finalize (GeePriorityQueueNodePair* obj) {
	GeePriorityQueueNodePair * self;
	self = GEE_PRIORITY_QUEUE_NODE_PAIR (obj);
	_gee_priority_queue_node_pair_unref0 (self->lp_next);
	_gee_priority_queue_node_unref0 (self->node1);
	_gee_priority_queue_node_unref0 (self->node2);
}


static GType gee_priority_queue_node_pair_get_type (void) {
	static GType gee_priority_queue_node_pair_type_id = 0;
	if (gee_priority_queue_node_pair_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { gee_priority_queue_value_node_pair_init, gee_priority_queue_value_node_pair_free_value, gee_priority_queue_value_node_pair_copy_value, gee_priority_queue_value_node_pair_peek_pointer, "p", gee_priority_queue_value_node_pair_collect_value, "p", gee_priority_queue_value_node_pair_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueNodePairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_node_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueNodePair), 0, (GInstanceInitFunc) gee_priority_queue_node_pair_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		gee_priority_queue_node_pair_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeePriorityQueueNodePair", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return gee_priority_queue_node_pair_type_id;
}


static gpointer gee_priority_queue_node_pair_ref (gpointer instance) {
	GeePriorityQueueNodePair* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_priority_queue_node_pair_unref (gpointer instance) {
	GeePriorityQueueNodePair* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_PRIORITY_QUEUE_NODE_PAIR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 916 "priorityqueue.vala"
static GeePriorityQueueIterator* gee_priority_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue) {
#line 2387 "priorityqueue.c"
	GeePriorityQueueIterator * self;
	GeePriorityQueue* _tmp0_;
#line 916 "priorityqueue.vala"
	g_return_val_if_fail (queue != NULL, NULL);
#line 916 "priorityqueue.vala"
	self = (GeePriorityQueueIterator*) g_object_new (object_type, NULL);
#line 916 "priorityqueue.vala"
	self->priv->g_type = g_type;
#line 916 "priorityqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 916 "priorityqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 917 "priorityqueue.vala"
	self->priv->queue = (_tmp0_ = _g_object_ref0 (queue), _g_object_unref0 (self->priv->queue), _tmp0_);
#line 918 "priorityqueue.vala"
	self->priv->position = (GeePriorityQueueNode*) queue->priv->_r;
#line 919 "priorityqueue.vala"
	self->priv->stamp = queue->priv->_stamp;
#line 2406 "priorityqueue.c"
	return self;
}


#line 916 "priorityqueue.vala"
static GeePriorityQueueIterator* gee_priority_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeePriorityQueue* queue) {
#line 916 "priorityqueue.vala"
	return gee_priority_queue_iterator_construct (GEE_PRIORITY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, queue);
#line 2415 "priorityqueue.c"
}


#line 922 "priorityqueue.vala"
static gboolean gee_priority_queue_iterator_real_next (GeeIterator* base) {
#line 2421 "priorityqueue.c"
	GeePriorityQueueIterator * self;
	gboolean result;
	self = (GeePriorityQueueIterator*) base;
#line 923 "priorityqueue.vala"
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
#line 924 "priorityqueue.vala"
	if (!gee_iterator_has_next ((GeeIterator*) self)) {
#line 2429 "priorityqueue.c"
		result = FALSE;
#line 925 "priorityqueue.vala"
		return result;
#line 2433 "priorityqueue.c"
	}
#line 927 "priorityqueue.vala"
	self->priv->removed = FALSE;
#line 928 "priorityqueue.vala"
	self->priv->position = self->priv->_next;
#line 929 "priorityqueue.vala"
	self->priv->_next = NULL;
#line 2441 "priorityqueue.c"
	result = self->priv->position != NULL;
#line 930 "priorityqueue.vala"
	return result;
#line 2445 "priorityqueue.c"
}


#line 933 "priorityqueue.vala"
static gboolean gee_priority_queue_iterator_real_has_next (GeeIterator* base) {
#line 2451 "priorityqueue.c"
	GeePriorityQueueIterator * self;
	gboolean result;
	self = (GeePriorityQueueIterator*) base;
#line 934 "priorityqueue.vala"
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
#line 935 "priorityqueue.vala"
	if (self->priv->_next == NULL) {
#line 936 "priorityqueue.vala"
		self->priv->_next = self->priv->position;
#line 937 "priorityqueue.vala"
		if (!_gee_priority_queue_iterator_has_next (self)) {
#line 938 "priorityqueue.vala"
			self->priv->_next = NULL;
#line 2465 "priorityqueue.c"
		}
	}
	result = self->priv->_next != NULL;
#line 941 "priorityqueue.vala"
	return result;
#line 2471 "priorityqueue.c"
}


#line 944 "priorityqueue.vala"
static gboolean _gee_priority_queue_iterator_has_next (GeePriorityQueueIterator* self) {
#line 2477 "priorityqueue.c"
	gboolean result;
	gboolean _tmp5_ = FALSE;
#line 944 "priorityqueue.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 945 "priorityqueue.vala"
	if (!self->priv->started) {
#line 946 "priorityqueue.vala"
		self->priv->started = TRUE;
#line 2486 "priorityqueue.c"
		result = self->priv->_next != NULL;
#line 947 "priorityqueue.vala"
		return result;
#line 2490 "priorityqueue.c"
	} else {
#line 948 "priorityqueue.vala"
		if (GEE_PRIORITY_QUEUE_IS_TYPE1_NODE (self->priv->_next)) {
#line 2494 "priorityqueue.c"
			GeePriorityQueueNode* _tmp0_;
			GeePriorityQueueType1Node* node;
			gboolean _tmp1_ = FALSE;
#line 949 "priorityqueue.vala"
			node = _gee_priority_queue_node_ref0 ((_tmp0_ = self->priv->_next, GEE_PRIORITY_QUEUE_IS_TYPE1_NODE (_tmp0_) ? ((GeePriorityQueueType1Node*) _tmp0_) : NULL));
#line 950 "priorityqueue.vala"
			if (!self->priv->from_type1_children) {
#line 950 "priorityqueue.vala"
				_tmp1_ = ((GeePriorityQueueNode*) node)->type1_children_head != NULL;
#line 2504 "priorityqueue.c"
			} else {
#line 950 "priorityqueue.vala"
				_tmp1_ = FALSE;
#line 2508 "priorityqueue.c"
			}
#line 950 "priorityqueue.vala"
			if (_tmp1_) {
#line 951 "priorityqueue.vala"
				self->priv->_next = (GeePriorityQueueNode*) ((GeePriorityQueueNode*) node)->type1_children_head;
#line 952 "priorityqueue.vala"
				self->priv->from_type1_children = FALSE;
#line 953 "priorityqueue.vala"
				self->priv->from_type2_child = FALSE;
#line 2518 "priorityqueue.c"
				result = TRUE;
				_gee_priority_queue_node_unref0 (node);
#line 954 "priorityqueue.vala"
				return result;
#line 2523 "priorityqueue.c"
			} else {
				gboolean _tmp2_ = FALSE;
#line 955 "priorityqueue.vala"
				if (!self->priv->from_type2_child) {
#line 955 "priorityqueue.vala"
					_tmp2_ = node->type2_child != NULL;
#line 2530 "priorityqueue.c"
				} else {
#line 955 "priorityqueue.vala"
					_tmp2_ = FALSE;
#line 2534 "priorityqueue.c"
				}
#line 955 "priorityqueue.vala"
				if (_tmp2_) {
#line 956 "priorityqueue.vala"
					self->priv->_next = (GeePriorityQueueNode*) node->type2_child;
#line 957 "priorityqueue.vala"
					self->priv->from_type1_children = FALSE;
#line 958 "priorityqueue.vala"
					self->priv->from_type2_child = FALSE;
#line 2544 "priorityqueue.c"
					result = TRUE;
					_gee_priority_queue_node_unref0 (node);
#line 959 "priorityqueue.vala"
					return result;
#line 2549 "priorityqueue.c"
				} else {
#line 960 "priorityqueue.vala"
					if (node->brothers_next != NULL) {
#line 961 "priorityqueue.vala"
						self->priv->_next = (GeePriorityQueueNode*) node->brothers_next;
#line 962 "priorityqueue.vala"
						self->priv->from_type1_children = FALSE;
#line 963 "priorityqueue.vala"
						self->priv->from_type2_child = FALSE;
#line 2559 "priorityqueue.c"
						result = TRUE;
						_gee_priority_queue_node_unref0 (node);
#line 964 "priorityqueue.vala"
						return result;
#line 2564 "priorityqueue.c"
					}
				}
			}
#line 966 "priorityqueue.vala"
			self->priv->from_type1_children = TRUE;
#line 2570 "priorityqueue.c"
			_gee_priority_queue_node_unref0 (node);
		} else {
#line 967 "priorityqueue.vala"
			if (GEE_PRIORITY_QUEUE_IS_TYPE2_NODE (self->priv->_next)) {
#line 2575 "priorityqueue.c"
				GeePriorityQueueNode* _tmp3_;
				GeePriorityQueueType2Node* node;
				gboolean _tmp4_ = FALSE;
#line 968 "priorityqueue.vala"
				node = _gee_priority_queue_node_ref0 ((_tmp3_ = self->priv->_next, GEE_PRIORITY_QUEUE_IS_TYPE2_NODE (_tmp3_) ? ((GeePriorityQueueType2Node*) _tmp3_) : NULL));
#line 969 "priorityqueue.vala"
				if (!self->priv->from_type1_children) {
#line 969 "priorityqueue.vala"
					_tmp4_ = ((GeePriorityQueueNode*) node)->type1_children_head != NULL;
#line 2585 "priorityqueue.c"
				} else {
#line 969 "priorityqueue.vala"
					_tmp4_ = FALSE;
#line 2589 "priorityqueue.c"
				}
#line 969 "priorityqueue.vala"
				if (_tmp4_) {
#line 970 "priorityqueue.vala"
					self->priv->_next = (GeePriorityQueueNode*) ((GeePriorityQueueNode*) node)->type1_children_head;
#line 971 "priorityqueue.vala"
					self->priv->from_type1_children = FALSE;
#line 972 "priorityqueue.vala"
					self->priv->from_type2_child = FALSE;
#line 2599 "priorityqueue.c"
					result = TRUE;
					_gee_priority_queue_node_unref0 (node);
#line 973 "priorityqueue.vala"
					return result;
#line 2604 "priorityqueue.c"
				}
#line 975 "priorityqueue.vala"
				self->priv->from_type2_child = TRUE;
#line 2608 "priorityqueue.c"
				_gee_priority_queue_node_unref0 (node);
			}
		}
	}
#line 977 "priorityqueue.vala"
	if (self->priv->_next != NULL) {
#line 977 "priorityqueue.vala"
		_tmp5_ = self->priv->_next != GEE_PRIORITY_QUEUE_NODE (self->priv->queue->priv->_r);
#line 2617 "priorityqueue.c"
	} else {
#line 977 "priorityqueue.vala"
		_tmp5_ = FALSE;
#line 2621 "priorityqueue.c"
	}
#line 977 "priorityqueue.vala"
	if (_tmp5_) {
#line 978 "priorityqueue.vala"
		self->priv->_next = self->priv->_next->parent;
#line 2627 "priorityqueue.c"
		result = _gee_priority_queue_iterator_has_next (self);
#line 979 "priorityqueue.vala"
		return result;
#line 2631 "priorityqueue.c"
	}
	result = FALSE;
#line 981 "priorityqueue.vala"
	return result;
#line 2636 "priorityqueue.c"
}


#line 984 "priorityqueue.vala"
static gboolean gee_priority_queue_iterator_real_first (GeeIterator* base) {
#line 2642 "priorityqueue.c"
	GeePriorityQueueIterator * self;
	gboolean result;
	self = (GeePriorityQueueIterator*) base;
#line 985 "priorityqueue.vala"
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
#line 986 "priorityqueue.vala"
	self->priv->position = (GeePriorityQueueNode*) self->priv->queue->priv->_r;
#line 987 "priorityqueue.vala"
	self->priv->started = FALSE;
#line 988 "priorityqueue.vala"
	self->priv->from_type1_children = FALSE;
#line 989 "priorityqueue.vala"
	self->priv->from_type2_child = FALSE;
#line 2656 "priorityqueue.c"
	result = gee_iterator_next ((GeeIterator*) self);
#line 990 "priorityqueue.vala"
	return result;
#line 2660 "priorityqueue.c"
}


#line 993 "priorityqueue.vala"
static gpointer gee_priority_queue_iterator_real_get (GeeIterator* base) {
#line 2666 "priorityqueue.c"
	GeePriorityQueueIterator * self;
	gpointer result;
	gconstpointer _tmp0_;
	self = (GeePriorityQueueIterator*) base;
#line 994 "priorityqueue.vala"
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
#line 995 "priorityqueue.vala"
	g_assert (self->priv->position != NULL);
#line 996 "priorityqueue.vala"
	g_assert (!self->priv->removed);
#line 2677 "priorityqueue.c"
	result = (_tmp0_ = self->priv->position->data, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 997 "priorityqueue.vala"
	return result;
#line 2681 "priorityqueue.c"
}


#line 1000 "priorityqueue.vala"
static void gee_priority_queue_iterator_real_remove (GeeIterator* base) {
#line 2687 "priorityqueue.c"
	GeePriorityQueueIterator * self;
	GeePriorityQueueNode* node;
	self = (GeePriorityQueueIterator*) base;
#line 1001 "priorityqueue.vala"
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
#line 1002 "priorityqueue.vala"
	g_assert (self->priv->position != NULL);
#line 1003 "priorityqueue.vala"
	g_assert (!self->priv->removed);
#line 1004 "priorityqueue.vala"
	gee_iterator_has_next ((GeeIterator*) self);
#line 1005 "priorityqueue.vala"
	node = _gee_priority_queue_node_ref0 (self->priv->position);
#line 1006 "priorityqueue.vala"
	self->priv->position = NULL;
#line 1007 "priorityqueue.vala"
	_gee_priority_queue_delete (self->priv->queue, node);
#line 1008 "priorityqueue.vala"
	self->priv->stamp = self->priv->queue->priv->_stamp;
#line 1009 "priorityqueue.vala"
	self->priv->removed = TRUE;
#line 2709 "priorityqueue.c"
	_gee_priority_queue_node_unref0 (node);
}


#line 1012 "priorityqueue.vala"
static GeePriorityQueueNode* gee_priority_queue_iterator_get_node (GeePriorityQueueIterator* self) {
#line 2716 "priorityqueue.c"
	GeePriorityQueueNode* result;
#line 1012 "priorityqueue.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1013 "priorityqueue.vala"
	g_assert (self->priv->stamp == self->priv->queue->priv->_stamp);
#line 1014 "priorityqueue.vala"
	g_assert (self->priv->position != NULL);
#line 2724 "priorityqueue.c"
	result = _gee_priority_queue_node_ref0 (self->priv->position);
#line 1015 "priorityqueue.vala"
	return result;
#line 2728 "priorityqueue.c"
}


static void gee_priority_queue_iterator_class_init (GeePriorityQueueIteratorClass * klass) {
	gee_priority_queue_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeePriorityQueueIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_priority_queue_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_priority_queue_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_priority_queue_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_priority_queue_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_priority_queue_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_priority_queue_iterator_real_next;
	iface->has_next = gee_priority_queue_iterator_real_has_next;
	iface->first = gee_priority_queue_iterator_real_first;
	iface->get = gee_priority_queue_iterator_real_get;
	iface->remove = gee_priority_queue_iterator_real_remove;
}


static void gee_priority_queue_iterator_instance_init (GeePriorityQueueIterator * self) {
	self->priv = GEE_PRIORITY_QUEUE_ITERATOR_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->from_type1_children = FALSE;
	self->priv->from_type2_child = FALSE;
	self->priv->removed = FALSE;
}


static void gee_priority_queue_iterator_finalize (GObject* obj) {
	GeePriorityQueueIterator * self;
	self = GEE_PRIORITY_QUEUE_ITERATOR (obj);
	_g_object_unref0 (self->priv->queue);
	G_OBJECT_CLASS (gee_priority_queue_iterator_parent_class)->finalize (obj);
}


static GType gee_priority_queue_iterator_get_type (void) {
	static GType gee_priority_queue_iterator_type_id = 0;
	if (gee_priority_queue_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueueIterator), 0, (GInstanceInitFunc) gee_priority_queue_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_priority_queue_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_priority_queue_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeePriorityQueueIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_priority_queue_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_priority_queue_iterator_type_id;
}


static void gee_priority_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeePriorityQueueIterator * self;
	self = GEE_PRIORITY_QUEUE_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_priority_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeePriorityQueueIterator * self;
	self = GEE_PRIORITY_QUEUE_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_PRIORITY_QUEUE_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_priority_queue_class_init (GeePriorityQueueClass * klass) {
	gee_priority_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeePriorityQueuePrivate));
	GEE_ABSTRACT_QUEUE_CLASS (klass)->offer = gee_priority_queue_real_offer;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->peek = gee_priority_queue_real_peek;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->poll = gee_priority_queue_real_poll;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->drain = gee_priority_queue_real_drain;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_priority_queue_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_priority_queue_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_priority_queue_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_priority_queue_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_priority_queue_real_iterator;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = gee_priority_queue_real_get_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = gee_priority_queue_real_get_remaining_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = gee_priority_queue_real_get_is_full;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_priority_queue_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_priority_queue_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_priority_queue_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_priority_queue_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_COMPARE_FUNC, g_param_spec_pointer ("compare-func", "compare-func", "compare-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_CAPACITY, "capacity");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_REMAINING_CAPACITY, "remaining-capacity");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_IS_FULL, "is-full");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_PRIORITY_QUEUE_SIZE, "size");
}


static void gee_priority_queue_instance_init (GeePriorityQueue * self) {
	self->priv = GEE_PRIORITY_QUEUE_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_r = NULL;
	self->priv->_r_prime = NULL;
	self->priv->_lm_head = NULL;
	self->priv->_lm_tail = NULL;
	self->priv->_p = NULL;
	self->priv->_a = g_new0 (GeePriorityQueueType1Node*, 0 + 1);
	self->priv->_a_length1 = 0;
	self->priv->_lp_head = NULL;
	self->priv->_lp_tail = NULL;
	self->priv->_b = g_new0 (gboolean, 0);
	self->priv->_b_length1 = 0;
	self->priv->_ll_head = NULL;
	self->priv->_ll_tail = NULL;
}


static void gee_priority_queue_finalize (GObject* obj) {
	GeePriorityQueue * self;
	self = GEE_PRIORITY_QUEUE (obj);
	_gee_priority_queue_node_unref0 (self->priv->_r);
	_gee_priority_queue_node_unref0 (self->priv->_r_prime);
	_gee_priority_queue_node_unref0 (self->priv->_lm_head);
	_gee_priority_queue_node_unref0 (self->priv->_lm_tail);
	_gee_priority_queue_node_unref0 (self->priv->_p);
	self->priv->_a = (_vala_array_free (self->priv->_a, self->priv->_a_length1, (GDestroyNotify) gee_priority_queue_node_unref), NULL);
	_gee_priority_queue_node_pair_unref0 (self->priv->_lp_head);
	_gee_priority_queue_node_pair_unref0 (self->priv->_lp_tail);
	self->priv->_b = (g_free (self->priv->_b), NULL);
	_gee_priority_queue_node_unref0 (self->priv->_ll_head);
	_gee_priority_queue_node_unref0 (self->priv->_ll_tail);
	G_OBJECT_CLASS (gee_priority_queue_parent_class)->finalize (obj);
}


GType gee_priority_queue_get_type (void) {
	static GType gee_priority_queue_type_id = 0;
	if (gee_priority_queue_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeePriorityQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_priority_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeePriorityQueue), 0, (GInstanceInitFunc) gee_priority_queue_instance_init, NULL };
		gee_priority_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "GeePriorityQueue", &g_define_type_info, 0);
	}
	return gee_priority_queue_type_id;
}


static void gee_priority_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeePriorityQueue * self;
	self = GEE_PRIORITY_QUEUE (object);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_COMPARE_FUNC:
		g_value_set_pointer (value, gee_priority_queue_get_compare_func (self));
		break;
		case GEE_PRIORITY_QUEUE_CAPACITY:
		g_value_set_int (value, gee_abstract_queue_get_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_REMAINING_CAPACITY:
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_IS_FULL:
		g_value_set_boolean (value, gee_abstract_queue_get_is_full ((GeeAbstractQueue*) self));
		break;
		case GEE_PRIORITY_QUEUE_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_priority_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeePriorityQueue * self;
	self = GEE_PRIORITY_QUEUE (object);
	switch (property_id) {
		case GEE_PRIORITY_QUEUE_COMPARE_FUNC:
		gee_priority_queue_set_compare_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_PRIORITY_QUEUE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_PRIORITY_QUEUE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_PRIORITY_QUEUE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




