/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-symbol-manager
 * @title: IAnjutaSymbolManager
 * @short_description: Source code symbols manager inteface
 * @see_also: #IAnjutaSymbol
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-symbol-manager.h
 * 
 */

#include "ianjuta-symbol-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-manager-quark");
	}
	
	return quark;
}

/**
* ianjuta_symbol_manager_get_parents:
* @obj: Self
* @symbol: Symbol which you want to know the parent classes of.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.
* 
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* 
* Returns: if the passed symbol is a class then this function tries to catch its parents.
*
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_class_parents (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_class_parents (obj, symbol, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_class_parents_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_members:
* @obj: Self
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.
* 
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
*	 
* Returns: an iteratable object, or NULL if error occurs or if no symbols are found.	
* 
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_members (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_members (obj, symbol, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_members_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_parent_scope: 
* @obj: Self
* @symbol: Symbol which you want to know the parent scope of.
* @filename: Can be NULL. Full path filename where to search for the parent scope symbol.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* Find the parent scope given a symbol
* 
* Returns: The returned #IAnjutaIterable object should contain just one element if the 
* query is successful, no element or NULL is returned if function went wrong.	
* The returned #IAnjutaIterable object must be unreffed after use.
*/	
IAnjutaIterable*
ianjuta_symbol_manager_get_parent_scope (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   const gchar *filename,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_parent_scope (obj, symbol, filename, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_parent_scope_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   const gchar *filename,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_scope: 
* @obj: Self
* @filename: full path of the file.
* @line line of @filename in which symbol exist.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.	 
* It gets the scope specified by the line of the file. 
*
* Returns: The returned iterator should contain just one element if the query is successful, 
* no element or NULL is returned if function went wrong.
*
*/
IAnjutaIterable*
ianjuta_symbol_manager_get_scope (IAnjutaSymbolManager *obj, const gchar* filename,   gulong line,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_scope (obj, filename, line, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_scope_default (IAnjutaSymbolManager *obj, const gchar* filename,   gulong line,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_symbol_by_id:
* @obj: Self
* @symbol_id unique id of the symbol you want to know about.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @return NULL on error.
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* A symbol is identified by an unique id. If you have its id you can also 
* have its object IAnjutaSymbol.	 
*
* Returns: The returned #IAnjutaIterable object should contain just one element if the 
* query is successful, no element or NULL is returned if function went wrong.	
* The returned #IAnjutaIterable object must be unreffed after use.	 
*/
IAnjutaSymbol*
ianjuta_symbol_manager_get_symbol_by_id (IAnjutaSymbolManager *obj, gint symbol_id,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_symbol_by_id (obj, symbol_id, info_fields, err);
}

/* Default implementation */
static IAnjutaSymbol*
ianjuta_symbol_manager_get_symbol_by_id_default (IAnjutaSymbolManager *obj, gint symbol_id,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_get_symbol_more_info:
* @obj: Self
* @symbol symbol of which you want to know more infos about.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @err: Error propagation and reporting.	
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* While at first sight this function may seem as useless, in a deeper inspection
* you can see that you can achieve speed improvements for example avoiding 
* to pass many info_fields requests to a search query, which itself could require
* complicated joins between the db tables, slowing down the thing.
* It's up to you to see which method is more performant.
*
* Returns: The returned #IAnjutaIterable object should contain just one element if the 
* query is successful, no element or NULL is returned if function went wrong.	
* The returned #IAnjutaIterable object must be unreffed after use.
*
*/	
IAnjutaIterable*
ianjuta_symbol_manager_get_symbol_more_info (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->get_symbol_more_info (obj, symbol, info_fields, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_get_symbol_more_info_default (IAnjutaSymbolManager *obj, const IAnjutaSymbol *symbol,   IAnjutaSymbolField info_fields, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_search:
* @obj: Self
* @match_types: If passed #IANJUTA_SYMBOL_TYPE_UNDEF the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @match_name: Name of the symbol you want to search for. If you just want to get all the
*              symbols then you need to use "%" as pattern. NULL _is not_ accepted.
* @partial_name_match: if TRUE it will search for %match_name%, it FALSE for the exact
* 					string match_name.
* @filescope_search: if #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC it will search only for public/extern functions. 
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE it will search also for static/private functions.
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE it'll search for both public and private
* @global_tags_search: If TRUE it'll search only for system tags, using pkg-config to retrieve installed packages
* info. If FALSE only current project's symbols will be searched.
* @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
* @err: Error propagation and reporting.	 
* @deprecated This function is deprecated and should not be used in new code. 
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* 
* Returns: an iteratable object, or NULL if error occurs or if no symbols are found.
* 
*/
IAnjutaIterable*
ianjuta_symbol_manager_search (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *match_name,   gboolean partial_name_match,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gboolean global_tags_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search (obj, match_types, include_types, info_fields, match_name, partial_name_match, filescope_search, global_tags_search, results_limit, results_offset, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_search_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *match_name,   gboolean partial_name_match,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gboolean global_tags_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_search_file:
* @obj: Self
* @match_types: If passed #IANJUTA_SYMBOL_TYPE_UNDEF the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @pattern Pattern you want to search for. It can me something like 'foo_func' (exact match)
*          or something like 'foo_fun%' (LIKE match, matching all the symbol prefixed with 
*          'foo_fun'). NULL _is not_ accepted
* @file GFile of the file, belonging to the project, which you want to scan symbols for.
* @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
* @err: Error propagation and reporting.	 
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* The search is case sensitive. Symbols are searched only in the specified file.
* There won't be distinction in symbols with file_scope = 1 or 0
* 
* Returns: an iteratable object, or NULL if error occurs or if no symbols are found.
* 
*/		
IAnjutaIterable*
ianjuta_symbol_manager_search_file (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   const GFile *file,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search_file (obj, match_types, include_types, info_fields, pattern, file, results_limit, results_offset, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_search_file_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   const GFile *file,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_search_file_async:
* @obj: Self
* @match_types: If passed #IANJUTA_SYMBOL_TYPE_UNDEF the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @pattern Pattern you want to search for. It can me something like 'foo_func' (exact match)
*          or something like 'foo_fun%' (LIKE match, matching all the symbol prefixed with 
*          'foo_fun'). NULL _is not_ accepted
* @file GFile of the file, belonging to the project, which you want to scan symbols for.
* @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
* @cancel: An optional #GCancellable object to cancel the operation, or NULL.
* @notify: #AnjutaAsyncNotify object for finish notification and error reporting.
* @callback: #SearchCallback callback to call when query result data from database is available
* @callback_user_data: User data passed to callback	 
* @err: Error propagation and reporting.	 
*
* Async database query. The returned #IAnjutaIterable object must be unreffed after use.
* The search is case sensitive. Symbols are searched only in the specified file.
* There won't be distinction in symbols with file_scope = 1 or 0
* 
* Returns: guint handle to identify the query result. It would infact be possible to have
* more async queries at the same time. This is for identify them. Returns 0 on error.
* 
    */
guint
ianjuta_symbol_manager_search_file_async (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   const GFile *file,   gint results_limit,   gint results_offset,   GCancellable* cancel,   AnjutaAsyncNotify *notify,   IAnjutaSymbolManagerSearchCallback callback,   gpointer callback_user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), 0);
	g_return_val_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify), 0);
	g_return_val_if_fail (callback_user_data != NULL, 0);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search_file_async (obj, match_types, include_types, info_fields, pattern, file, results_limit, results_offset, cancel, notify, callback, callback_user_data, err);
}

/* Default implementation */
static guint
ianjuta_symbol_manager_search_file_async_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   const GFile *file,   gint results_limit,   gint results_offset,   GCancellable* cancel,   AnjutaAsyncNotify *notify,   IAnjutaSymbolManagerSearchCallback callback,   gpointer callback_user_data, GError **err)
{
	g_return_val_if_reached (0);
}

/**
* ianjuta_symbol_manager_search_project:
* @obj: Self
* @match_types: If passed #IANJUTA_SYMBOL_TYPE_UNDEF the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @pattern Pattern you want to search for. It can me something like 'foo_func' (exact match)
*          or something like 'foo_fun%' (LIKE match, matching all the symbol prefixed with 
*          'foo_fun'). NULL _is not_ accepted
* @filescope_search: if #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC it will search only for public/extern functions. 
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE it will search also for static/private functions.
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE it'll search for both public and private
* @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
* @err: Error propagation and reporting.	 
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* The search is case sensitive. Symbols are searched in current opened project.
* 
* Returns: an iteratable object, or NULL if error occurs or if no symbols are found.
* 
*/	
IAnjutaIterable*
ianjuta_symbol_manager_search_project (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search_project (obj, match_types, include_types, info_fields, pattern, filescope_search, results_limit, results_offset, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_search_project_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_search_project_async:
* @obj: Self
* @match_types: If passed #IANJUTA_SYMBOL_TYPE_UNDEF the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @pattern Pattern you want to search for. It can me something like 'foo_func' (exact match)
*          or something like 'foo_fun%' (LIKE match, matching all the symbol prefixed with 
*          'foo_fun'). NULL _is not_ accepted	
* @filescope_search: if #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC it will search only for public/extern functions. 
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE it will search also for static/private functions.
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE it'll search for both public and private
    * @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
* @cancel: An optional #GCancellable object to cancel the operation, or NULL.
* @notify: #AnjutaAsyncNotify object for finish notification and error reporting.
* @callback: #SearchCallback callback to call when query result data from database is available
* @callback_user_data: User data passed to callback	 
* @err: Error propagation and reporting.	 
*
* Async database query. The returned #IAnjutaIterable object must be unreffed after use.
* The search is case sensitive. Symbols are searched only in the opened project's context.
* 
* Returns: guint handle to identify the query result. It would infact be possible to have
* more async queries at the same time. This is for identify them. Returns 0 on error.
* 
    */	
guint
ianjuta_symbol_manager_search_project_async (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset,   GCancellable* cancel,   AnjutaAsyncNotify *notify,   IAnjutaSymbolManagerSearchCallback callback,   gpointer callback_user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), 0);
	g_return_val_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify), 0);
	g_return_val_if_fail (callback_user_data != NULL, 0);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search_project_async (obj, match_types, include_types, info_fields, pattern, filescope_search, results_limit, results_offset, cancel, notify, callback, callback_user_data, err);
}

/* Default implementation */
static guint
ianjuta_symbol_manager_search_project_async_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset,   GCancellable* cancel,   AnjutaAsyncNotify *notify,   IAnjutaSymbolManagerSearchCallback callback,   gpointer callback_user_data, GError **err)
{
	g_return_val_if_reached (0);
}

/**
* ianjuta_symbol_manager_search_system:
* @obj: Self
* @match_types: If passed #IANJUTA_SYMBOL_TYPE_UNDEF the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @pattern Pattern you want to search for. It can me something like 'foo_func' (exact match)
*          or something like 'foo_fun%' (LIKE match, matching all the symbol prefixed with 
*          'foo_fun'). NULL _is not_ accepted
* @filescope_search: if #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC it will search only for public/extern functions. 
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE it will search also for static/private functions.
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE it'll search for both public and private
* @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
* @err: Error propagation and reporting.	 
*
* Database query. The returned #IAnjutaIterable object must be unreffed after use.
* The search is case sensitive. Symbols are searched in global (system) packages.
* User must have installed the -dev packages of, for istance, gtk+, glib, etc.
* 
* Returns: an iteratable object, or NULL if error occurs or if no symbols are found.
* 
*/	
IAnjutaIterable*
ianjuta_symbol_manager_search_system (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search_system (obj, match_types, include_types, info_fields, pattern, filescope_search, results_limit, results_offset, err);
}

/* Default implementation */
static IAnjutaIterable*
ianjuta_symbol_manager_search_system_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_symbol_manager_search_project_async:
* @obj: Self
* @match_types: If passed #IANJUTA_SYMBOL_TYPE_UNDEF the function will not perfom any filter.
* @include_types: Should the result contain or exclude the match_types? TRUE to include them,
*				  FALSE to exclude. For example use may want all symbols but classes.
* @info_fields: Kind of infos you would like to have available on the resulting Symbols.
* @pattern Pattern you want to search for. It can me something like 'foo_func' (exact match)
*          or something like 'foo_fun%' (LIKE match, matching all the symbol prefixed with 
*          'foo_fun'). NULL _is not_ accepted
* @filescope_search: if #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC it will search only for public/extern functions. 
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE it will search also for static/private functions.
* 						If #IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE it'll search for both public and private
* @results_limit: Limit results to an upper bound. -1 If you don't want to use this par.
* @results_offset: Skip results_offset results. -1 If you don't want to use this par.	 
* @cancel: An optional #GCancellable object to cancel the operation, or NULL.
* @notify: #AnjutaAsyncNotify object for finish notification and error reporting.
* @callback: #SearchCallback callback to call when query result data from database is available
* @callback_user_data: User data passed to callback	 
* @err: Error propagation and reporting.	 
*
* Async database query. The returned #IAnjutaIterable object must be unreffed after use.
* The search is case sensitive. Symbols are searched in the global packages (system) context.
* 
* Returns: guint handle to identify the query result. It would infact be possible to have
* more async queries at the same time. This is for identify them. Returns 0 on error.
* 
    */
guint
ianjuta_symbol_manager_search_system_async (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset,   GCancellable* cancel,   AnjutaAsyncNotify *notify,   IAnjutaSymbolManagerSearchCallback callback,   gpointer callback_user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), 0);
	g_return_val_if_fail ((notify == NULL) ||ANJUTA_IS_ASYNC_NOTIFY(notify), 0);
	g_return_val_if_fail (callback_user_data != NULL, 0);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->search_system_async (obj, match_types, include_types, info_fields, pattern, filescope_search, results_limit, results_offset, cancel, notify, callback, callback_user_data, err);
}

/* Default implementation */
static guint
ianjuta_symbol_manager_search_system_async_default (IAnjutaSymbolManager *obj, IAnjutaSymbolType match_types,   gboolean include_types,   IAnjutaSymbolField info_fields,   const gchar *pattern,   IAnjutaSymbolManagerSearchFileScope filescope_search,   gint results_limit,   gint results_offset,   GCancellable* cancel,   AnjutaAsyncNotify *notify,   IAnjutaSymbolManagerSearchCallback callback,   gpointer callback_user_data, GError **err)
{
	g_return_val_if_reached (0);
}

static void
ianjuta_symbol_manager_base_init (IAnjutaSymbolManagerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_class_parents = ianjuta_symbol_manager_get_class_parents_default;
	klass->get_members = ianjuta_symbol_manager_get_members_default;
	klass->get_parent_scope = ianjuta_symbol_manager_get_parent_scope_default;
	klass->get_scope = ianjuta_symbol_manager_get_scope_default;
	klass->get_symbol_by_id = ianjuta_symbol_manager_get_symbol_by_id_default;
	klass->get_symbol_more_info = ianjuta_symbol_manager_get_symbol_more_info_default;
	klass->search = ianjuta_symbol_manager_search_default;
	klass->search_file = ianjuta_symbol_manager_search_file_default;
	klass->search_file_async = ianjuta_symbol_manager_search_file_async_default;
	klass->search_project = ianjuta_symbol_manager_search_project_default;
	klass->search_project_async = ianjuta_symbol_manager_search_project_async_default;
	klass->search_system = ianjuta_symbol_manager_search_system_default;
	klass->search_system_async = ianjuta_symbol_manager_search_system_async_default;
	
	if (!initialized) {

		/**
		 * IAnjutaSymbolManager::prj_scan_end:
		 * @obj: Self
		 * 
		 * This signal is emitted when a scanning of one or more files on project db
		 * ends. 
		 */
		g_signal_new ("prj-scan-end",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, prj_scan_end),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::prj_symbol_inserted:
		 * @obj: Self
		 *
		 * This signal is emitted when a new symbol is added to project db.
		 * The chain of symbols emitted is inserted, scan-end, removed.
		 */
		g_signal_new ("prj-symbol-inserted",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, prj_symbol_inserted),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::prj_symbol_removed:
		 * @obj: Self
		 *
		 * This signal is emitted when a new symbol is removed from project db.
		 * The chain of symbols emitted is inserted, scan-end, removed.
		 */
		g_signal_new ("prj-symbol-removed",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, prj_symbol_removed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::prj_symbol_updated:
		 * @obj: Self
		 *
		 * This signal is emitted when a new symbol is updated on project db.
		 * For 'update' we mean updating on all the fields which are not its primary key.
		 * Be sure to consider the following cases (comment from the core): 
		 *
		 * #1. The symbol remains the same [at least on unique index key]. We will 
		 *     perform only a simple update.
		 * #2. The symbol has changed: at least on name/type/file. We will insert a 
		 *     new symbol on table 'symbol'. Deletion of old one will take place 
		 *     at a second stage, when a delete of all symbols with 
		 *     'tmp_flag = 0' will be done.
		 * #3. The symbol has been deleted. As above it will be deleted at 
		 *     a second stage because of the 'tmp_flag = 0'. Triggers will remove 
		 *     also scope_ids and other things.
		 */
		g_signal_new ("prj-symbol-updated",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, prj_symbol_updated),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::sys_scan_end:
		 * @obj: Self
		 * 
		 * This signal is emitted when a scanning of one or more packages on system db
		 * ends. This signal doesn't mean that all the scan process for the packages
		 * is ended, but that just one (or more) is (are).
		 */
		g_signal_new ("sys-scan-end",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, sys_scan_end),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::sys_symbol_inserted:
		 * @obj: Self
		 *
		 * This signal is emitted when a new symbol is added to system db.
		 * The chain of symbols emitted is inserted, scan-end, removed.
		 */	
		g_signal_new ("sys-symbol-inserted",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, sys_symbol_inserted),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::sys_symbol_removed:
		 * @obj: Self
		 *
		 * This signal is emitted when a new symbol is removed from system db.
		 * The chain of symbols emitted is inserted, scan-end, removed.
		 */	
		g_signal_new ("sys-symbol-removed",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, sys_symbol_removed),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::sys_symbol_updated:
		 * @obj: Self
		 *
		 * This signal is emitted when a new symbol is updated on system db.
		 * For 'update' we mean updating on all the fields which are not its primary key.
		 * Be sure to consider the following cases (comment from the core): 
		 *
		 * #1. The symbol remains the same [at least on unique index key]. We will 
		 *     perform only a simple update.
		 * #2. The symbol has changed: at least on name/type/file. We will insert a 
		 *     new symbol on table 'symbol'. Deletion of old one will take place 
		 *     at a second stage, when a delete of all symbols with 
		 *     'tmp_flag = 0' will be done.
		 * #3. The symbol has been deleted. As above it will be deleted at 
		 *     a second stage because of the 'tmp_flag = 0'. Triggers will remove 
		 *     also scope_ids and other things.
		 */	
		g_signal_new ("sys-symbol-updated",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, sys_symbol_updated),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		initialized = TRUE;
	}
}

GType
ianjuta_symbol_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolManagerIface),
			(GBaseInitFunc) ianjuta_symbol_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbolManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_symbol_manager_search_filescope_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE, "IANJUTA_SYMBOL_MANAGER_SEARCH_FS_IGNORE", "search-fs-ignore" }, 
		{ IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC, "IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PUBLIC", "search-fs-public" }, 
		{ IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE, "IANJUTA_SYMBOL_MANAGER_SEARCH_FS_PRIVATE", "search-fs-private" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolManagerSearchFileScope", values);
	}

	return type;
}
