/* rygel-transcode-manager.c generated by valac 0.11.6, the Vala compiler
 * generated from rygel-transcode-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;

#define RYGEL_TYPE_MP3_LAYER (rygel_mp3_layer_get_type ())

#define RYGEL_TYPE_MP3_TRANSCODER (rygel_mp3_transcoder_get_type ())
#define RYGEL_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3Transcoder))
#define RYGEL_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))
#define RYGEL_IS_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_IS_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_MP3_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))

typedef struct _RygelMP3Transcoder RygelMP3Transcoder;
typedef struct _RygelMP3TranscoderClass RygelMP3TranscoderClass;

#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelTranscodeManagerPrivate {
	GeeArrayList* transcoders;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;

typedef enum  {
	RYGEL_MP3_LAYER_TWO = 1,
	RYGEL_MP3_LAYER_THREE = 2
} RygelMP3Layer;

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD = 0,
	RYGEL_MP2_TS_PROFILE_HD
} RygelMP2TSProfile;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()

static gpointer rygel_transcode_manager_parent_class = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerPrivate))
enum  {
	RYGEL_TRANSCODE_MANAGER_DUMMY_PROPERTY
};
static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_transcoding (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_lpcm_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_mp3_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_mp2ts_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_wmv_transcoder (RygelConfiguration* self, GError** error);
GType endianness_get_type (void) G_GNUC_CONST;
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp3_layer_get_type (void) G_GNUC_CONST;
RygelMP3Transcoder* rygel_mp3_transcoder_new (RygelMP3Layer layer);
RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type, RygelMP3Layer layer);
GType rygel_mp3_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST;
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
GQuark rygel_http_request_error_quark (void);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self);
static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b);
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);
static void rygel_transcode_manager_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b) {
	gboolean result = FALSE;
	void* _tmp0_;
	GUPnPProtocolInfo* _tmp1_;
	GUPnPProtocolInfo* protocol_a;
	void* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	GUPnPProtocolInfo* protocol_b;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	_tmp1_ = _g_object_ref0 ((_tmp0_ = a, GUPNP_IS_PROTOCOL_INFO (_tmp0_) ? ((GUPnPProtocolInfo*) _tmp0_) : NULL));
	protocol_a = _tmp1_;
	_tmp3_ = _g_object_ref0 ((_tmp2_ = b, GUPNP_IS_PROTOCOL_INFO (_tmp2_) ? ((GUPnPProtocolInfo*) _tmp2_) : NULL));
	protocol_b = _tmp3_;
	_tmp5_ = gupnp_protocol_info_get_dlna_profile (protocol_a);
	_tmp6_ = gupnp_protocol_info_get_dlna_profile (protocol_b);
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = gupnp_protocol_info_get_mime_type (protocol_a);
		_tmp8_ = gupnp_protocol_info_get_mime_type (protocol_b);
		_tmp4_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	_g_object_unref0 (protocol_b);
	_g_object_unref0 (protocol_a);
	return result;
}


RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type) {
	RygelTranscodeManager * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_;
	RygelMetaConfig* _tmp2_ = NULL;
	RygelMetaConfig* config;
	gboolean transcoding;
	gboolean lpcm_transcoder;
	gboolean mp3_transcoder;
	gboolean mp2ts_transcoder;
	gboolean wmv_transcoder;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	self = (RygelTranscodeManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TRANSCODER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->transcoders);
	self->priv->transcoders = _tmp1_;
	_tmp2_ = rygel_meta_config_get_default ();
	config = _tmp2_;
	transcoding = TRUE;
	lpcm_transcoder = TRUE;
	mp3_transcoder = TRUE;
	mp2ts_transcoder = TRUE;
	wmv_transcoder = TRUE;
	_tmp3_ = rygel_configuration_get_transcoding ((RygelConfiguration*) config, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch26_g_error;
	}
	transcoding = _tmp4_;
	if (transcoding) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp5_ = rygel_configuration_get_lpcm_transcoder ((RygelConfiguration*) config, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		lpcm_transcoder = _tmp6_;
		_tmp7_ = rygel_configuration_get_mp3_transcoder ((RygelConfiguration*) config, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		mp3_transcoder = _tmp8_;
		_tmp9_ = rygel_configuration_get_mp2ts_transcoder ((RygelConfiguration*) config, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		mp2ts_transcoder = _tmp10_;
		_tmp11_ = rygel_configuration_get_wmv_transcoder ((RygelConfiguration*) config, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		wmv_transcoder = _tmp12_;
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (transcoding) {
		if (lpcm_transcoder) {
			RygelL16Transcoder* _tmp13_ = NULL;
			RygelL16Transcoder* _tmp14_;
			_tmp13_ = rygel_l16_transcoder_new (ENDIANNESS_BIG);
			_tmp14_ = _tmp13_;
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->transcoders, (RygelTranscoder*) _tmp14_);
			_g_object_unref0 (_tmp14_);
		}
		if (mp3_transcoder) {
			RygelMP3Transcoder* _tmp15_ = NULL;
			RygelMP3Transcoder* _tmp16_;
			_tmp15_ = rygel_mp3_transcoder_new (RYGEL_MP3_LAYER_THREE);
			_tmp16_ = _tmp15_;
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->transcoders, (RygelTranscoder*) _tmp16_);
			_g_object_unref0 (_tmp16_);
		}
		if (mp2ts_transcoder) {
			RygelMP2TSTranscoder* _tmp17_ = NULL;
			RygelMP2TSTranscoder* _tmp18_;
			RygelMP2TSTranscoder* _tmp19_ = NULL;
			RygelMP2TSTranscoder* _tmp20_;
			_tmp17_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD);
			_tmp18_ = _tmp17_;
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->transcoders, (RygelTranscoder*) _tmp18_);
			_g_object_unref0 (_tmp18_);
			_tmp19_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_HD);
			_tmp20_ = _tmp19_;
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->transcoders, (RygelTranscoder*) _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
		if (wmv_transcoder) {
			RygelWMVTranscoder* _tmp21_ = NULL;
			RygelWMVTranscoder* _tmp22_;
			_tmp21_ = rygel_wmv_transcoder_new ();
			_tmp22_ = _tmp21_;
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->transcoders, (RygelTranscoder*) _tmp22_);
			_g_object_unref0 (_tmp22_);
		}
	}
	_g_object_unref0 (config);
	return self;
}


static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_create_uri_for_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->create_uri_for_item (self, item, thumbnail_index, subtitle_index, transcode_target);
}


static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = rygel_media_item_compare_transcoders (self, a, b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	GList* list;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_item != NULL);
	g_return_if_fail (item != NULL);
	list = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _transcoder_list;
		gint _tmp1_;
		gint _transcoder_size;
		gint _transcoder_index;
		_tmp0_ = _g_object_ref0 (self->priv->transcoders);
		_transcoder_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _transcoder_list);
		_transcoder_size = _tmp1_;
		_transcoder_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelTranscoder* transcoder;
			guint _tmp3_;
			_transcoder_index = _transcoder_index + 1;
			if (!(_transcoder_index < _transcoder_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _transcoder_list, _transcoder_index);
			transcoder = (RygelTranscoder*) _tmp2_;
			_tmp3_ = rygel_transcoder_get_distance (transcoder, item);
			if (_tmp3_ != G_MAXUINT) {
				RygelTranscoder* _tmp4_;
				_tmp4_ = _g_object_ref0 (transcoder);
				list = g_list_append (list, _tmp4_);
			}
			_g_object_unref0 (transcoder);
		}
		_g_object_unref0 (_transcoder_list);
	}
	list = g_list_sort_with_data (list, _rygel_media_item_compare_transcoders_gcompare_data_func, item);
	{
		GList* transcoder_collection;
		GList* transcoder_it;
		transcoder_collection = list;
		for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
			RygelTranscoder* _tmp5_;
			RygelTranscoder* transcoder;
			_tmp5_ = _g_object_ref0 ((RygelTranscoder*) transcoder_it->data);
			transcoder = _tmp5_;
			{
				GUPnPDIDLLiteResource* _tmp6_ = NULL;
				GUPnPDIDLLiteResource* _tmp7_;
				_tmp6_ = rygel_transcoder_add_resource (transcoder, didl_item, item, self, &_inner_error_);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp7_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (transcoder);
					__g_list_free__g_object_unref0_0 (list);
					return;
				}
				_g_object_unref0 (transcoder);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (list);
}


RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	RygelTranscoder* transcoder;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	transcoder = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _iter_list;
		gint _tmp1_;
		gint _iter_size;
		gint _iter_index;
		_tmp0_ = _g_object_ref0 (self->priv->transcoders);
		_iter_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _iter_list);
		_iter_size = _tmp1_;
		_iter_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelTranscoder* iter;
			gboolean _tmp3_;
			_iter_index = _iter_index + 1;
			if (!(_iter_index < _iter_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _iter_list, _iter_index);
			iter = (RygelTranscoder*) _tmp2_;
			_tmp3_ = rygel_transcoder_can_handle (iter, target);
			if (_tmp3_) {
				RygelTranscoder* _tmp4_;
				RygelTranscoder* _tmp5_;
				_tmp4_ = _g_object_ref0 (iter);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (transcoder);
				transcoder = _tmp5_;
			}
			_g_object_unref0 (iter);
		}
		_g_object_unref0 (_iter_list);
	}
	if (transcoder == NULL) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("No transcoder available for target format '%s'");
		_tmp7_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp6_, target);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (transcoder);
		return NULL;
	}
	result = transcoder;
	return result;
}


static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_get_protocol'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self) {
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol (self);
}


static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = rygel_transcode_manager_protocol_equal_func (a, b);
	return result;
}


static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* protocol_infos;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GUPNP_TYPE_PROTOCOL_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, _rygel_transcode_manager_protocol_equal_func_gequal_func);
	protocol_infos = _tmp0_;
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _transcoder_list;
		gint _tmp2_;
		gint _transcoder_size;
		gint _transcoder_index;
		_tmp1_ = _g_object_ref0 (self->priv->transcoders);
		_transcoder_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _transcoder_list);
		_transcoder_size = _tmp2_;
		_transcoder_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			RygelTranscoder* transcoder;
			GUPnPProtocolInfo* _tmp4_ = NULL;
			GUPnPProtocolInfo* protocol_info;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_transcoder_index = _transcoder_index + 1;
			if (!(_transcoder_index < _transcoder_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _transcoder_list, _transcoder_index);
			transcoder = (RygelTranscoder*) _tmp3_;
			_tmp4_ = gupnp_protocol_info_new ();
			protocol_info = _tmp4_;
			_tmp5_ = rygel_transcode_manager_get_protocol (self);
			_tmp6_ = _tmp5_;
			gupnp_protocol_info_set_protocol (protocol_info, _tmp6_);
			_g_free0 (_tmp6_);
			_tmp7_ = rygel_transcoder_get_mime_type (transcoder);
			gupnp_protocol_info_set_mime_type (protocol_info, _tmp7_);
			_tmp8_ = rygel_transcoder_get_dlna_profile (transcoder);
			gupnp_protocol_info_set_dlna_profile (protocol_info, _tmp8_);
			gee_abstract_collection_add ((GeeAbstractCollection*) protocol_infos, protocol_info);
			_g_object_unref0 (protocol_info);
			_g_object_unref0 (transcoder);
		}
		_g_object_unref0 (_transcoder_list);
	}
	result = protocol_infos;
	return result;
}


GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self) {
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol_info (self);
}


static void rygel_transcode_manager_class_init (RygelTranscodeManagerClass * klass) {
	rygel_transcode_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTranscodeManagerPrivate));
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_transcode_manager_real_create_uri_for_item;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_transcode_manager_real_get_protocol;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_transcode_manager_real_get_protocol_info;
	G_OBJECT_CLASS (klass)->finalize = rygel_transcode_manager_finalize;
}


static void rygel_transcode_manager_instance_init (RygelTranscodeManager * self) {
	self->priv = RYGEL_TRANSCODE_MANAGER_GET_PRIVATE (self);
}


static void rygel_transcode_manager_finalize (GObject* obj) {
	RygelTranscodeManager * self;
	self = RYGEL_TRANSCODE_MANAGER (obj);
	_g_object_unref0 (self->priv->transcoders);
	G_OBJECT_CLASS (rygel_transcode_manager_parent_class)->finalize (obj);
}


/**
 * Responsible for management of all transcoders:
 *    - gets the appropriate transcoder given a transcoding target.
 *    - provide all possible transcoding resources for items.
 */
GType rygel_transcode_manager_get_type (void) {
	static volatile gsize rygel_transcode_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcode_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscodeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcode_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscodeManager), 0, (GInstanceInitFunc) rygel_transcode_manager_instance_init, NULL };
		GType rygel_transcode_manager_type_id;
		rygel_transcode_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscodeManager", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcode_manager_type_id__volatile, rygel_transcode_manager_type_id);
	}
	return rygel_transcode_manager_type_id__volatile;
}



