/* rygel-tracker-category-all-container.c generated by valac 0.11.6, the Vala compiler
 * generated from rygel-tracker-category-all-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER (rygel_tracker_category_all_container_get_type ())
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer))
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerClass))
#define RYGEL_TRACKER_IS_CATEGORY_ALL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER))
#define RYGEL_TRACKER_IS_CATEGORY_ALL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER))
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerClass))

typedef struct _RygelTrackerCategoryAllContainer RygelTrackerCategoryAllContainer;
typedef struct _RygelTrackerCategoryAllContainerClass RygelTrackerCategoryAllContainerClass;
typedef struct _RygelTrackerCategoryAllContainerPrivate RygelTrackerCategoryAllContainerPrivate;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY (rygel_tracker_resources_iface_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER (rygel_tracker_category_container_get_type ())
#define RYGEL_TRACKER_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER, RygelTrackerCategoryContainer))
#define RYGEL_TRACKER_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER, RygelTrackerCategoryContainerClass))
#define RYGEL_TRACKER_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER))
#define RYGEL_TRACKER_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER))
#define RYGEL_TRACKER_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_CATEGORY_CONTAINER, RygelTrackerCategoryContainerClass))

typedef struct _RygelTrackerCategoryContainer RygelTrackerCategoryContainer;
typedef struct _RygelTrackerCategoryContainerClass RygelTrackerCategoryContainerClass;
typedef struct _RygelTrackerCategoryContainerPrivate RygelTrackerCategoryContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_EVENT (event_get_type ())
typedef struct _Event Event;
typedef struct _RygelTrackerCategoryAllContainerAddItemData RygelTrackerCategoryAllContainerAddItemData;
typedef struct _RygelTrackerCategoryAllContainerRemoveItemData RygelTrackerCategoryAllContainerRemoveItemData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerCategoryAllContainerSearchData RygelTrackerCategoryAllContainerSearchData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_INSERTION_QUERY (rygel_tracker_insertion_query_get_type ())
#define RYGEL_TRACKER_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery))
#define RYGEL_TRACKER_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))
#define RYGEL_TRACKER_IS_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_IS_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_INSERTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))

typedef struct _RygelTrackerInsertionQuery RygelTrackerInsertionQuery;
typedef struct _RygelTrackerInsertionQueryClass RygelTrackerInsertionQueryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerInsertionQueryPrivate RygelTrackerInsertionQueryPrivate;
typedef struct _RygelTrackerCategoryAllContainerCreateEntryInStoreData RygelTrackerCategoryAllContainerCreateEntryInStoreData;

#define RYGEL_TRACKER_TYPE_DELETION_QUERY (rygel_tracker_deletion_query_get_type ())
#define RYGEL_TRACKER_DELETION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_DELETION_QUERY, RygelTrackerDeletionQuery))
#define RYGEL_TRACKER_DELETION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_DELETION_QUERY, RygelTrackerDeletionQueryClass))
#define RYGEL_TRACKER_IS_DELETION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_DELETION_QUERY))
#define RYGEL_TRACKER_IS_DELETION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_DELETION_QUERY))
#define RYGEL_TRACKER_DELETION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_DELETION_QUERY, RygelTrackerDeletionQueryClass))

typedef struct _RygelTrackerDeletionQuery RygelTrackerDeletionQuery;
typedef struct _RygelTrackerDeletionQueryClass RygelTrackerDeletionQueryClass;
typedef struct _RygelTrackerCategoryAllContainerRemoveEntryFromStoreData RygelTrackerCategoryAllContainerRemoveEntryFromStoreData;

struct _RygelTrackerSearchContainer {
	RygelMediaContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelTrackerCategoryAllContainer {
	RygelTrackerSearchContainer parent_instance;
	RygelTrackerCategoryAllContainerPrivate * priv;
};

struct _RygelTrackerCategoryAllContainerClass {
	RygelTrackerSearchContainerClass parent_class;
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerCategoryAllContainerPrivate {
	GeeArrayList* _create_classes;
	RygelTrackerResourcesIface* resources;
};

struct _RygelTrackerCategoryContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerCategoryContainerPrivate * priv;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerCategoryContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
};

struct _Event {
	gint graph_id;
	gint subject_id;
	gint pred_id;
	gint object_id;
};

struct _RygelTrackerCategoryAllContainerAddItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaItem* item;
	GCancellable* cancellable;
	gchar* _tmp0_;
	gchar* urn;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	GCancellable* cancellable;
	gchar* parent_id;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* urn;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerCategoryAllContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerInsertionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerInsertionQueryPrivate * priv;
	gchar* id;
};

struct _RygelTrackerInsertionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerCategoryAllContainerCreateEntryInStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaItem* item;
	gchar* result;
	gchar* _tmp0_;
	gchar* category;
	RygelTrackerInsertionQuery* _tmp1_;
	RygelTrackerInsertionQuery* query;
	gchar* _tmp2_;
	GError * _inner_error_;
};

struct _RygelTrackerCategoryAllContainerRemoveEntryFromStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	RygelTrackerDeletionQuery* _tmp0_;
	RygelTrackerDeletionQuery* query;
	GError * _inner_error_;
};


static gpointer rygel_tracker_category_all_container_parent_class = NULL;
static RygelWritableContainerIface* rygel_tracker_category_all_container_rygel_writable_container_parent_iface = NULL;
static RygelSearchableContainerIface* rygel_tracker_category_all_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_category_all_container_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_resources_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainerPrivate))
enum  {
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_DUMMY_PROPERTY,
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES
};
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_MINER_SERVICE "org.freedesktop.Tracker1.Miner.Files"
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_MINER_PATH "/org/freedesktop/Tracker1/Miner/Files"
GType rygel_tracker_category_container_get_type (void) G_GNUC_CONST;
RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_new (RygelTrackerCategoryContainer* parent);
RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_construct (GType object_type, RygelTrackerCategoryContainer* parent);
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
GType event_get_type (void) G_GNUC_CONST;
Event* event_dup (const Event* self);
void event_free (Event* self);
static void rygel_tracker_category_all_container_on_graph_updated (RygelTrackerCategoryAllContainer* self, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1);
static void _rygel_tracker_category_all_container_on_graph_updated_rygel_tracker_resources_iface_graph_updated (RygelTrackerResourcesIface* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer self);
static void rygel_tracker_category_all_container_real_add_item_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_add_item (RygelWritableContainer* base, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_add_item_co (RygelTrackerCategoryAllContainerAddItemData* data);
static void rygel_tracker_category_all_container_create_entry_in_store (RygelTrackerCategoryAllContainer* self, RygelMediaItem* item, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_tracker_category_all_container_create_entry_in_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_category_all_container_add_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn);
static void rygel_tracker_category_all_container_real_remove_item_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_remove_item (RygelWritableContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_remove_item_co (RygelTrackerCategoryAllContainerRemoveItemData* data);
gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id);
static void rygel_tracker_category_all_container_remove_entry_from_store (RygelTrackerCategoryAllContainer* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_category_all_container_remove_entry_from_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_category_all_container_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_category_all_container_real_search_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_search_co (RygelTrackerCategoryAllContainerSearchData* data);
static void rygel_tracker_category_all_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
static void rygel_tracker_category_all_container_create_entry_in_store_data_free (gpointer _data);
static gboolean rygel_tracker_category_all_container_create_entry_in_store_co (RygelTrackerCategoryAllContainerCreateEntryInStoreData* data);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const gchar* category);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const gchar* category);
GType rygel_tracker_insertion_query_get_type (void) G_GNUC_CONST;
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_category_all_container_create_entry_in_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_category_all_container_remove_entry_from_store_data_free (gpointer _data);
static gboolean rygel_tracker_category_all_container_remove_entry_from_store_co (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* data);
RygelTrackerDeletionQuery* rygel_tracker_deletion_query_new (const gchar* id);
RygelTrackerDeletionQuery* rygel_tracker_deletion_query_construct (GType object_type, const gchar* id);
GType rygel_tracker_deletion_query_get_type (void) G_GNUC_CONST;
static void rygel_tracker_category_all_container_remove_entry_from_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_category_all_container_finalize (GObject* obj);
static void _vala_rygel_tracker_category_all_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_tracker_category_all_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_tracker_category_all_container_on_graph_updated_rygel_tracker_resources_iface_graph_updated (RygelTrackerResourcesIface* _sender, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1, gpointer self) {
	rygel_tracker_category_all_container_on_graph_updated (self, class_name, deletes, deletes_length1, inserts, inserts_length1);
}


RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_construct (GType object_type, RygelTrackerCategoryContainer* parent) {
	RygelTrackerCategoryAllContainer * self = NULL;
	gchar* _tmp0_;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_ = NULL;
	RygelTrackerResourcesIface* _tmp4_ = NULL;
	RygelTrackerResourcesIface* _tmp5_;
	RygelTrackerResourcesIface* _tmp6_;
	gchar* _tmp8_ = NULL;
	gchar* uri;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = g_strconcat ("All", ((RygelMediaObject*) parent)->id, NULL);
	self = (RygelTrackerCategoryAllContainer*) rygel_tracker_search_container_construct (object_type, _tmp0_, (RygelMediaContainer*) parent, "All", parent->item_factory, NULL, NULL);
	_g_free0 (_tmp0_);
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_tmp2_ = _tmp1_;
	rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = rygel_writable_container_get_create_classes ((RygelWritableContainer*) self);
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, ((RygelTrackerSearchContainer*) self)->item_factory->upnp_class);
	_tmp4_ = g_initable_new (RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_RESOURCES_PATH, "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
	_tmp5_ = (RygelTrackerResourcesIface*) _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch6_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->priv->resources);
	self->priv->resources = _tmp6_;
	goto __finally6;
	__catch6_g_io_error:
	{
		GError * io_error;
		const gchar* _tmp7_ = NULL;
		io_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Failed to create D-Bus proxies: %s");
		g_critical (_tmp7_, io_error->message);
		_g_error_free0 (io_error);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = g_filename_to_uri (((RygelTrackerSearchContainer*) self)->item_factory->upload_dir, NULL, &_inner_error_);
	uri = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_CONVERT_ERROR) {
			goto __catch7_g_convert_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris, uri);
	_g_free0 (uri);
	goto __finally7;
	__catch7_g_convert_error:
	{
		GError * _error_;
		const gchar* _tmp9_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = _ ("Failed to construct URI for folder '%s': %s");
		g_warning (_tmp9_, ((RygelTrackerSearchContainer*) self)->item_factory->upload_dir, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_signal_connect_object (self->priv->resources, "graph-updated", (GCallback) _rygel_tracker_category_all_container_on_graph_updated_rygel_tracker_resources_iface_graph_updated, self, 0);
	return self;
}


RygelTrackerCategoryAllContainer* rygel_tracker_category_all_container_new (RygelTrackerCategoryContainer* parent) {
	return rygel_tracker_category_all_container_construct (RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, parent);
}


static void rygel_tracker_category_all_container_real_add_item_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerAddItemData* data;
	data = _data;
	_g_object_unref0 (data->item);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (RygelTrackerCategoryAllContainerAddItemData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_category_all_container_real_add_item (RygelWritableContainer* base, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerAddItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_category_all_container_real_add_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_add_item_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->item = _g_object_ref0 (item);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_category_all_container_real_add_item_co (_data_);
}


static void rygel_tracker_category_all_container_real_add_item_finish (RygelWritableContainer* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_category_all_container_add_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerAddItemData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_category_all_container_real_add_item_co (data);
}


static gboolean rygel_tracker_category_all_container_real_add_item_co (RygelTrackerCategoryAllContainerAddItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	rygel_tracker_category_all_container_create_entry_in_store (data->self, data->item, rygel_tracker_category_all_container_add_item_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_tracker_category_all_container_create_entry_in_store_finish (data->self, data->_res_, &data->_inner_error_);
	data->urn = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_tracker_search_container_create_child_id_for_urn ((RygelTrackerSearchContainer*) data->self, data->urn);
	data->_tmp2_ = data->_tmp1_;
	_g_free0 (((RygelMediaObject*) data->item)->id);
	((RygelMediaObject*) data->item)->id = data->_tmp2_;
	((RygelMediaObject*) data->item)->parent = (RygelMediaContainer*) data->self;
	_g_free0 (data->urn);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_real_remove_item_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerRemoveItemData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveItemData, data);
}


static void rygel_tracker_category_all_container_real_remove_item (RygelWritableContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_category_all_container_real_remove_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_remove_item_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_category_all_container_real_remove_item_co (_data_);
}


static void rygel_tracker_category_all_container_real_remove_item_finish (RygelWritableContainer* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_category_all_container_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerRemoveItemData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_category_all_container_real_remove_item_co (data);
}


static gboolean rygel_tracker_category_all_container_real_remove_item_co (RygelTrackerCategoryAllContainerRemoveItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_tracker_search_container_get_item_info ((RygelTrackerSearchContainer*) data->self, data->id, &data->_tmp0_);
	_g_free0 (data->parent_id);
	data->parent_id = data->_tmp0_;
	data->urn = data->_tmp1_;
	data->_state_ = 1;
	rygel_tracker_category_all_container_remove_entry_from_store (data->self, data->urn, rygel_tracker_category_all_container_remove_item_ready, data);
	return FALSE;
	_state_1:
	rygel_tracker_category_all_container_remove_entry_from_store_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->urn);
		_g_free0 (data->parent_id);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_free0 (data->urn);
	_g_free0 (data->parent_id);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_real_search_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelTrackerCategoryAllContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_tracker_category_all_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerSearchData* _data_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_category_all_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_category_all_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_tracker_category_all_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerCategoryAllContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_category_all_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_category_all_container_real_search_co (data);
}


static gboolean rygel_tracker_category_all_container_real_search_co (RygelTrackerCategoryAllContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) data->self, data->expression, data->offset, data->max_count, data->cancellable, rygel_tracker_category_all_container_search_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) data->self, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->total_matches = data->_tmp0_;
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->_tmp2_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch8_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch8_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void rygel_tracker_category_all_container_on_graph_updated (RygelTrackerCategoryAllContainer* self, const gchar* class_name, Event* deletes, int deletes_length1, Event* inserts, int inserts_length1) {
	gchar* _tmp0_ = NULL;
	gchar* our_suffix;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_name != NULL);
	_tmp0_ = string_replace (((RygelTrackerSearchContainer*) self)->item_factory->category, ":", "#");
	our_suffix = _tmp0_;
	_tmp1_ = g_str_has_suffix (class_name, our_suffix);
	if (!_tmp1_) {
		_g_free0 (our_suffix);
		return;
	}
	rygel_tracker_search_container_get_children_count ((RygelTrackerSearchContainer*) self, NULL, NULL);
	_g_free0 (our_suffix);
}


static void rygel_tracker_category_all_container_create_entry_in_store_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* data;
	data = _data;
	_g_object_unref0 (data->item);
	_g_free0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelTrackerCategoryAllContainerCreateEntryInStoreData, data);
}


static void rygel_tracker_category_all_container_create_entry_in_store (RygelTrackerCategoryAllContainer* self, RygelMediaItem* item, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerCreateEntryInStoreData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_category_all_container_create_entry_in_store);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_category_all_container_create_entry_in_store_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->item = _g_object_ref0 (item);
	rygel_tracker_category_all_container_create_entry_in_store_co (_data_);
}


static gchar* rygel_tracker_category_all_container_create_entry_in_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_category_all_container_create_entry_in_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_category_all_container_create_entry_in_store_co (data);
}


static gboolean rygel_tracker_category_all_container_create_entry_in_store_co (RygelTrackerCategoryAllContainerCreateEntryInStoreData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = g_strdup (((RygelTrackerSearchContainer*) data->self)->item_factory->category);
	data->category = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_tracker_insertion_query_new (data->item, data->category);
	data->query = data->_tmp1_;
	data->_state_ = 1;
	rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_category_all_container_create_entry_in_store_ready, data);
	return FALSE;
	_state_1:
	rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_rygel_tracker_query_unref0 (data->query);
		_g_free0 (data->category);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = g_strdup (data->query->id);
	data->result = data->_tmp2_;
	_rygel_tracker_query_unref0 (data->query);
	_g_free0 (data->category);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_rygel_tracker_query_unref0 (data->query);
	_g_free0 (data->category);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_tracker_category_all_container_remove_entry_from_store_data_free (gpointer _data) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData, data);
}


static void rygel_tracker_category_all_container_remove_entry_from_store (RygelTrackerCategoryAllContainer* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_category_all_container_remove_entry_from_store);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_category_all_container_remove_entry_from_store_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	rygel_tracker_category_all_container_remove_entry_from_store_co (_data_);
}


static void rygel_tracker_category_all_container_remove_entry_from_store_finish (RygelTrackerCategoryAllContainer* self, GAsyncResult* _res_, GError** error) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_category_all_container_remove_entry_from_store_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_category_all_container_remove_entry_from_store_co (data);
}


static gboolean rygel_tracker_category_all_container_remove_entry_from_store_co (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_tracker_deletion_query_new (data->id);
	data->query = data->_tmp0_;
	data->_state_ = 1;
	rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_category_all_container_remove_entry_from_store_ready, data);
	return FALSE;
	_state_1:
	rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_rygel_tracker_query_unref0 (data->query);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_rygel_tracker_query_unref0 (data->query);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GeeArrayList* rygel_tracker_category_all_container_real_get_create_classes (RygelWritableContainer* base) {
	GeeArrayList* result;
	RygelTrackerCategoryAllContainer* self;
	self = (RygelTrackerCategoryAllContainer*) base;
	result = self->priv->_create_classes;
	return result;
}


static void rygel_tracker_category_all_container_real_set_create_classes (RygelWritableContainer* base, GeeArrayList* value) {
	RygelTrackerCategoryAllContainer* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_create_classes);
	self->priv->_create_classes = _tmp1_;
	g_object_notify ((GObject *) self, "create-classes");
}


static void rygel_tracker_category_all_container_class_init (RygelTrackerCategoryAllContainerClass * klass) {
	rygel_tracker_category_all_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerCategoryAllContainerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_tracker_category_all_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_tracker_category_all_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_category_all_container_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES, "create-classes");
}


static void rygel_tracker_category_all_container_rygel_writable_container_interface_init (RygelWritableContainerIface * iface) {
	rygel_tracker_category_all_container_rygel_writable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_item = (void (*)(RygelWritableContainer* ,RygelMediaItem* ,GCancellable* ,GError**)) rygel_tracker_category_all_container_real_add_item;
	iface->add_item_finish = rygel_tracker_category_all_container_real_add_item_finish;
	iface->remove_item = (void (*)(RygelWritableContainer* ,const gchar* ,GCancellable* ,GError**)) rygel_tracker_category_all_container_real_remove_item;
	iface->remove_item_finish = rygel_tracker_category_all_container_real_remove_item_finish;
	iface->get_create_classes = rygel_tracker_category_all_container_real_get_create_classes;
	iface->set_create_classes = rygel_tracker_category_all_container_real_set_create_classes;
}


static void rygel_tracker_category_all_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
	rygel_tracker_category_all_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer* ,RygelSearchExpression* ,guint ,guint ,guint* ,GCancellable* ,GError**)) rygel_tracker_category_all_container_real_search;
	iface->search_finish = rygel_tracker_category_all_container_real_search_finish;
}


static void rygel_tracker_category_all_container_instance_init (RygelTrackerCategoryAllContainer * self) {
	self->priv = RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_GET_PRIVATE (self);
}


static void rygel_tracker_category_all_container_finalize (GObject* obj) {
	RygelTrackerCategoryAllContainer * self;
	self = RYGEL_TRACKER_CATEGORY_ALL_CONTAINER (obj);
	_g_object_unref0 (self->priv->_create_classes);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_category_all_container_parent_class)->finalize (obj);
}


/**
 * A search container that contains all the items in a category.
 */
GType rygel_tracker_category_all_container_get_type (void) {
	static volatile gsize rygel_tracker_category_all_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_category_all_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerCategoryAllContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_category_all_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerCategoryAllContainer), 0, (GInstanceInitFunc) rygel_tracker_category_all_container_instance_init, NULL };
		static const GInterfaceInfo rygel_writable_container_info = { (GInterfaceInitFunc) rygel_tracker_category_all_container_rygel_writable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_tracker_category_all_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_tracker_category_all_container_type_id;
		rygel_tracker_category_all_container_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, "RygelTrackerCategoryAllContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_tracker_category_all_container_type_id, RYGEL_TYPE_WRITABLE_CONTAINER, &rygel_writable_container_info);
		g_type_add_interface_static (rygel_tracker_category_all_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_tracker_category_all_container_type_id__volatile, rygel_tracker_category_all_container_type_id);
	}
	return rygel_tracker_category_all_container_type_id__volatile;
}


static void _vala_rygel_tracker_category_all_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTrackerCategoryAllContainer * self;
	self = RYGEL_TRACKER_CATEGORY_ALL_CONTAINER (object);
	switch (property_id) {
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES:
		g_value_set_object (value, rygel_writable_container_get_create_classes ((RygelWritableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_tracker_category_all_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTrackerCategoryAllContainer * self;
	self = RYGEL_TRACKER_CATEGORY_ALL_CONTAINER (object);
	switch (property_id) {
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES:
		rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



