/* rygel-media-export-recursive-file-monitor.c generated by valac 0.11.6, the Vala compiler
 * generated from rygel-media-export-recursive-file-monitor.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
typedef struct _RygelMediaExportRecursiveFileMonitorPrivate RygelMediaExportRecursiveFileMonitorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportRecursiveFileMonitorAddData RygelMediaExportRecursiveFileMonitorAddData;

struct _RygelMediaExportRecursiveFileMonitor {
	GObject parent_instance;
	RygelMediaExportRecursiveFileMonitorPrivate * priv;
};

struct _RygelMediaExportRecursiveFileMonitorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportRecursiveFileMonitorPrivate {
	GCancellable* cancellable;
	GeeHashMap* monitors;
};

struct _RygelMediaExportRecursiveFileMonitorAddData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRecursiveFileMonitor* self;
	GFile* file;
	GFileInfo* _tmp0_;
	GFileInfo* info;
	GFileType _tmp1_;
	GFileMonitor* _tmp2_;
	GFileMonitor* file_monitor;
	GError * err;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_recursive_file_monitor_parent_class = NULL;

GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_DUMMY_PROPERTY
};
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
void rygel_media_export_recursive_file_monitor_on_monitor_changed (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
static void _rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_media_export_recursive_file_monitor_add_data_free (gpointer _data);
static gboolean rygel_media_export_recursive_file_monitor_add_co (RygelMediaExportRecursiveFileMonitorAddData* data);
static void rygel_media_export_recursive_file_monitor_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_cancel (RygelMediaExportRecursiveFileMonitor* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_export_recursive_file_monitor_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable) {
	RygelMediaExportRecursiveFileMonitor * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_;
	self = (RygelMediaExportRecursiveFileMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancellable);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_file_hash, g_file_equal, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp3_;
	return self;
}


RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable) {
	return rygel_media_export_recursive_file_monitor_construct (RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, cancellable);
}


static void _rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_media_export_recursive_file_monitor_on_monitor_changed (self, file, other_file, event_type);
}


void rygel_media_export_recursive_file_monitor_on_monitor_changed (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_signal_emit_by_name (self, "changed", file, other_file, event_type);
	switch (event_type) {
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			rygel_media_export_recursive_file_monitor_add (self, file, NULL, NULL);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			gpointer _tmp0_ = NULL;
			GFileMonitor* file_monitor;
			_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->monitors, file);
			file_monitor = (GFileMonitor*) _tmp0_;
			if (file_monitor != NULL) {
				gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				guint _tmp3_;
				_tmp1_ = g_file_get_uri (file);
				_tmp2_ = _tmp1_;
				g_debug ("rygel-media-export-recursive-file-monitor.vala:48: Folder %s gone; rem" \
"oving watch", _tmp2_);
				_g_free0 (_tmp2_);
				gee_abstract_map_unset ((GeeAbstractMap*) self->priv->monitors, file, NULL);
				g_file_monitor_cancel (file_monitor);
				g_signal_parse_name ("changed", G_TYPE_FILE_MONITOR, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (file_monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed, self);
			}
			_g_object_unref0 (file_monitor);
			break;
		}
		default:
		{
			break;
		}
	}
}


static void rygel_media_export_recursive_file_monitor_add_data_free (gpointer _data) {
	RygelMediaExportRecursiveFileMonitorAddData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaExportRecursiveFileMonitorAddData, data);
}


void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRecursiveFileMonitorAddData* _data_;
	_data_ = g_slice_new0 (RygelMediaExportRecursiveFileMonitorAddData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_recursive_file_monitor_add);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_recursive_file_monitor_add_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	rygel_media_export_recursive_file_monitor_add_co (_data_);
}


void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_) {
	RygelMediaExportRecursiveFileMonitorAddData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_recursive_file_monitor_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRecursiveFileMonitorAddData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_export_recursive_file_monitor_add_co (data);
}


static gboolean rygel_media_export_recursive_file_monitor_add_co (RygelMediaExportRecursiveFileMonitorAddData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	g_file_query_info_async (data->file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_media_export_recursive_file_monitor_add_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
	data->info = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch40_g_error;
	}
	data->_tmp1_ = g_file_info_get_file_type (data->info);
	if (data->_tmp1_ == G_FILE_TYPE_DIRECTORY) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_file_monitor_directory (data->file, G_FILE_MONITOR_NONE, data->self->priv->cancellable, &data->_inner_error_);
		data->file_monitor = data->_tmp2_;
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->info);
			goto __catch40_g_error;
		}
		gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->monitors, data->file, data->file_monitor);
		g_signal_connect_object (data->file_monitor, "changed", (GCallback) _rygel_media_export_recursive_file_monitor_on_monitor_changed_g_file_monitor_changed, data->self, 0);
		_g_object_unref0 (data->file_monitor);
	}
	_g_object_unref0 (data->info);
	goto __finally40;
	__catch40_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp3_ = NULL;
		data->_tmp3_ = _ ("Failed to get file info for %s");
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_file_get_uri (data->file);
		data->_tmp5_ = data->_tmp4_;
		g_warning (data->_tmp3_, data->_tmp5_);
		_g_free0 (data->_tmp5_);
		_g_error_free0 (data->err);
	}
	__finally40:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void rygel_media_export_recursive_file_monitor_cancel (RygelMediaExportRecursiveFileMonitor* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->cancellable != NULL) {
		g_cancellable_cancel (self->priv->cancellable);
	} else {
		{
			GeeCollection* _tmp0_ = NULL;
			GeeCollection* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _monitor_it;
			_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->monitors);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_monitor_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				GFileMonitor* monitor;
				_tmp4_ = gee_iterator_next (_monitor_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_monitor_it);
				monitor = (GFileMonitor*) _tmp5_;
				g_file_monitor_cancel (monitor);
				_g_object_unref0 (monitor);
			}
			_g_object_unref0 (_monitor_it);
		}
	}
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_enum (param_values + 3), data2);
}


static void rygel_media_export_recursive_file_monitor_class_init (RygelMediaExportRecursiveFileMonitorClass * klass) {
	rygel_media_export_recursive_file_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportRecursiveFileMonitorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_recursive_file_monitor_finalize;
	g_signal_new ("changed", RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM, G_TYPE_NONE, 3, G_TYPE_FILE, G_TYPE_FILE, G_TYPE_FILE_MONITOR_EVENT);
}


static void rygel_media_export_recursive_file_monitor_instance_init (RygelMediaExportRecursiveFileMonitor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_PRIVATE (self);
}


static void rygel_media_export_recursive_file_monitor_finalize (GObject* obj) {
	RygelMediaExportRecursiveFileMonitor * self;
	self = RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR (obj);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->monitors);
	G_OBJECT_CLASS (rygel_media_export_recursive_file_monitor_parent_class)->finalize (obj);
}


GType rygel_media_export_recursive_file_monitor_get_type (void) {
	static volatile gsize rygel_media_export_recursive_file_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_recursive_file_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRecursiveFileMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_recursive_file_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRecursiveFileMonitor), 0, (GInstanceInitFunc) rygel_media_export_recursive_file_monitor_instance_init, NULL };
		GType rygel_media_export_recursive_file_monitor_type_id;
		rygel_media_export_recursive_file_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportRecursiveFileMonitor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_recursive_file_monitor_type_id__volatile, rygel_media_export_recursive_file_monitor_type_id);
	}
	return rygel_media_export_recursive_file_monitor_type_id__volatile;
}



