/* rygel-media-export-query-container.c generated by valac 0.11.6, the Vala compiler
 * generated from rygel-media-export-query-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerSearchData RygelMediaExportQueryContainerSearchData;
typedef struct _RygelMediaExportQueryContainerGetChildrenData RygelMediaExportQueryContainerGetChildrenData;

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	gchar* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportQueryContainerPrivate {
	gchar* attribute;
	RygelSearchExpression* expression;
	gchar* pattern;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _RygelMediaExportQueryContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* children;
	RygelSearchExpression* combined_expression;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelLogicalExpression* _tmp2_;
	RygelLogicalExpression* local_expression;
	RygelSearchExpression* _tmp3_;
	RygelSearchExpression* _tmp4_;
	RygelSearchExpression* _tmp5_;
	RygelSearchExpression* _tmp6_;
	RygelSearchExpression* _tmp7_;
	RygelSearchExpression* _tmp8_;
	guint _tmp9_;
	RygelMediaObjects* _tmp10_;
	RygelMediaObjects* _tmp11_;
	RygelMediaObjects* _tmp12_;
	GError * _error_;
	RygelMediaObjects* _tmp13_;
	RygelMediaObjects* _tmp14_;
	GError* _tmp15_;
	GError * _inner_error_;
};

struct _RygelMediaExportQueryContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportQueryContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* children;
	guint total_matches;
	guint _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	RygelMediaObjects* _tmp5_;
	GeeList* _tmp6_;
	GeeList* data;
	GeeList* _tmp7_;
	GeeList* _meta_data_list;
	gint _tmp8_;
	gint _meta_data_size;
	gint _meta_data_index;
	gpointer _tmp9_;
	gchar* meta_data;
	gchar* _tmp10_;
	gchar* new_id;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RygelMediaExportQueryContainer* _tmp13_;
	RygelMediaExportQueryContainer* container;
	RygelMediaObjects* _tmp14_;
	RygelMediaObjects* _child_list;
	gint _tmp15_;
	gint _child_size;
	gint _child_index;
	gpointer _tmp16_;
	RygelMediaObject* child;
	GError * _inner_error_;
};


static gpointer rygel_media_export_query_container_parent_class = NULL;
static GeeHashMap* rygel_media_export_query_container_virtual_container_map;
static GeeHashMap* rygel_media_export_query_container_virtual_container_map = NULL;

GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
gchar* rygel_media_export_query_container_get_virtual_container_definition (const gchar* hash);
static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const gchar* op1_, const gchar* op2);
static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
static void rygel_media_export_query_container_real_search_data_free (gpointer _data);
static void rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* data);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
GQuark rygel_media_export_media_cache_error_quark (void);
static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data);
static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* data);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_export_query_container_register_id (gchar** id);
static void rygel_media_export_query_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch36_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch36_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally36;
	__catch36_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally36:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name) {
	RygelMediaExportQueryContainer * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gint i;
	gint _tmp14_;
	g_return_val_if_fail (media_db != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelMediaExportQueryContainer*) rygel_media_export_db_container_construct (object_type, media_db, id, name);
	_tmp0_ = rygel_media_export_query_container_get_virtual_container_definition (id);
	_tmp1_ = _tmp0_;
	_g_free0 (self->plaintext_id);
	self->plaintext_id = _tmp1_;
	g_debug ("rygel-media-export-query-container.vala:57: plaintext ID is: %s", self->plaintext_id);
	_tmp3_ = _tmp2_ = g_strsplit (self->plaintext_id, ",", 0);
	args = _tmp3_;
	args_length1 = _vala_array_length (_tmp2_);
	_args_size_ = _vala_array_length (_tmp2_);
	if ((args_length1 % 2) != 0) {
		g_assert_not_reached ();
	}
	i = 0;
	while (TRUE) {
		if (!(i < args_length1)) {
			break;
		}
		if (g_strcmp0 (args[i + 1], "?") != 0) {
			rygel_media_export_query_container_update_search_expression (self, args[i], args[i + 1]);
			if (g_strcmp0 (name, "") == 0) {
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				_tmp4_ = g_uri_unescape_string (args[i + 1], NULL);
				_tmp5_ = _tmp4_;
				rygel_media_object_set_title ((RygelMediaObject*) self, _tmp5_);
				_g_free0 (_tmp5_);
			}
		} else {
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp6_ = g_strdup ("%s");
			_tmp7_ = _tmp6_;
			_g_free0 (args[i + 1]);
			args[i + 1] = _tmp7_;
			_tmp8_ = string_replace (args[i], RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
			_tmp9_ = _tmp8_;
			_g_free0 (self->priv->attribute);
			self->priv->attribute = _tmp9_;
			_tmp10_ = g_uri_unescape_string (self->priv->attribute, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (self->priv->attribute);
			self->priv->attribute = _tmp11_;
			_tmp12_ = g_strjoinv (",", args);
			_tmp13_ = _tmp12_;
			_g_free0 (self->priv->pattern);
			self->priv->pattern = _tmp13_;
			break;
		}
		i = i + 2;
	}
	_tmp14_ = rygel_media_export_query_container_count_children (self);
	((RygelMediaContainer*) self)->child_count = _tmp14_;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name) {
	return rygel_media_export_query_container_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, media_db, id, name);
}


static gint rygel_media_export_query_container_count_children (RygelMediaExportQueryContainer* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	if (g_strcmp0 (self->priv->pattern, "") == 0) {
		glong _tmp0_;
		glong _tmp1_;
		_tmp0_ = rygel_media_export_media_cache_get_object_count_by_search_expression (((RygelMediaExportDBContainer*) self)->media_db, self->priv->expression, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
		result = (gint) _tmp1_;
		return result;
	} else {
		GeeList* _tmp2_ = NULL;
		GeeList* data;
		gint _tmp3_;
		_tmp2_ = rygel_media_export_media_cache_get_object_attribute_by_search_expression (((RygelMediaExportDBContainer*) self)->media_db, self->priv->attribute, self->priv->expression, (glong) 0, (guint) (-1), &_inner_error_);
		data = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
		_tmp3_ = gee_collection_get_size ((GeeCollection*) data);
		result = _tmp3_;
		_g_object_unref0 (data);
		return result;
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = 0;
		_g_error_free0 (e);
		return result;
	}
	__finally37:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static void rygel_media_export_query_container_real_search_data_free (gpointer _data) {
	RygelMediaExportQueryContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaExportQueryContainerSearchData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_export_query_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerSearchData* _data_;
	self = (RygelMediaExportQueryContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_query_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_export_query_container_real_search_finish (RygelMediaExportDBContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportQueryContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_media_export_query_container_real_search_co (RygelMediaExportQueryContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->children = NULL;
	if (data->expression == NULL) {
		data->_tmp0_ = _rygel_search_expression_ref0 (data->self->priv->expression);
		data->_tmp1_ = data->_tmp0_;
		_rygel_search_expression_unref0 (data->combined_expression);
		data->combined_expression = data->_tmp1_;
	} else {
		data->_tmp2_ = NULL;
		data->_tmp2_ = rygel_logical_expression_new ();
		data->local_expression = data->_tmp2_;
		data->_tmp3_ = _rygel_search_expression_ref0 (data->self->priv->expression);
		data->_tmp4_ = data->_tmp3_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) data->local_expression)->operand1);
		((RygelSearchExpression*) data->local_expression)->operand1 = data->_tmp4_;
		((RygelSearchExpression*) data->local_expression)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
		data->_tmp5_ = _rygel_search_expression_ref0 (data->expression);
		data->_tmp6_ = data->_tmp5_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) data->local_expression)->operand2);
		((RygelSearchExpression*) data->local_expression)->operand2 = data->_tmp6_;
		data->_tmp7_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) data->local_expression);
		data->_tmp8_ = data->_tmp7_;
		_rygel_search_expression_unref0 (data->combined_expression);
		data->combined_expression = data->_tmp8_;
		_rygel_search_expression_unref0 (data->local_expression);
	}
	data->_tmp10_ = NULL;
	data->_tmp10_ = rygel_media_export_media_cache_get_objects_by_search_expression (((RygelMediaExportDBContainer*) data->self)->media_db, data->combined_expression, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, data->offset, data->max_count, &data->_tmp9_, &data->_inner_error_);
	data->total_matches = data->_tmp9_;
	data->_tmp11_ = data->_tmp10_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR) {
			goto __catch38_rygel_media_export_media_cache_error;
		}
		goto __finally38;
	}
	data->_tmp12_ = data->_tmp11_;
	_g_object_unref0 (data->children);
	data->children = data->_tmp12_;
	goto __finally38;
	__catch38_rygel_media_export_media_cache_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (g_error_matches (data->_error_, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH)) {
			data->_tmp13_ = NULL;
			data->_tmp13_ = rygel_media_objects_new ();
			data->_tmp14_ = data->_tmp13_;
			_g_object_unref0 (data->children);
			data->children = data->_tmp14_;
			data->total_matches = (guint) 0;
		} else {
			data->_tmp15_ = _g_error_copy0 (data->_error_);
			data->_inner_error_ = data->_tmp15_;
			_g_error_free0 (data->_error_);
			goto __finally38;
		}
		_g_error_free0 (data->_error_);
	}
	__finally38:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_rygel_search_expression_unref0 (data->combined_expression);
		_g_object_unref0 (data->children);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->children;
	_rygel_search_expression_unref0 (data->combined_expression);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_rygel_search_expression_unref0 (data->combined_expression);
	_g_object_unref0 (data->children);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_media_export_query_container_real_get_children_data_free (gpointer _data) {
	RygelMediaExportQueryContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaExportQueryContainerGetChildrenData, data);
}


static void rygel_media_export_query_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportQueryContainer * self;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	self = (RygelMediaExportQueryContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportQueryContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_query_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_query_container_real_get_children_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_query_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_media_export_query_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportQueryContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_query_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportQueryContainerGetChildrenData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_export_query_container_real_get_children_co (data);
}


static gboolean rygel_media_export_query_container_real_get_children_co (RygelMediaExportQueryContainerGetChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_strcmp0 (data->self->priv->pattern, "") == 0) {
		data->_state_ = 1;
		rygel_media_export_db_container_search ((RygelMediaExportDBContainer*) data->self, data->self->priv->expression, data->offset, data->max_count, data->cancellable, rygel_media_export_query_container_get_children_ready, data);
		return FALSE;
		_state_1:
		data->_tmp1_ = NULL;
		data->_tmp1_ = rygel_media_export_db_container_search_finish ((RygelMediaExportDBContainer*) data->self, data->_res_, &data->_tmp0_, &data->_inner_error_);
		data->total_matches = data->_tmp0_;
		data->_tmp2_ = data->_tmp1_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->children);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp3_ = data->_tmp2_;
		_g_object_unref0 (data->children);
		data->children = data->_tmp3_;
	} else {
		data->_tmp4_ = NULL;
		data->_tmp4_ = rygel_media_objects_new ();
		data->_tmp5_ = data->_tmp4_;
		_g_object_unref0 (data->children);
		data->children = data->_tmp5_;
		data->_tmp6_ = NULL;
		data->_tmp6_ = rygel_media_export_media_cache_get_object_attribute_by_search_expression (((RygelMediaExportDBContainer*) data->self)->media_db, data->self->priv->attribute, data->self->priv->expression, (glong) data->offset, data->max_count, &data->_inner_error_);
		data->data = data->_tmp6_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->children);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		{
			data->_tmp7_ = _g_object_ref0 (data->data);
			data->_meta_data_list = data->_tmp7_;
			data->_tmp8_ = gee_collection_get_size ((GeeCollection*) data->_meta_data_list);
			data->_meta_data_size = data->_tmp8_;
			data->_meta_data_index = -1;
			while (TRUE) {
				data->_meta_data_index = data->_meta_data_index + 1;
				if (!(data->_meta_data_index < data->_meta_data_size)) {
					break;
				}
				data->_tmp9_ = NULL;
				data->_tmp9_ = gee_list_get (data->_meta_data_list, data->_meta_data_index);
				data->meta_data = (gchar*) data->_tmp9_;
				data->_tmp10_ = NULL;
				data->_tmp10_ = g_uri_escape_string (data->meta_data, "", TRUE);
				data->new_id = data->_tmp10_;
				data->_tmp11_ = NULL;
				data->_tmp11_ = string_replace (data->self->priv->pattern, "%s", data->new_id);
				data->_tmp12_ = data->_tmp11_;
				_g_free0 (data->new_id);
				data->new_id = data->_tmp12_;
				rygel_media_export_query_container_register_id (&data->new_id);
				data->_tmp13_ = NULL;
				data->_tmp13_ = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) data->self)->media_db, data->new_id, data->meta_data);
				data->container = data->_tmp13_;
				gee_abstract_collection_add ((GeeAbstractCollection*) data->children, (RygelMediaObject*) data->container);
				_g_object_unref0 (data->container);
				_g_free0 (data->new_id);
				_g_free0 (data->meta_data);
			}
			_g_object_unref0 (data->_meta_data_list);
		}
		_g_object_unref0 (data->data);
	}
	{
		data->_tmp14_ = _g_object_ref0 (data->children);
		data->_child_list = data->_tmp14_;
		data->_tmp15_ = gee_collection_get_size ((GeeCollection*) data->_child_list);
		data->_child_size = data->_tmp15_;
		data->_child_index = -1;
		while (TRUE) {
			data->_child_index = data->_child_index + 1;
			if (!(data->_child_index < data->_child_size)) {
				break;
			}
			data->_tmp16_ = NULL;
			data->_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) data->_child_list, data->_child_index);
			data->child = (RygelMediaObject*) data->_tmp16_;
			data->child->parent = (RygelMediaContainer*) data->self;
			_g_object_unref0 (data->child);
		}
		_g_object_unref0 (data->_child_list);
	}
	data->result = data->children;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->children);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void rygel_media_export_query_container_register_id (gchar** id) {
	gchar* _tmp0_ = NULL;
	gchar* md5;
	gboolean _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (id != NULL);
	_tmp0_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, *id, (gsize) (-1));
	md5 = _tmp0_;
	if (rygel_media_export_query_container_virtual_container_map == NULL) {
		GeeHashMap* _tmp1_ = NULL;
		GeeHashMap* _tmp2_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (rygel_media_export_query_container_virtual_container_map);
		rygel_media_export_query_container_virtual_container_map = _tmp2_;
	}
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, md5);
	if (!_tmp3_) {
		gee_abstract_map_set ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, md5, *id);
		g_debug ("rygel-media-export-query-container.vala:191: Registering %s for %s", md5, *id);
	}
	_tmp4_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, md5, NULL);
	_g_free0 (*id);
	*id = _tmp4_;
	_g_free0 (md5);
}


gchar* rygel_media_export_query_container_get_virtual_container_definition (const gchar* hash) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* id;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (hash != NULL, NULL);
	_tmp0_ = string_replace (hash, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	id = _tmp0_;
	if (rygel_media_export_query_container_virtual_container_map != NULL) {
		gboolean _tmp2_;
		_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, id);
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gpointer _tmp3_ = NULL;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) rygel_media_export_query_container_virtual_container_map, id);
		result = (gchar*) _tmp3_;
		_g_free0 (id);
		return result;
	}
	result = NULL;
	_g_free0 (id);
	return result;
}


static void rygel_media_export_query_container_update_search_expression (RygelMediaExportQueryContainer* self, const gchar* op1_, const gchar* op2) {
	RygelRelationalExpression* _tmp0_ = NULL;
	RygelRelationalExpression* exp;
	gchar* _tmp1_ = NULL;
	gchar* op1;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op1_ != NULL);
	g_return_if_fail (op2 != NULL);
	_tmp0_ = rygel_relational_expression_new ();
	exp = _tmp0_;
	_tmp1_ = string_replace (op1_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	op1 = _tmp1_;
	_tmp2_ = g_uri_unescape_string (op1, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (((RygelSearchExpression*) exp)->operand1);
	((RygelSearchExpression*) exp)->operand1 = _tmp3_;
	((RygelSearchExpression*) exp)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
	_tmp4_ = g_uri_unescape_string (op2, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (((RygelSearchExpression*) exp)->operand2);
	((RygelSearchExpression*) exp)->operand2 = _tmp5_;
	if (self->priv->expression != NULL) {
		RygelLogicalExpression* _tmp6_ = NULL;
		RygelLogicalExpression* exp2;
		RygelSearchExpression* _tmp7_;
		RygelSearchExpression* _tmp8_;
		RygelSearchExpression* _tmp9_;
		RygelSearchExpression* _tmp10_;
		RygelSearchExpression* _tmp11_;
		RygelSearchExpression* _tmp12_;
		_tmp6_ = rygel_logical_expression_new ();
		exp2 = _tmp6_;
		_tmp7_ = _rygel_search_expression_ref0 (self->priv->expression);
		_tmp8_ = _tmp7_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand1);
		((RygelSearchExpression*) exp2)->operand1 = _tmp8_;
		_tmp9_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp);
		_tmp10_ = _tmp9_;
		_rygel_search_expression_unref0 (((RygelSearchExpression*) exp2)->operand2);
		((RygelSearchExpression*) exp2)->operand2 = _tmp10_;
		((RygelSearchExpression*) exp2)->op = GINT_TO_POINTER (RYGEL_LOGICAL_OPERATOR_AND);
		_tmp11_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp2);
		_tmp12_ = _tmp11_;
		_rygel_search_expression_unref0 (self->priv->expression);
		self->priv->expression = _tmp12_;
		_rygel_search_expression_unref0 (exp2);
	} else {
		RygelSearchExpression* _tmp13_;
		RygelSearchExpression* _tmp14_;
		_tmp13_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) exp);
		_tmp14_ = _tmp13_;
		_rygel_search_expression_unref0 (self->priv->expression);
		self->priv->expression = _tmp14_;
	}
	_g_free0 (op1);
	_rygel_search_expression_unref0 (exp);
}


static void rygel_media_export_query_container_class_init (RygelMediaExportQueryContainerClass * klass) {
	rygel_media_export_query_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerPrivate));
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search = rygel_media_export_query_container_real_search;
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_query_container_real_search_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_export_query_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_export_query_container_real_get_children_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_finalize;
}


static void rygel_media_export_query_container_instance_init (RygelMediaExportQueryContainer * self) {
	gchar* _tmp0_;
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->pattern = _tmp0_;
}


static void rygel_media_export_query_container_finalize (GObject* obj) {
	RygelMediaExportQueryContainer * self;
	self = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER (obj);
	_g_free0 (self->priv->attribute);
	_rygel_search_expression_unref0 (self->priv->expression);
	_g_free0 (self->plaintext_id);
	_g_free0 (self->priv->pattern);
	G_OBJECT_CLASS (rygel_media_export_query_container_parent_class)->finalize (obj);
}


GType rygel_media_export_query_container_get_type (void) {
	static volatile gsize rygel_media_export_query_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainer), 0, (GInstanceInitFunc) rygel_media_export_query_container_instance_init, NULL };
		GType rygel_media_export_query_container_type_id;
		rygel_media_export_query_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportQueryContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_type_id__volatile, rygel_media_export_query_container_type_id);
	}
	return rygel_media_export_query_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



