/* rygel-changelog.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-changelog.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;
typedef struct _RygelChangeLogPrivate RygelChangeLogPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelChangeLog {
	GObject parent_instance;
	RygelChangeLogPrivate * priv;
};

struct _RygelChangeLogClass {
	GObjectClass parent_class;
};

struct _RygelChangeLogPrivate {
	GUPnPService* _service;
	gchar* service_ns;
	GString* str;
	GeeHashMap* hash;
	guint timeout_id;
};


static gpointer rygel_change_log_parent_class = NULL;

GType rygel_change_log_get_type (void) G_GNUC_CONST;
#define RYGEL_CHANGE_LOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogPrivate))
enum  {
	RYGEL_CHANGE_LOG_DUMMY_PROPERTY,
	RYGEL_CHANGE_LOG_SERVICE
};
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
void rygel_change_log_set_service (RygelChangeLog* self, GUPnPService* value);
static gboolean rygel_change_log_timeout (RygelChangeLog* self);
GUPnPService* rygel_change_log_get_service (RygelChangeLog* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static void rygel_change_log_ensure_timeout (RygelChangeLog* self);
static gboolean _rygel_change_log_timeout_gsource_func (gpointer self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
void rygel_change_log_log_with_channel (RygelChangeLog* self, const gchar* variable, const gchar* value, const gchar* channel);
static void rygel_change_log_finalize (GObject* obj);
static void _vala_rygel_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns) {
	RygelChangeLog * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GString* _tmp2_ = NULL;
	GString* _tmp3_;
	GeeHashMap* _tmp4_ = NULL;
	GeeHashMap* _tmp5_;
	g_return_val_if_fail (service_ns != NULL, NULL);
	self = (RygelChangeLog*) g_object_new (object_type, NULL);
	rygel_change_log_set_service (self, service);
	_tmp0_ = g_strdup (service_ns);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->service_ns);
	self->priv->service_ns = _tmp1_;
	_tmp2_ = g_string_new ("");
	_tmp3_ = _tmp2_;
	_g_string_free0 (self->priv->str);
	self->priv->str = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->hash);
	self->priv->hash = _tmp5_;
	return self;
}


RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns) {
	return rygel_change_log_construct (RYGEL_TYPE_CHANGE_LOG, service, service_ns);
}


static gboolean rygel_change_log_timeout (RygelChangeLog* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_change_log_finish (self);
	_tmp1_ = _tmp0_;
	gupnp_service_notify (self->priv->_service, "LastChange", G_TYPE_STRING, _tmp1_, NULL);
	_g_free0 (_tmp1_);
	g_debug ("rygel-changelog.vala:55: LastChange sent");
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->hash);
	g_string_erase (self->priv->str, (gssize) 0, (gssize) (-1));
	self->priv->timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean _rygel_change_log_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_change_log_timeout (self);
	return result;
}


static void rygel_change_log_ensure_timeout (RygelChangeLog* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_service != NULL) {
		_tmp0_ = self->priv->timeout_id == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp1_;
		g_debug ("rygel-changelog.vala:68: Setting up timeout for LastChange");
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_change_log_timeout_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->timeout_id = _tmp1_;
	}
}


void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("rygel-changelog.vala:74: '%s = %s' logged", variable, value);
	_tmp0_ = g_strdup_printf ("<%s val=\"%s\"/>", variable, value);
	_tmp1_ = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->hash, variable, _tmp1_);
	_g_free0 (_tmp1_);
	rygel_change_log_ensure_timeout (self);
}


void rygel_change_log_log_with_channel (RygelChangeLog* self, const gchar* variable, const gchar* value, const gchar* channel) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = g_strdup_printf ("<%s val=\"%s\" channel=\"%s\"/>", variable, value, channel);
	_tmp1_ = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->hash, variable, _tmp1_);
	_g_free0 (_tmp1_);
	rygel_change_log_ensure_timeout (self);
}


gchar* rygel_change_log_finish (RygelChangeLog* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strconcat ("<Event xmlns=\"", self->priv->service_ns, NULL);
	_tmp1_ = g_strconcat (_tmp0_, "\"><InstanceID val=\"0\">", NULL);
	g_string_append (self->priv->str, _tmp1_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	{
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _line_it;
		_tmp2_ = gee_map_get_values ((GeeMap*) self->priv->hash);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_line_it = (_tmp5_ = _tmp4_, _g_object_unref0 (_tmp3_), _tmp5_);
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			gchar* line;
			_tmp6_ = gee_iterator_next (_line_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_line_it);
			line = (gchar*) _tmp7_;
			g_string_append (self->priv->str, line);
			_g_free0 (line);
		}
		_g_object_unref0 (_line_it);
	}
	g_string_append (self->priv->str, "</InstanceID></Event>");
	_tmp8_ = g_strdup (self->priv->str->str);
	result = _tmp8_;
	return result;
}


GUPnPService* rygel_change_log_get_service (RygelChangeLog* self) {
	GUPnPService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


void rygel_change_log_set_service (RygelChangeLog* self, GUPnPService* value) {
	g_return_if_fail (self != NULL);
	self->priv->_service = value;
	g_object_notify ((GObject *) self, "service");
}


static void rygel_change_log_class_init (RygelChangeLogClass * klass) {
	rygel_change_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelChangeLogPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_change_log_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_change_log_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_change_log_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_CHANGE_LOG_SERVICE, g_param_spec_object ("service", "service", "service", GUPNP_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_change_log_instance_init (RygelChangeLog * self) {
	self->priv = RYGEL_CHANGE_LOG_GET_PRIVATE (self);
	self->priv->timeout_id = (guint) 0;
}


static void rygel_change_log_finalize (GObject* obj) {
	RygelChangeLog * self;
	self = RYGEL_CHANGE_LOG (obj);
	if (self->priv->timeout_id != 0) {
		g_source_remove (self->priv->timeout_id);
	}
	_g_free0 (self->priv->service_ns);
	_g_string_free0 (self->priv->str);
	_g_object_unref0 (self->priv->hash);
	G_OBJECT_CLASS (rygel_change_log_parent_class)->finalize (obj);
}


GType rygel_change_log_get_type (void) {
	static volatile gsize rygel_change_log_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_change_log_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelChangeLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_change_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelChangeLog), 0, (GInstanceInitFunc) rygel_change_log_instance_init, NULL };
		GType rygel_change_log_type_id;
		rygel_change_log_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelChangeLog", &g_define_type_info, 0);
		g_once_init_leave (&rygel_change_log_type_id__volatile, rygel_change_log_type_id);
	}
	return rygel_change_log_type_id__volatile;
}


static void _vala_rygel_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelChangeLog * self;
	self = RYGEL_CHANGE_LOG (object);
	switch (property_id) {
		case RYGEL_CHANGE_LOG_SERVICE:
		g_value_set_object (value, rygel_change_log_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelChangeLog * self;
	self = RYGEL_CHANGE_LOG (object);
	switch (property_id) {
		case RYGEL_CHANGE_LOG_SERVICE:
		rygel_change_log_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



