/* rygel-mediathek-rss-container.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-mediathek-rss-container.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libgupnp/gupnp.h>
#include <libxml/xpath.h>
#include <gee.h>


#define RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER (rygel_mediathek_rss_container_get_type ())
#define RYGEL_MEDIATHEK_RSS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainer))
#define RYGEL_MEDIATHEK_RSS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerClass))
#define RYGEL_MEDIATHEK_IS_RSS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER))
#define RYGEL_MEDIATHEK_IS_RSS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER))
#define RYGEL_MEDIATHEK_RSS_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerClass))

typedef struct _RygelMediathekRssContainer RygelMediathekRssContainer;
typedef struct _RygelMediathekRssContainerClass RygelMediathekRssContainerClass;
typedef struct _RygelMediathekRssContainerPrivate RygelMediathekRssContainerPrivate;
#define _soup_date_free0(var) ((var == NULL) ? NULL : (var = (soup_date_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediathekRssContainerUpdateData RygelMediathekRssContainerUpdateData;

#define RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY (rygel_mediathek_video_item_factory_get_type ())
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactory))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM_FACTORY, RygelMediathekVideoItemFactoryClass))

typedef struct _RygelMediathekVideoItemFactory RygelMediathekVideoItemFactory;
typedef struct _RygelMediathekVideoItemFactoryClass RygelMediathekVideoItemFactoryClass;
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediathekRssContainerParseResponseData RygelMediathekRssContainerParseResponseData;

struct _RygelMediathekRssContainer {
	RygelSimpleContainer parent_instance;
	RygelMediathekRssContainerPrivate * priv;
};

struct _RygelMediathekRssContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelMediathekRssContainerPrivate {
	guint content_id;
	SoupDate* last_modified;
	gchar* feed_uri;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediathekRssContainer * self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediathekRssContainerUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekRssContainer* self;
	Block2Data* _data2_;
	SoupMessage* _tmp0_;
	SoupMessage* message;
	SoupSessionAsync* _tmp1_;
	SoupSessionAsync* session;
	SoupMessage* _tmp2_;
	guint _tmp3_;
	SoupURI* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean success;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* date;
	SoupDate* _tmp10_;
	SoupDate* _tmp11_;
	guint _tmp12_;
	SoupURI* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	guint _tmp16_;
	const gchar* _tmp17_;
};

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR,
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_NETWORK_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekRssContainerParseResponseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediathekRssContainer* self;
	SoupMessage* message;
	gboolean result;
	RygelMediathekVideoItemFactory* _tmp0_;
	RygelMediathekVideoItemFactory* factory;
	SoupMessageBody* response;
	xmlDoc* _tmp1_;
	xmlDoc* doc;
	GUPnPXMLDoc* _tmp2_;
	GUPnPXMLDoc* guard;
	xmlXPathContext* _tmp3_;
	xmlXPathContext* context;
	xmlXPathObject* _tmp4_;
	xmlXPathObject* xpath_object;
	gboolean _tmp5_;
	gint _tmp6_;
	xmlNode* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	xmlXPathObject* _tmp10_;
	gint i;
	gboolean _tmp11_;
	gint _tmp12_;
	xmlNode* _tmp13_;
	xmlNode* node;
	RygelVideoItem* _tmp14_;
	RygelVideoItem* item;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer rygel_mediathek_rss_container_parent_class = NULL;

GType rygel_mediathek_rss_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIATHEK_RSS_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, RygelMediathekRssContainerPrivate))
enum  {
	RYGEL_MEDIATHEK_RSS_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIATHEK_RSS_CONTAINER_uri_template "http://www.zdf.de/ZDFmediathek/" "content/%u?view=rss"
RygelMediathekRssContainer* rygel_mediathek_rss_container_new (RygelMediaContainer* parent, guint id);
RygelMediathekRssContainer* rygel_mediathek_rss_container_construct (GType object_type, RygelMediaContainer* parent, guint id);
void rygel_mediathek_rss_container_update (RygelMediathekRssContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_mediathek_rss_container_update_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_);
static void rygel_mediathek_rss_container_update_data_free (gpointer _data);
static gboolean rygel_mediathek_rss_container_update_co (RygelMediathekRssContainerUpdateData* data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static SoupMessage* rygel_mediathek_rss_container_get_update_message (RygelMediathekRssContainer* self);
SoupSessionAsync* rygel_mediathek_root_container_get_default_session (void);
static gboolean _rygel_mediathek_rss_container_update_co_gsource_func (gpointer self);
static void _lambda1_ (Block2Data* _data2_);
static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_mediathek_rss_container_parse_response (RygelMediathekRssContainer* self, SoupMessage* message, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_mediathek_rss_container_parse_response_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_);
static void rygel_mediathek_rss_container_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_mediathek_rss_container_parse_response_data_free (gpointer _data);
static gboolean rygel_mediathek_rss_container_parse_response_co (RygelMediathekRssContainerParseResponseData* data);
GType rygel_mediathek_video_item_factory_get_type (void) G_GNUC_CONST;
RygelMediathekVideoItemFactory* rygel_mediathek_video_item_factory_get_default (void);
void xmlXPathFreeObject (xmlXPathObject* object);
void rygel_mediathek_video_item_factory_create (RygelMediathekVideoItemFactory* self, RygelMediaContainer* parent, xmlNode* xml_item, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark rygel_mediathek_video_item_error_quark (void);
RygelVideoItem* rygel_mediathek_video_item_factory_create_finish (RygelMediathekVideoItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_mediathek_rss_container_parse_response_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_mediathek_rss_container_finalize (GObject* obj);


RygelMediathekRssContainer* rygel_mediathek_rss_container_construct (GType object_type, RygelMediaContainer* parent, guint id) {
	RygelMediathekRssContainer * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = g_strdup_printf ("GroupId:%u", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("ZDF Mediathek RSS feed %u", id);
	_tmp3_ = _tmp2_;
	self = (RygelMediathekRssContainer*) rygel_simple_container_construct (object_type, _tmp1_, parent, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	self->priv->content_id = id;
	_tmp4_ = g_strdup_printf (RYGEL_MEDIATHEK_RSS_CONTAINER_uri_template, id);
	_tmp5_ = _tmp4_;
	_g_free0 (self->priv->feed_uri);
	self->priv->feed_uri = _tmp5_;
	rygel_mediathek_rss_container_update (self, NULL, NULL);
	return self;
}


RygelMediathekRssContainer* rygel_mediathek_rss_container_new (RygelMediaContainer* parent, guint id) {
	return rygel_mediathek_rss_container_construct (RYGEL_MEDIATHEK_TYPE_RSS_CONTAINER, parent, id);
}


static void rygel_mediathek_rss_container_update_data_free (gpointer _data) {
	RygelMediathekRssContainerUpdateData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediathekRssContainerUpdateData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_mediathek_rss_container_update (RygelMediathekRssContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekRssContainerUpdateData* _data_;
	_data_ = g_slice_new0 (RygelMediathekRssContainerUpdateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_rss_container_update);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_rss_container_update_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_mediathek_rss_container_update_co (_data_);
}


void rygel_mediathek_rss_container_update_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_) {
	RygelMediathekRssContainerUpdateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _rygel_mediathek_rss_container_update_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_mediathek_rss_container_update_co (self);
	return result;
}


static void _lambda1_ (Block2Data* _data2_) {
	RygelMediathekRssContainer * self;
	self = _data2_->self;
	_data2_->callback (_data2_->callback_target);
}


static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	_lambda1_ (self);
}


static void rygel_mediathek_rss_container_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediathekRssContainerUpdateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_mediathek_rss_container_update_co (data);
}


static gboolean rygel_mediathek_rss_container_update_co (RygelMediathekRssContainerUpdateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data2_ = g_slice_new0 (Block2Data);
	data->_data2_->_ref_count_ = 1;
	data->_data2_->self = g_object_ref (data->self);
	data->_data2_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_mediathek_rss_container_get_update_message (data->self);
	data->message = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_mediathek_root_container_get_default_session ();
	data->session = data->_tmp1_;
	data->_data2_->callback = _rygel_mediathek_rss_container_update_co_gsource_func;
	data->_data2_->callback_target = data;
	data->_data2_->callback_target_destroy_notify = NULL;
	data->_tmp2_ = _g_object_ref0 (data->message);
	soup_session_queue_message ((SoupSession*) data->session, data->_tmp2_, __lambda1__soup_session_callback, data->_data2_);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	switch ((g_object_get (data->message, "status-code", &data->_tmp3_, NULL), data->_tmp3_)) {
		case 304:
		{
			data->_tmp4_ = NULL;
			data->_tmp4_ = soup_message_get_uri (data->message);
			data->_tmp5_ = NULL;
			data->_tmp5_ = soup_uri_to_string (data->_tmp4_, FALSE);
			data->_tmp6_ = data->_tmp5_;
			g_debug ("rygel-mediathek-rss-container.vala:55: Feed at %s did not change, noth" \
"ing to do.", data->_tmp6_);
			_g_free0 (data->_tmp6_);
			break;
		}
		case 200:
		{
			data->_state_ = 2;
			rygel_mediathek_rss_container_parse_response (data->self, data->message, rygel_mediathek_rss_container_update_ready, data);
			return FALSE;
			_state_2:
			data->_tmp7_ = rygel_mediathek_rss_container_parse_response_finish (data->self, data->_res_);
			data->success = data->_tmp7_;
			if (data->success) {
				data->_tmp8_ = NULL;
				data->_tmp8_ = soup_message_headers_get_one (data->message->response_headers, "Date");
				data->_tmp9_ = g_strdup (data->_tmp8_);
				data->date = data->_tmp9_;
				data->_tmp10_ = NULL;
				data->_tmp10_ = soup_date_new_from_string (data->date);
				data->_tmp11_ = data->_tmp10_;
				_soup_date_free0 (data->self->priv->last_modified);
				data->self->priv->last_modified = data->_tmp11_;
				_g_free0 (data->date);
			}
			break;
		}
		default:
		{
			data->_tmp13_ = NULL;
			data->_tmp13_ = soup_message_get_uri (data->message);
			data->_tmp14_ = NULL;
			data->_tmp14_ = soup_uri_to_string (data->_tmp13_, FALSE);
			data->_tmp15_ = data->_tmp14_;
			data->_tmp17_ = NULL;
			data->_tmp17_ = soup_status_get_phrase ((g_object_get (data->message, "status-code", &data->_tmp16_, NULL), data->_tmp16_));
			g_warning ("rygel-mediathek-rss-container.vala:67: Unexpected response %u for %s: " \
"%s", (g_object_get (data->message, "status-code", &data->_tmp12_, NULL), data->_tmp12_), data->_tmp15_, data->_tmp17_);
			_g_free0 (data->_tmp15_);
			break;
		}
	}
	_g_object_unref0 (data->session);
	_g_object_unref0 (data->message);
	block2_data_unref (data->_data2_);
	data->_data2_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_mediathek_rss_container_parse_response_data_free (gpointer _data) {
	RygelMediathekRssContainerParseResponseData* data;
	data = _data;
	_g_object_unref0 (data->message);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediathekRssContainerParseResponseData, data);
}


static void rygel_mediathek_rss_container_parse_response (RygelMediathekRssContainer* self, SoupMessage* message, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediathekRssContainerParseResponseData* _data_;
	_data_ = g_slice_new0 (RygelMediathekRssContainerParseResponseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_mediathek_rss_container_parse_response);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_mediathek_rss_container_parse_response_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->message = _g_object_ref0 (message);
	rygel_mediathek_rss_container_parse_response_co (_data_);
}


static gboolean rygel_mediathek_rss_container_parse_response_finish (RygelMediathekRssContainer* self, GAsyncResult* _res_) {
	gboolean result;
	RygelMediathekRssContainerParseResponseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void rygel_mediathek_rss_container_parse_response_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediathekRssContainerParseResponseData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_mediathek_rss_container_parse_response_co (data);
}


static gboolean rygel_mediathek_rss_container_parse_response_co (RygelMediathekRssContainerParseResponseData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_mediathek_video_item_factory_get_default ();
	data->factory = data->_tmp0_;
	data->response = data->message->response_body;
	data->_tmp1_ = NULL;
	data->_tmp1_ = xmlParseMemory ((const gchar*) data->response->data, (gint) data->response->length);
	data->doc = data->_tmp1_;
	if (data->doc == NULL) {
		g_warning ("rygel-mediathek-rss-container.vala:82: Failed to parse XML document");
		data->result = FALSE;
		_g_object_unref0 (data->factory);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = NULL;
	data->_tmp2_ = gupnp_xml_doc_new (data->doc);
	data->guard = data->_tmp2_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = xmlXPathNewContext (data->guard->doc);
	data->context = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = xmlXPathEval ("/rss/channel/title", data->context);
	data->xpath_object = data->_tmp4_;
	if (data->xpath_object->type == XPATH_NODESET) {
		data->_tmp6_ = xmlXPathNodeSetGetLength (data->xpath_object->nodesetval);
		data->_tmp5_ = data->_tmp6_ > 0;
	} else {
		data->_tmp5_ = FALSE;
	}
	if (data->_tmp5_) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = xmlXPathNodeSetItem (data->xpath_object->nodesetval, 0);
		data->_tmp8_ = NULL;
		data->_tmp8_ = xmlNodeGetContent (data->_tmp7_);
		data->_tmp9_ = data->_tmp8_;
		rygel_media_object_set_title ((RygelMediaObject*) data->self, data->_tmp9_);
		_g_free0 (data->_tmp9_);
	}
	xmlXPathFreeObject (data->xpath_object);
	data->_tmp10_ = NULL;
	data->_tmp10_ = xmlXPathEval ("/rss/channel/item", data->context);
	data->xpath_object = data->_tmp10_;
	if (data->xpath_object->type != XPATH_NODESET) {
		xmlXPathFreeObject (data->xpath_object);
		g_warning ("rygel-mediathek-rss-container.vala:100: RSS feed doesn't have items");
		data->result = FALSE;
		_xmlXPathFreeContext0 (data->context);
		_g_object_unref0 (data->guard);
		_g_object_unref0 (data->factory);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	gee_abstract_collection_clear ((GeeAbstractCollection*) ((RygelSimpleContainer*) data->self)->children);
	((RygelMediaContainer*) data->self)->child_count = 0;
	{
		data->i = 0;
		{
			data->_tmp11_ = TRUE;
			while (TRUE) {
				if (!data->_tmp11_) {
					data->i++;
				}
				data->_tmp11_ = FALSE;
				data->_tmp12_ = xmlXPathNodeSetGetLength (data->xpath_object->nodesetval);
				if (!(data->i < data->_tmp12_)) {
					break;
				}
				data->_tmp13_ = NULL;
				data->_tmp13_ = xmlXPathNodeSetItem (data->xpath_object->nodesetval, data->i);
				data->node = data->_tmp13_;
				data->_state_ = 1;
				rygel_mediathek_video_item_factory_create (data->factory, (RygelMediaContainer*) data->self, data->node, rygel_mediathek_rss_container_parse_response_ready, data);
				return FALSE;
				_state_1:
				data->_tmp14_ = NULL;
				data->_tmp14_ = rygel_mediathek_video_item_factory_create_finish (data->factory, data->_res_, &data->_inner_error_);
				data->item = data->_tmp14_;
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
						goto __catch5_rygel_mediathek_video_item_error;
					}
					_xmlXPathFreeContext0 (data->context);
					_g_object_unref0 (data->guard);
					_g_object_unref0 (data->factory);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				if (data->item != NULL) {
					rygel_simple_container_add_child_item ((RygelSimpleContainer*) data->self, (RygelMediaItem*) data->item);
				}
				_g_object_unref0 (data->item);
				goto __finally5;
				__catch5_rygel_mediathek_video_item_error:
				{
					data->_error_ = data->_inner_error_;
					data->_inner_error_ = NULL;
					g_warning ("rygel-mediathek-rss-container.vala:115: Error creating video item: %s", data->_error_->message);
					_g_error_free0 (data->_error_);
				}
				__finally5:
				if (data->_inner_error_ != NULL) {
					_xmlXPathFreeContext0 (data->context);
					_g_object_unref0 (data->guard);
					_g_object_unref0 (data->factory);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
			}
		}
	}
	xmlXPathFreeObject (data->xpath_object);
	rygel_media_container_updated ((RygelMediaContainer*) data->self);
	data->result = ((RygelMediaContainer*) data->self)->child_count > 0;
	_xmlXPathFreeContext0 (data->context);
	_g_object_unref0 (data->guard);
	_g_object_unref0 (data->factory);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_xmlXPathFreeContext0 (data->context);
	_g_object_unref0 (data->guard);
	_g_object_unref0 (data->factory);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static SoupMessage* rygel_mediathek_rss_container_get_update_message (RygelMediathekRssContainer* self) {
	SoupMessage* result = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* message;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = soup_message_new ("GET", self->priv->feed_uri);
	message = _tmp0_;
	if (self->priv->last_modified != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* datestring;
		_tmp1_ = soup_date_to_string (self->priv->last_modified, SOUP_DATE_HTTP);
		_tmp2_ = g_strdup (_tmp1_);
		datestring = _tmp2_;
		g_debug ("rygel-mediathek-rss-container.vala:131: Requesting change since %s", datestring);
		soup_message_headers_append (message->request_headers, "If-Modified-Since", datestring);
		_g_free0 (datestring);
	}
	result = message;
	return result;
}


static void rygel_mediathek_rss_container_class_init (RygelMediathekRssContainerClass * klass) {
	rygel_mediathek_rss_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediathekRssContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_mediathek_rss_container_finalize;
}


static void rygel_mediathek_rss_container_instance_init (RygelMediathekRssContainer * self) {
	self->priv = RYGEL_MEDIATHEK_RSS_CONTAINER_GET_PRIVATE (self);
	self->priv->last_modified = NULL;
}


static void rygel_mediathek_rss_container_finalize (GObject* obj) {
	RygelMediathekRssContainer * self;
	self = RYGEL_MEDIATHEK_RSS_CONTAINER (obj);
	_soup_date_free0 (self->priv->last_modified);
	_g_free0 (self->priv->feed_uri);
	G_OBJECT_CLASS (rygel_mediathek_rss_container_parent_class)->finalize (obj);
}


GType rygel_mediathek_rss_container_get_type (void) {
	static volatile gsize rygel_mediathek_rss_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_rss_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekRssContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_rss_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekRssContainer), 0, (GInstanceInitFunc) rygel_mediathek_rss_container_instance_init, NULL };
		GType rygel_mediathek_rss_container_type_id;
		rygel_mediathek_rss_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelMediathekRssContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mediathek_rss_container_type_id__volatile, rygel_mediathek_rss_container_type_id);
	}
	return rygel_mediathek_rss_container_type_id__volatile;
}



