/* rygel-external-item-factory.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-external-item-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
typedef struct _RygelExternalItemFactoryPrivate RygelExternalItemFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
typedef struct _RygelExternalItemFactoryCreateData RygelExternalItemFactoryCreateData;

#define RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY (rygel_external_album_art_factory_get_type ())
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactory))
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactoryClass))
#define RYGEL_EXTERNAL_IS_ALBUM_ART_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY))
#define RYGEL_EXTERNAL_IS_ALBUM_ART_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY))
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactoryClass))

typedef struct _RygelExternalAlbumArtFactory RygelExternalAlbumArtFactory;
typedef struct _RygelExternalAlbumArtFactoryClass RygelExternalAlbumArtFactoryClass;
#define _rygel_external_album_art_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_album_art_factory_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelExternalItemFactorySetMusicMetadataData RygelExternalItemFactorySetMusicMetadataData;

#define RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY (rygel_external_thumbnail_factory_get_type ())
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactory))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))
#define RYGEL_EXTERNAL_IS_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_IS_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))

typedef struct _RygelExternalThumbnailFactory RygelExternalThumbnailFactory;
typedef struct _RygelExternalThumbnailFactoryClass RygelExternalThumbnailFactoryClass;
#define _rygel_external_thumbnail_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_thumbnail_factory_unref (var), NULL)))
typedef struct _RygelExternalItemFactorySetVisualMetadataData RygelExternalItemFactorySetVisualMetadataData;
typedef struct _RygelExternalItemFactorySetVideoMetadataData RygelExternalItemFactorySetVideoMetadataData;
typedef struct _RygelExternalParamSpecItemFactory RygelExternalParamSpecItemFactory;

struct _RygelExternalItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalItemFactoryPrivate * priv;
};

struct _RygelExternalItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalItemFactory *self);
};

struct _RygelExternalItemFactoryCreateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	gchar* id;
	gchar* type;
	gchar* title;
	GHashTable* props;
	gchar* service_name;
	RygelMediaContainer* parent;
	RygelMediaItem* result;
	RygelMediaItem* item;
	gboolean _tmp0_;
	RygelAudioItem* _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMediaItem* _tmp3_;
	gboolean _tmp4_;
	RygelMusicItem* _tmp5_;
	RygelMediaItem* _tmp6_;
	RygelMediaItem* _tmp7_;
	gboolean _tmp8_;
	RygelVideoItem* _tmp9_;
	RygelMediaItem* _tmp10_;
	RygelMediaItem* _tmp11_;
	RygelImageItem* _tmp12_;
	RygelMediaItem* _tmp13_;
	RygelMediaItem* _tmp14_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetMusicMetadataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	RygelMusicItem* music;
	GHashTable* props;
	gchar* service_name;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gconstpointer _tmp6_;
	GVariant* _tmp7_;
	GVariant* value;
	RygelExternalAlbumArtFactory* _tmp8_;
	RygelExternalAlbumArtFactory* cover_factory;
	RygelThumbnail* _tmp9_;
	RygelThumbnail* _tmp10_;
	RygelThumbnail* _tmp11_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetVisualMetadataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	RygelVisualItem* visual;
	GHashTable* props;
	gchar* service_name;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gconstpointer _tmp5_;
	GVariant* _tmp6_;
	GVariant* value;
	RygelExternalThumbnailFactory* _tmp7_;
	RygelExternalThumbnailFactory* factory;
	RygelThumbnail* _tmp8_;
	RygelThumbnail* thumbnail;
	GeeArrayList* _tmp9_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetVideoMetadataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	RygelVideoItem* video;
	GHashTable* props;
	gchar* service_name;
	GError * _inner_error_;
};

struct _RygelExternalParamSpecItemFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_external_item_factory_parent_class = NULL;

gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_EXTERNAL_ITEM_FACTORY_DUMMY_PROPERTY
};
static void rygel_external_item_factory_create_data_free (gpointer _data);
void rygel_external_item_factory_create (RygelExternalItemFactory* self, const gchar* id, const gchar* type, const gchar* title, GHashTable* props, const gchar* service_name, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data);
static void rygel_external_item_factory_set_audio_metadata (RygelExternalItemFactory* self, RygelAudioItem* audio, GHashTable* props, const gchar* service_name, GError** error);
static void rygel_external_item_factory_set_music_metadata (RygelExternalItemFactory* self, RygelMusicItem* music, GHashTable* props, const gchar* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_item_factory_set_music_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_item_factory_set_video_metadata (RygelExternalItemFactory* self, RygelVideoItem* video, GHashTable* props, const gchar* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_item_factory_set_video_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_item_factory_set_visual_metadata (RygelExternalItemFactory* self, RygelVisualItem* visual, GHashTable* props, const gchar* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_item_factory_set_visual_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_item_factory_set_generic_metadata (RygelExternalItemFactory* self, RygelMediaItem* item, GHashTable* props, const gchar* service_name);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
static void rygel_external_item_factory_set_music_metadata_data_free (gpointer _data);
static gboolean rygel_external_item_factory_set_music_metadata_co (RygelExternalItemFactorySetMusicMetadataData* data);
static gchar* rygel_external_item_factory_get_string (RygelExternalItemFactory* self, GHashTable* props, const gchar* prop);
RygelExternalAlbumArtFactory* rygel_external_album_art_factory_new (void);
RygelExternalAlbumArtFactory* rygel_external_album_art_factory_construct (GType object_type);
gpointer rygel_external_album_art_factory_ref (gpointer instance);
void rygel_external_album_art_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_album_art_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_album_art_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_album_art_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_album_art_factory (const GValue* value);
GType rygel_external_album_art_factory_get_type (void) G_GNUC_CONST;
void rygel_external_album_art_factory_create (RygelExternalAlbumArtFactory* self, const gchar* service_name, const gchar* object_path, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelThumbnail* rygel_external_album_art_factory_create_finish (RygelExternalAlbumArtFactory* self, GAsyncResult* _res_, GError** error);
static const gchar* _variant_get10 (GVariant* value);
static void rygel_external_item_factory_set_music_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gint rygel_external_item_factory_get_int (RygelExternalItemFactory* self, GHashTable* props, const gchar* prop);
static void rygel_external_item_factory_set_visual_metadata_data_free (gpointer _data);
static gboolean rygel_external_item_factory_set_visual_metadata_co (RygelExternalItemFactorySetVisualMetadataData* data);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_new (void);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_construct (GType object_type);
gpointer rygel_external_thumbnail_factory_ref (gpointer instance);
void rygel_external_thumbnail_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_thumbnail_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_thumbnail_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_thumbnail_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_thumbnail_factory (const GValue* value);
GType rygel_external_thumbnail_factory_get_type (void) G_GNUC_CONST;
void rygel_external_thumbnail_factory_create (RygelExternalThumbnailFactory* self, const gchar* service_name, const gchar* object_path, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelThumbnail* rygel_external_thumbnail_factory_create_finish (RygelExternalThumbnailFactory* self, GAsyncResult* _res_, GError** error);
static const gchar* _variant_get11 (GVariant* value);
static void rygel_external_item_factory_set_visual_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_item_factory_set_video_metadata_data_free (gpointer _data);
static gboolean rygel_external_item_factory_set_video_metadata_co (RygelExternalItemFactorySetVideoMetadataData* data);
static void rygel_external_item_factory_set_video_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _variant_get12 (GVariant* value, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gint64 _variant_get13 (GVariant* value);
static const gchar* _variant_get14 (GVariant* value);
static gint _variant_get15 (GVariant* value);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void rygel_external_item_factory_create_data_free (gpointer _data) {
	RygelExternalItemFactoryCreateData* data;
	data = _data;
	_g_free0 (data->id);
	_g_free0 (data->type);
	_g_free0 (data->title);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	_rygel_external_item_factory_unref0 (data->self);
	g_slice_free (RygelExternalItemFactoryCreateData, data);
}


static gpointer _rygel_external_item_factory_ref0 (gpointer self) {
	return self ? rygel_external_item_factory_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_external_item_factory_create (RygelExternalItemFactory* self, const gchar* id, const gchar* type, const gchar* title, GHashTable* props, const gchar* service_name, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_create_data_free);
	_data_->self = _rygel_external_item_factory_ref0 (self);
	_data_->id = g_strdup (id);
	_data_->type = g_strdup (type);
	_data_->title = g_strdup (title);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_item_factory_create_co (_data_);
}


RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMediaItem* result;
	RygelExternalItemFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_item_factory_create_co (data);
}


static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = g_str_has_prefix (data->type, "audio");
	if (data->_tmp0_) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = rygel_audio_item_new (data->id, data->parent, data->title, RYGEL_AUDIO_ITEM_UPNP_CLASS);
		data->_tmp2_ = (RygelMediaItem*) data->_tmp1_;
		_g_object_unref0 (data->item);
		data->item = data->_tmp2_;
		rygel_external_item_factory_set_audio_metadata (data->self, (data->_tmp3_ = data->item, RYGEL_IS_AUDIO_ITEM (data->_tmp3_) ? ((RygelAudioItem*) data->_tmp3_) : NULL), data->props, data->service_name, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->item);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	} else {
		data->_tmp4_ = g_str_has_prefix (data->type, "music");
		if (data->_tmp4_) {
			data->_tmp5_ = NULL;
			data->_tmp5_ = rygel_music_item_new (data->id, data->parent, data->title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
			data->_tmp6_ = (RygelMediaItem*) data->_tmp5_;
			_g_object_unref0 (data->item);
			data->item = data->_tmp6_;
			data->_state_ = 1;
			rygel_external_item_factory_set_music_metadata (data->self, (data->_tmp7_ = data->item, RYGEL_IS_MUSIC_ITEM (data->_tmp7_) ? ((RygelMusicItem*) data->_tmp7_) : NULL), data->props, data->service_name, rygel_external_item_factory_create_ready, data);
			return FALSE;
			_state_1:
			rygel_external_item_factory_set_music_metadata_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->item);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->_tmp8_ = g_str_has_prefix (data->type, "video");
			if (data->_tmp8_) {
				data->_tmp9_ = NULL;
				data->_tmp9_ = rygel_video_item_new (data->id, data->parent, data->title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				data->_tmp10_ = (RygelMediaItem*) data->_tmp9_;
				_g_object_unref0 (data->item);
				data->item = data->_tmp10_;
				data->_state_ = 2;
				rygel_external_item_factory_set_video_metadata (data->self, (data->_tmp11_ = data->item, RYGEL_IS_VIDEO_ITEM (data->_tmp11_) ? ((RygelVideoItem*) data->_tmp11_) : NULL), data->props, data->service_name, rygel_external_item_factory_create_ready, data);
				return FALSE;
				_state_2:
				rygel_external_item_factory_set_video_metadata_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->item);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				data->_tmp12_ = NULL;
				data->_tmp12_ = rygel_image_item_new (data->id, data->parent, data->title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
				data->_tmp13_ = (RygelMediaItem*) data->_tmp12_;
				_g_object_unref0 (data->item);
				data->item = data->_tmp13_;
				data->_state_ = 3;
				rygel_external_item_factory_set_visual_metadata (data->self, (data->_tmp14_ = data->item, RYGEL_IS_VISUAL_ITEM (data->_tmp14_) ? ((RygelVisualItem*) data->_tmp14_) : NULL), data->props, data->service_name, rygel_external_item_factory_create_ready, data);
				return FALSE;
				_state_3:
				rygel_external_item_factory_set_visual_metadata_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->item);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
		}
	}
	rygel_external_item_factory_set_generic_metadata (data->self, data->item, data->props, data->service_name);
	if (RYGEL_EXTERNAL_IS_DUMMY_CONTAINER (data->parent)) {
		rygel_media_object_set_parent_ref ((RygelMediaObject*) data->item, data->parent);
	}
	data->result = data->item;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->item);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_item_factory_set_music_metadata_data_free (gpointer _data) {
	RygelExternalItemFactorySetMusicMetadataData* data;
	data = _data;
	_g_object_unref0 (data->music);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_rygel_external_item_factory_unref0 (data->self);
	g_slice_free (RygelExternalItemFactorySetMusicMetadataData, data);
}


static void rygel_external_item_factory_set_music_metadata (RygelExternalItemFactory* self, RygelMusicItem* music, GHashTable* props, const gchar* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetMusicMetadataData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_set_music_metadata);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_set_music_metadata_data_free);
	_data_->self = _rygel_external_item_factory_ref0 (self);
	_data_->music = _g_object_ref0 (music);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	rygel_external_item_factory_set_music_metadata_co (_data_);
}


static void rygel_external_item_factory_set_music_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static const gchar* _variant_get10 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static void rygel_external_item_factory_set_music_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactorySetMusicMetadataData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_item_factory_set_music_metadata_co (data);
}


static gboolean rygel_external_item_factory_set_music_metadata_co (RygelExternalItemFactorySetMusicMetadataData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_external_item_factory_get_string (data->self, data->props, "Artist");
	data->_tmp1_ = data->_tmp0_;
	_g_free0 (data->music->artist);
	data->music->artist = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = rygel_external_item_factory_get_string (data->self, data->props, "Album");
	data->_tmp3_ = data->_tmp2_;
	_g_free0 (data->music->album);
	data->music->album = data->_tmp3_;
	data->_tmp4_ = NULL;
	data->_tmp4_ = rygel_external_item_factory_get_string (data->self, data->props, "Genre");
	data->_tmp5_ = data->_tmp4_;
	_g_free0 (data->music->genre);
	data->music->genre = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_hash_table_lookup (data->props, "AlbumArt");
	data->_tmp7_ = _g_variant_ref0 ((GVariant*) data->_tmp6_);
	data->value = data->_tmp7_;
	if (data->value != NULL) {
		data->_tmp8_ = NULL;
		data->_tmp8_ = rygel_external_album_art_factory_new ();
		data->cover_factory = data->_tmp8_;
		data->_state_ = 1;
		rygel_external_album_art_factory_create (data->cover_factory, _variant_get10 (data->value), data->service_name, rygel_external_item_factory_set_music_metadata_ready, data);
		return FALSE;
		_state_1:
		data->_tmp9_ = NULL;
		data->_tmp9_ = rygel_external_album_art_factory_create_finish (data->cover_factory, data->_res_, &data->_inner_error_);
		data->_tmp10_ = data->_tmp9_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_external_album_art_factory_unref0 (data->cover_factory);
			_g_variant_unref0 (data->value);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp11_ = data->_tmp10_;
		_rygel_icon_info_unref0 (data->music->album_art);
		data->music->album_art = data->_tmp11_;
		_rygel_external_album_art_factory_unref0 (data->cover_factory);
	}
	rygel_external_item_factory_set_audio_metadata (data->self, (RygelAudioItem*) data->music, data->props, data->service_name, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_variant_unref0 (data->value);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_variant_unref0 (data->value);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_item_factory_set_audio_metadata (RygelExternalItemFactory* self, RygelAudioItem* audio, GHashTable* props, const gchar* service_name, GError** error) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (audio != NULL);
	g_return_if_fail (props != NULL);
	g_return_if_fail (service_name != NULL);
	_tmp0_ = rygel_external_item_factory_get_int (self, props, "Duration");
	audio->duration = (glong) _tmp0_;
	_tmp1_ = rygel_external_item_factory_get_int (self, props, "Bitrate");
	audio->bitrate = _tmp1_;
	_tmp2_ = rygel_external_item_factory_get_int (self, props, "SampleRate");
	audio->sample_freq = _tmp2_;
	_tmp3_ = rygel_external_item_factory_get_int (self, props, "BitsPerSample");
	audio->bits_per_sample = _tmp3_;
}


static void rygel_external_item_factory_set_visual_metadata_data_free (gpointer _data) {
	RygelExternalItemFactorySetVisualMetadataData* data;
	data = _data;
	_g_object_unref0 (data->visual);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_rygel_external_item_factory_unref0 (data->self);
	g_slice_free (RygelExternalItemFactorySetVisualMetadataData, data);
}


static void rygel_external_item_factory_set_visual_metadata (RygelExternalItemFactory* self, RygelVisualItem* visual, GHashTable* props, const gchar* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetVisualMetadataData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_set_visual_metadata);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_set_visual_metadata_data_free);
	_data_->self = _rygel_external_item_factory_ref0 (self);
	_data_->visual = _g_object_ref0 (visual);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	rygel_external_item_factory_set_visual_metadata_co (_data_);
}


static void rygel_external_item_factory_set_visual_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static const gchar* _variant_get11 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static void rygel_external_item_factory_set_visual_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactorySetVisualMetadataData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_item_factory_set_visual_metadata_co (data);
}


static gboolean rygel_external_item_factory_set_visual_metadata_co (RygelExternalItemFactorySetVisualMetadataData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = rygel_external_item_factory_get_int (data->self, data->props, "Width");
	rygel_visual_item_set_width (data->visual, data->_tmp0_);
	data->_tmp1_ = rygel_external_item_factory_get_int (data->self, data->props, "Height");
	rygel_visual_item_set_height (data->visual, data->_tmp1_);
	data->_tmp2_ = rygel_external_item_factory_get_int (data->self, data->props, "ColorDepth");
	rygel_visual_item_set_color_depth (data->visual, data->_tmp2_);
	data->_tmp3_ = rygel_external_item_factory_get_int (data->self, data->props, "PixelWidth");
	rygel_visual_item_set_pixel_width (data->visual, data->_tmp3_);
	data->_tmp4_ = rygel_external_item_factory_get_int (data->self, data->props, "PixelHeight");
	rygel_visual_item_set_pixel_height (data->visual, data->_tmp4_);
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_hash_table_lookup (data->props, "Thumbnail");
	data->_tmp6_ = _g_variant_ref0 ((GVariant*) data->_tmp5_);
	data->value = data->_tmp6_;
	if (data->value != NULL) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = rygel_external_thumbnail_factory_new ();
		data->factory = data->_tmp7_;
		data->_state_ = 1;
		rygel_external_thumbnail_factory_create (data->factory, _variant_get11 (data->value), data->service_name, rygel_external_item_factory_set_visual_metadata_ready, data);
		return FALSE;
		_state_1:
		data->_tmp8_ = NULL;
		data->_tmp8_ = rygel_external_thumbnail_factory_create_finish (data->factory, data->_res_, &data->_inner_error_);
		data->thumbnail = data->_tmp8_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_external_thumbnail_factory_unref0 (data->factory);
			_g_variant_unref0 (data->value);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp9_ = NULL;
		data->_tmp9_ = rygel_visual_item_get_thumbnails (data->visual);
		gee_abstract_collection_add ((GeeAbstractCollection*) data->_tmp9_, data->thumbnail);
		_rygel_icon_info_unref0 (data->thumbnail);
		_rygel_external_thumbnail_factory_unref0 (data->factory);
	}
	_g_variant_unref0 (data->value);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_external_item_factory_set_video_metadata_data_free (gpointer _data) {
	RygelExternalItemFactorySetVideoMetadataData* data;
	data = _data;
	_g_object_unref0 (data->video);
	_g_hash_table_unref0 (data->props);
	_g_free0 (data->service_name);
	_rygel_external_item_factory_unref0 (data->self);
	g_slice_free (RygelExternalItemFactorySetVideoMetadataData, data);
}


static void rygel_external_item_factory_set_video_metadata (RygelExternalItemFactory* self, RygelVideoItem* video, GHashTable* props, const gchar* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetVideoMetadataData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_item_factory_set_video_metadata);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_set_video_metadata_data_free);
	_data_->self = _rygel_external_item_factory_ref0 (self);
	_data_->video = _g_object_ref0 (video);
	_data_->props = _g_hash_table_ref0 (props);
	_data_->service_name = g_strdup (service_name);
	rygel_external_item_factory_set_video_metadata_co (_data_);
}


static void rygel_external_item_factory_set_video_metadata_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_item_factory_set_video_metadata_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactorySetVideoMetadataData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_item_factory_set_video_metadata_co (data);
}


static gboolean rygel_external_item_factory_set_video_metadata_co (RygelExternalItemFactorySetVideoMetadataData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	rygel_external_item_factory_set_visual_metadata (data->self, (RygelVisualItem*) data->video, data->props, data->service_name, rygel_external_item_factory_set_video_metadata_ready, data);
	return FALSE;
	_state_1:
	rygel_external_item_factory_set_visual_metadata_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	rygel_external_item_factory_set_audio_metadata (data->self, (RygelAudioItem*) data->video, data->props, data->service_name, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar** _variant_get12 (GVariant* value, int* result_length1) {
	gchar** _tmp4_;
	int _tmp4__length;
	int _tmp4__size;
	int _tmp4__length1;
	GVariantIter _tmp5_;
	GVariant* _tmp6_;
	_tmp4_ = g_new (gchar*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
	g_variant_iter_init (&_tmp5_, value);
	for (; (_tmp6_ = g_variant_iter_next_value (&_tmp5_)) != NULL; _tmp4__length1++) {
		if (_tmp4__size == _tmp4__length) {
			_tmp4__size = 2 * _tmp4__size;
			_tmp4_ = g_renew (gchar*, _tmp4_, _tmp4__size + 1);
		}
		_tmp4_[_tmp4__length++] = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
	}
	*result_length1 = _tmp4__length1;
	_tmp4_[_tmp4__length] = NULL;
	return _tmp4_;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gint64 _variant_get13 (GVariant* value) {
	return g_variant_get_int64 (value);
}


static void rygel_external_item_factory_set_generic_metadata (RygelExternalItemFactory* self, RygelMediaItem* item, GHashTable* props, const gchar* service_name) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gconstpointer _tmp12_ = NULL;
	GVariant* _tmp13_;
	GVariant* value;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (props != NULL);
	g_return_if_fail (service_name != NULL);
	_tmp0_ = rygel_external_item_factory_get_string (self, props, "MIMEType");
	_tmp1_ = _tmp0_;
	_g_free0 (item->mime_type);
	item->mime_type = _tmp1_;
	_tmp2_ = g_hash_table_lookup (props, "URLs");
	_tmp7_ = (_tmp8_ = _variant_get12 ((GVariant*) _tmp2_, &_tmp3_), (_tmp8_ == NULL) ? ((gpointer) _tmp8_) : _vala_array_dup2 (_tmp8_, _tmp3_));
	uris = _tmp7_;
	uris_length1 = _tmp3_;
	_uris_size_ = _tmp3_;
	if (uris != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					if (!_tmp9_) {
						i++;
					}
					_tmp9_ = FALSE;
					if (!(uris[i] != NULL)) {
						break;
					}
					rygel_media_item_add_uri (item, uris[i]);
				}
			}
		}
	}
	_tmp10_ = rygel_external_item_factory_get_string (self, props, "DLNAProfile");
	_tmp11_ = _tmp10_;
	_g_free0 (item->dlna_profile);
	item->dlna_profile = _tmp11_;
	_tmp12_ = g_hash_table_lookup (props, "Size");
	_tmp13_ = _g_variant_ref0 ((GVariant*) _tmp12_);
	value = _tmp13_;
	if (value != NULL) {
		rygel_media_item_set_size (item, _variant_get13 (value));
	}
	_tmp14_ = rygel_external_item_factory_get_string (self, props, "Date");
	_tmp15_ = _tmp14_;
	_g_free0 (item->date);
	item->date = _tmp15_;
	_g_variant_unref0 (value);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}


static const gchar* _variant_get14 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar* rygel_external_item_factory_get_string (RygelExternalItemFactory* self, GHashTable* props, const gchar* prop) {
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	GVariant* _tmp1_;
	GVariant* value;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (props != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (props, prop);
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	value = _tmp1_;
	if (value != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_variant_get14 (value));
		result = _tmp2_;
		_g_variant_unref0 (value);
		return result;
	} else {
		result = NULL;
		_g_variant_unref0 (value);
		return result;
	}
	_g_variant_unref0 (value);
}


static gint _variant_get15 (GVariant* value) {
	return g_variant_get_int32 (value);
}


static gint rygel_external_item_factory_get_int (RygelExternalItemFactory* self, GHashTable* props, const gchar* prop) {
	gint result = 0;
	gconstpointer _tmp0_ = NULL;
	GVariant* _tmp1_;
	GVariant* value;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (props != NULL, 0);
	g_return_val_if_fail (prop != NULL, 0);
	_tmp0_ = g_hash_table_lookup (props, prop);
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	value = _tmp1_;
	if (value != NULL) {
		result = _variant_get15 (value);
		_g_variant_unref0 (value);
		return result;
	} else {
		result = -1;
		_g_variant_unref0 (value);
		return result;
	}
	_g_variant_unref0 (value);
}


RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type) {
	RygelExternalItemFactory* self = NULL;
	self = (RygelExternalItemFactory*) g_type_create_instance (object_type);
	return self;
}


RygelExternalItemFactory* rygel_external_item_factory_new (void) {
	return rygel_external_item_factory_construct (RYGEL_EXTERNAL_TYPE_ITEM_FACTORY);
}


static void rygel_external_value_item_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_external_value_item_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_item_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_external_value_item_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_item_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_external_value_item_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_external_value_item_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalItemFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_item_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_external_value_item_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalItemFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_item_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelExternalParamSpecItemFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_external_value_get_item_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_external_value_set_item_factory (GValue* value, gpointer v_object) {
	RygelExternalItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_item_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


void rygel_external_value_take_item_factory (GValue* value, gpointer v_object) {
	RygelExternalItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


static void rygel_external_item_factory_class_init (RygelExternalItemFactoryClass * klass) {
	rygel_external_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_ITEM_FACTORY_CLASS (klass)->finalize = rygel_external_item_factory_finalize;
}


static void rygel_external_item_factory_instance_init (RygelExternalItemFactory * self) {
	self->ref_count = 1;
}


static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj) {
	RygelExternalItemFactory * self;
	self = RYGEL_EXTERNAL_ITEM_FACTORY (obj);
}


/**
 * Creates item for external plugins.
 */
GType rygel_external_item_factory_get_type (void) {
	static volatile gsize rygel_external_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_item_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_external_value_item_factory_init, rygel_external_value_item_factory_free_value, rygel_external_value_item_factory_copy_value, rygel_external_value_item_factory_peek_pointer, "p", rygel_external_value_item_factory_collect_value, "p", rygel_external_value_item_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalItemFactory), 0, (GInstanceInitFunc) rygel_external_item_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_item_factory_type_id;
		rygel_external_item_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalItemFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_external_item_factory_type_id__volatile, rygel_external_item_factory_type_id);
	}
	return rygel_external_item_factory_type_id__volatile;
}


gpointer rygel_external_item_factory_ref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_item_factory_unref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



