/* rygel-item-creator.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;
typedef struct _RygelItemCreatorParseArgsData RygelItemCreatorParseArgsData;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelItemCreatorCreateUriData RygelItemCreatorCreateUriData;
typedef struct _Block5Data Block5Data;
typedef struct _RygelItemCreatorWaitForItemData RygelItemCreatorWaitForItemData;

typedef enum  {
	RYGEL_ITEM_CREATOR_ERROR_PARSE
} RygelItemCreatorError;
#define RYGEL_ITEM_CREATOR_ERROR rygel_item_creator_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelItemCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* message;
	GError* _tmp2_;
	RygelWritableContainer* _tmp3_;
	RygelWritableContainer* container;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	RygelMediaItem* _tmp7_;
	RygelMediaItem* _tmp8_;
	RygelMediaItem* _tmp9_;
	GList* _tmp10_;
	GList* resources;
	gboolean _tmp11_;
	guint _tmp12_;
	GList* _tmp13_;
	GUPnPDIDLLiteResource* _tmp14_;
	GUPnPDIDLLiteResource* resource;
	GUPnPProtocolInfo* _tmp15_;
	GUPnPProtocolInfo* _tmp16_;
	GUPnPProtocolInfo* info;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_;
	const gchar* _tmp27_;
	glong _tmp28_;
	glong _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gint64 _tmp32_;
	gint _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* uri;
	gpointer _tmp36_;
	gchar* _tmp37_;
	GCancellable* _tmp38_;
	GUPnPDIDLLiteObject* _tmp39_;
	GUPnPDIDLLiteObject* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	RygelItemRemovalQueue* _tmp43_;
	RygelItemRemovalQueue* queue;
	GCancellable* _tmp44_;
	GError * err;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemCreatorParseArgsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	const gchar* _tmp0_;
	GError* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	guint total_matches;
	GCancellable* _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* _result_;
	gint _tmp9_;
	gpointer _tmp10_;
	RygelMediaObject* _tmp11_;
	GCancellable* _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelMediaObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	gboolean _tmp18_;
	GUPnPOCMFlags _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	RygelMediaObject* _tmp22_;
	RygelWritableContainer* _tmp23_;
	GError * _inner_error_;
};

struct _RygelItemCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	GCancellable* _tmp0_;
	GFile* _tmp1_;
	GFile* dir;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	gchar* _tmp5_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	RygelItemCreator * self;
	gpointer _async_data_;
};

struct _RygelItemCreatorWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	Block5Data* _data5_;
	gboolean not_added;
	gulong id;
	GCancellable* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* item;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer rygel_item_creator_parent_class = NULL;
static GPatternSpec* rygel_item_creator_comment_pattern;
static GPatternSpec* rygel_item_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GQuark rygel_item_creator_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void _lambda9_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self);
static void __lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_item_creator_conclude (RygelItemCreator* self);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
static void rygel_item_creator_parse_args_data_free (gpointer _data);
static void rygel_item_creator_parse_args_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static void rygel_item_creator_create_uri_data_free (gpointer _data);
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_wait_for_item_data_free (gpointer _data);
static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* data);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda10_ (RygelMediaContainer* container, Block5Data* _data5_);
static void __lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static void rygel_item_creator_finalize (GObject* obj);
static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_item_creator_error_quark (void) {
	return g_quark_from_static_string ("rygel_item_creator_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	GUPnPDIDLLiteWriter* _tmp3_ = NULL;
	GUPnPDIDLLiteWriter* _tmp4_;
	GUPnPDIDLLiteParser* _tmp5_ = NULL;
	GUPnPDIDLLiteParser* _tmp6_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp1_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
	_tmp2_ = action;
	action = NULL;
	self->priv->action = _tmp2_;
	_tmp3_ = gupnp_didl_lite_writer_new (NULL);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->didl_writer);
	self->priv->didl_writer = _tmp4_;
	_tmp5_ = gupnp_didl_lite_parser_new ();
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->priv->didl_parser);
	self->priv->didl_parser = _tmp6_;
	return self;
}


RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorRunData, data);
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	self = (RygelItemCreator*) base;
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_creator_real_run_co (_data_);
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_real_run_co (data);
}


static void _lambda9_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self) {
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = _g_object_ref0 (didl_item);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->didl_item);
	self->didl_item = _tmp1_;
}


static void __lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
	_lambda9_ (item, self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	rygel_item_creator_parse_args (data->self, NULL, NULL);
	g_signal_connect_object (data->self->priv->didl_parser, "item-available", (GCallback) __lambda9__gupnp_didl_lite_parser_item_available, data->self, 0);
	gupnp_didl_lite_parser_parse_didl (data->self->priv->didl_parser, data->self->elements, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch59_g_error;
	}
	if (data->self->didl_item == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("No items in DIDL-Lite from client: '%s'");
		data->_tmp1_ = g_strdup (data->_tmp0_);
		data->message = data->_tmp1_;
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_error_new (RYGEL_ITEM_CREATOR_ERROR, RYGEL_ITEM_CREATOR_ERROR_PARSE, data->message, data->self->elements);
		data->_inner_error_ = data->_tmp2_;
		_g_free0 (data->message);
		goto __catch59_g_error;
	}
	data->_state_ = 1;
	rygel_item_creator_fetch_container (data->self, rygel_item_creator_run_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = NULL;
	data->_tmp3_ = rygel_item_creator_fetch_container_finish (data->self, data->_res_, &data->_inner_error_);
	data->container = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		goto __catch59_g_error;
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->_tmp5_ = NULL;
	data->_tmp5_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->_tmp6_ = NULL;
	data->_tmp6_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->_tmp7_ = NULL;
	data->_tmp7_ = rygel_item_creator_create_item (data->self, data->_tmp4_, data->container, data->_tmp5_, data->_tmp6_, &data->_inner_error_);
	data->_tmp8_ = data->_tmp7_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->container);
		goto __catch59_g_error;
	}
	data->_tmp9_ = data->_tmp8_;
	_g_object_unref0 (data->self->item);
	data->self->item = data->_tmp9_;
	data->_tmp10_ = NULL;
	data->_tmp10_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->resources = data->_tmp10_;
	if (data->resources != NULL) {
		data->_tmp12_ = g_list_length (data->resources);
		data->_tmp11_ = data->_tmp12_ > 0;
	} else {
		data->_tmp11_ = FALSE;
	}
	if (data->_tmp11_) {
		data->_tmp13_ = NULL;
		data->_tmp13_ = g_list_nth (data->resources, (guint) 0);
		data->_tmp14_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) data->_tmp13_->data);
		data->resource = data->_tmp14_;
		data->_tmp15_ = NULL;
		data->_tmp15_ = gupnp_didl_lite_resource_get_protocol_info (data->resource);
		data->_tmp16_ = _g_object_ref0 (data->_tmp15_);
		data->info = data->_tmp16_;
		if (data->info != NULL) {
			data->_tmp17_ = NULL;
			data->_tmp17_ = gupnp_protocol_info_get_dlna_profile (data->info);
			if (data->_tmp17_ != NULL) {
				data->_tmp18_ = NULL;
				data->_tmp18_ = gupnp_protocol_info_get_dlna_profile (data->info);
				data->_tmp19_ = g_strdup (data->_tmp18_);
				data->_tmp20_ = data->_tmp19_;
				_g_free0 (data->self->item->dlna_profile);
				data->self->item->dlna_profile = data->_tmp20_;
			}
			data->_tmp21_ = NULL;
			data->_tmp21_ = gupnp_protocol_info_get_mime_type (data->info);
			if (data->_tmp21_ != NULL) {
				data->_tmp22_ = NULL;
				data->_tmp22_ = gupnp_protocol_info_get_mime_type (data->info);
				data->_tmp23_ = g_strdup (data->_tmp22_);
				data->_tmp24_ = data->_tmp23_;
				_g_free0 (data->self->item->mime_type);
				data->self->item->mime_type = data->_tmp24_;
			}
		}
		data->_tmp25_ = NULL;
		data->_tmp25_ = gupnp_didl_lite_resource_get_uri (data->resource);
		data->_tmp26_ = rygel_item_creator_is_valid_uri (data->self, data->_tmp25_);
		if (data->_tmp26_) {
			data->_tmp27_ = NULL;
			data->_tmp27_ = gupnp_didl_lite_resource_get_uri (data->resource);
			rygel_media_item_add_uri (data->self->item, data->_tmp27_);
		}
		data->_tmp28_ = gupnp_didl_lite_resource_get_size (data->resource);
		if (data->_tmp28_ >= 0) {
			data->_tmp29_ = gupnp_didl_lite_resource_get_size (data->resource);
			rygel_media_item_set_size (data->self->item, (gint64) data->_tmp29_);
		}
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->resource);
	}
	if (data->self->item->mime_type == NULL) {
		data->_tmp30_ = NULL;
		data->_tmp30_ = rygel_item_creator_get_generic_mime_type (data->self);
		data->_tmp31_ = data->_tmp30_;
		_g_free0 (data->self->item->mime_type);
		data->self->item->mime_type = data->_tmp31_;
	}
	data->_tmp32_ = rygel_media_item_get_size (data->self->item);
	if (data->_tmp32_ < 0) {
		rygel_media_item_set_size (data->self->item, (gint64) 0);
	}
	data->_tmp33_ = gee_collection_get_size ((GeeCollection*) ((RygelMediaObject*) data->self->item)->uris);
	if (data->_tmp33_ == 0) {
		data->_tmp34_ = NULL;
		data->_tmp34_ = rygel_media_object_get_title ((RygelMediaObject*) data->self->item);
		data->_state_ = 2;
		rygel_item_creator_create_uri (data->self, data->container, data->_tmp34_, rygel_item_creator_run_ready, data);
		return FALSE;
		_state_2:
		data->_tmp35_ = NULL;
		data->_tmp35_ = rygel_item_creator_create_uri_finish (data->self, data->_res_, &data->_inner_error_);
		data->uri = data->_tmp35_;
		if (data->_inner_error_ != NULL) {
			__g_list_free__g_object_unref0_0 (data->resources);
			_g_object_unref0 (data->container);
			goto __catch59_g_error;
		}
		gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) data->self->item)->uris, data->uri);
		_g_free0 (data->uri);
	}
	data->_tmp36_ = NULL;
	data->_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) data->self->item)->uris, 0);
	data->_tmp37_ = (gchar*) data->_tmp36_;
	_g_free0 (((RygelMediaObject*) data->self->item)->id);
	((RygelMediaObject*) data->self->item)->id = data->_tmp37_;
	data->_tmp38_ = NULL;
	data->_tmp38_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 3;
	rygel_writable_container_add_item (data->container, data->self->item, data->_tmp38_, rygel_item_creator_run_ready, data);
	return FALSE;
	_state_3:
	rygel_writable_container_add_item_finish (data->container, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (data->resources);
		_g_object_unref0 (data->container);
		goto __catch59_g_error;
	}
	data->_state_ = 4;
	rygel_item_creator_wait_for_item (data->self, data->container, rygel_item_creator_run_ready, data);
	return FALSE;
	_state_4:
	rygel_item_creator_wait_for_item_finish (data->self, data->_res_);
	data->_tmp39_ = NULL;
	data->_tmp39_ = rygel_media_object_serialize ((RygelMediaObject*) data->self->item, data->self->priv->didl_writer, data->self->priv->content_dir->http_server, &data->_inner_error_);
	data->_tmp40_ = data->_tmp39_;
	data->_tmp40_;
	_g_object_unref0 (data->_tmp40_);
	if (data->_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (data->resources);
		_g_object_unref0 (data->container);
		goto __catch59_g_error;
	}
	rygel_item_creator_conclude (data->self);
	if (g_strcmp0 (data->self->container_id, "DLNA.ORG_AnyContainer") == 0) {
		data->_tmp42_ = rygel_media_item_get_place_holder (data->self->item);
		data->_tmp41_ = data->_tmp42_;
	} else {
		data->_tmp41_ = FALSE;
	}
	if (data->_tmp41_) {
		data->_tmp43_ = NULL;
		data->_tmp43_ = rygel_item_removal_queue_get_default ();
		data->queue = data->_tmp43_;
		data->_tmp44_ = NULL;
		data->_tmp44_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		rygel_item_removal_queue_queue (data->queue, data->self->item, data->_tmp44_);
		_g_object_unref0 (data->queue);
	}
	__g_list_free__g_object_unref0_0 (data->resources);
	_g_object_unref0 (data->container);
	goto __finally59;
	__catch59_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		rygel_item_creator_handle_error (data->self, data->err);
		_g_error_free0 (data->err);
	}
	__finally59:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_parse_args_data_free (gpointer _data) {
	RygelItemCreatorParseArgsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorParseArgsData, data);
}


static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorParseArgsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_parse_args);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_parse_args_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_creator_parse_args_co (_data_);
}


static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorParseArgsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_parse_args_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_parse_args_co (data);
}


static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	gupnp_service_action_get (data->self->priv->action, "ContainerID", G_TYPE_STRING, &data->self->container_id, "Elements", G_TYPE_STRING, &data->self->elements, NULL);
	if (data->self->elements == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("'Elements' argument missing.");
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, data->_tmp0_);
		data->_inner_error_ = data->_tmp1_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp2_ = g_pattern_match_string (rygel_item_creator_comment_pattern, data->self->elements);
		if (data->_tmp2_) {
			data->_tmp3_ = NULL;
			data->_tmp3_ = _ ("Comments not allowed in XML");
			data->_tmp4_ = NULL;
			data->_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, data->_tmp3_);
			data->_inner_error_ = data->_tmp4_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->self->container_id == NULL) {
		data->_tmp5_ = NULL;
		data->_tmp5_ = _ ("No such object");
		data->_tmp6_ = NULL;
		data->_tmp6_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, data->_tmp5_);
		data->_inner_error_ = data->_tmp6_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* data;
	data = _data;
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorFetchContainerData, data);
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_creator_fetch_container_co (_data_);
}


static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_fetch_container_co (data);
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->media_object = NULL;
	if (g_strcmp0 (data->self->container_id, "DLNA.ORG_AnyContainer") == 0) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = rygel_relational_expression_new ();
		data->expression = data->_tmp0_;
		((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
		data->_tmp1_ = g_strdup ("upnp:createClass");
		data->_tmp2_ = data->_tmp1_;
		_g_free0 (((RygelSearchExpression*) data->expression)->operand1);
		((RygelSearchExpression*) data->expression)->operand1 = data->_tmp2_;
		data->_tmp3_ = NULL;
		data->_tmp3_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item);
		data->_tmp4_ = g_strdup (data->_tmp3_);
		data->_tmp5_ = data->_tmp4_;
		_g_free0 (((RygelSearchExpression*) data->expression)->operand2);
		((RygelSearchExpression*) data->expression)->operand2 = data->_tmp5_;
		data->_tmp6_ = NULL;
		data->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 1;
		rygel_media_container_search (data->self->priv->content_dir->root_container, (RygelSearchExpression*) data->expression, (guint) 0, (guint) 1, data->_tmp6_, rygel_item_creator_fetch_container_ready, data);
		return FALSE;
		_state_1:
		data->_tmp8_ = NULL;
		data->_tmp8_ = rygel_media_container_search_finish (data->self->priv->content_dir->root_container, data->_res_, &data->_tmp7_, &data->_inner_error_);
		data->total_matches = data->_tmp7_;
		data->_result_ = data->_tmp8_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_rygel_search_expression_unref0 (data->expression);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp9_ = gee_collection_get_size ((GeeCollection*) data->_result_);
		if (data->_tmp9_ > 0) {
			data->_tmp10_ = NULL;
			data->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) data->_result_, 0);
			data->_tmp11_ = (RygelMediaObject*) data->_tmp10_;
			_g_object_unref0 (data->media_object);
			data->media_object = data->_tmp11_;
		}
		_g_object_unref0 (data->_result_);
		_rygel_search_expression_unref0 (data->expression);
	} else {
		data->_tmp12_ = NULL;
		data->_tmp12_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 2;
		rygel_media_container_find_object (data->self->priv->content_dir->root_container, data->self->container_id, data->_tmp12_, rygel_item_creator_fetch_container_ready, data);
		return FALSE;
		_state_2:
		data->_tmp13_ = NULL;
		data->_tmp13_ = rygel_media_container_find_object_finish (data->self->priv->content_dir->root_container, data->_res_, &data->_inner_error_);
		data->_tmp14_ = data->_tmp13_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp15_ = data->_tmp14_;
		_g_object_unref0 (data->media_object);
		data->media_object = data->_tmp15_;
	}
	if (data->media_object == NULL) {
		data->_tmp16_ = NULL;
		data->_tmp16_ = _ ("No such object");
		data->_tmp17_ = NULL;
		data->_tmp17_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, data->_tmp16_);
		data->_inner_error_ = data->_tmp17_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->media_object);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		if (!RYGEL_IS_MEDIA_CONTAINER (data->media_object)) {
			data->_tmp18_ = TRUE;
		} else {
			data->_tmp19_ = rygel_media_object_get_ocm_flags (data->media_object);
			data->_tmp18_ = !((data->_tmp19_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD);
		}
		if (data->_tmp18_) {
			data->_tmp20_ = NULL;
			data->_tmp20_ = _ ("Object creation in %s not allowed");
			data->_tmp21_ = NULL;
			data->_tmp21_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, data->_tmp20_, data->media_object->id);
			data->_inner_error_ = data->_tmp21_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_tmp23_ = _g_object_ref0 ((data->_tmp22_ = data->media_object, RYGEL_IS_WRITABLE_CONTAINER (data->_tmp22_) ? ((RygelWritableContainer*) data->_tmp22_) : NULL));
	data->result = data->_tmp23_;
	_g_object_unref0 (data->media_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->media_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_conclude (RygelItemCreator* self) {
	gchar* _tmp0_ = NULL;
	gchar* didl;
	g_return_if_fail (self != NULL);
	_tmp0_ = gupnp_didl_lite_writer_get_string (self->priv->didl_writer);
	didl = _tmp0_;
	gupnp_service_action_set (self->priv->action, "ObjectID", G_TYPE_STRING, ((RygelMediaObject*) self->item)->id, "Result", G_TYPE_STRING, didl, NULL);
	gupnp_service_action_return (self->priv->action);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		gupnp_service_action_return_error (self->priv->action, (guint) _error_->code, _error_->message);
	} else {
		gupnp_service_action_return_error (self->priv->action, (guint) 701, _error_->message);
	}
	_tmp0_ = _ ("Failed to create item under '%s': %s");
	g_warning (_tmp0_, self->container_id, _error_->message);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (RYGEL_IS_IMAGE_ITEM (self->item)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("image");
		result = _tmp0_;
		return result;
	} else {
		if (RYGEL_IS_VIDEO_ITEM (self->item)) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("video");
			result = _tmp1_;
			return result;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("audio");
			result = _tmp2_;
			return result;
		}
	}
}


static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = upnp_class;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelImageItem* _tmp2_ = NULL;
				_tmp2_ = rygel_image_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp2_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelPhotoItem* _tmp3_ = NULL;
				_tmp3_ = rygel_photo_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp3_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelVideoItem* _tmp4_ = NULL;
				_tmp4_ = rygel_video_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp4_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelAudioItem* _tmp5_ = NULL;
				_tmp5_ = rygel_audio_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_AUDIO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp5_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp6_ = NULL;
				_tmp6_ = rygel_music_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp7_ = NULL;
				_tmp7_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", upnp_class);
				_inner_error_ = _tmp7_;
				g_propagate_error (error, _inner_error_);
				return NULL;
			}
		}
	}
}


static gunichar string_get_char (const gchar* self, gint index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (uri == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (uri, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* next;
		_tmp1_ = g_utf8_next_char (uri);
		_tmp2_ = g_strdup (_tmp1_);
		next = _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gunichar _tmp7_;
				gboolean _tmp8_;
				if (!_tmp3_) {
					const gchar* _tmp4_ = NULL;
					gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp4_ = g_utf8_next_char (next);
					_tmp5_ = g_strdup (_tmp4_);
					_tmp6_ = _tmp5_;
					_g_free0 (next);
					next = _tmp6_;
				}
				_tmp3_ = FALSE;
				if (!(g_strcmp0 (next, "") != 0)) {
					break;
				}
				_tmp7_ = string_get_char (next, 0);
				_tmp8_ = g_unichar_isspace (_tmp7_);
				if (_tmp8_) {
					result = FALSE;
					_g_free0 (next);
					return result;
				}
			}
		}
		_g_free0 (next);
	}
	result = TRUE;
	return result;
}


static void rygel_item_creator_create_uri_data_free (gpointer _data) {
	RygelItemCreatorCreateUriData* data;
	data = _data;
	_g_object_unref0 (data->container);
	_g_free0 (data->title);
	_g_free0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorCreateUriData, data);
}


static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorCreateUriData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_uri);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_uri_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->container = _g_object_ref0 (container);
	_data_->title = g_strdup (title);
	rygel_item_creator_create_uri_co (_data_);
}


static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelItemCreatorCreateUriData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_create_uri_co (data);
}


static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	rygel_media_object_get_writable ((RygelMediaObject*) data->container, data->_tmp0_, rygel_item_creator_create_uri_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) data->container, data->_res_, &data->_inner_error_);
	data->dir = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->dir == NULL) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("Object creation in %s not allowed");
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, data->_tmp2_, ((RygelMediaObject*) data->container)->id);
		data->_inner_error_ = data->_tmp3_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->dir);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_file_get_child_for_display_name (data->dir, data->title, &data->_inner_error_);
	data->file = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->dir);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_file_get_uri (data->file);
	data->result = data->_tmp5_;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->dir);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->dir);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_wait_for_item_data_free (gpointer _data) {
	RygelItemCreatorWaitForItemData* data;
	data = _data;
	_g_object_unref0 (data->container);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorWaitForItemData, data);
}


static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorWaitForItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_wait_for_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_wait_for_item_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->container = _g_object_ref0 (container);
	rygel_item_creator_wait_for_item_co (_data_);
}


static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_wait_for_item_co (data);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda10_ (RygelMediaContainer* container, Block5Data* _data5_) {
	RygelItemCreator * self;
	self = _data5_->self;
	g_return_if_fail (container != NULL);
	rygel_item_creator_wait_for_item_co (_data5_->_async_data_);
}


static void __lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	_lambda10_ (container, self);
}


static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data5_ = g_slice_new0 (Block5Data);
	data->_data5_->_ref_count_ = 1;
	data->_data5_->self = g_object_ref (data->self);
	data->_data5_->_async_data_ = data;
	g_debug ("rygel-item-creator.vala:288: Waiting for new item to appear under cont" \
"ainer '%s'..", ((RygelMediaObject*) data->container)->id);
	data->not_added = TRUE;
	while (TRUE) {
		if (!data->not_added) {
			break;
		}
		data->id = g_signal_connect_data ((RygelMediaContainer*) data->container, "container-updated", (GCallback) __lambda10__rygel_media_container_container_updated, block5_data_ref (data->_data5_), (GClosureNotify) block5_data_unref, 0);
		data->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) data->container, data->id);
		data->_tmp0_ = NULL;
		data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 2;
		rygel_media_container_find_object ((RygelMediaContainer*) data->container, ((RygelMediaObject*) data->self->item)->id, data->_tmp0_, rygel_item_creator_wait_for_item_ready, data);
		return FALSE;
		_state_2:
		data->_tmp1_ = NULL;
		data->_tmp1_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) data->container, data->_res_, &data->_inner_error_);
		data->item = data->_tmp1_;
		if (data->_inner_error_ != NULL) {
			goto __catch60_g_error;
		}
		if (data->item != NULL) {
			data->not_added = FALSE;
		}
		_g_object_unref0 (data->item);
		goto __finally60;
		__catch60_g_error:
		{
			data->_error_ = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("Error from container '%s' on trying to find newly " "added child item '%s' in it", ((RygelMediaObject*) data->container)->id, ((RygelMediaObject*) data->self->item)->id);
			_g_error_free0 (data->_error_);
		}
		__finally60:
		if (data->_inner_error_ != NULL) {
			block5_data_unref (data->_data5_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	g_debug ("rygel-item-creator.vala:314: Finished waiting for new item to appear u" \
"nder container '%s'", ((RygelMediaObject*) data->container)->id);
	block5_data_unref (data->_data5_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	self = (RygelItemCreator*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelItemCreator*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	GPatternSpec* _tmp0_ = NULL;
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, "cancellable");
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
	rygel_item_creator_comment_pattern = _tmp0_;
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_creator_real_run;
	iface->run_finish = rygel_item_creator_real_run_finish;
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (obj);
	_g_free0 (self->container_id);
	_g_free0 (self->elements);
	_g_object_unref0 (self->didl_item);
	_g_object_unref0 (self->item);
	_g_object_unref0 (self->priv->content_dir);
	_g_object_unref0 (self->priv->didl_writer);
	_g_object_unref0 (self->priv->didl_parser);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
}


/**
 * CreateObject action implementation.
 */
GType rygel_item_creator_get_type (void) {
	static volatile gsize rygel_item_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_creator_type_id;
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_creator_type_id__volatile, rygel_item_creator_type_id);
	}
	return rygel_item_creator_type_id__volatile;
}


static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



