/* rygel-av-transport.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelAVTransportPrivate {
	guint _n_tracks;
	guint _track;
	gchar* _metadata;
	gchar* _status;
	gchar* _speed;
	gchar* _mode;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_N_TRACKS,
	RYGEL_AV_TRANSPORT_TRACK,
	RYGEL_AV_TRANSPORT_METADATA,
	RYGEL_AV_TRANSPORT_URI,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_SPEED,
	RYGEL_AV_TRANSPORT_MODE
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
const gchar* rygel_av_transport_get_mode (RygelAVTransport* self);
const gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
guint rygel_av_transport_get_n_tracks (RygelAVTransport* self);
guint rygel_av_transport_get_track (RygelAVTransport* self);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_av_transport_get_metadata (RygelAVTransport* self);
gchar* rygel_av_transport_get_uri (RygelAVTransport* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
void rygel_av_transport_set_uri (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_metadata (RygelAVTransport* self, const gchar* value);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, GstClockTime time);
GstClockTime rygel_gst_utils_time_from_string (const gchar* str);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value);
void rygel_av_transport_set_track (RygelAVTransport* self, guint value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value);
static void rygel_av_transport_finalize (GObject* obj);
static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_av_transport_query_last_change_cb (self, _sender, variable, value);
}


static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_set_av_transport_uri_cb (self, _sender, action);
}


static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_media_info_cb (self, _sender, action);
}


static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_info_cb (self, _sender, action);
}


static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_position_info_cb (self, _sender, action);
}


static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_device_capabilities_cb (self, _sender, action);
}


static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_settings_cb (self, _sender, action);
}


static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_stop_cb (self, _sender, action);
}


static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_play_cb (self, _sender, action);
}


static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_pause_cb (self, _sender, action);
}


static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_seek_cb (self, _sender, action);
}


static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_next_cb (self, _sender, action);
}


static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_previous_cb (self, _sender, action);
}


static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_state_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_duration_cb (self, _sender, pspec);
}


static void rygel_av_transport_real_constructed (GObject* base) {
	RygelAVTransport * self;
	RygelChangeLog* _tmp0_ = NULL;
	RygelChangeLog* _tmp1_;
	RygelMediaPlayer* _tmp2_ = NULL;
	RygelMediaPlayer* _tmp3_;
	self = (RygelAVTransport*) base;
	_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->changelog);
	self->priv->changelog = _tmp1_;
	_tmp2_ = rygel_av_transport_get_player (self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp3_;
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GObject*) self->priv->player, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->player, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPResourceFactory* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_;
	RygelMediaRendererPlugin* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* plugin;
	RygelMediaPlayer* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = (g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL), _tmp0_);
	_tmp2_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp1_);
	_tmp4_ = _g_object_ref0 ((_tmp3_ = _tmp2_, RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp3_) ? ((RygelMediaRendererPlugin*) _tmp3_) : NULL));
	plugin = (_tmp5_ = _tmp4_, _g_object_unref0 (_tmp1_), _tmp5_);
	_tmp6_ = rygel_media_renderer_plugin_get_player (plugin);
	result = _tmp6_;
	_g_object_unref0 (plugin);
	return result;
}


static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelChangeLog* log;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	guint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	guint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (variable != NULL);
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	log = _tmp0_;
	_tmp1_ = rygel_media_player_get_playback_state (self->priv->player);
	_tmp2_ = _tmp1_;
	rygel_change_log_log (log, "TransportState", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = rygel_av_transport_get_status (self);
	rygel_change_log_log (log, "TransportStatus", _tmp3_);
	rygel_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
	_tmp4_ = rygel_av_transport_get_mode (self);
	rygel_change_log_log (log, "CurrentPlayMode", _tmp4_);
	_tmp5_ = rygel_av_transport_get_speed (self);
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp5_);
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossibleRecordQualityMode", "NOT_IMPLEMENTED");
	_tmp6_ = rygel_av_transport_get_n_tracks (self);
	_tmp7_ = g_strdup_printf ("%u", _tmp6_);
	_tmp8_ = _tmp7_;
	rygel_change_log_log (log, "NumberOfTracks", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = rygel_av_transport_get_track (self);
	_tmp10_ = g_strdup_printf ("%u", _tmp9_);
	_tmp11_ = _tmp10_;
	rygel_change_log_log (log, "CurrentTrack", _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = rygel_media_player_get_duration_as_str (self->priv->player);
	_tmp13_ = _tmp12_;
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = rygel_media_player_get_duration_as_str (self->priv->player);
	_tmp15_ = _tmp14_;
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = rygel_av_transport_get_metadata (self);
	_tmp17_ = _tmp16_;
	rygel_change_log_log (log, "CurrentTrackMetadata", _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = rygel_av_transport_get_uri (self);
	_tmp19_ = _tmp18_;
	rygel_change_log_log (log, "CurrentTrackURI", _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = rygel_av_transport_get_uri (self);
	_tmp21_ = _tmp20_;
	rygel_change_log_log (log, "AVTransportURI", _tmp21_);
	_g_free0 (_tmp21_);
	rygel_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
	g_value_init (value, G_TYPE_STRING);
	_tmp22_ = rygel_change_log_finish (log);
	_tmp23_ = _tmp22_;
	g_value_set_string (value, _tmp23_);
	_g_free0 (_tmp23_);
	_g_object_unref0 (log);
}


static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	guint instance_id = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	gupnp_service_action_get (action, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
	if (instance_id != 0) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("Invalid InstanceID");
		gupnp_service_action_return_error (action, (guint) 718, _tmp0_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gchar* _uri;
	gchar* _metadata;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_uri = NULL;
	_metadata = NULL;
	gupnp_service_action_get (action, "CurrentURI", G_TYPE_STRING, &_uri, "CurrentURIMetaData", G_TYPE_STRING, &_metadata, NULL);
	rygel_av_transport_set_uri (self, _uri);
	rygel_av_transport_set_metadata (self, _metadata);
	gupnp_service_action_return (action);
	_g_free0 (_metadata);
	_g_free0 (_uri);
}


static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_av_transport_get_n_tracks (self);
	_tmp2_ = rygel_media_player_get_duration_as_str (self->priv->player);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_av_transport_get_uri (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = rygel_av_transport_get_metadata (self);
	_tmp7_ = _tmp6_;
	gupnp_service_action_set (action, "NrTracks", G_TYPE_UINT, _tmp1_, "MediaDuration", G_TYPE_STRING, _tmp3_, "CurrentURI", G_TYPE_STRING, _tmp5_, "CurrentURIMetaData", G_TYPE_STRING, _tmp7_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	gupnp_service_action_return (action);
}


static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_media_player_get_playback_state (self->priv->player);
	_tmp2_ = _tmp1_;
	_tmp3_ = rygel_av_transport_get_status (self);
	_tmp4_ = rygel_av_transport_get_speed (self);
	gupnp_service_action_set (action, "CurrentTransportState", G_TYPE_STRING, _tmp2_, "CurrentTransportStatus", G_TYPE_STRING, _tmp3_, "CurrentSpeed", G_TYPE_STRING, _tmp4_, NULL);
	_g_free0 (_tmp2_);
	gupnp_service_action_return (action);
}


static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_av_transport_get_track (self);
	_tmp2_ = rygel_media_player_get_duration_as_str (self->priv->player);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_av_transport_get_metadata (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = rygel_av_transport_get_uri (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = rygel_media_player_get_position_as_str (self->priv->player);
	_tmp9_ = _tmp8_;
	_tmp10_ = rygel_media_player_get_position_as_str (self->priv->player);
	_tmp11_ = _tmp10_;
	gupnp_service_action_set (action, "Track", G_TYPE_UINT, _tmp1_, "TrackDuration", G_TYPE_STRING, _tmp3_, "TrackMetaData", G_TYPE_STRING, _tmp5_, "TrackURI", G_TYPE_STRING, _tmp7_, "RelTime", G_TYPE_STRING, _tmp9_, "AbsTime", G_TYPE_STRING, _tmp11_, "RelCount", G_TYPE_INT, G_MAXINT, "AbsCount", G_TYPE_INT, G_MAXINT, NULL);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	gupnp_service_action_return (action);
}


static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	gupnp_service_action_set (action, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	gupnp_service_action_return (action);
}


static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rygel_av_transport_get_mode (self);
	gupnp_service_action_set (action, "PlayMode", G_TYPE_STRING, _tmp1_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	gupnp_service_action_return (action);
}


static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	rygel_media_player_set_playback_state (self->priv->player, "STOPPED");
	gupnp_service_action_return (action);
}


static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gchar* speed;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	speed = NULL;
	gupnp_service_action_get (action, "Speed", G_TYPE_STRING, &speed, NULL);
	if (g_strcmp0 (speed, "1") != 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Play speed not supported");
		gupnp_service_action_return_error (action, (guint) 717, _tmp1_);
		_g_free0 (speed);
		return;
	}
	rygel_media_player_set_playback_state (self->priv->player, "PLAYING");
	gupnp_service_action_return (action);
	_g_free0 (speed);
}


static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	rygel_media_player_set_playback_state (self->priv->player, "PAUSED_PLAYBACK");
	gupnp_service_action_return (action);
}


static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	gboolean _tmp0_;
	gchar* unit;
	gchar* target;
	const gchar* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = rygel_av_transport_check_instance_id (self, action);
	if (!_tmp0_) {
		return;
	}
	unit = NULL;
	target = NULL;
	gupnp_service_action_get (action, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
	_tmp1_ = unit;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("REL_TIME"))))) {
		switch (0) {
			default:
			{
				GstClockTime _tmp3_;
				gboolean _tmp4_;
				g_debug ("rygel-av-transport.vala:414: Seeking to %s.", target);
				_tmp3_ = rygel_gst_utils_time_from_string (target);
				_tmp4_ = rygel_media_player_seek (self->priv->player, _tmp3_);
				if (!_tmp4_) {
					const gchar* _tmp5_ = NULL;
					_tmp5_ = _ ("Seek mode not supported");
					gupnp_service_action_return_error (action, (guint) 710, _tmp5_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				gupnp_service_action_return (action);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp6_ = NULL;
				_tmp6_ = _ ("Seek mode not supported");
				gupnp_service_action_return_error (action, (guint) 710, _tmp6_);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	}
	_g_free0 (target);
	_g_free0 (unit);
}


static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = _ ("Transition not available");
	gupnp_service_action_return_error (action, (guint) 701, _tmp0_);
}


static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = _ ("Transition not available");
	gupnp_service_action_return_error (action, (guint) 701, _tmp0_);
}


static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = rygel_media_player_get_playback_state (self->priv->player);
	_tmp1_ = _tmp0_;
	rygel_change_log_log (self->priv->changelog, "TransportState", _tmp1_);
	_g_free0 (_tmp1_);
}


static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = rygel_media_player_get_duration_as_str (self->priv->player);
	_tmp1_ = _tmp0_;
	rygel_change_log_log (self->priv->changelog, "CurrentTrackDuration", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = rygel_media_player_get_duration_as_str (self->priv->player);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (self->priv->changelog, "CurrentMediaDuration", _tmp3_);
	_g_free0 (_tmp3_);
}


RygelAVTransport* rygel_av_transport_construct (GType object_type) {
	RygelAVTransport * self = NULL;
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
	return self;
}


RygelAVTransport* rygel_av_transport_new (void) {
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
}


guint rygel_av_transport_get_n_tracks (RygelAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_tracks;
	return result;
}


void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_n_tracks = value;
	_tmp0_ = g_strdup_printf ("%u", self->priv->_n_tracks);
	_tmp1_ = _tmp0_;
	rygel_change_log_log (self->priv->changelog, "NumberOfTracks", _tmp1_);
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "n-tracks");
}


guint rygel_av_transport_get_track (RygelAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_track;
	return result;
}


void rygel_av_transport_set_track (RygelAVTransport* self, guint value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_track = value;
	_tmp0_ = g_strdup_printf ("%u", self->priv->_track);
	_tmp1_ = _tmp0_;
	rygel_change_log_log (self->priv->changelog, "CurrentTrack", _tmp1_);
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "track");
}


gchar* rygel_av_transport_get_metadata (RygelAVTransport* self) {
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_metadata != NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_markup_escape_text (self->priv->_metadata, (gssize) (-1));
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
}


void rygel_av_transport_set_metadata (RygelAVTransport* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	_tmp2_ = rygel_av_transport_get_metadata (self);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (self->priv->changelog, "CurrentTrackMetadata", _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify ((GObject *) self, "metadata");
}


gchar* rygel_av_transport_get_uri (RygelAVTransport* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_player_get_uri (self->priv->player);
	_tmp1_ = _tmp0_;
	if ((_tmp2_ = _tmp1_ != NULL, _g_free0 (_tmp1_), _tmp2_)) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp3_ = rygel_media_player_get_uri (self->priv->player);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) (-1));
		result = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp6_);
		return result;
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		return result;
	}
}


void rygel_av_transport_set_uri (RygelAVTransport* self, const gchar* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	rygel_media_player_set_uri (self->priv->player, value);
	_tmp0_ = rygel_av_transport_get_uri (self);
	_tmp1_ = _tmp0_;
	rygel_change_log_log (self->priv->changelog, "CurrentTrackURI", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = rygel_av_transport_get_uri (self);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (self->priv->changelog, "AVTransportURI", _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify ((GObject *) self, "uri");
}


const gchar* rygel_av_transport_get_status (RygelAVTransport* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_status;
	return result;
}


void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_status);
	self->priv->_status = _tmp1_;
	rygel_change_log_log (self->priv->changelog, "TransportStatus", self->priv->_status);
	g_object_notify ((GObject *) self, "status");
}


const gchar* rygel_av_transport_get_speed (RygelAVTransport* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_speed;
	return result;
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_speed);
	self->priv->_speed = _tmp1_;
	rygel_change_log_log (self->priv->changelog, "TransportPlaySpeed", self->priv->_speed);
	g_object_notify ((GObject *) self, "speed");
}


const gchar* rygel_av_transport_get_mode (RygelAVTransport* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mode;
	return result;
}


void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_mode);
	self->priv->_mode = _tmp1_;
	rygel_change_log_log (self->priv->changelog, "CurrentPlayMode", self->priv->_mode);
	g_object_notify ((GObject *) self, "mode");
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_av_transport_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
	self->priv->_n_tracks = (guint) 0;
	self->priv->_track = (guint) 0;
	_tmp0_ = g_strdup ("");
	self->priv->_metadata = _tmp0_;
	_tmp1_ = g_strdup ("OK");
	self->priv->_status = _tmp1_;
	_tmp2_ = g_strdup ("1");
	self->priv->_speed = _tmp2_;
	_tmp3_ = g_strdup ("NORMAL");
	self->priv->_mode = _tmp3_;
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (obj);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_status);
	_g_free0 (self->priv->_speed);
	_g_free0 (self->priv->_mode);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_N_TRACKS:
		g_value_set_uint (value, rygel_av_transport_get_n_tracks (self));
		break;
		case RYGEL_AV_TRANSPORT_TRACK:
		g_value_set_uint (value, rygel_av_transport_get_track (self));
		break;
		case RYGEL_AV_TRANSPORT_METADATA:
		g_value_take_string (value, rygel_av_transport_get_metadata (self));
		break;
		case RYGEL_AV_TRANSPORT_URI:
		g_value_take_string (value, rygel_av_transport_get_uri (self));
		break;
		case RYGEL_AV_TRANSPORT_STATUS:
		g_value_set_string (value, rygel_av_transport_get_status (self));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		g_value_set_string (value, rygel_av_transport_get_speed (self));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		g_value_set_string (value, rygel_av_transport_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_N_TRACKS:
		rygel_av_transport_set_n_tracks (self, g_value_get_uint (value));
		break;
		case RYGEL_AV_TRANSPORT_TRACK:
		rygel_av_transport_set_track (self, g_value_get_uint (value));
		break;
		case RYGEL_AV_TRANSPORT_METADATA:
		rygel_av_transport_set_metadata (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_URI:
		rygel_av_transport_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_STATUS:
		rygel_av_transport_set_status (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		rygel_av_transport_set_speed (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		rygel_av_transport_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



