/* rygel-media-export-object-factory.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-media-export-object-factory.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;
typedef struct _RygelMediaExportObjectFactoryPrivate RygelMediaExportObjectFactoryPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;

struct _RygelMediaExportObjectFactory {
	GObject parent_instance;
	RygelMediaExportObjectFactoryPrivate * priv;
};

struct _RygelMediaExportObjectFactoryClass {
	GObjectClass parent_class;
	RygelMediaContainer* (*get_container) (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count);
	RygelMediaItem* (*get_item) (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
};


static gpointer rygel_media_export_object_factory_parent_class = NULL;

GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_DUMMY_PROPERTY
};
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count);
static RygelMediaContainer* rygel_media_export_object_factory_real_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* name);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* title);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
static RygelMediaItem* rygel_media_export_object_factory_real_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);



/**
     * Return a new instance of DatabaseBackedMediaContainer
     *
     * @param media_db instance of MediaDB
     * @param title title of the container
     * @param child_count number of children in the container
     */
#line 31 "rygel-media-export-object-factory.vala"
static RygelMediaContainer* rygel_media_export_object_factory_real_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count) {
#line 119 "rygel-media-export-object-factory.c"
	RygelMediaContainer* result = NULL;
#line 31 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 31 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 31 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 36 "rygel-media-export-object-factory.vala"
	if (g_str_has_prefix (id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX)) {
#line 131 "rygel-media-export-object-factory.c"
		result = (RygelMediaContainer*) rygel_media_export_query_container_new (media_db, id, title);
#line 37 "rygel-media-export-object-factory.vala"
		return result;
#line 135 "rygel-media-export-object-factory.c"
	} else {
		result = (RygelMediaContainer*) rygel_media_export_db_container_new (media_db, id, title);
#line 39 "rygel-media-export-object-factory.vala"
		return result;
#line 140 "rygel-media-export-object-factory.c"
	}
}


#line 37 "rygel-media-export-jpeg-writer.vala"
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const char* id, const char* title, guint child_count) {
#line 37 "rygel-media-export-jpeg-writer.vala"
	return RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS (self)->get_container (self, media_db, id, title, child_count);
#line 149 "rygel-media-export-object-factory.c"
}


/**
     * Return a new instance of MediaItem
     *
     * @param media_db instance of MediaDB
     * @param id id of the item
     * @param title title of the item
     * @param upnp_class upnp_class of the item
     */
#line 51 "rygel-media-export-object-factory.vala"
static RygelMediaItem* rygel_media_export_object_factory_real_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class) {
#line 163 "rygel-media-export-object-factory.c"
	RygelMediaItem* result = NULL;
	const char* _tmp0_;
	GQuark _tmp1_;
#line 51 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 51 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 51 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 51 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 51 "rygel-media-export-object-factory.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 179 "rygel-media-export-object-factory.c"
	_tmp0_ = upnp_class;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_music_item_new (id, parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 58 "rygel-media-export-object-factory.vala"
			return result;
#line 189 "rygel-media-export-object-factory.c"
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_video_item_new (id, parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 60 "rygel-media-export-object-factory.vala"
			return result;
#line 198 "rygel-media-export-object-factory.c"
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS))
	switch (0) {
		default:
		{
			result = (RygelMediaItem*) rygel_photo_item_new (id, parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS);
#line 62 "rygel-media-export-object-factory.vala"
			return result;
#line 207 "rygel-media-export-object-factory.c"
		}
	} else
	switch (0) {
		default:
		{
#line 64 "rygel-media-export-object-factory.vala"
			g_assert_not_reached ();
#line 215 "rygel-media-export-object-factory.c"
		}
	}
}


#line 37 "rygel-media-export-jpeg-writer.vala"
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class) {
#line 37 "rygel-media-export-jpeg-writer.vala"
	return RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS (self)->get_item (self, media_db, parent, id, title, upnp_class);
#line 225 "rygel-media-export-object-factory.c"
}


#line 23 "rygel-media-export-object-factory.vala"
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type) {
#line 231 "rygel-media-export-object-factory.c"
	RygelMediaExportObjectFactory * self;
#line 23 "rygel-media-export-object-factory.vala"
	self = (RygelMediaExportObjectFactory*) g_object_new (object_type, NULL);
#line 235 "rygel-media-export-object-factory.c"
	return self;
}


#line 23 "rygel-media-export-object-factory.vala"
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void) {
#line 23 "rygel-media-export-object-factory.vala"
	return rygel_media_export_object_factory_construct (RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY);
#line 244 "rygel-media-export-object-factory.c"
}


static void rygel_media_export_object_factory_class_init (RygelMediaExportObjectFactoryClass * klass) {
	rygel_media_export_object_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS (klass)->get_container = rygel_media_export_object_factory_real_get_container;
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS (klass)->get_item = rygel_media_export_object_factory_real_get_item;
}


static void rygel_media_export_object_factory_instance_init (RygelMediaExportObjectFactory * self) {
}


GType rygel_media_export_object_factory_get_type (void) {
	static volatile gsize rygel_media_export_object_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportObjectFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_object_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportObjectFactory), 0, (GInstanceInitFunc) rygel_media_export_object_factory_instance_init, NULL };
		GType rygel_media_export_object_factory_type_id;
		rygel_media_export_object_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportObjectFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_object_factory_type_id__volatile, rygel_media_export_object_factory_type_id);
	}
	return rygel_media_export_object_factory_type_id__volatile;
}




