/* rygel-gst-utils.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-gst-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_GST_UTILS (rygel_gst_utils_get_type ())
#define RYGEL_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtils))
#define RYGEL_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))
#define RYGEL_IS_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_UTILS))
#define RYGEL_IS_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_UTILS))
#define RYGEL_GST_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))

typedef struct _RygelGstUtils RygelGstUtils;
typedef struct _RygelGstUtilsClass RygelGstUtilsClass;
typedef struct _RygelGstUtilsPrivate RygelGstUtilsPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define __g_list_free__gst_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_object_unref0_ (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
typedef struct _RygelParamSpecGstUtils RygelParamSpecGstUtils;

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()
struct _RygelGstUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelGstUtilsPrivate * priv;
};

struct _RygelGstUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelGstUtils *self);
};

struct _RygelParamSpecGstUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_gst_utils_parent_class = NULL;

GQuark rygel_gst_error_quark (void);
gpointer rygel_gst_utils_ref (gpointer instance);
void rygel_gst_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_gst_utils (GValue* value, gpointer v_object);
void rygel_value_take_gst_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_gst_utils (const GValue* value);
GType rygel_gst_utils_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_GST_UTILS_DUMMY_PROPERTY
};
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
void rygel_gst_utils_post_error (GstElement* dest, GError* _error_);
GstClockTime rygel_gst_utils_time_from_string (const gchar* str);
gchar* rygel_gst_utils_time_to_string (GstClockTime time);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
static inline void _dynamic_set_blocksize6 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout7 (GstElement* obj, gint64 value);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps);
static gboolean rygel_gst_utils_rtp_depay_filter (GstPluginFeature* feature);
static gboolean _rygel_gst_utils_rtp_depay_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self);
static GstElement* rygel_gst_utils_get_best_depay (GList* features, GstCaps* caps);
static void _gst_object_unref0_ (gpointer var);
static void _g_list_free__gst_object_unref0_ (GList* self);
static gint rygel_gst_utils_compare_factories (GstElementFactory* factory_a, GstElementFactory* factory_b);
static gint _rygel_gst_utils_compare_factories_gcompare_func (gconstpointer a, gconstpointer b);
RygelGstUtils* rygel_gst_utils_construct (GType object_type);
static void rygel_gst_utils_finalize (RygelGstUtils* obj);


GQuark rygel_gst_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_error-quark");
}


GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error) {
	GstElement* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GstElement* _tmp2_ = NULL;
	GstElement* element;
	GstElement* _tmp3_;
	GError * _inner_error_ = NULL;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (factoryname != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = factoryname;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = name;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = gst_element_factory_make (_tmp0_, _tmp1_);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	element = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp3_ = element;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (_tmp3_ == NULL) {
#line 135 "rygel-gst-utils.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp4_ = _ ("Required element %s missing");
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp5_ = factoryname;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp6_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_MISSING_PLUGIN, _tmp4_, _tmp5_);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_inner_error_ = _tmp6_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		g_propagate_error (error, _inner_error_);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_gst_object_unref0 (element);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		return NULL;
#line 153 "rygel-gst-utils.c"
	}
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = element;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 159 "rygel-gst-utils.c"
}


static gpointer _gst_message_ref0 (gpointer self) {
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return self ? gst_message_ref (self) : NULL;
#line 166 "rygel-gst-utils.c"
}


void rygel_gst_utils_post_error (GstElement* dest, GError* _error_) {
	GstElement* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GstMessage* _tmp4_;
	GstMessage* msg;
	GstElement* _tmp5_;
	GstMessage* _tmp6_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_if_fail (dest != NULL);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = dest;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = _error_;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = _error_;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp3_ = _tmp2_->message;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp4_ = gst_message_new_error ((GstObject*) _tmp0_, _tmp1_, _tmp3_);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	msg = _tmp4_;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp5_ = dest;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp6_ = _gst_message_ref0 (msg);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	gst_element_post_message (_tmp5_, _tmp6_);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_gst_message_unref0 (msg);
#line 201 "rygel-gst-utils.c"
}


GstClockTime rygel_gst_utils_time_from_string (const gchar* str) {
	GstClockTime result = 0ULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	const gchar* _tmp0_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (str != NULL, 0ULL);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = str;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	sscanf (_tmp0_, "%llu:%2llu:%2llu%*s", &hours, &minutes, &seconds);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = (GstClockTime) ((((hours * 3600) + (minutes * 60)) + seconds) * GST_SECOND);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 221 "rygel-gst-utils.c"
}


gchar* rygel_gst_utils_time_to_string (GstClockTime time) {
	gchar* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	GstClockTime _tmp0_;
	GstClockTime _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
	guint64 _tmp4_;
	gchar* _tmp5_ = NULL;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = time;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	hours = (guint64) ((_tmp0_ / GST_SECOND) / 3600);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = time;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	seconds = (guint64) ((_tmp1_ / GST_SECOND) % 3600);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = seconds;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	minutes = _tmp2_ / 60;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp3_ = seconds;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	seconds = _tmp3_ % 60;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp4_ = seconds;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp5_ = g_strdup_printf ("%llu:%.2llu:%.2llu", hours, minutes, _tmp4_);
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = _tmp5_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 260 "rygel-gst-utils.c"
}


static inline void _dynamic_set_blocksize6 (GstElement* obj, glong value) {
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_object_set (obj, "blocksize", value, NULL);
#line 267 "rygel-gst-utils.c"
}


static inline void _dynamic_set_tcp_timeout7 (GstElement* obj, gint64 value) {
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_object_set (obj, "tcp-timeout", value, NULL);
#line 274 "rygel-gst-utils.c"
}


GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri) {
	GstElement* result = NULL;
	const gchar* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* src;
	GstElement* _tmp2_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = uri;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = gst_element_make_from_uri (GST_URI_SRC, _tmp0_, NULL);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	src = _tmp1_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = src;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (_tmp2_ != NULL) {
#line 296 "rygel-gst-utils.c"
		GstElement* _tmp3_;
		GObjectClass* _tmp4_ = NULL;
		GParamSpec* _tmp5_ = NULL;
		GstElement* _tmp7_;
		GObjectClass* _tmp8_ = NULL;
		GParamSpec* _tmp9_ = NULL;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp3_ = src;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp4_ = G_OBJECT_GET_CLASS ((GObject*) _tmp3_);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp5_ = g_object_class_find_property (_tmp4_, "blocksize");
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		if (_tmp5_ != NULL) {
#line 311 "rygel-gst-utils.c"
			GstElement* _tmp6_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			_tmp6_ = src;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			_dynamic_set_blocksize6 (_tmp6_, (glong) 65536);
#line 317 "rygel-gst-utils.c"
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp7_ = src;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp8_ = G_OBJECT_GET_CLASS ((GObject*) _tmp7_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		_tmp9_ = g_object_class_find_property (_tmp8_, "tcp-timeout");
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		if (_tmp9_ != NULL) {
#line 327 "rygel-gst-utils.c"
			GstElement* _tmp10_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			_tmp10_ = src;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			_dynamic_set_tcp_timeout7 (_tmp10_, (gint64) 60000000);
#line 333 "rygel-gst-utils.c"
		}
	}
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = src;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 340 "rygel-gst-utils.c"
}


static gboolean _rygel_gst_utils_rtp_depay_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self) {
	gboolean result;
	result = rygel_gst_utils_rtp_depay_filter (feature);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 349 "rygel-gst-utils.c"
}


static void _gst_object_unref0_ (gpointer var) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	(var == NULL) ? NULL : (var = (gst_object_unref (var), NULL));
#line 356 "rygel-gst-utils.c"
}


static void _g_list_free__gst_object_unref0_ (GList* self) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_list_foreach (self, (GFunc) _gst_object_unref0_, NULL);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_list_free (self);
#line 365 "rygel-gst-utils.c"
}


GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps) {
	GstElement* result = NULL;
	GstCaps* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GstRegistry* _tmp2_ = NULL;
	GstRegistry* registry;
	GstRegistry* _tmp3_;
	GList* _tmp4_ = NULL;
	GList* features;
	GList* _tmp5_;
	GstCaps* _tmp6_;
	GstElement* _tmp7_ = NULL;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = caps;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = rygel_gst_utils_need_rtp_depayloader (_tmp0_);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (!_tmp1_) {
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		result = NULL;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		return result;
#line 393 "rygel-gst-utils.c"
	}
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = gst_registry_get_default ();
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	registry = _tmp2_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp3_ = registry;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp4_ = gst_registry_feature_filter (_tmp3_, _rygel_gst_utils_rtp_depay_filter_gst_plugin_feature_filter, FALSE, NULL);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	features = _tmp4_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp5_ = features;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp6_ = caps;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp7_ = rygel_gst_utils_get_best_depay (_tmp5_, _tmp6_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = _tmp7_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	__g_list_free__gst_object_unref0_0 (features);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 417 "rygel-gst-utils.c"
}


static gpointer _gst_structure_copy0 (gpointer self) {
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return self ? gst_structure_copy (self) : NULL;
#line 424 "rygel-gst-utils.c"
}


static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps) {
	gboolean result = FALSE;
	GstCaps* _tmp0_;
	const GstStructure* _tmp1_ = NULL;
	GstStructure* _tmp2_;
	GstStructure* structure;
	const gchar* _tmp3_ = NULL;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (caps != NULL, FALSE);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = caps;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = gst_caps_get_structure (_tmp0_, (guint) 0);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = _gst_structure_copy0 (_tmp1_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	structure = _tmp2_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp3_ = gst_structure_get_name (structure);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = g_strcmp0 (_tmp3_, "application/x-rtp") == 0;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_gst_structure_free0 (structure);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 453 "rygel-gst-utils.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return self ? gst_object_ref (self) : NULL;
#line 460 "rygel-gst-utils.c"
}


static gint _rygel_gst_utils_compare_factories_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = rygel_gst_utils_compare_factories (a, b);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 469 "rygel-gst-utils.c"
}


static GstElement* rygel_gst_utils_get_best_depay (GList* features, GstCaps* caps) {
	GstElement* result = NULL;
	GList* relevant_factories;
	GList* _tmp0_;
	GList* _tmp9_;
	guint _tmp10_ = 0U;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	GstElementFactory* _tmp13_;
	GstElementFactory* factory;
	GstElementFactory* _tmp14_;
	const gchar* _tmp15_ = NULL;
	GstElement* _tmp16_ = NULL;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	relevant_factories = NULL;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = features;
#line 492 "rygel-gst-utils.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		feature_collection = _tmp0_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 500 "rygel-gst-utils.c"
			GstPluginFeature* _tmp1_;
			GstPluginFeature* feature = NULL;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			_tmp1_ = _gst_object_ref0 ((GstPluginFeature*) feature_it->data);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			feature = _tmp1_;
#line 507 "rygel-gst-utils.c"
			{
				GstPluginFeature* _tmp2_;
				GstElementFactory* _tmp3_;
				GstElementFactory* factory;
				GstElementFactory* _tmp4_;
				GstCaps* _tmp5_;
				gboolean _tmp6_ = FALSE;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				_tmp2_ = feature;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				_tmp3_ = _gst_object_ref0 (GST_ELEMENT_FACTORY (_tmp2_));
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				factory = _tmp3_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				_tmp4_ = factory;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				_tmp5_ = caps;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				_tmp6_ = gst_element_factory_can_sink_caps (_tmp4_, _tmp5_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				if (_tmp6_) {
#line 529 "rygel-gst-utils.c"
					GstElementFactory* _tmp7_;
					GstElementFactory* _tmp8_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
					_tmp7_ = factory;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
					_tmp8_ = _gst_object_ref0 (_tmp7_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
					relevant_factories = g_list_append (relevant_factories, _tmp8_);
#line 538 "rygel-gst-utils.c"
				}
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				_gst_object_unref0 (factory);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
				_gst_object_unref0 (feature);
#line 544 "rygel-gst-utils.c"
			}
		}
	}
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp9_ = relevant_factories;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp10_ = g_list_length (_tmp9_);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (_tmp10_ == ((guint) 0)) {
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		result = NULL;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		__g_list_free__gst_object_unref0_0 (relevant_factories);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		return result;
#line 560 "rygel-gst-utils.c"
	}
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	relevant_factories = g_list_sort (relevant_factories, _rygel_gst_utils_compare_factories_gcompare_func);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp11_ = relevant_factories;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp12_ = _tmp11_->data;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp13_ = _gst_object_ref0 ((GstElementFactory*) _tmp12_);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	factory = _tmp13_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp14_ = factory;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp15_ = gst_plugin_feature_get_name ((GstPluginFeature*) _tmp14_);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp16_ = gst_element_factory_make (_tmp15_, NULL);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = _tmp16_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_gst_object_unref0 (factory);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	__g_list_free__gst_object_unref0_0 (relevant_factories);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 586 "rygel-gst-utils.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1378 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1378 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 606 "rygel-gst-utils.c"
}


static gboolean rygel_gst_utils_rtp_depay_filter (GstPluginFeature* feature) {
	gboolean result = FALSE;
	GstPluginFeature* _tmp0_;
	GType _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GstPluginFeature* _tmp3_;
	GstElementFactory* _tmp4_;
	GstElementFactory* factory;
	GstElementFactory* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (feature != NULL, FALSE);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = feature;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp0_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = g_type_is_a (_tmp1_, GST_TYPE_ELEMENT_FACTORY);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (!_tmp2_) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		result = FALSE;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		return result;
#line 635 "rygel-gst-utils.c"
	}
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp3_ = feature;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp4_ = _gst_object_ref0 (GST_ELEMENT_FACTORY (_tmp3_));
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	factory = _tmp4_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp5_ = factory;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp6_ = gst_element_factory_get_klass (_tmp5_);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp7_ = string_contains (_tmp6_, "Depayloader");
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = _tmp7_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_gst_object_unref0 (factory);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 655 "rygel-gst-utils.c"
}


static gint rygel_gst_utils_compare_factories (GstElementFactory* factory_a, GstElementFactory* factory_b) {
	gint result = 0;
	GstElementFactory* _tmp0_;
	guint _tmp1_ = 0U;
	GstElementFactory* _tmp2_;
	guint _tmp3_ = 0U;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (factory_a != NULL, 0);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (factory_b != NULL, 0);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp0_ = factory_b;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp1_ = gst_plugin_feature_get_rank ((GstPluginFeature*) _tmp0_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp2_ = factory_a;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	_tmp3_ = gst_plugin_feature_get_rank ((GstPluginFeature*) _tmp2_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	result = (gint) (_tmp1_ - _tmp3_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return result;
#line 681 "rygel-gst-utils.c"
}


RygelGstUtils* rygel_gst_utils_construct (GType object_type) {
	RygelGstUtils* self = NULL;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	self = (RygelGstUtils*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return self;
#line 691 "rygel-gst-utils.c"
}


static void rygel_value_gst_utils_init (GValue* value) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	value->data[0].v_pointer = NULL;
#line 698 "rygel-gst-utils.c"
}


static void rygel_value_gst_utils_free_value (GValue* value) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (value->data[0].v_pointer) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		rygel_gst_utils_unref (value->data[0].v_pointer);
#line 707 "rygel-gst-utils.c"
	}
}


static void rygel_value_gst_utils_copy_value (const GValue* src_value, GValue* dest_value) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (src_value->data[0].v_pointer) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		dest_value->data[0].v_pointer = rygel_gst_utils_ref (src_value->data[0].v_pointer);
#line 717 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 721 "rygel-gst-utils.c"
	}
}


static gpointer rygel_value_gst_utils_peek_pointer (const GValue* value) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return value->data[0].v_pointer;
#line 729 "rygel-gst-utils.c"
}


static gchar* rygel_value_gst_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (collect_values[0].v_pointer) {
#line 736 "rygel-gst-utils.c"
		RygelGstUtils* object;
		object = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 743 "rygel-gst-utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 747 "rygel-gst-utils.c"
		}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		value->data[0].v_pointer = rygel_gst_utils_ref (object);
#line 751 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 755 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return NULL;
#line 759 "rygel-gst-utils.c"
}


static gchar* rygel_value_gst_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelGstUtils** object_p;
	object_p = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (!object_p) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 770 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (!value->data[0].v_pointer) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		*object_p = NULL;
#line 776 "rygel-gst-utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		*object_p = value->data[0].v_pointer;
#line 780 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		*object_p = rygel_gst_utils_ref (value->data[0].v_pointer);
#line 784 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return NULL;
#line 788 "rygel-gst-utils.c"
}


GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecGstUtils* spec;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_GST_UTILS), NULL);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return G_PARAM_SPEC (spec);
#line 802 "rygel-gst-utils.c"
}


gpointer rygel_value_get_gst_utils (const GValue* value) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS), NULL);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return value->data[0].v_pointer;
#line 811 "rygel-gst-utils.c"
}


void rygel_value_set_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (v_object) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		value->data[0].v_pointer = v_object;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		rygel_gst_utils_ref (value->data[0].v_pointer);
#line 831 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 835 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (old) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		rygel_gst_utils_unref (old);
#line 841 "rygel-gst-utils.c"
	}
}


void rygel_value_take_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (v_object) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		value->data[0].v_pointer = v_object;
#line 860 "rygel-gst-utils.c"
	} else {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 864 "rygel-gst-utils.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (old) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		rygel_gst_utils_unref (old);
#line 870 "rygel-gst-utils.c"
	}
}


static void rygel_gst_utils_class_init (RygelGstUtilsClass * klass) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	rygel_gst_utils_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	RYGEL_GST_UTILS_CLASS (klass)->finalize = rygel_gst_utils_finalize;
#line 880 "rygel-gst-utils.c"
}


static void rygel_gst_utils_instance_init (RygelGstUtils * self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	self->ref_count = 1;
#line 887 "rygel-gst-utils.c"
}


static void rygel_gst_utils_finalize (RygelGstUtils* obj) {
	RygelGstUtils * self;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	self = RYGEL_GST_UTILS (obj);
#line 895 "rygel-gst-utils.c"
}


GType rygel_gst_utils_get_type (void) {
	static volatile gsize rygel_gst_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_gst_utils_init, rygel_value_gst_utils_free_value, rygel_value_gst_utils_copy_value, rygel_value_gst_utils_peek_pointer, "p", rygel_value_gst_utils_collect_value, "p", rygel_value_gst_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstUtils), 0, (GInstanceInitFunc) rygel_gst_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_gst_utils_type_id;
		rygel_gst_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelGstUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_utils_type_id__volatile, rygel_gst_utils_type_id);
	}
	return rygel_gst_utils_type_id__volatile;
}


gpointer rygel_gst_utils_ref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	return instance;
#line 920 "rygel-gst-utils.c"
}


void rygel_gst_utils_unref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		RYGEL_GST_UTILS_GET_CLASS (self)->finalize (self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-gst-utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 933 "rygel-gst-utils.c"
	}
}



