// -*- c++ -*-
/* Do not edit! -- generated file */
#ifndef _SIGC_FUNCTORS_MACROS_SLOTHM4_
#define _SIGC_FUNCTORS_MACROS_SLOTHM4_
#include <sigc++/trackable.h>
#include <sigc++/visit_each.h>
#include <sigc++/adaptors/adaptor_trait.h>

namespace sigc {

namespace internal {

typedef void* (*hook)(void*);

/** Internal representation of a slot.
 * Derivations of this class can be considered as a link
 * between a slot and the functor that the slot should
 * execute in operator(). This link is needed because in
 * libsigc++2 the slot doesn't necessarily have exactly the
 * same function signature as the functor thus allowing for
 * implicit conversions.
 * The base class slot_rep serves the purpose to
 * - form a common pointer type (slot_rep*),
 * - offer the possibility to create duplicates (dup()),
 * - offer a notification callback (notify()),
 * - implement some of slot_base's interface that depends
 *   on the notification callback, i.e.
 *   -# the possibility to set a single parent with a callback
 *      (set_parent()) that is executed from notify(),
 *   -# a generic function pointer, call_, that is simply
 *      set to zero in notify() to invalidate the slot.
 * slot_rep inherits trackable so that connection objects can
 * refer to the slot and are notified when the slot is destroyed.
 */
struct slot_rep : public trackable
{
  /* NB: Instead of slot_rep we could inherit slot_base from trackable.
   * However, a simple benchmark seems to indicate that this slows
   * down dereferencing of slot list iterators. Martin. */

  /// Callback that invokes the contained functor.
  /* This can't be a virtual function since number of arguments
   * must be flexible. We use function pointers to slot_call::call_it()
   * instead. call_ is set to zero to indicate that the slot is invalid.
   */
  hook call_;

  /// Callback that detaches the slot_rep object from referred trackables.
  /* This could be a virtual function. However it would be identical to
   * the virtual dtor. Therefore it's more efficient to have no virtual
   * functions at all.
   */
  hook detach_;

  /** Callback that makes a deep copy of the slot_rep object.
   * @return A deep copy of the slot_rep object.
   */
  hook dup_;

  /** Callback of parent_. */
  hook cleanup_;

  /** Parent object whose callback cleanup_ is executed on notification. */
  void* parent_;

  inline slot_rep(hook call__, hook detach__, hook dup__)
    : call_(call__), detach_(detach__), dup_(dup__), cleanup_(0), parent_(0) {}

  inline ~slot_rep()
    { if (detach_) (*detach_)(this); }

  /** Makes a deep copy of the slot_rep object.
   * @return A deep copy of the slot_rep object.
   */
  inline slot_rep* dup() const
    { return (slot_rep*)(*dup_)(const_cast<slot_rep*>(this)); }

  /** Set the parent with a callback.
   * slots have one parent exclusively.
   * @param parent The new parent.
   * @param cleanup The callback to execute from notify().
   */
  inline void set_parent(void* parent, hook cleanup)
    {
      parent_ = parent;
      cleanup_ = cleanup;
    }

  /// Invalidates the slot and executes the parent's cleanup callback.
  void disconnect();

  /** Callback that invalidates the slot.
   * This callback is registered in every object of a trackable
   * inherited type that is referred by this slot_rep object.
   * It is executed when the slot becomes invalid because of some 
   * referred object dying.
   * @param data The slot_rep object that is becoming invalid (@p this).
   */
  static void* notify(void* data);
};

/** Functor used to add a dependency to a trackable.
 * Consequently slot_rep::notify() gets executed when the
 * trackable is destroyed or overwritten.
 */
struct slot_do_bind
{
  /** The slot_rep object trackables should notify on destruction. */
  slot_rep* rep_;

  /** Construct a slot_do_bind functor.
   * @param rep The slot_rep object trackables should notify on destruction.
   */
  inline slot_do_bind(slot_rep* rep) : rep_(rep) {}

  /** Adds a dependency to @p t.
   * @param t The trackable object to add a callback to.
   */
  inline void operator()(const trackable* t) const
    { t->add_destroy_notify_callback(rep_, &slot_rep::notify); }
};

/// Functor used to remove a dependency from a trackable.
struct slot_do_unbind
{
  /** The slot_rep object trackables don't need to notify on destruction any more. */
  slot_rep* rep_;

  /** Construct a slot_do_unbind functor.
   * @param rep The slot_rep object trackables don't need to notify on destruction any more.
   */
  inline slot_do_unbind(slot_rep* rep) : rep_(rep) {}

  /** Removes a dependency from @p t.
   * @param t The trackable object to remove the callback from.
   */
  inline void operator()(const trackable* t) const
    { t->remove_destroy_notify_callback(rep_); }
};

/** A typed slot_rep.
 * A typed slot_rep holds a functor that can be invoked from
 * slot::operator()(). visit_each() is used to visit the functor's
 * targets that inherit trackable recursively and register the
 * notification callback. Consequently the slot_rep object will be
 * notified when some referred object is destroyed or overwritten.
 */
template <class T_functor>
struct typed_slot_rep : public slot_rep
{
  typedef typed_slot_rep<T_functor> self;

  /* Use an adaptor type so that arguments can be passed as const references
   * through explicit template instantiation from slot_call#::call_it() */
  typedef typename adaptor_trait<T_functor>::adaptor_type adaptor_type;

  /** The functor contained by this slot_rep object. */
  adaptor_type functor_;

  /** Constructs an invalid typed slot_rep object.
   * The notification callback is registered using visit_each().
   * @param functor The functor contained by the new slot_rep object.
   */
  inline typed_slot_rep(const T_functor& functor)
    : slot_rep(0, &detach, &dup), functor_(functor)
    { visit_each_type<trackable*>(slot_do_bind(this), functor_); }

  inline typed_slot_rep(const typed_slot_rep& cl)
    : slot_rep(cl.call_, &detach, &dup), functor_(cl.functor_)
    { visit_each_type<trackable*>(slot_do_bind(this), functor_); }

  /** Detaches the slot_rep object from all referred trackables.
   * The notification callback is unregistered using visit_each().
   */
  static void* detach(void* data)
    {
      slot_rep* rep_ = (slot_rep*)data;
      visit_each_type<trackable*>(slot_do_unbind(rep_), static_cast<self*>(rep_)->functor_);
      return 0;
    }

  /** Makes a deep copy of the slot_rep object.
   * Deep copy means that the notification callback of the new
   * slot_rep object is registered in the referred trackables.
   * @return A deep copy of the slot_rep object.
   */
  static void* dup(void* data)
    {
      slot_rep* rep_ = (slot_rep*)data;
      return static_cast<slot_rep*>(new self(*static_cast<self*>(rep_)));
    }
};

} /* namespace internal */

/** @defgroup functors Functors
 * Functors are copyable types that define operator()().
 *
 * Types that define operator()() overloads with different return types
 * are referred to as multi-type functors. Multi-type functors are only
 * partly supported in libsigc++.
 *
 * Closures are functors that store all information needed to invoke
 * a callback from operator()().
 *
 * Adaptors are functors that alter the signature of a functor's
 * operator()().
 *
 * libsigc++ defines numerous functors, closures and adaptors.
 * Since libsigc++ is a callback libaray, most functors are also
 * closures. Therefore the documentation doesn't distinguish between
 * functors and closures.
 *
 * The basic functor types libsigc++ provides
 * are created with ptr_fun() and mem_fun() and can be converted into
 * slots implicitly. The set of adaptors that ships with libsigc++ is
 * documented in the equally named module.
 */

/** @defgroup slot Slots
 * Slots are type-safe representations of callback methods and functions.
 * A Slot can be constructed from any function, regardless of whether it is
 * a global function, a member method, static, or virtual.
 *
 * Use the sigc::mem_fun() and sigc::ptr_fun() template functions to get a sigc::slot, like so:
 * @code
 * sigc::slot<void, int> sl = sigc::mem_fun(someobj, &SomeClass::somemethod);
 * @endcode
 * or
 * @code
 * sigc::slot<void, int> sl = sigc::ptr_fun(&somefunction);
 * @endcode
 * or
 * @code
 * m_Button.signal_clicked().connect( sigc::mem_fun(*this, &MyWindow::on_button_clicked) );
 * @endcode
 * The compiler will complain if SomeClass::somemethod, etc. have the wrong signature.
 *
 * You can also pass slots as method parameters where you might normally pass a function pointer.
 *
 * @ingroup functors
 */

/** Base type for slots.
 * slot_base integrates most of the interface of the derived
 * sigc::slot templates. slots
 * can be connected to signals, be disconnected at some later point
 * (disconnect()) and temporarily be blocked (block(), unblock()).
 * The validity of a slot can be tested with empty().
 *
 * The internal representation of a sigc::internal::slot_rep derived
 * type is built from slot_base's derivations. set_parent() is used to
 * register a notification callback that is executed when the slot gets
 * invalid. add_destroy_notify_callback() is used by connection objects
 * to add a notification callback that is executed on destruction.
 *
 * @ingroup slot
 */
class slot_base : public functor_base
{
  typedef internal::slot_rep rep_type;

public:
  /// Constructs an empty slot.
  slot_base()
    : rep_(0), blocked_(false) {}

  /** Constructs a slot from an existing slot_rep object.
   * @param rep The slot_rep object this slot should contain.
   */
  explicit slot_base(rep_type* rep)
    : rep_(rep), blocked_(false) {}

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot_base(const slot_base& src)
    : rep_(0), blocked_(src.blocked_)
    { if (src.rep_) rep_ = src.rep_->dup(); }

  ~slot_base()
    { if (rep_) delete rep_; }

  /** Tests whether a slot is null, because the default constructor was used.
   * Test a slot for null like so:
   * <code>
   * if(slot)
   *  do_something()
   * <endcode>
   */
  operator bool() const
    { return rep_ != 0; }

  /** Sets the parent of this slot.
   * This function is used by signals to register a notification callback.
   * This notification callback is executed when the slot becomes invalid
   * because of some referred object dying.
   * @param parent The new parent.
   * @param cleanup The notification callback.
   */
  void set_parent(void* parent, void* (*cleanup)(void*)) const
    { if (rep_) rep_->set_parent(parent, cleanup); }

  /** Add a callback that is executed (notified) when the slot is detroyed.
   * This function is used internally by connection objects.
   * @param data Passed into func upon notification.
   * @param func Callback executed upon destruction of the object.
   */
  void add_destroy_notify_callback(void* data, void* (*func)(void*)) const
    { if (rep_) rep_->add_destroy_notify_callback(data, func); }

  /** Remove a callback previously installed with add_destroy_notify_callback().
   * The callback is not executed.
   * @param data Parameter passed into previous call to add_destroy_notify_callback().
   */
  void remove_destroy_notify_callback(void* data) const
    { if (rep_) rep_->remove_destroy_notify_callback(data); }

  /** Returns whether the slot is invalid.
   * @return @p true if the slot is invalid (empty).
   */
  inline bool empty() const
    { return (!rep_ || !rep_->call_); }

  /** Returns whether the slot is blocked.
   * @return @p true if the slot is blocked.
   */
  inline bool blocked() const
    { return blocked_; }

  /** Sets the blocking state.
   * If @e should_block is @p true then the blocking state is set.
   * Subsequent calls to slot::operator()() don't invoke the functor
   * contained by this slot until unblock() or block() with
   * @e should_block = @p false is called.
   * @param should_block Indicates whether the blocking state should be set or unset.
   * @return @p true if the slot was in blocking state before.
   */
  bool block(bool should_block = true);

  /** Unsets the blocking state.
   * @return @p true if the slot was in blocking state before.
   */
  bool unblock()
    { return block(false); }

  /** Disconnects the slot.
   * Invalidates the slot and notifies the parent.
   */
  void disconnect()
    { if (rep_) rep_->disconnect(); }

protected:
  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot_base& operator=(const slot_base& src);

public: // public to avoid template friend declarations
  /** Typed slot_rep object that contains a functor. */
  mutable rep_type *rep_;

  /** Indicates whether the slot is blocked. */
  bool blocked_;
};

namespace internal {

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 *
 */
template<class T_functor, class T_return>
struct slot_call0
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_)();
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 * - @e T_arg1 Argument type used in the definition of call_it().
 *
 */
template<class T_functor, class T_return, class T_arg1>
struct slot_call1
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @param _A_a1 Argument to be passed on to the functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep, typename type_trait<T_arg1>::take a_1)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_).LIBSIGC_TEMPLATE_PREFIX operator()<typename type_trait<T_arg1>::take>
               (a_1);
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 * - @e T_arg1 Argument type used in the definition of call_it().
 * - @e T_arg2 Argument type used in the definition of call_it().
 *
 */
template<class T_functor, class T_return, class T_arg1,class T_arg2>
struct slot_call2
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep, typename type_trait<T_arg1>::take a_1,typename type_trait<T_arg2>::take a_2)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_).LIBSIGC_TEMPLATE_PREFIX operator()<typename type_trait<T_arg1>::take,typename type_trait<T_arg2>::take>
               (a_1,a_2);
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 * - @e T_arg1 Argument type used in the definition of call_it().
 * - @e T_arg2 Argument type used in the definition of call_it().
 * - @e T_arg3 Argument type used in the definition of call_it().
 *
 */
template<class T_functor, class T_return, class T_arg1,class T_arg2,class T_arg3>
struct slot_call3
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep, typename type_trait<T_arg1>::take a_1,typename type_trait<T_arg2>::take a_2,typename type_trait<T_arg3>::take a_3)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_).LIBSIGC_TEMPLATE_PREFIX operator()<typename type_trait<T_arg1>::take,typename type_trait<T_arg2>::take,typename type_trait<T_arg3>::take>
               (a_1,a_2,a_3);
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 * - @e T_arg1 Argument type used in the definition of call_it().
 * - @e T_arg2 Argument type used in the definition of call_it().
 * - @e T_arg3 Argument type used in the definition of call_it().
 * - @e T_arg4 Argument type used in the definition of call_it().
 *
 */
template<class T_functor, class T_return, class T_arg1,class T_arg2,class T_arg3,class T_arg4>
struct slot_call4
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep, typename type_trait<T_arg1>::take a_1,typename type_trait<T_arg2>::take a_2,typename type_trait<T_arg3>::take a_3,typename type_trait<T_arg4>::take a_4)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_).LIBSIGC_TEMPLATE_PREFIX operator()<typename type_trait<T_arg1>::take,typename type_trait<T_arg2>::take,typename type_trait<T_arg3>::take,typename type_trait<T_arg4>::take>
               (a_1,a_2,a_3,a_4);
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 * - @e T_arg1 Argument type used in the definition of call_it().
 * - @e T_arg2 Argument type used in the definition of call_it().
 * - @e T_arg3 Argument type used in the definition of call_it().
 * - @e T_arg4 Argument type used in the definition of call_it().
 * - @e T_arg5 Argument type used in the definition of call_it().
 *
 */
template<class T_functor, class T_return, class T_arg1,class T_arg2,class T_arg3,class T_arg4,class T_arg5>
struct slot_call5
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @param _A_a5 Argument to be passed on to the functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep, typename type_trait<T_arg1>::take a_1,typename type_trait<T_arg2>::take a_2,typename type_trait<T_arg3>::take a_3,typename type_trait<T_arg4>::take a_4,typename type_trait<T_arg5>::take a_5)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_).LIBSIGC_TEMPLATE_PREFIX operator()<typename type_trait<T_arg1>::take,typename type_trait<T_arg2>::take,typename type_trait<T_arg3>::take,typename type_trait<T_arg4>::take,typename type_trait<T_arg5>::take>
               (a_1,a_2,a_3,a_4,a_5);
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 * - @e T_arg1 Argument type used in the definition of call_it().
 * - @e T_arg2 Argument type used in the definition of call_it().
 * - @e T_arg3 Argument type used in the definition of call_it().
 * - @e T_arg4 Argument type used in the definition of call_it().
 * - @e T_arg5 Argument type used in the definition of call_it().
 * - @e T_arg6 Argument type used in the definition of call_it().
 *
 */
template<class T_functor, class T_return, class T_arg1,class T_arg2,class T_arg3,class T_arg4,class T_arg5,class T_arg6>
struct slot_call6
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @param _A_a5 Argument to be passed on to the functor.
   * @param _A_a6 Argument to be passed on to the functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep, typename type_trait<T_arg1>::take a_1,typename type_trait<T_arg2>::take a_2,typename type_trait<T_arg3>::take a_3,typename type_trait<T_arg4>::take a_4,typename type_trait<T_arg5>::take a_5,typename type_trait<T_arg6>::take a_6)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_).LIBSIGC_TEMPLATE_PREFIX operator()<typename type_trait<T_arg1>::take,typename type_trait<T_arg2>::take,typename type_trait<T_arg3>::take,typename type_trait<T_arg4>::take,typename type_trait<T_arg5>::take,typename type_trait<T_arg6>::take>
               (a_1,a_2,a_3,a_4,a_5,a_6);
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};

/** Abstracts functor execution.
 * call_it() invokes a functor of type @e T_functor with a list of
 * parameters whose types are given by the template arguments.
 * address() forms a function pointer from call_it().
 *
 * The following template arguments are used:
 * - @e T_functor The functor type.
 * - @e T_return The return type of call_it().
 * - @e T_arg1 Argument type used in the definition of call_it().
 * - @e T_arg2 Argument type used in the definition of call_it().
 * - @e T_arg3 Argument type used in the definition of call_it().
 * - @e T_arg4 Argument type used in the definition of call_it().
 * - @e T_arg5 Argument type used in the definition of call_it().
 * - @e T_arg6 Argument type used in the definition of call_it().
 * - @e T_arg7 Argument type used in the definition of call_it().
 *
 */
template<class T_functor, class T_return, class T_arg1,class T_arg2,class T_arg3,class T_arg4,class T_arg5,class T_arg6,class T_arg7>
struct slot_call7
{
  /** Invokes a functor of type @p T_functor.
   * @param rep slot_rep object that holds a functor of type @p T_functor.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @param _A_a5 Argument to be passed on to the functor.
   * @param _A_a6 Argument to be passed on to the functor.
   * @param _A_a7 Argument to be passed on to the functor.
   * @return The return values of the functor invocation.
   */
  static T_return call_it(slot_rep* rep, typename type_trait<T_arg1>::take a_1,typename type_trait<T_arg2>::take a_2,typename type_trait<T_arg3>::take a_3,typename type_trait<T_arg4>::take a_4,typename type_trait<T_arg5>::take a_5,typename type_trait<T_arg6>::take a_6,typename type_trait<T_arg7>::take a_7)
    {
      typedef typed_slot_rep<T_functor> typed_slot;
      typed_slot *typed_rep = static_cast<typed_slot*>(rep);
      return (typed_rep->functor_).LIBSIGC_TEMPLATE_PREFIX operator()<typename type_trait<T_arg1>::take,typename type_trait<T_arg2>::take,typename type_trait<T_arg3>::take,typename type_trait<T_arg4>::take,typename type_trait<T_arg5>::take,typename type_trait<T_arg6>::take,typename type_trait<T_arg7>::take>
               (a_1,a_2,a_3,a_4,a_5,a_6,a_7);
    }

  /** Forms a function pointer from call_it().
   * @return A function pointer formed from call_it().
   */
  static hook address() 
    { return reinterpret_cast<hook>(&call_it); }
};


} /* namespace internal */

/** Converts an arbitrary functor to a unified type which is opaque.
 * sigc::slot itself is a functor or to be more precise a closure. It contains
 * a single, arbitrary functor (or closure) that is executed in operator()().
 *
 * The template arguments determine the function signature of operator()():
 * - @e T_return The return type of operator()().
 * - @e T_arg1 Argument type used in the definition of operator()(). The default @p nil means no argument.
 * - @e T_arg2 Argument type used in the definition of operator()(). The default @p nil means no argument.
 * - @e T_arg3 Argument type used in the definition of operator()(). The default @p nil means no argument.
 * - @e T_arg4 Argument type used in the definition of operator()(). The default @p nil means no argument.
 * - @e T_arg5 Argument type used in the definition of operator()(). The default @p nil means no argument.
 * - @e T_arg6 Argument type used in the definition of operator()(). The default @p nil means no argument.
 * - @e T_arg7 Argument type used in the definition of operator()(). The default @p nil means no argument.
 *
 * To use simply assign the slot to the desired functor. If the functor
 * is not compatible with the parameter list defined with the template
 * arguments compiler errors are triggered. When called the slot
 * will invoke the functor with minimal copies.
 * block() and unblock() can be used to block the functor's invocation
 * from operator()() temporarily.
 *
 * @par Example:
 *   @code
 *   void foo(int) {}
 *   sigc::slot<void, long> s = sigc::ptr_fun(&foo);
 *   s(19);
 *   @endcode
 *
 * @ingroup slot
 */
/* TODO: Where put the following bit of information? I can't make any
 *       sense of the "because", by the way!
 *
 * Because slot is opaque, visit_each() will not visit its internal members.
 */
template <class T_return, class T_arg1 = nil,class T_arg2 = nil,class T_arg3 = nil,class T_arg4 = nil,class T_arg5 = nil,class T_arg6 = nil,class T_arg7 = nil>
class slot 
  : public slot_base
{
public:
  typedef T_return result_type;
  typedef typename type_trait<T_arg1>::take arg1_type_;
  typedef typename type_trait<T_arg2>::take arg2_type_;
  typedef typename type_trait<T_arg3>::take arg3_type_;
  typedef typename type_trait<T_arg4>::take arg4_type_;
  typedef typename type_trait<T_arg5>::take arg5_type_;
  typedef typename type_trait<T_arg6>::take arg6_type_;
  typedef typename type_trait<T_arg7>::take arg7_type_;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*, arg1_type_,arg2_type_,arg3_type_,arg4_type_,arg5_type_,arg6_type_,arg7_type_);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @param _A_a5 Argument to be passed on to the functor.
   * @param _A_a6 Argument to be passed on to the functor.
   * @param _A_a7 Argument to be passed on to the functor.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()(arg1_type_ _A_a1,arg2_type_ _A_a2,arg3_type_ _A_a3,arg4_type_ _A_a4,arg5_type_ _A_a5,arg6_type_ _A_a6,arg7_type_ _A_a7) const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_, _A_a1,_A_a2,_A_a3,_A_a4,_A_a5,_A_a6,_A_a7);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call7<T_functor, T_return, T_arg1,T_arg2,T_arg3,T_arg4,T_arg5,T_arg6,T_arg7>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};


/** Converts an arbitrary functor to a unified type which is opaque.
 * This is the template specialization of the sigc::slot template
 * for 0 arguments.
 */
template <class T_return>
class slot <T_return>
  : public slot_base
{
public:
  typedef T_return result_type;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()() const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call0<T_functor, T_return>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};

/** Converts an arbitrary functor to a unified type which is opaque.
 * This is the template specialization of the sigc::slot template
 * for 1 arguments.
 */
template <class T_return, class T_arg1>
class slot <T_return, T_arg1>
  : public slot_base
{
public:
  typedef T_return result_type;
  typedef typename type_trait<T_arg1>::take arg1_type_;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*, arg1_type_);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @param _A_a1 Argument to be passed on to the functor.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()(arg1_type_ _A_a1) const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_, _A_a1);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call1<T_functor, T_return, T_arg1>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};

/** Converts an arbitrary functor to a unified type which is opaque.
 * This is the template specialization of the sigc::slot template
 * for 2 arguments.
 */
template <class T_return, class T_arg1,class T_arg2>
class slot <T_return, T_arg1,T_arg2>
  : public slot_base
{
public:
  typedef T_return result_type;
  typedef typename type_trait<T_arg1>::take arg1_type_;
  typedef typename type_trait<T_arg2>::take arg2_type_;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*, arg1_type_,arg2_type_);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()(arg1_type_ _A_a1,arg2_type_ _A_a2) const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_, _A_a1,_A_a2);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call2<T_functor, T_return, T_arg1,T_arg2>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};

/** Converts an arbitrary functor to a unified type which is opaque.
 * This is the template specialization of the sigc::slot template
 * for 3 arguments.
 */
template <class T_return, class T_arg1,class T_arg2,class T_arg3>
class slot <T_return, T_arg1,T_arg2,T_arg3>
  : public slot_base
{
public:
  typedef T_return result_type;
  typedef typename type_trait<T_arg1>::take arg1_type_;
  typedef typename type_trait<T_arg2>::take arg2_type_;
  typedef typename type_trait<T_arg3>::take arg3_type_;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*, arg1_type_,arg2_type_,arg3_type_);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()(arg1_type_ _A_a1,arg2_type_ _A_a2,arg3_type_ _A_a3) const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_, _A_a1,_A_a2,_A_a3);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call3<T_functor, T_return, T_arg1,T_arg2,T_arg3>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};

/** Converts an arbitrary functor to a unified type which is opaque.
 * This is the template specialization of the sigc::slot template
 * for 4 arguments.
 */
template <class T_return, class T_arg1,class T_arg2,class T_arg3,class T_arg4>
class slot <T_return, T_arg1,T_arg2,T_arg3,T_arg4>
  : public slot_base
{
public:
  typedef T_return result_type;
  typedef typename type_trait<T_arg1>::take arg1_type_;
  typedef typename type_trait<T_arg2>::take arg2_type_;
  typedef typename type_trait<T_arg3>::take arg3_type_;
  typedef typename type_trait<T_arg4>::take arg4_type_;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*, arg1_type_,arg2_type_,arg3_type_,arg4_type_);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()(arg1_type_ _A_a1,arg2_type_ _A_a2,arg3_type_ _A_a3,arg4_type_ _A_a4) const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_, _A_a1,_A_a2,_A_a3,_A_a4);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call4<T_functor, T_return, T_arg1,T_arg2,T_arg3,T_arg4>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};

/** Converts an arbitrary functor to a unified type which is opaque.
 * This is the template specialization of the sigc::slot template
 * for 5 arguments.
 */
template <class T_return, class T_arg1,class T_arg2,class T_arg3,class T_arg4,class T_arg5>
class slot <T_return, T_arg1,T_arg2,T_arg3,T_arg4,T_arg5>
  : public slot_base
{
public:
  typedef T_return result_type;
  typedef typename type_trait<T_arg1>::take arg1_type_;
  typedef typename type_trait<T_arg2>::take arg2_type_;
  typedef typename type_trait<T_arg3>::take arg3_type_;
  typedef typename type_trait<T_arg4>::take arg4_type_;
  typedef typename type_trait<T_arg5>::take arg5_type_;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*, arg1_type_,arg2_type_,arg3_type_,arg4_type_,arg5_type_);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @param _A_a5 Argument to be passed on to the functor.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()(arg1_type_ _A_a1,arg2_type_ _A_a2,arg3_type_ _A_a3,arg4_type_ _A_a4,arg5_type_ _A_a5) const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_, _A_a1,_A_a2,_A_a3,_A_a4,_A_a5);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call5<T_functor, T_return, T_arg1,T_arg2,T_arg3,T_arg4,T_arg5>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};

/** Converts an arbitrary functor to a unified type which is opaque.
 * This is the template specialization of the sigc::slot template
 * for 6 arguments.
 */
template <class T_return, class T_arg1,class T_arg2,class T_arg3,class T_arg4,class T_arg5,class T_arg6>
class slot <T_return, T_arg1,T_arg2,T_arg3,T_arg4,T_arg5,T_arg6>
  : public slot_base
{
public:
  typedef T_return result_type;
  typedef typename type_trait<T_arg1>::take arg1_type_;
  typedef typename type_trait<T_arg2>::take arg2_type_;
  typedef typename type_trait<T_arg3>::take arg3_type_;
  typedef typename type_trait<T_arg4>::take arg4_type_;
  typedef typename type_trait<T_arg5>::take arg5_type_;
  typedef typename type_trait<T_arg6>::take arg6_type_;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  typedef internal::slot_rep rep_type;
public:
  typedef T_return (*call_type)(rep_type*, arg1_type_,arg2_type_,arg3_type_,arg4_type_,arg5_type_,arg6_type_);
#endif

  /** Invoke the contained functor unless slot is in blocking state.
   * @param _A_a1 Argument to be passed on to the functor.
   * @param _A_a2 Argument to be passed on to the functor.
   * @param _A_a3 Argument to be passed on to the functor.
   * @param _A_a4 Argument to be passed on to the functor.
   * @param _A_a5 Argument to be passed on to the functor.
   * @param _A_a6 Argument to be passed on to the functor.
   * @return The return value of the functor invocation.
   */
  inline T_return operator()(arg1_type_ _A_a1,arg2_type_ _A_a2,arg3_type_ _A_a3,arg4_type_ _A_a4,arg5_type_ _A_a5,arg6_type_ _A_a6) const
    {
      if (!empty() && !blocked())
        return (reinterpret_cast<call_type>(rep_->call_))(rep_, _A_a1,_A_a2,_A_a3,_A_a4,_A_a5,_A_a6);
      return T_return();
    }

  /** Constructs an empty slot. */
  inline slot() 
    {}

  /** Constructs a slot from an arbitrary functor.
   * @param _A_func The desirer functor the new slot should be assigned to.
   */
  template <class T_functor>
  slot(const T_functor& _A_func)
    : slot_base(new internal::typed_slot_rep<T_functor>(_A_func))
    { rep_->call_ = internal::slot_call6<T_functor, T_return, T_arg1,T_arg2,T_arg3,T_arg4,T_arg5,T_arg6>::address(); }

  /** Constructs a slot, copying an existing one.
   * @param src The existing slot to copy.
   */
  slot(const slot& src)
    : slot_base(src) {}

  /** Overrides this slot making a copy from another slot.
   * @param src The slot from which to make a copy.
   * @return @p this.
   */
  slot& operator=(const slot& src)
    { slot_base::operator=(src); return *this; }
};



} /* namespace sigc */
#endif /* _SIGC_FUNCTORS_MACROS_SLOTHM4_ */
