
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgnomedbmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "basicform.h"
#include "combo.h"
#include "connectionproperties.h"
#include "datacellrendererboolean.h"
#include "datacellrenderercombo.h"
#include "datacellrendererinfo.h"
#include "datacellrenderertextual.h"
#include "dataentry.h"
#include "datawidget.h"
#include "datawidgetinfo.h"
#include "datasourceselector.h"
#include "datastore.h"
#include "dbmsupdateviewer.h"
#include "dsneditor.h"
#include "dsnspec.h"
#include "entryboolean.h"
#include "entrycombo.h"
#include "entrycommontime.h"
#include "entrydate.h"
#include "entrynone.h"
#include "entryshell.h"
#include "entrystring.h"
#include "entrytime.h"
#include "entrytimestamp.h"
#include "entrywrapper.h"
#include "editor.h"
#include "error.h"
#include "errordialog.h"
#include "finddialog.h"
#include "form.h"
#include "formatentry.h"
#include "graybar.h"
#include "grid.h"
#include "login.h"
#include "logindialog.h"
#include "providerselector.h"
#include "rawform.h"
#include "rawgrid.h"
#include "reporteditor.h"
#include "selector.h"
#include "serveroperation.h"
#include "sqlconsole.h"
#include "transactionstatus.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gnome_db_basic_form_get_type(void);
GType gnome_db_combo_get_type(void);
GType gnome_db_connection_properties_get_type(void);
GType gnome_db_data_cell_renderer_boolean_get_type(void);
GType gnome_db_data_cell_renderer_combo_get_type(void);
GType gnome_db_data_cell_renderer_info_get_type(void);
GType gnome_db_data_cell_renderer_textual_get_type(void);
GType gnome_db_data_source_selector_get_type(void);
GType gnome_db_data_store_get_type(void);
GType gnome_db_data_widget_info_get_type(void);
GType gnome_db_dbms_update_viewer_get_type(void);
GType gnome_db_dsn_editor_get_type(void);
GType gnome_db_dsn_spec_get_type(void);
GType gnome_db_editor_get_type(void);
GType gnome_db_entry_boolean_get_type(void);
GType gnome_db_entry_combo_get_type(void);
GType gnome_db_entry_common_time_get_type(void);
GType gnome_db_entry_date_get_type(void);
GType gnome_db_entry_none_get_type(void);
GType gnome_db_entry_shell_get_type(void);
GType gnome_db_entry_string_get_type(void);
GType gnome_db_entry_time_get_type(void);
GType gnome_db_entry_timestamp_get_type(void);
GType gnome_db_entry_wrapper_get_type(void);
GType gnome_db_error_get_type(void);
GType gnome_db_error_dialog_get_type(void);
GType gnome_db_find_dialog_get_type(void);
GType gnome_db_form_get_type(void);
GType gnome_db_format_entry_get_type(void);
GType gnome_db_gray_bar_get_type(void);
GType gnome_db_grid_get_type(void);
GType gnome_db_login_get_type(void);
GType gnome_db_login_dialog_get_type(void);
GType gnome_db_provider_selector_get_type(void);
GType gnome_db_raw_form_get_type(void);
GType gnome_db_raw_grid_get_type(void);
GType gnome_db_report_editor_get_type(void);
GType gnome_db_selector_get_type(void);
GType gnome_db_server_operation_get_type(void);
GType gnome_db_sql_console_get_type(void);
GType gnome_db_transaction_status_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace Db {  class BasicForm_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class Combo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class ConnectionProperties_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DataCellRendererBoolean_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DataCellRendererCombo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DataCellRendererInfo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DataCellRendererTextual_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DataSourceSelector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DataStore_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DataWidgetInfo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DbmsUpdateViewer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DsnEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class DsnSpec_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class Editor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryBoolean_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryCombo_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryCommonTime_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryDate_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryNone_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryShell_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryString_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryTime_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryTimestamp_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class EntryWrapper_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class Error_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class ErrorDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class FindDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class Form_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class FormatEntry_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class GrayBar_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class Grid_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class Login_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class LoginDialog_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class ProviderSelector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class RawForm_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class RawGrid_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class ReportEditor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class Selector_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class ServerOperation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class SqlConsole_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Db {  class TransactionStatus_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace Db { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gnome_db_basic_form_get_type(), &Gnome::Db::BasicForm_Class::wrap_new);
  Glib::wrap_register(gnome_db_combo_get_type(), &Gnome::Db::Combo_Class::wrap_new);
  Glib::wrap_register(gnome_db_connection_properties_get_type(), &Gnome::Db::ConnectionProperties_Class::wrap_new);
  Glib::wrap_register(gnome_db_data_cell_renderer_boolean_get_type(), &Gnome::Db::DataCellRendererBoolean_Class::wrap_new);
  Glib::wrap_register(gnome_db_data_cell_renderer_combo_get_type(), &Gnome::Db::DataCellRendererCombo_Class::wrap_new);
  Glib::wrap_register(gnome_db_data_cell_renderer_info_get_type(), &Gnome::Db::DataCellRendererInfo_Class::wrap_new);
  Glib::wrap_register(gnome_db_data_cell_renderer_textual_get_type(), &Gnome::Db::DataCellRendererTextual_Class::wrap_new);
  Glib::wrap_register(gnome_db_data_source_selector_get_type(), &Gnome::Db::DataSourceSelector_Class::wrap_new);
  Glib::wrap_register(gnome_db_data_store_get_type(), &Gnome::Db::DataStore_Class::wrap_new);
  Glib::wrap_register(gnome_db_data_widget_info_get_type(), &Gnome::Db::DataWidgetInfo_Class::wrap_new);
  Glib::wrap_register(gnome_db_dbms_update_viewer_get_type(), &Gnome::Db::DbmsUpdateViewer_Class::wrap_new);
  Glib::wrap_register(gnome_db_dsn_editor_get_type(), &Gnome::Db::DsnEditor_Class::wrap_new);
  Glib::wrap_register(gnome_db_dsn_spec_get_type(), &Gnome::Db::DsnSpec_Class::wrap_new);
  Glib::wrap_register(gnome_db_editor_get_type(), &Gnome::Db::Editor_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_boolean_get_type(), &Gnome::Db::EntryBoolean_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_combo_get_type(), &Gnome::Db::EntryCombo_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_common_time_get_type(), &Gnome::Db::EntryCommonTime_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_date_get_type(), &Gnome::Db::EntryDate_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_none_get_type(), &Gnome::Db::EntryNone_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_shell_get_type(), &Gnome::Db::EntryShell_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_string_get_type(), &Gnome::Db::EntryString_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_time_get_type(), &Gnome::Db::EntryTime_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_timestamp_get_type(), &Gnome::Db::EntryTimestamp_Class::wrap_new);
  Glib::wrap_register(gnome_db_entry_wrapper_get_type(), &Gnome::Db::EntryWrapper_Class::wrap_new);
  Glib::wrap_register(gnome_db_error_get_type(), &Gnome::Db::Error_Class::wrap_new);
  Glib::wrap_register(gnome_db_error_dialog_get_type(), &Gnome::Db::ErrorDialog_Class::wrap_new);
  Glib::wrap_register(gnome_db_find_dialog_get_type(), &Gnome::Db::FindDialog_Class::wrap_new);
  Glib::wrap_register(gnome_db_form_get_type(), &Gnome::Db::Form_Class::wrap_new);
  Glib::wrap_register(gnome_db_format_entry_get_type(), &Gnome::Db::FormatEntry_Class::wrap_new);
  Glib::wrap_register(gnome_db_gray_bar_get_type(), &Gnome::Db::GrayBar_Class::wrap_new);
  Glib::wrap_register(gnome_db_grid_get_type(), &Gnome::Db::Grid_Class::wrap_new);
  Glib::wrap_register(gnome_db_login_get_type(), &Gnome::Db::Login_Class::wrap_new);
  Glib::wrap_register(gnome_db_login_dialog_get_type(), &Gnome::Db::LoginDialog_Class::wrap_new);
  Glib::wrap_register(gnome_db_provider_selector_get_type(), &Gnome::Db::ProviderSelector_Class::wrap_new);
  Glib::wrap_register(gnome_db_raw_form_get_type(), &Gnome::Db::RawForm_Class::wrap_new);
  Glib::wrap_register(gnome_db_raw_grid_get_type(), &Gnome::Db::RawGrid_Class::wrap_new);
  Glib::wrap_register(gnome_db_report_editor_get_type(), &Gnome::Db::ReportEditor_Class::wrap_new);
  Glib::wrap_register(gnome_db_selector_get_type(), &Gnome::Db::Selector_Class::wrap_new);
  Glib::wrap_register(gnome_db_server_operation_get_type(), &Gnome::Db::ServerOperation_Class::wrap_new);
  Glib::wrap_register(gnome_db_sql_console_get_type(), &Gnome::Db::SqlConsole_Class::wrap_new);
  Glib::wrap_register(gnome_db_transaction_status_get_type(), &Gnome::Db::TransactionStatus_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::Db::BasicForm::get_type();
  Gnome::Db::Combo::get_type();
  Gnome::Db::ConnectionProperties::get_type();
  Gnome::Db::DataCellRendererBoolean::get_type();
  Gnome::Db::DataCellRendererCombo::get_type();
  Gnome::Db::DataCellRendererInfo::get_type();
  Gnome::Db::DataCellRendererTextual::get_type();
  Gnome::Db::DataSourceSelector::get_type();
  Gnome::Db::DataStore::get_type();
  Gnome::Db::DataWidgetInfo::get_type();
  Gnome::Db::DbmsUpdateViewer::get_type();
  Gnome::Db::DsnEditor::get_type();
  Gnome::Db::DsnSpec::get_type();
  Gnome::Db::Editor::get_type();
  Gnome::Db::EntryBoolean::get_type();
  Gnome::Db::EntryCombo::get_type();
  Gnome::Db::EntryCommonTime::get_type();
  Gnome::Db::EntryDate::get_type();
  Gnome::Db::EntryNone::get_type();
  Gnome::Db::EntryShell::get_type();
  Gnome::Db::EntryString::get_type();
  Gnome::Db::EntryTime::get_type();
  Gnome::Db::EntryTimestamp::get_type();
  Gnome::Db::EntryWrapper::get_type();
  Gnome::Db::Error::get_type();
  Gnome::Db::ErrorDialog::get_type();
  Gnome::Db::FindDialog::get_type();
  Gnome::Db::Form::get_type();
  Gnome::Db::FormatEntry::get_type();
  Gnome::Db::GrayBar::get_type();
  Gnome::Db::Grid::get_type();
  Gnome::Db::Login::get_type();
  Gnome::Db::LoginDialog::get_type();
  Gnome::Db::ProviderSelector::get_type();
  Gnome::Db::RawForm::get_type();
  Gnome::Db::RawGrid::get_type();
  Gnome::Db::ReportEditor::get_type();
  Gnome::Db::Selector::get_type();
  Gnome::Db::ServerOperation::get_type();
  Gnome::Db::SqlConsole::get_type();
  Gnome::Db::TransactionStatus::get_type();

} // wrap_init()

} //Db
} //Gnome


