// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEDBMM_COMBO_H
#define _LIBGNOMEDBMM_COMBO_H


#include <glibmm.h>

// -*- C++ -*- // 

/* combo.h
 * 
 * Copyright 2006 libgnomedbmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/combobox.h>
#include <libgdamm/datamodel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GnomeDbCombo GnomeDbCombo;
typedef struct _GnomeDbComboClass GnomeDbComboClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Db
{ class Combo_Class; } // namespace Db

} // namespace Gnome
namespace Gnome
{

namespace Db
{

/** A combo box with data to be displayed from a Gda::DataModel.
 * This widget acts like the Gtk::ComboBox widget which it inherits, 
 * but displays data from a provided Gda::DataModel and it is easy to set the currently 
 * selected row or retrieve values of the currently selected row.
 *
 * Specifically, it is possible to show only some columns of the data model 
 * by providing an array of integers (containing the column number of each column to display). 
 *
 * @ingroup DbWidgets
 */

class Combo : public Gtk::ComboBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Combo CppObjectType;
  typedef Combo_Class CppClassType;
  typedef GnomeDbCombo BaseObjectType;
  typedef GnomeDbComboClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Combo();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Combo_Class;
  static CppClassType combo_class_;

  // noncopyable
  Combo(const Combo&);
  Combo& operator=(const Combo&);

protected:
  explicit Combo(const Glib::ConstructParams& construct_params);
  explicit Combo(GnomeDbCombo* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GnomeDbCombo*       gobj()       { return reinterpret_cast<GnomeDbCombo*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GnomeDbCombo* gobj() const { return reinterpret_cast<GnomeDbCombo*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Combo();

  // We need to hand-code the constructors because the C version also takes int n_cols which
  // is not required in C++.

  /** Create a new Combo widget with a model. See set_model() for
   * more information.
   *
   * @param model A Gda::DataModel object.
   * @param cols_index The indexes of the columns in the model to be shown.
   */
  Combo(const Glib::RefPtr<Gda::DataModel>& model, const Glib::ArrayHandle<int>& cols_index);

  /** Create a new Combo widget with a model. See set_model() for
   * more information.
   *
   * @param model A Gda::DataModel object.
   */
  explicit Combo(const Glib::RefPtr<Gda::DataModel>& model);

 /* Makes the combo display data stored in @a model (makes the
   * combo widget refresh its list of values and display the values contained
   * in the model). 
   *
   * See also unset_model().
   *
   * @param model A Gda::DataModel object.
   * @param cols_index The indexes of the columns in the model to be shown.
   */
  void set_model(const Glib::RefPtr<Gda::DataModel>& model, const Glib::ArrayHandle<int>& cols_index);
  

  /* Makes the combo display all columns of data stored in @a model (makes the
   * combo widget refresh its list of values and display the values contained
   * in the model). 
   *
   * See also unset_model().
   *
   * @param model A Gda::DataModel object.
   */
  void set_model(const Glib::RefPtr<Gda::DataModel>& model);

  /** Make the combo empty and disassociate the previous model, if any.
   */
  void unset_model();

  
  /** This function returns the Gda::DataModel from which @a combo  displays values.
   * @return A Gda::DataModel containing the data from the Gnome::DbCombo widget.
   */
  Glib::RefPtr<Gda::DataModel> get_model();
  
  /** This function returns the Gda::DataModel from which @a combo  displays values.
   * @return A Gda::DataModel containing the data from the Gnome::DbCombo widget.
   */
  Glib::RefPtr<const Gda::DataModel> get_model() const;

   
  /** Sets the currently selected row of @a combo  from the values stored in @a values . 
   * 
   * WARNING: @a values  must contain one value for each column set to be displayed when the
   * data model was associated to @a combo .
   * @param values A list of G::Value.
   * @return <tt>true</tt> if a row in the model was found to match the list of values.
   */
  bool set_values(const Glib::SListHandle<Gda::Value>& values);

   
  /** Sets the currently selected row of @a combo  from the values stored in @a values , assuming that
   * these values correspond to the columns listed in @a cols_index . @a cols_index  must contain at least as
   * many <tt>int</tt> as there are elements in @a values ;
   * 
   * if @a cols_index  is <tt>0</tt>, then it is assumed that @a values  has the same number of columns 
   * than @a combo 's data
   * model and that the values in @a values  are ordered in the same way as the columns of 
   *  @a combo 's data model.
   * @param values A list of G::Value objects.
   * @param cols_index Array of <tt>int</tt>, index of column to which each value in @a values  corresponds, or <tt>0</tt>.
   * @return <tt>true</tt> if a row in the model was found to match the list of values.
   */
  bool set_values(const Glib::SListHandle<Gda::Value>& values, const Glib::ArrayHandle<int>& cols_index);


   // We own the list, but not the GValues in it.
   

  /** Get a list of the currently selected values in @a combo . The list itself must be free'd using Glib::slist_free(), 
   * but not the values it contains.
   * 
   * WARNING: @a values  will contain one value for each column set to be displayed when the
   * data model was associated to @a combo .
   * @return A new list of values, or <tt>0</tt> if there is no displayed data in @a combo .
   */
  Glib::SListHandle<Gda::Value> get_values() const;

  /** Get a list of the currently selected values in particular columns.
   *
   * @param cols_index An array of indexes indicating which columns to get a value for.
   * @result A list of selected values.
   */
  Glib::SListHandle<Gda::Value> get_values(const Glib::ArrayHandle<int>& cols_index) const;
  

  /** Tells if @a combo  should add a special entry representing an "undefined choice". The default is
   * that only the available choices in @a combo 's model are presented.
   */
  void add_undef_choice(bool add_undef_choice = true);
  
  /** Tell if the currently selected entry represents the "undefined choice" entry.
   */
  bool undef_selected() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gda::DataModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gda::DataModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Db
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Db::Combo
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gnome::Db::Combo* wrap(GnomeDbCombo* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGNOMEDBMM_COMBO_H */

