#include <libgnomedbmm.h>
#include <gtkmm.h>

int main(int argc, char* argv[])
{
  Gtk::Main kit(argc, argv);
  Gnome::Db::init("Example", "1.0", argc, argv);

#ifndef GLIBMM_EXCEPTIONS_ENABLED
  std::auto_ptr<Glib::Error> error;
#endif

  Glib::RefPtr<Gnome::Gda::Client> client = Gnome::Gda::Client::create();
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Gnome::Gda::Connection> connection = client->open_connection_from_string("SQLite", "DB_DIR=" LIBGNOMEDB_DATADIR ";DB_NAME=demo_db", "" /* username */, "" /* password */);
#else
  Glib::RefPtr<Gnome::Gda::Connection> connection = client->open_connection_from_string("SQLite", "DB_DIR=" LIBGNOMEDB_DATADIR ";DB_NAME=demo_db", "" /* username */, "" /* password */, Gnome::Gda::ConnectionOptions(0), error);
  if(error.get() != NULL) return -1;
#endif // GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Gnome::Gda::DataModel> model = connection->execute_select_command("SELECT * FROM products");
#else
  Glib::RefPtr<Gnome::Gda::DataModel> model = connection->execute_select_command("SELECT * FROM products", error);
  if(error.get() != NULL) return -1;
#endif // GLIBMM_EXCEPTIONS_ENABLED

  Gnome::Db::Grid grid(model);
  Gnome::Db::RawGrid* raw_grid = grid.get_raw_grid();
  raw_grid->get_column(0)->set_title("ID");
  raw_grid->get_column(1)->set_title("Category");
  raw_grid->get_column(2)->set_title("Name");
  raw_grid->get_column(3)->set_title("Price");
  raw_grid->get_column(4)->set_title("Stored");

  Gtk::Window window;
  window.set_title("Libgnomedbmm example window");
  window.set_default_size(400, 400);
  window.add(grid);
  window.show_all();

  kit.run(window);
  return 0;
}
