
#include <libgnomedbmm.h>

class ReadOnlyGridDemo: public Gtk::Window
{
public:
  static const char* FILE;

  ReadOnlyGridDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict);
};

const char* ReadOnlyGridDemo::FILE = __FILE__;

ReadOnlyGridDemo::ReadOnlyGridDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict):
  Gtk::Window(Gtk::WINDOW_TOPLEVEL)
{
  Gtk::VBox* box = Gtk::manage(new Gtk::VBox(false, 5));
  Gtk::Label* label = Gtk::manage(new Gtk::Label("The following GnomeDbGrid widget displays data from the 'products' table.\n\n"
                                                 "As no modification query is provided, the data is read-only."));

  Glib::RefPtr<Gnome::Gda::Query> query = Gnome::Gda::Query::create(dict);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
    query->set_sql_text("SELECT * FROM products");
  }
  catch(const Glib::Error& e)
  {
    std::cerr << e.what() << std::endl;
  }
#else
  std::auto_ptr<Glib::Error> error;
  query->set_sql_text("SELECT * FROM products", error);
  if(error.get() != NULL)
    std::cerr << error->what() << std::endl;
#endif

  Glib::RefPtr<Gnome::Gda::DataModelQuery> model = Gnome::Gda::DataModelQuery::create(query);
  Gnome::Db::Grid* grid = Gtk::manage(new Gnome::Db::Grid(model));

  box->pack_start(*label, Gtk::PACK_SHRINK);
  box->pack_start(*grid);
  add(*box);

  show_all_children();
}
