/* gnome-db-canvas.h
 *
 * Copyright (C) 2002 - 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_CANVAS__
#define __GNOME_DB_CANVAS__

#include <libgnomecanvas/gnome-canvas.h>
#include <libgda/gda-decl.h>
#include <libgnomedb/gnome-db-decl.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_CANVAS          (gnome_db_canvas_get_type())
#define GNOME_DB_CANVAS(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_canvas_get_type(), GnomeDbCanvas)
#define GNOME_DB_CANVAS_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_canvas_get_type (), GnomeDbCanvasClass)
#define GNOME_DB_IS_CANVAS(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_canvas_get_type ())


/* struct for the object's data */
struct _GnomeDbCanvas
{
	GnomeCanvas         widget;

	/* pointer position when a context menu was last opened */
	gdouble             xmouse;
	gdouble             ymouse;
	/* private */
	GnomeDbCanvasPrivate    *priv;
};

/* struct for the object's class */
struct _GnomeDbCanvasClass
{
	GnomeCanvasClass parent_class;

	/* virtual functions */
	void           (*create_canvas_items) (GnomeDbCanvas *canvas); /* create individual GnomeDbCanvasItem objects */
	void           (*clean_canvas_items)  (GnomeDbCanvas *canvas); /* clean any extra structure, not the individual items */

	void           (*graph_item_added)    (GnomeDbCanvas *canvas, GdaGraphItem *item);
	void           (*graph_item_dropped)  (GnomeDbCanvas *canvas, GdaGraphItem *item);

	GtkWidget     *(*build_context_menu)  (GnomeDbCanvas *canvas);
	void           (*set_pixels_per_unit) (GnomeDbCanvas *canvas, gdouble n);

	/* signals */
	void           (*drag_action)        (GnomeDbCanvas *canvas, GnomeDbCanvasItem *from_item, GnomeDbCanvasItem *to_item);
};

/* generic widget's functions */
GType            gnome_db_canvas_get_type                (void);

GdaGraph         *gnome_db_canvas_get_graph               (GnomeDbCanvas *canvas);

GtkWidget       *gnome_db_canvas_set_in_scrolled_window  (GnomeDbCanvas *canvas);
void             gnome_db_canvas_declare_item            (GnomeDbCanvas *canvas, GnomeDbCanvasItem *item);

GnomeDbCanvasItem    *gnome_db_canvas_get_item_for_object     (GnomeDbCanvas *canvas, GdaObject *ref_obj);
void             gnome_db_canvas_set_zoom_factor         (GnomeDbCanvas *canvas, gdouble n);
gdouble          gnome_db_canvas_get_zoom_factor         (GnomeDbCanvas *canvas);
gdouble          gnome_db_canvas_fit_zoom_factor         (GnomeDbCanvas *canvas);

#define GNOME_DB_CANVAS_ENTITY_COLOR      "yellow"
#define GNOME_DB_CANVAS_DB_TABLE_COLOR    "lightblue"
#define GNOME_DB_CANVAS_QUERY_COLOR       "lightgreen"

G_END_DECLS

#endif
