import unittest
from utils import refresh_gui, init_gazpacho
import gtk

app, project = init_gazpacho()

from gazpacho import command

#what will we do with these?
widgetProperties = ['app_paintable', 'can_default', 'can_focus', \
                    'composite_child', 'events', 'extension_events', \
                    'has_default', 'has_focus', 'height_request', \
                    'is_focus', 'name', 'no_show_all', 'parent', \
                    'receives_default', 'sensitive', 'style', 'visible']
                      
#2.6 -> single-line-mode
boolProperties = ['selectable', 'use-markup', 'use-underline', 'wrap']
# missing: attributes, ellipsize, justify, width-chars
customProperties = {'label':['label', 'Read Me!'], \
                    'xalign':[0.0, 0.5, 1.0], \
                    'yalign':[0.0, 0.3, 1.0], \
                    'xpad':[1, 3], \
                    'ypad':[2, 6]}
#not used yet
readProperties = ['cursor_position', 'mnemonic_keyval', 'selection_bound']
 
class GtkLabelTest(unittest.TestCase):
   
    def test01Creation(self):
        global app, project
        app.palette.select_widget('Gtk+ Base', 'GtkWindow')
        refresh_gui()
        gwidget = project.get_widget_by_name('window1')
        app.palette.select_widget('Gtk+ Base', 'GtkLabel')
        placeholder = gwidget.gtk_widget.get_child()
        cm = app.get_command_manager()
        cm.create(app.add_class, placeholder, None)
        refresh_gui()
        gwidget = project.get_widget_by_name('label1')
        self.assertEqual(gtk.Label, type(gwidget.gtk_widget))

    def test02boolProperties(self):
        global app, project, boolProperties
        gwidget = project.get_widget_by_name('label1')
        cm = app.get_command_manager()
        for property in boolProperties:
            prop = gwidget.get_glade_property(property)
            if prop is not None:
                cm.set_property(prop, True)
                refresh_gui()
                self.assertEqual(gwidget.gtk_widget.get_property(property),
                                 True)
                cm.set_property(prop, False)
                refresh_gui()
                self.assertEqual(gwidget.gtk_widget.get_property(property),
                                 False)
            else:
                self.fail("prop for %s is None" % property)

    def test03customProperties(self):
        global app, project, customProperties
        gwidget = project.get_widget_by_name('label1')
        cm = app.get_command_manager()
        for property in customProperties.keys():
            prop = gwidget.get_glade_property(property)
            #should we check custom setters and getters?
            for value in customProperties[property]:
                cm.set_property(prop, value)
                refresh_gui()
                savedvalue = gwidget.gtk_widget.get_property(property)
                if isinstance(value, (basestring, bool)):
                    self.assertEqual(savedvalue , value)
                else:
                    self.assertAlmostEqual(savedvalue, value)

    def test04readProperties(self):
        global app, project, readProperties
        #gwidget = project.get_widget_by_name('label1')
        #prop = gwidget.get_glade_property('xalign')
        #cm = app.get_command_manager()
        #cm.set_property(prop, 'False')
        #refresh_gui()
        #self.assertEqual(gwidget.widget.get_label(), 'False')
        pass
 
    def test25Saving(self):
        global project
        project.save(__file__+'.glade')
        refresh_gui()
        
    def test26Loading(self):
        global app
        app.open_project(__file__+'.glade')
        refresh_gui()
        
if __name__ == '__main__':
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(GtkLabelTest))
    unittest.TextTestRunner(verbosity=2).run(suite)
