/* This is -*- C -*- */
/* vim: set sw=2: */
/* $Id: guppi-chart.h,v 1.2 2001/11/19 05:40:44 trow Exp $ */

/*
 * guppi-chart.h
 *
 * Copyright (C) 2001 The Free Software Foundation
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CHART_H
#define _INC_GUPPI_CHART_H

#include <gnome.h>
#include  "guppi-defs.h"
#include "guppi-root-group-view.h"

BEGIN_GUPPI_DECLS;

typedef struct _GuppiChart GuppiChart;
typedef struct _GuppiChartPrivate GuppiChartPrivate;
typedef struct _GuppiChartClass GuppiChartClass;

struct _GuppiChart {
  GtkObject parent;
  GuppiChartPrivate *priv;
};

struct _GuppiChartClass {
  GtkObjectClass parent_class;

  void     (*construct) (GuppiChart *, GuppiRootGroupView *);
  gchar   *(*set_data)  (GuppiChart *, const gchar *hint, GuppiData *);
  gboolean (*command)   (GuppiChart *, const gchar *cmd, va_list args);
};

#define GUPPI_TYPE_CHART (guppi_chart_get_type ())
#define GUPPI_CHART(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CHART,GuppiChart))
#define GUPPI_CHART0(obj) ((obj) ? (GUPPI_CHART(obj)) : NULL)
#define GUPPI_CHART_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CHART,GuppiChartClass))
#define GUPPI_IS_CHART(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CHART))
#define GUPPI_IS_CHART0(obj) (((obj) == NULL) || (GUPPI_IS_CHART(obj)))
#define GUPPI_IS_CHART_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CHART))

GtkType guppi_chart_get_type (void);

GuppiChart *guppi_chart_new (const gchar *type);

GuppiRootGroupView *guppi_chart_get_root_group_view (GuppiChart *);
GuppiCanvasItem    *guppi_chart_make_canvas_item    (GuppiChart *, GnomeCanvas *);
GnomeCanvas        *guppi_chart_make_canvas         (GuppiChart *, GuppiCanvasItem **);

gboolean            guppi_chart_command             (GuppiChart *, const gchar *command, ...);



END_GUPPI_DECLS;

#endif /* _INC_GUPPI_CHART_H */

/* $Id: guppi-chart.h,v 1.2 2001/11/19 05:40:44 trow Exp $ */
