/* This is -*- C -*- */
/* vim: set sw=2: */
/* $Id: guppi-chart.c,v 1.1 2001/11/16 16:58:57 trow Exp $ */

/*
 * guppi-chart.c
 *
 * Copyright (C) 2001 The Free Software Foundation
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include "guppi-chart.h"

#include <guppi-memory.h>
#include <guppi-plug-in-spec.h>
#include "guppi-chart-plug-in.h"


static GtkObjectClass *parent_class = NULL;

#if 0
enum {
  LAST_SIGNAL
};

static guint guppi_chart_signals[LAST_SIGNAL] = { 0 };
#endif

struct _GuppiChartPrivate {
  GuppiRootGroupView *rgv;
};

static void
guppi_chart_finalize (GtkObject *obj)
{
  GuppiChart *x = GUPPI_CHART(obj);

  guppi_unref (x->priv->rgv);

  g_free (x->priv);
  x->priv = NULL;

  guppi_finalized (obj);

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
guppi_chart_class_init (GuppiChartClass *klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *)klass;

  parent_class = gtk_type_class (GTK_TYPE_OBJECT);

  object_class->finalize = guppi_chart_finalize;

#if 0
  /* Signal definition template */
  guppi_chart_signals[CHANGED] =
    gtk_signal_new ("changed",
                    GTK_RUN_FIRST,
                    object_class->type,
                    GTK_SIGNAL_OFFSET (GuppiChartClass, changed),
                    gtk_marshal_NONE__NONE, GTK_TYPE_NONE, 0);

  gtk_object_class_add_signals (object_class, guppi_chart_signals,
                                LAST_SIGNAL);
#endif

}

static void
guppi_chart_init (GuppiChart *obj)
{
  obj->priv = g_new0 (GuppiChartPrivate, 1);
}

GtkType
guppi_chart_get_type (void)
{
  static GtkType guppi_chart_type = 0;
  if (!guppi_chart_type) {
    static const GtkTypeInfo guppi_chart_info = {
      "GuppiChart",
      sizeof (GuppiChart),
      sizeof (GuppiChartClass),
      (GtkClassInitFunc)guppi_chart_class_init,
      (GtkObjectInitFunc)guppi_chart_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_chart_type = gtk_type_unique (GTK_TYPE_OBJECT, &guppi_chart_info);
  }
  return guppi_chart_type;
}

GuppiChart *
guppi_chart_new (const gchar *type)
{
  GuppiChartPlugIn *chart_plug_in;
  GuppiChart *chart;

  g_return_val_if_fail (type && *type, NULL);

  chart_plug_in = (GuppiChartPlugIn *) guppi_plug_in_lookup ("chart", type);
  if (chart_plug_in == NULL) {
    g_warning ("Unknown chart plug-in: \"%s\"", type);
    return NULL;
  }

  g_return_val_if_fail (GUPPI_IS_CHART_PLUG_IN (chart_plug_in), NULL);

  g_return_val_if_fail (chart_plug_in->chart_constructor != NULL, NULL);
  chart = chart_plug_in->chart_constructor ();
  g_return_val_if_fail (GUPPI_IS_CHART (chart), NULL);

  return chart;
}

GuppiRootGroupView *
guppi_chart_get_root_group_view (GuppiChart *chart)
{
  g_return_val_if_fail (GUPPI_IS_CHART (chart), NULL);

  if (chart->priv->rgv == NULL) {
    GuppiChartClass *klass = GUPPI_CHART_CLASS (GTK_OBJECT (chart)->klass);

    g_return_val_if_fail (klass->construct != NULL, NULL);

    chart->priv->rgv = guppi_root_group_view_new ();
    klass->construct (chart, chart->priv->rgv);
  }

  return chart->priv->rgv;
}

GuppiCanvasItem *
guppi_chart_make_canvas_item (GuppiChart *chart, GnomeCanvas *canvas)
{
  GuppiRootGroupView *rgv;

  g_return_val_if_fail (GUPPI_IS_CHART (chart), NULL);
  g_return_val_if_fail (GNOME_IS_CANVAS (canvas), NULL);

  rgv = guppi_chart_get_root_group_view (chart);
  g_return_val_if_fail (GUPPI_IS_ROOT_GROUP_VIEW (rgv), NULL);
  
  return guppi_root_group_view_make_canvas_item (rgv, canvas);
}

GnomeCanvas *
guppi_chart_make_canvas (GuppiChart *chart, GuppiCanvasItem **item_ptr)
{
  GuppiRootGroupView *rgv;

  g_return_val_if_fail (GUPPI_IS_CHART (chart), NULL);

  rgv = guppi_chart_get_root_group_view (chart);
  g_return_val_if_fail (GUPPI_IS_ROOT_GROUP_VIEW (rgv), NULL);

  return guppi_root_group_view_make_canvas (rgv, item_ptr);
}

gboolean
guppi_chart_command (GuppiChart *chart, const gchar *command, ...)
{
  GuppiChartClass *klass;
  va_list args;
  gboolean rv;

  g_return_val_if_fail (GUPPI_IS_CHART (chart), FALSE);
  g_return_val_if_fail (command && *command, FALSE);

  klass = GUPPI_CHART_CLASS (GTK_OBJECT (chart)->klass);
  g_return_val_if_fail (klass->command != NULL, FALSE);

  va_start (args, command);
  rv = klass->command (chart, command, args);
  va_end (args);

  return rv;
}
