/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_init
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1init (JNIEnv *env, 
						   jclass cls, 
						   jintArray argc, 
						   jobjectArray args) 
{
    gint *argc_g = (gint *) (*env)->GetIntArrayElements (env, argc, NULL);
    gchar **args_g_arr =getStringArray(env, args);
    gchar ***args_g = &args_g_arr;
    gtk_init (argc_g, args_g);
    (*env)->ReleaseIntArrayElements (env, argc, (jint *) argc_g, 0);
    freeStringArray(env, args, args_g_arr);
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_init_check
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1init_1check (JNIEnv *env, jclass cls, 
    jintArray argc, jobjectArray args) 
{
    gint *argc_g = (gint *) (*env)->GetIntArrayElements (env, argc, NULL);
    gchar **args_g_arr = getStringArray(env, args);
    gchar ***args_g = &args_g_arr;
    gtk_init_check (argc_g, args_g);
    (*env)->ReleaseIntArrayElements (env, argc, (jint *) argc_g, 0);
    freeStringArray(env, args, args_g_arr);
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_disable_setlocale
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1disable_1setlocale (JNIEnv *env, jclass cls) 
{
    gtk_disable_setlocale ();
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_set_locale
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Gtk_gtk_1set_1locale (JNIEnv *env, jclass cls) 
{
	return (*env)->NewStringUTF(env, gtk_set_locale ());
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_get_default_language
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1default_1language (JNIEnv *env, jclass 
    cls) 
{
    return getHandleFromPointer(env, gtk_get_default_language ());
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_events_pending
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Gtk_gtk_1events_1pending (JNIEnv *env, jclass cls) 
{
    return (jboolean)gtk_events_pending ();
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_main_do_event
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1do_1event (JNIEnv *env, jclass cls, jobject 
    event) 
{
    GdkEvent *event_g = (GdkEvent *)getPointerFromHandle(env, event);
    gtk_main_do_event (event_g);
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_main
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1main (JNIEnv *env, jclass cls) 
{
    gtk_main ();
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_main_level
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1level (JNIEnv *env, jclass cls) 
{
    return (jint)gtk_main_level();
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_main_quit
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1quit (JNIEnv *env, jclass cls) 
{
    gtk_main_quit ();
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_main_iteration
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Gtk_gtk_1main_1iteration (JNIEnv *env, jclass cls) 
{
    return (jboolean) (gtk_main_iteration ());
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_grab_add
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1grab_1add (JNIEnv *env, jclass cls, jobject 
    widget) 
{
    GtkWidget *widget_g = (GtkWidget *)getPointerFromHandle(env, widget);
    gtk_grab_add (widget_g);
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_grab_get_current
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Gtk_gtk_1grab_1get_1current (JNIEnv *env, jclass cls) 
{
    return getHandleFromPointer(env, gtk_grab_get_current ());
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_grab_remove
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Gtk_gtk_1grab_1remove (JNIEnv *env, jclass cls, jobject 
    widget) 
{
    GtkWidget *widget_g = (GtkWidget *)getPointerFromHandle(env, widget);
    gtk_grab_remove (widget_g);
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_get_current_event
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1current_1event (JNIEnv *env, jclass cls) 
{
    return getHandleFromPointer(env, gtk_get_current_event ());
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_get_current_event_time
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1current_1event_1time (JNIEnv *env, jclass 
    cls) 
{
    return (jint) (gtk_get_current_event_time ());
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_get_event_widget
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Gtk_gtk_1get_1event_1widget (JNIEnv *env, jclass cls, 
    jobject event) 
{
    GdkEvent *event_g = (GdkEvent *)getPointerFromHandle(env, event);
    return getHandleFromPointer(env, gtk_get_event_widget (event_g));
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_type_name
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Gtk_gtk_1type_1name (JNIEnv *env, jclass cls, 
    jobject type) 
{
    GType *type_g = (GType *)getPointerFromHandle(env, type);
	return (*env)->NewStringUTF(env,  (gchar*)gtk_type_name (GTK_OBJECT_TYPE(type_g)));
}

/*
 * Class:     org.gnu.gtk.Gtk
 * Method:    gtk_type_from_name
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_Gtk_gtk_1type_1from_1name (JNIEnv *env, jclass cls, 
    jstring name) 
{
    const gchar* name_g = (*env)->GetStringUTFChars( env, name, NULL);
	jobject retval = getHandleFromPointer(env, (GType*)gtk_type_from_name (name_g));
	(*env)->ReleaseStringUTFChars(env, name, name_g);
	return retval;
}

#ifdef __cplusplus
}

#endif
