/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

public class PixbufAnimation extends Boxed 
{
	/**
	 * Construct a new Pixbuf animation from an image file.
	 * @param filename The name of the image file.
	 */
	public PixbufAnimation(String filename) {
		int error = 0;
		this.handle = gdk_pixbuf_animation_new_from_file(filename, error);
	}
	
	/**
	 * Create a new pixbuf from a handle to a native resource.  For
	 * internal use.
	 * @param handle The handle to the native resoufce
	 */
	public PixbufAnimation(Handle handle) {
		this.handle = handle;
	}
	
	/**
	 * Return the width of the pixbuf.
	 * @return The width
	 */
	public int width() {
		return gdk_pixbuf_animation_get_width(handle);
	}

	/**
	 * Return the height of the pixbuf.
	 * @return The height
	 */
	public int height() {
		return gdk_pixbuf_animation_get_height(handle);
	}
	
    /****************************************
     * BEGINNING OF JNI CODE
     ****************************************/
    native static final protected int gdk_pixbuf_animation_get_type ();
    native static final protected Handle gdk_pixbuf_animation_new_from_file (String filename, int 
        error);
    native static final protected int gdk_pixbuf_animation_get_width (Handle animation);
    native static final protected int gdk_pixbuf_animation_get_height (Handle animation);
    native static final protected boolean gdk_pixbuf_animation_is_static_image (Handle animation);
    native static final protected int gdk_pixbuf_animation_get_static_image (Handle animation);
    /****************************************
     * END OF JNI CODE
     ****************************************/
}

