package combobox;

import org.gnu.gtk.ComboBox;
import org.gnu.gtk.CellRendererText;
import org.gnu.gtk.DataColumn;
import org.gnu.gtk.DataColumnBoolean;
import org.gnu.gtk.DataColumnString;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.ListStore;
import org.gnu.gtk.TreeIter;
import org.gnu.gtk.Window;
import org.gnu.gtk.WindowType;
import org.gnu.gtk.event.LifeCycleListener;
import org.gnu.gtk.event.LifeCycleEvent;


public class ComboBoxExample {

    public static void main( String[] argv ) {
        Gtk.init( argv );
        ComboBoxExample example = new ComboBoxExample();
        Gtk.main();
    }

    protected ComboBox box1;
    protected DataColumnBoolean dataBool;
    protected DataColumnString dataStr;
    protected ListStore timestore;

    public ComboBoxExample() {
        Window window = new Window( WindowType.TOPLEVEL );
	window.setTitle( "ComboBoxExample" );
	window.addListener( new Life() );

        // Create a ListStore to hold the values to be displayed in the 
        // ComboBox.
        dataStr = new DataColumnString();
        timestore = new ListStore( new DataColumn[] { dataStr } );
        TreeIter iter;
        for( int i = 0; i < TIMES.length; i++ ) {
            iter = timestore.appendRow();
            timestore.setValue( iter, dataStr, TIMES[i] );
        }

        // Create the ComboBox with the ListStore as the data model.
        box1 = new ComboBox( timestore );
        // Create a renderer to display the ListStore data.
        CellRendererText renderer = new CellRendererText();
        // Attach the renderer to the ComboBox so it uses it to display
        // the data.
	box1.packStart( renderer, true );
	box1.addAttributeMapping( renderer, 
                                  CellRendererText.Attribute.TEXT, 
                                  dataStr );
        // Set the active element to be the first element in the liststore.
        box1.setActive( 0 );

	window.add( box1 );
        window.showAll();
    }

    private static final String[] TIMES = {
        "00:00",
        "01:00",
        "02:00",
        "03:00",
        "04:00",
        "05:00",
        "06:00",
        "07:00",
        "08:00",
        "09:00",
        "10:00",
        "11:00",
        "12:00",
        "13:00",
        "14:00",
        "15:00",
        "16:00",
        "17:00",
        "18:00",
        "19:00",
        "20:00",
        "21:00",
        "22:00",
        "23:00"
    };
    
    protected class Life implements LifeCycleListener {
        public void lifeCycleEvent(LifeCycleEvent event) {}
        public boolean lifeCycleQuery(LifeCycleEvent event) {
            if (event.isOfType(LifeCycleEvent.Type.DESTROY) || 
                event.isOfType(LifeCycleEvent.Type.DELETE)) {

                TreeIter iter = box1.getActiveIter();
                if ( iter != null ) {
                    System.out.println( "selected was: " +
                                        timestore.getValue( iter, dataStr ) );
                } else {
                    System.out.println( "selected was: No Selection" );
                }
                Gtk.mainQuit();
            }
            return false;
        }
    }


}
