/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Enum;

/**
 * Used to indicate how well a font can represent a particular ISO 10646
 * character point for a particular script.
 */
public class CoverageLevel extends Enum 
{
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    static final private int _NONE = 0;
	/** The character is not representable with the font. */
    static final public org.gnu.pango.CoverageLevel NONE = new org.gnu.pango.CoverageLevel (_NONE);
    static final private int _FALLBACK = 1;
	/** 
	 * The character is represented in a way that may be comprehensible but is
	 * not the correct graphical form. For instance, a Hangul character
	 * represented as a a sequence of Jamos, or a Latin transliteration of a
	 * Cyrillic word. 
	 */
    static final public org.gnu.pango.CoverageLevel FALLBACK = new org.gnu.pango.CoverageLevel (
        _FALLBACK);
    static final private int _APPROXIMATE = 2;
	/**
	 * The character is represented as basically the correct graphical form, but with a stylistic variant inappropriate for the current script.
	 */
    static final public org.gnu.pango.CoverageLevel APPROXIMATE = new org.gnu.pango.CoverageLevel (
        _APPROXIMATE);
    static final private int _EXACT = 3;
	/** The character is represented as the correct graphical form. */
    static final public org.gnu.pango.CoverageLevel EXACT = new org.gnu.pango.CoverageLevel (_EXACT);
    static final private org.gnu.pango.CoverageLevel[] theInterned = new 
    org.gnu.pango.CoverageLevel[] 
    {
        NONE, FALLBACK, APPROXIMATE, EXACT 
    }

;
    static private java.util.Hashtable theInternedExtras;
    static final private org.gnu.pango.CoverageLevel theSacrificialOne = new 
    org.gnu.pango.CoverageLevel (0);
    static public org.gnu.pango.CoverageLevel intern (int value) 
    {
        if (value < theInterned.length) 
        {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) 
        {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.pango.CoverageLevel already = (org.gnu.pango.CoverageLevel) theInternedExtras.get (
            theSacrificialOne);
        if (already == null) 
        {
            already = new org.gnu.pango.CoverageLevel(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private CoverageLevel (int value) 
    {
        value_ = value;
    }

    public org.gnu.pango.CoverageLevel or (org.gnu.pango.CoverageLevel other) 
    {
        return intern(value_ | other.value_);
    }

    public org.gnu.pango.CoverageLevel and (org.gnu.pango.CoverageLevel other) 
    {
        return intern(value_ & other.value_);
    }

    public org.gnu.pango.CoverageLevel xor (org.gnu.pango.CoverageLevel other) 
    {
        return intern(value_ ^ other.value_);
    }

    public boolean test (org.gnu.pango.CoverageLevel other) 
    {
        return (value_ & other.value_) == other.value_;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

