/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * This container widget wraps a single widget in a frame with a label,
 * and imposes an aspect ratio on the child widget.  It is useful when
 * you want to pack a widget so that it can be resized but always retain
 * the same aspect ratio.
 */
public class AspectFrame extends Frame {
	
	/**
	 * Construct a new AspectFrame.
	 * @param label The text label for the frame.
	 * @param xAlign The horizontal alignment for the child within the allocation
	 * of the AspectFrame.  This ranges from 0.0 (left aligned) to 1.0 (right
	 * aligned).
	 * @param yAlign The vertical alignment for the child within the allocation
	 * of the AspectFrame.  This ranges from 0.0 (top aligned) to 1.0 (bottom
	 * aligned).
	 * @param ratio, The desired aspect ration.
	 * @param obeyChild If true the ratio is ignored and the aspect ratio is
	 * taken from the requisition of the child.
	 */
	public AspectFrame(String label, double xAlign, double yAlign, double ratio, boolean obeyChild) {
		super(gtk_aspect_frame_new(label, xAlign, yAlign, ratio, obeyChild));
	}
	
	/**
	 * Construct an AspectFrame using a handle to a native resource.
	 */
	public AspectFrame(int handle) {
	    super(handle);
	}

	/**
	 * Set the aspect for an already created AspectFrame.
	 * @param xAlign The horizontal alignment for the child within the allocation
	 * of the AspectFrame.  This ranges from 0.0 (left aligned) to 1.0 (right
	 * aligned).
	 * @param yAlign The vertical alignment for the child within the allocation
	 * of the AspectFrame.  This ranges from 0.0 (top aligned) to 1.0 (bottom
	 * aligned).
	 * @param ratio, The desired aspect ration.
	 * @param obeyChild If true the ratio is ignored and the aspect ratio is
	 * taken from the requisition of the child.
	 */
	public void setAspect(double xAlign, double yAlign, double ratio, boolean obeyChild) {
		AspectFrame.gtk_aspect_frame_set(getHandle(), xAlign, yAlign, ratio, obeyChild);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_aspect_frame_get_type());
	}
	
	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_aspect_frame_get_type();
	native static final protected int gtk_aspect_frame_new(String label, double xalign, double yalign, double ratio, boolean obeyChild);
	native static final protected void gtk_aspect_frame_set(int aspect_frame, double xalign, double yalign, double ratio, boolean obeyChild);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
